/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.bookmark;

import freenet.clients.http.bookmark.Bookmark;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.node.FSParseException;
import freenet.support.SimpleFieldSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkCategory
extends Bookmark {
    public static final String NAME = "BookmarkCategory";
    private final Vector bookmarks = new Vector();

    public BookmarkCategory(String name) {
        this.setName(name);
    }

    public BookmarkCategory(SimpleFieldSet sfs) throws FSParseException {
        String aName = sfs.get("Name");
        if (aName == null) {
            throw new FSParseException("No Name!");
        }
        this.setName(aName);
    }

    protected synchronized Bookmark addBookmark(Bookmark b) {
        if (b == null) {
            return null;
        }
        int x = this.bookmarks.indexOf(b);
        if (x >= 0) {
            return (Bookmark)this.bookmarks.get(x);
        }
        this.bookmarks.add(b);
        return b;
    }

    protected synchronized void removeBookmark(Bookmark b) {
        this.bookmarks.remove(b);
    }

    public Bookmark get(int i) {
        return (Bookmark)this.bookmarks.get(i);
    }

    protected void moveBookmarkUp(Bookmark b) {
        int index = this.bookmarks.indexOf(b);
        if (index == -1) {
            return;
        }
        Bookmark bk = this.get(index);
        this.bookmarks.remove(index);
        this.bookmarks.add(--index < 0 ? 0 : index, bk);
    }

    protected void moveBookmarkDown(Bookmark b) {
        int index = this.bookmarks.indexOf(b);
        if (index == -1) {
            return;
        }
        Bookmark bk = this.get(index);
        this.bookmarks.remove(index);
        this.bookmarks.add(++index > this.size() ? this.size() : index, bk);
    }

    public int size() {
        return this.bookmarks.size();
    }

    public List<BookmarkItem> getItems() {
        Vector<BookmarkItem> items = new Vector<BookmarkItem>();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof BookmarkItem)) continue;
            items.add((BookmarkItem)this.get(i));
        }
        return items;
    }

    public List<BookmarkItem> getAllItems() {
        List<BookmarkItem> items = this.getItems();
        List<BookmarkCategory> subCategories = this.getSubCategories();
        for (int i = 0; i < subCategories.size(); ++i) {
            items.addAll(subCategories.get(i).getAllItems());
        }
        return items;
    }

    public List<BookmarkCategory> getSubCategories() {
        Vector<BookmarkCategory> categories = new Vector<BookmarkCategory>();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof BookmarkCategory)) continue;
            categories.add((BookmarkCategory)this.get(i));
        }
        return categories;
    }

    public List<BookmarkCategory> getAllSubCategories() {
        List<BookmarkCategory> categories = this.getSubCategories();
        List<BookmarkCategory> subCategories = this.getSubCategories();
        for (int i = 0; i < subCategories.size(); ++i) {
            categories.addAll(subCategories.get(i).getAllSubCategories());
        }
        return categories;
    }

    public String[] toStrings() {
        return this.toStrings("").toArray(new String[0]);
    }

    private Vector<String> toStrings(String prefix) {
        int i;
        Vector<String> strings = new Vector<String>();
        List<BookmarkItem> items = this.getItems();
        List<BookmarkCategory> subCategories = this.getSubCategories();
        prefix = prefix + this.name + "/";
        for (i = 0; i < items.size(); ++i) {
            strings.add(prefix + items.get(i).toString());
        }
        for (i = 0; i < subCategories.size(); ++i) {
            strings.addAll(subCategories.get(i).toStrings(prefix));
        }
        return strings;
    }

    @Override
    public SimpleFieldSet getSimpleFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Name", this.name);
        sfs.put("Content", BookmarkManager.toSimpleFieldSet(this));
        return sfs;
    }
}

