/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.ClientMetadata;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.bookmark.BookmarkCategory;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.tanukisoftware.wrapper.WrapperManager;

public class WelcomeToadlet
extends Toadlet {
    private static final int MAX_URL_LENGTH = 0x100000;
    final NodeClientCore core;
    final Node node;
    final BookmarkManager bookmarkManager;

    WelcomeToadlet(HighLevelSimpleClient client, NodeClientCore core, Node node, BookmarkManager bookmarks) {
        super(client);
        this.node = node;
        this.core = core;
        this.bookmarkManager = bookmarks;
    }

    void redirectToRoot(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", "/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    private void addCategoryToList(BookmarkCategory cat, HTMLNode list, boolean noActiveLinks, ToadletContext ctx) {
        int i;
        List<BookmarkItem> items = cat.getItems();
        if (items.size() > 0) {
            HTMLNode table = list.addChild("li").addChild("table", new String[]{"border", "style"}, new String[]{"0", "border: none"});
            for (i = 0; i < items.size(); ++i) {
                BookmarkItem item = items.get(i);
                HTMLNode row = table.addChild("tr");
                HTMLNode cell = row.addChild("td", "style", "border: none");
                if (item.hasAnActivelink() && !noActiveLinks) {
                    String initialKey = item.getKey();
                    String key = '/' + initialKey + (initialKey.endsWith("/") ? "" : "/") + "activelink.png";
                    cell.addChild("a", "href", '/' + item.getKey()).addChild("img", new String[]{"src", "height", "width", "alt", "title"}, new String[]{key, "36", "108", "activelink", item.getDescription()});
                } else {
                    cell.addChild("#", " ");
                }
                cell = row.addChild("td", "style", "border: none");
                cell.addChild("a", new String[]{"href", "title"}, new String[]{'/' + item.getKey(), item.getDescription()}, item.getName());
            }
        }
        List<BookmarkCategory> cats = cat.getSubCategories();
        for (i = 0; i < cats.size(); ++i) {
            list.addChild("li", "class", "cat", cats.get(i).getName());
            this.addCategoryToList(cats.get(i), list.addChild("li").addChild("ul"), noActiveLinks, ctx);
        }
    }

    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        boolean noPassword;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        String passwd = request.getPartAsString("formPassword", 32);
        boolean bl = noPassword = passwd == null || !passwd.equals(this.core.formPassword);
        if (noPassword && Logger.shouldLog(4, this)) {
            Logger.minor(this, "No password (" + passwd + " should be " + this.core.formPassword + ')');
        }
        if (request.getPartAsString("updateconfirm", 32).length() > 0) {
            if (noPassword) {
                this.redirectToRoot(ctx);
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("updatingTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content = ctx.getPageMaker().getInfobox("infobox-information", this.l10n("updatingTitle"), contentNode);
            content.addChild("p").addChild("#", this.l10n("updating"));
            content.addChild("p").addChild("#", this.l10n("thanks"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            Logger.normal(this, "Node is updating/restarting");
            this.node.getNodeUpdater().arm();
        } else if (request.getPartAsString("_CHECKED_HTTP_", 0x100000).length() > 0) {
            if (noPassword) {
                this.redirectToRoot(ctx);
                return;
            }
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            String url = null;
            if (request.getPartAsString("Go", 32).length() > 0) {
                url = request.getPartAsString("_CHECKED_HTTP_", 0x100000);
            }
            headers.put("Location", url == null ? "/" : url);
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
        } else if (request.getPartAsString("update", 32).length() > 0) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("nodeUpdateConfirmTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", this.l10n("nodeUpdateConfirmTitle"), contentNode);
            content.addChild("p").addChild("#", this.l10n("nodeUpdateConfirm"));
            HTMLNode updateForm = ctx.addFormChild(content, "/", "updateConfirmForm");
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "updateconfirm", this.l10n("update")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
        } else if (request.isPartSet("getThreadDump")) {
            if (noPassword) {
                this.redirectToRoot(ctx);
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("threadDumpTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (this.node.isUsingWrapper()) {
                ctx.getPageMaker().getInfobox("#", this.l10n("threadDumpSubTitle"), contentNode).addChild("#", this.l10n("threadDumpWithFilename", "filename", WrapperManager.getProperties().getProperty("wrapper.logfile")));
                System.out.println("Thread Dump:");
                WrapperManager.requestThreadDump();
            } else {
                ctx.getPageMaker().getInfobox("infobox-error", this.l10n("threadDumpSubTitle"), contentNode).addChild("#", this.l10n("threadDumpNotUsingWrapper"));
            }
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
        } else if (request.isPartSet("getJEStatsDump")) {
            if (noPassword) {
                this.redirectToRoot(ctx);
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("databaseStatsTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>> START DATABASE STATS <<<<<<<<<<<<<<<<<<<<<<<");
            this.node.JEStatsDump();
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>  END DATABASE STATS  <<<<<<<<<<<<<<<<<<<<<<<");
            ctx.getPageMaker().getInfobox("#", this.l10n("databaseStatsSubTitle"), contentNode).addChild("#", this.l10n("writtenDatabaseStats"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
        } else {
            if (request.isPartSet("disable")) {
                if (noPassword) {
                    this.redirectToRoot(ctx);
                    return;
                }
                int validAlertsRemaining = 0;
                UserAlert[] alerts = this.core.alerts.getAlerts();
                for (int i = 0; i < alerts.length; ++i) {
                    if (request.getIntPart("disable", -1) == alerts[i].hashCode()) {
                        UserAlert alert = alerts[i];
                        if (alert.userCanDismiss() && alert.shouldUnregisterOnDismiss()) {
                            alert.onDismiss();
                            Logger.normal(this, "Unregistering the userAlert " + alert.hashCode());
                            this.core.alerts.unregister(alert);
                            continue;
                        }
                        Logger.normal(this, "Disabling the userAlert " + alert.hashCode());
                        alert.isValid(false);
                        continue;
                    }
                    if (!alerts[i].isValid()) continue;
                    ++validAlertsRemaining;
                }
                WelcomeToadlet.writePermanentRedirect(ctx, this.l10n("disabledAlert"), validAlertsRemaining > 0 ? "/alerts/" : "/");
                return;
            }
            if (request.isPartSet("key") && request.isPartSet("filename")) {
                HTMLNode content;
                HTMLNode pageNode;
                Bucket bucket;
                block42: {
                    String[] metas;
                    if (noPassword) {
                        this.redirectToRoot(ctx);
                        return;
                    }
                    FreenetURI key = new FreenetURI(request.getPartAsString("key", 128));
                    String type = request.getPartAsString("content-type", 128);
                    if (type == null) {
                        type = "text/plain";
                    }
                    ClientMetadata contentType = new ClientMetadata(type);
                    bucket = request.getPart("filename");
                    PageNode page = ctx.getPageMaker().getPageNode(this.l10n("insertedTitle"), ctx);
                    pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    String filenameHint = null;
                    if (key.getKeyType().equals("CHK") && (metas = key.getAllMetaStrings()) != null && metas.length > 1) {
                        filenameHint = metas[0];
                    }
                    InsertBlock block = new InsertBlock(bucket, contentType, key);
                    try {
                        key = this.insert(block, filenameHint, false);
                        content = ctx.getPageMaker().getInfobox("infobox-success", this.l10n("insertSucceededTitle"), contentNode);
                        String u = key.toString();
                        L10n.addL10nSubstitution(content, "WelcomeToadlet.keyInsertedSuccessfullyWithKeyAndName", new String[]{"link", "/link", "name"}, new String[]{"<a href=\"/" + u + "\">", "</a>", u});
                    }
                    catch (InsertException e) {
                        int mode;
                        content = ctx.getPageMaker().getInfobox("infobox-error", this.l10n("insertFailedTitle"), contentNode);
                        content.addChild("#", this.l10n("insertFailedWithMessage", "message", e.getMessage()));
                        content.addChild("br");
                        if (e.uri != null) {
                            content.addChild("#", this.l10n("uriWouldHaveBeen", "uri", e.uri.toString()));
                        }
                        if ((mode = e.getMode()) != 6 && mode != 7) break block42;
                        content.addChild("br");
                        content.addChild("#", this.l10n("splitfileErrorLabel"));
                        content.addChild("pre", e.errorCodes.toVerboseString());
                    }
                }
                content.addChild("br");
                WelcomeToadlet.addHomepageLink(content);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                request.freeParts();
                bucket.free();
            } else {
                if (request.isPartSet("exit")) {
                    PageNode page = ctx.getPageMaker().getPageNode(this.l10n("shutdownConfirmTitle"), ctx);
                    HTMLNode pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", this.l10n("shutdownConfirmTitle"), contentNode);
                    content.addChild("p").addChild("#", this.l10n("shutdownConfirm"));
                    HTMLNode shutdownForm = ctx.addFormChild(content.addChild("p"), "/", "confirmShutdownForm");
                    shutdownForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                    shutdownForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "shutdownconfirm", this.l10n("shutdown")});
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    return;
                }
                if (request.isPartSet("shutdownconfirm")) {
                    if (noPassword) {
                        this.redirectToRoot(ctx);
                        return;
                    }
                    MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                    headers.put("Location", "/?terminated&formPassword=" + this.core.formPassword);
                    ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                    this.node.ps.queueTimedJob(new Runnable(){

                        public void run() {
                            WelcomeToadlet.this.node.exit("Shutdown from fproxy");
                        }
                    }, 1L);
                    return;
                }
                if (request.isPartSet("restart")) {
                    PageNode page = ctx.getPageMaker().getPageNode(this.l10n("restartConfirmTitle"), ctx);
                    HTMLNode pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", this.l10n("restartConfirmTitle"), contentNode);
                    content.addChild("p").addChild("#", this.l10n("restartConfirm"));
                    HTMLNode restartForm = ctx.addFormChild(content.addChild("p"), "/", "confirmRestartForm");
                    restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                    restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restartconfirm", this.l10n("restart")});
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    return;
                }
                if (request.isPartSet("restartconfirm")) {
                    if (noPassword) {
                        this.redirectToRoot(ctx);
                        return;
                    }
                    MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                    headers.put("Location", "/?restarted&formPassword=" + this.core.formPassword);
                    ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                    this.node.ps.queueTimedJob(new Runnable(){

                        public void run() {
                            WelcomeToadlet.this.node.getNodeStarter().restart();
                        }
                    }, 1L);
                    return;
                }
                if (request.isPartSet("dismiss-events")) {
                    if (noPassword) {
                        this.redirectToRoot(ctx);
                        return;
                    }
                    String alertsToDump = request.getPartAsString("events", Integer.MAX_VALUE);
                    String[] alertAnchors = alertsToDump.split(",");
                    HashSet<String> toDump = new HashSet<String>();
                    for (String alertAnchor : alertAnchors) {
                        toDump.add(alertAnchor);
                    }
                    this.core.alerts.dumpEvents(toDump);
                    this.redirectToRoot(ctx);
                } else {
                    this.redirectToRoot(ctx);
                }
            }
        }
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String useragent;
        boolean advancedModeOutputEnabled = this.core.getToadletContainer().isAdvancedModeEnabled();
        if (ctx.isAllowedFullAccess()) {
            if (request.isParameterSet("latestlog")) {
                File logs = new File(this.node.config.get("logger").getString("dirname") + File.separator + "freenet-latest.log");
                this.writeHTMLReply(ctx, 200, "OK", FileUtil.readUTF(logs));
                return;
            }
            if (request.isParameterSet("terminated")) {
                if (!request.isParameterSet("formPassword") || !request.getParam("formPassword").equals(this.core.formPassword)) {
                    this.redirectToRoot(ctx);
                    return;
                }
                PageNode page = ctx.getPageMaker().getPageNode("Node Shutdown", false, ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                ctx.getPageMaker().getInfobox("infobox-information", this.l10n("shutdownDone"), contentNode).addChild("#", this.l10n("thanks"));
                WelcomeToadlet.maybeDisplayWrapperLogfile(ctx, contentNode);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.isParameterSet("restarted")) {
                if (!request.isParameterSet("formPassword") || !request.getParam("formPassword").equals(this.core.formPassword)) {
                    this.redirectToRoot(ctx);
                    return;
                }
                PageNode page = ctx.getPageMaker().getPageNode("Node Restart", false, ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode headNode = page.headNode;
                headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "20; url="});
                HTMLNode contentNode = page.content;
                ctx.getPageMaker().getInfobox("infobox-information", this.l10n("restartingTitle"), contentNode).addChild("#", this.l10n("restarting"));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                Logger.normal(this, "Node is restarting");
                return;
            }
            if (request.getParam("newbookmark").length() > 0) {
                PageNode page = ctx.getPageMaker().getPageNode(this.l10n("confirmAddBookmarkTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("#", this.l10n("confirmAddBookmarkSubTitle"), contentNode);
                HTMLNode addForm = ctx.addFormChild(infoboxContent, "/bookmarkEditor/", "editBookmarkForm");
                addForm.addChild("#", this.l10n("confirmAddBookmarkWithKey", "key", request.getParam("newbookmark")));
                addForm.addChild("br");
                String key = request.getParam("newbookmark");
                if (key.startsWith("freenet:")) {
                    key = key.substring(8);
                }
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key});
                if (request.isParameterSet("hasAnActivelink")) {
                    addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "hasAnActivelink", request.getParam("hasAnActivelink")});
                }
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "name", request.getParam("desc")});
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "bookmark", "/"});
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "action", "addItem"});
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "addbookmark", L10n.getString("BookmarkEditorToadlet.addBookmark")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getParam("_CHECKED_HTTP_").length() > 0) {
                PageNode page = ctx.getPageMaker().getPageNode(this.l10n("confirmExternalLinkTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode warnboxContent = ctx.getPageMaker().getInfobox("infobox-warning", this.l10n("confirmExternalLinkSubTitle"), contentNode);
                HTMLNode externalLinkForm = ctx.addFormChild(warnboxContent, "/", "confirmExternalLinkForm");
                String target = request.getParam("_CHECKED_HTTP_");
                externalLinkForm.addChild("#", this.l10n("confirmExternalLinkWithURL", "url", target));
                externalLinkForm.addChild("br");
                externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "_CHECKED_HTTP_", target});
                externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "Go", this.l10n("goToExternalLink")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("homepageFullTitleWithName", "name", this.node.getMyName()), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (this.node.isTestnetEnabled()) {
            ctx.getPageMaker().getInfobox("infobox-alert", this.l10n("testnetWarningTitle"), contentNode).addChild("#", this.l10n("testnetWarning"));
        }
        if ((useragent = ctx.getHeaders().get("user-agent")) != null && (useragent = useragent.toLowerCase()).indexOf("msie") > -1 && useragent.indexOf("opera") == -1) {
            ctx.getPageMaker().getInfobox("infobox-alert", this.l10n("ieWarningTitle"), contentNode).addChild("#", this.l10n("ieWarning"));
        }
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createAlertsShort(this.l10n("alertsSummary"), advancedModeOutputEnabled, true));
        }
        HTMLNode searchBoxContent = ctx.getPageMaker().getInfobox("infobox-normal", L10n.getString("WelcomeToadlet.searchBoxLabel"), contentNode);
        if (this.core.node.pluginManager != null && this.core.node.pluginManager.isPluginLoaded("plugins.XMLLibrarian.XMLLibrarian")) {
            HTMLNode form = searchBoxContent.addChild("form", new String[]{"method", "action"}, new String[]{"GET", "/plugins/plugins.XMLLibrarian.XMLLibrarian"});
            form.addAttribute("target", "_blank");
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "choice", "index"});
            form.addChild("input", new String[]{"type", "size", "name"}, new String[]{"text", "80", "search"});
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "find", this.l10n("searchFreenet")});
            searchBoxContent.addChild("#", this.l10n("searchBoxWarningSlow"));
        } else {
            L10n.addL10nSubstitution(searchBoxContent, "WelcomeToadlet.searchPluginNotLoaded", new String[]{"link", "/link"}, new String[]{"<a href=\"/plugins/\">", "</a>"});
        }
        HTMLNode bookmarkBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        HTMLNode bookmarkBoxHeader = bookmarkBox.addChild("div", "class", "infobox-header");
        bookmarkBoxHeader.addChild("#", L10n.getString("BookmarkEditorToadlet.myBookmarksTitle"));
        if (ctx.isAllowedFullAccess()) {
            bookmarkBoxHeader.addChild("#", " [");
            bookmarkBoxHeader.addChild("span", "id", "bookmarkedit").addChild("a", new String[]{"href", "class"}, new String[]{"/bookmarkEditor/", "interfacelink"}, L10n.getString("BookmarkEditorToadlet.edit"));
            bookmarkBoxHeader.addChild("#", "]");
        }
        HTMLNode bookmarkBoxContent = bookmarkBox.addChild("div", "class", "infobox-content");
        HTMLNode bookmarksList = bookmarkBoxContent.addChild("ul", "id", "bookmarks");
        this.addCategoryToList(BookmarkManager.MAIN_CATEGORY, bookmarksList, !this.container.enableActivelinks() || useragent != null && useragent.contains("khtml") && !useragent.contains("chrome"), ctx);
        HTMLNode fetchKeyContent = ctx.getPageMaker().getInfobox("infobox-normal", this.l10n("fetchKeyLabel"), contentNode);
        fetchKeyContent.addAttribute("id", "keyfetchbox");
        HTMLNode fetchKeyForm = fetchKeyContent.addChild("form", new String[]{"action", "method"}, new String[]{"/", "get"}).addChild("div");
        fetchKeyForm.addChild("#", this.l10n("keyRequestLabel") + ' ');
        fetchKeyForm.addChild("input", new String[]{"type", "size", "name"}, new String[]{"text", "80", "key"});
        fetchKeyForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("fetch")});
        HTMLNode versionContent = ctx.getPageMaker().getInfobox("infobox-information", this.l10n("versionHeader"), contentNode);
        versionContent.addChild("#", L10n.getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{"0.7", Integer.toString(Version.buildNumber()), "build01217"}));
        versionContent.addChild("br");
        if (NodeStarter.extBuildNumber < 26) {
            versionContent.addChild("#", L10n.getString("WelcomeToadlet.extVersionWithRecommended", new String[]{"build", "recbuild", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), Integer.toString(26), NodeStarter.extRevisionNumber}));
        } else {
            versionContent.addChild("#", L10n.getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber}));
        }
        versionContent.addChild("br");
        if (ctx.isAllowedFullAccess()) {
            HTMLNode shutdownForm = ctx.addFormChild(versionContent, ".", "shutdownForm");
            shutdownForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "exit"});
            shutdownForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("shutdownNode")});
            if (this.node.isUsingWrapper()) {
                HTMLNode restartForm = ctx.addFormChild(versionContent, ".", "restartForm");
                restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", this.l10n("restartNode")});
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    private String l10n(String key) {
        return L10n.getString("WelcomeToadlet." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("WelcomeToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    public static void maybeDisplayWrapperLogfile(ToadletContext ctx, HTMLNode contentNode) {
        File logs = new File("wrapper.log");
        long logSize = logs.length();
        if (logs.exists() && logs.isFile() && logs.canRead() && logSize > 0L) {
            try {
                HTMLNode logInfoboxContent = ctx.getPageMaker().getInfobox("infobox-info", "Current status", contentNode);
                boolean isShortFile = logSize < 2000L;
                String content = FileUtil.readUTF(logs, isShortFile ? 0L : logSize - 2000L);
                int eol = content.indexOf(10);
                boolean shallStripFirstLine = !isShortFile && eol > 0;
                logInfoboxContent.addChild("%", content.substring(shallStripFirstLine ? eol + 1 : 0).replaceAll("\n", "<br>\n"));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public String path() {
        return "/";
    }
}

