/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class UserAlertsToadlet
extends Toadlet {
    private UserAlertManager alerts;
    private Node node;

    UserAlertsToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.node = node;
        this.alerts = core.alerts;
    }

    public String supportedMethods() {
        return "GET";
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("titleWithName", "name", this.node.getMyName()), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(this.alerts.createAlerts());
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    protected String l10n(String name, String pattern, String value) {
        return L10n.getString("UserAlertsToadlet." + name, pattern, value);
    }

    public String path() {
        return "/alerts/";
    }
}

