/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleFieldSet;
import freenet.support.api.HTTPRequest;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.URI;

public class TranslationToadlet
extends Toadlet {
    public static final String TOADLET_URL = "/translation/";
    private final NodeClientCore core;
    private static final SimpleFieldSet DEFAULT_TRANSLATION = L10n.getDefaultLanguageTranslation();

    TranslationToadlet(HighLevelSimpleClient client, NodeClientCore core) {
        super(client);
        this.core = core;
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        boolean showEverything;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        boolean bl = showEverything = !request.isParameterSet("toTranslateOnly");
        if (request.isParameterSet("getOverrideTranlationFile")) {
            SimpleFieldSet sfs = L10n.getOverrideForCurrentLanguageTranslation();
            if (sfs == null) {
                super.sendErrorPage(ctx, 503, "Service Unavailable", this.l10n("noCustomTranslations"));
                return;
            }
            byte[] data = sfs.toOrderedString().getBytes("UTF-8");
            MultiValueTable<String, String> head = new MultiValueTable<String, String>();
            head.put("Content-Disposition", "attachment; filename=\"" + L10n.getSelectedLanguage().l10nOverrideFilename + '\"');
            ctx.sendReplyHeaders(200, "Found", head, "text/plain; charset=utf-8", data.length);
            ctx.writeData(data);
            return;
        }
        if (request.isParameterSet("translation_updated")) {
            String key = request.getParam("translation_updated");
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("translationUpdatedTitle"), true, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode translationNode = contentNode.addChild("div", "class", "translation");
            HTMLNode legendTable = translationNode.addChild("table", "class", "translation");
            HTMLNode legendRow = legendTable.addChild("tr").addChild("b");
            legendRow.addChild("td", "class", "translation-key", this.l10n("translationKeyLabel"));
            legendRow.addChild("td", "class", "translation-key", this.l10n("originalVersionLabel"));
            legendRow.addChild("td", "class", "translation-key", this.l10n("currentTranslationLabel"));
            HTMLNode contentRow = legendTable.addChild("tr");
            contentRow.addChild("td", "class", "translation-key", key);
            contentRow.addChild("td", "class", "translation-orig", L10n.getDefaultString(key));
            contentRow.addChild("td", "class", "translation-new", L10n.getString(key));
            HTMLNode footer = translationNode.addChild("div", "class", "warning");
            footer.addChild("a", "href", "/translation/?getOverrideTranlationFile").addChild("#", this.l10n("downloadTranslationsFile"));
            footer.addChild("%", "&nbsp;&nbsp;");
            footer.addChild("a", "href", "/translation/?translate=" + key + (showEverything ? "" : "&toTranslateOnly")).addChild("#", this.l10n("reEdit"));
            footer.addChild("%", "&nbsp;&nbsp;");
            footer.addChild("a", "href", TOADLET_URL + (showEverything ? "" : "?toTranslateOnly")).addChild("#", this.l10n("returnToTranslations"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (request.isParameterSet("translate")) {
            boolean gotoNext = request.isParameterSet("gotoNext");
            String key = request.getParam("translate");
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("translationUpdateTitle"), true, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode translationNode = contentNode.addChild("div", "class", "translation");
            HTMLNode updateForm = ctx.addFormChild(translationNode, TOADLET_URL, "trans_update");
            HTMLNode legendTable = updateForm.addChild("table", "class", "translation");
            HTMLNode legendRow = legendTable.addChild("tr");
            legendRow.addChild("td", "class", "translation-key", this.l10n("translationKeyLabel"));
            legendRow.addChild("td", "class", "translation-key", this.l10n("originalVersionLabel"));
            legendRow.addChild("td", "class", "translation-key", this.l10n("currentTranslationLabel"));
            HTMLNode contentRow = legendTable.addChild("tr");
            contentRow.addChild("td", "class", "translation-key", key);
            contentRow.addChild("td", "class", "translation-orig", L10n.getDefaultString(key));
            contentRow.addChild("td", "class", "translation-new").addChild("textarea", new String[]{"name", "rows", "cols"}, new String[]{"trans", "6", "80"}, L10n.getString(key));
            contentRow.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key});
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "translation_update", this.l10n("updateTranslationCommand")});
            updateForm.addChild("input", new String[]{"type", "name", gotoNext ? "checked" : "unchecked"}, new String[]{"checkbox", "gotoNext", ""}, this.l10n("gotoNext"));
            if (!showEverything) {
                updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "toTranslateOnly", key});
            }
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (request.isParameterSet("remove")) {
            String key = request.getParam("remove");
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("removeOverrideTitle"), true, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content = ctx.getPageMaker().getInfobox("infobox-warning", this.l10n("removeOverrideWarningTitle"), contentNode);
            content.addChild("p").addChild("#", L10n.getString("TranslationToadlet.confirmRemoveOverride", new String[]{"key", "value"}, new String[]{key, L10n.getString(key)}));
            HTMLNode removeForm = ctx.addFormChild(content.addChild("p"), TOADLET_URL, "remove_confirmed");
            if (!showEverything) {
                removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "toTranslateOnly", key});
            }
            removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "remove_confirm", key});
            removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_confirmed", this.l10n("remove")});
            removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("translationUpdateTitle"), true, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode translationNode = contentNode.addChild("div", "class", "translation");
        HTMLNode translationHeaderNode = translationNode.addChild("p");
        translationHeaderNode.addChild("#", this.l10n("contributingToLabelWithLang", "lang", L10n.getSelectedLanguage().fullName));
        translationHeaderNode.addChild("a", "href", "/translation/?getOverrideTranlationFile").addChild("#", this.l10n("downloadTranslationsFile"));
        translationHeaderNode.addChild("#", " ");
        if (showEverything) {
            translationHeaderNode.addChild("a", "href", "/translation/?toTranslateOnly").addChild("#", this.l10n("hideAlreadyTranslated"));
        } else {
            translationHeaderNode.addChild("a", "href", TOADLET_URL).addChild("#", this.l10n("showEverything"));
        }
        HTMLNode legendTable = translationNode.addChild("table", "class", "translation");
        HTMLNode legendRow = legendTable.addChild("tr");
        legendRow.addChild("td", "class", "translation-key", this.l10n("translationKeyLabel"));
        legendRow.addChild("td", "class", "translation-key", this.l10n("originalVersionLabel"));
        legendRow.addChild("td", "class", "translation-key", this.l10n("currentTranslationLabel"));
        SimpleFieldSet sfs = L10n.getCurrentLanguageTranslation();
        if (sfs != null) {
            SimpleFieldSet.KeyIterator it = DEFAULT_TRANSLATION.keyIterator("");
            while (it.hasNext()) {
                String key = it.nextKey();
                boolean isOverriden = L10n.isOverridden(key);
                if (!showEverything && (isOverriden || L10n.getString(key, true) != null)) continue;
                HTMLNode contentRow = legendTable.addChild("tr");
                contentRow.addChild("td", "class", "translation-key", key);
                contentRow.addChild("td", "class", "translation-orig", L10n.getDefaultString(key));
                contentRow.addChild("td", "class", "translation-new").addChild(this._setOrRemoveOverride(key, isOverriden, showEverything));
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        boolean noPassword;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        boolean logMINOR = Logger.shouldLog(4, this);
        String passwd = request.getPartAsString("formPassword", 32);
        boolean bl = noPassword = passwd == null || !passwd.equals(this.core.formPassword);
        if (noPassword) {
            if (logMINOR) {
                Logger.minor(this, "No password (" + passwd + " should be " + this.core.formPassword + ')');
            }
            this.redirectTo(ctx, "/");
            return;
        }
        boolean toTranslateOnly = request.isPartSet("toTranslateOnly");
        if (request.getPartAsString("translation_update", 32).length() > 0) {
            String key = request.getPartAsString("key", 256);
            L10n.setOverride(key, new String(BucketTools.toByteArray(request.getPart("trans")), "UTF-8").trim());
            if ("on".equalsIgnoreCase(request.getPartAsString("gotoNext", 7))) {
                SimpleFieldSet.KeyIterator it = DEFAULT_TRANSLATION.keyIterator("");
                while (it.hasNext()) {
                    String newKey = it.nextKey();
                    boolean isOverriden = L10n.isOverridden(newKey);
                    System.out.println("newkey:" + newKey);
                    if (isOverriden || L10n.getString(newKey, true) != null) continue;
                    this.redirectTo(ctx, "/translation/?gotoNext&translate=" + newKey + (toTranslateOnly ? "&toTranslateOnly" : ""));
                    return;
                }
            }
            this.redirectTo(ctx, "/translation/?translation_updated=" + key + (toTranslateOnly ? "&toTranslateOnly" : ""));
            return;
        }
        if (request.getPartAsString("remove_confirmed", 32).length() > 0) {
            String key = request.getPartAsString("remove_confirm", 256).trim();
            L10n.setOverride(key, "");
            this.redirectTo(ctx, "/translation/?translation_updated=" + key + (toTranslateOnly ? "&toTranslateOnly" : ""));
            return;
        }
        this.redirectTo(ctx, "/");
    }

    private void redirectTo(ToadletContext ctx, String target) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", target);
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    private HTMLNode _setOrRemoveOverride(String key, boolean isOverriden, boolean showEverything) {
        String value = L10n.getString(key, true);
        HTMLNode translationField = new HTMLNode("span", "class", isOverriden ? "translate_d" : "translate_it");
        if (value == null) {
            translationField.addChild("#", L10n.getDefaultString(key));
            translationField.addChild("a", "href", "/translation/?translate=" + key + (showEverything ? "" : "&toTranslateOnly")).addChild("small", this.l10n("bracketTranslateIt"));
        } else {
            translationField.addChild("#", L10n.getString(key));
            translationField.addChild("a", "href", "/translation/?translate=" + key + (showEverything ? "" : "&toTranslateOnly")).addChild("small", this.l10n("bracketUpdateTranslation"));
            if (isOverriden) {
                translationField.addChild("a", "href", "/translation/?remove=" + key + (showEverything ? "" : "&toTranslateOnly")).addChild("small", this.l10n("bracketRemoveOverride"));
            }
        }
        return translationField;
    }

    private String l10n(String key) {
        return L10n.getString("TranslationToadlet." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("TranslationToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    public String path() {
        return TOADLET_URL;
    }
}

