/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.PageMaker;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToadletContextImpl
implements ToadletContext {
    private final MultiValueTable<String, String> headers;
    private final OutputStream sockOutputStream;
    private final PageMaker pagemaker;
    private final BucketFactory bf;
    private final ToadletContainer container;
    private final InetAddress remoteAddr;
    private boolean sentReplyHeaders;
    private volatile Toadlet activeToadlet;
    private boolean closed;
    private boolean shouldDisconnect;
    static TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");

    public ToadletContextImpl(Socket sock, MultiValueTable<String, String> headers, BucketFactory bf, PageMaker pageMaker, ToadletContainer container) throws IOException {
        this.headers = headers;
        this.closed = false;
        this.sockOutputStream = sock.getOutputStream();
        this.remoteAddr = sock.getInetAddress();
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "Connection from " + this.remoteAddr);
        }
        this.bf = bf;
        this.pagemaker = pageMaker;
        this.container = container;
    }

    private void close() {
        this.closed = true;
    }

    private void sendMethodNotAllowed(String method, boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Allow", "GET, PUT");
        ToadletContextImpl.sendError(this.sockOutputStream, 405, "Method Not Allowed", ToadletContextImpl.l10n("methodNotAllowed"), shouldDisconnect, mvt);
    }

    private static String l10n(String key) {
        return L10n.getString("ToadletContextImpl." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("ToadletContextImpl." + key, new String[]{pattern}, new String[]{value});
    }

    private static void sendError(OutputStream os, int code, String httpReason, String message, boolean shouldDisconnect, MultiValueTable<String, String> mvt) throws IOException {
        ToadletContextImpl.sendHTMLError(os, code, httpReason, "<html><head><title>" + message + "</title></head><body><h1>" + message + "</h1></body>", shouldDisconnect, mvt);
    }

    private static void sendHTMLError(OutputStream os, int code, String httpReason, String htmlMessage, boolean disconnect, MultiValueTable<String, String> mvt) throws IOException {
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        byte[] messageBytes = htmlMessage.getBytes("UTF-8");
        ToadletContextImpl.sendReplyHeaders(os, code, httpReason, mvt, "text/html; charset=UTF-8", messageBytes.length, null, disconnect);
        os.write(messageBytes);
    }

    private void sendNoToadletError(boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        ToadletContextImpl.sendError(this.sockOutputStream, 404, "Not Found", ToadletContextImpl.l10n("noSuchToadlet"), shouldDisconnect, null);
    }

    private static void sendURIParseError(OutputStream os, boolean shouldDisconnect, Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String message = "<html><head><title>" + ToadletContextImpl.l10n("uriParseErrorTitle") + "</title></head><body><p>" + HTMLEncoder.encode(e.getMessage()) + "</p><pre>\n" + sw.toString();
        ToadletContextImpl.sendHTMLError(os, 400, "Bad Request", message, shouldDisconnect, null);
    }

    @Override
    public void sendReplyHeaders(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength) throws ToadletContextClosedException, IOException {
        this.sendReplyHeaders(replyCode, replyDescription, mvt, mimeType, contentLength, null);
    }

    @Override
    public void sendReplyHeaders(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        if (this.sentReplyHeaders) {
            throw new IllegalStateException("Already sent headers!");
        }
        this.sentReplyHeaders = true;
        ToadletContextImpl.sendReplyHeaders(this.sockOutputStream, replyCode, replyDescription, mvt, mimeType, contentLength, mTime, this.shouldDisconnect);
    }

    @Override
    public PageMaker getPageMaker() {
        return this.pagemaker;
    }

    @Override
    public MultiValueTable<String, String> getHeaders() {
        return this.headers;
    }

    static void sendReplyHeaders(OutputStream sockOutputStream, int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime, boolean disconnect) throws IOException {
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        if (mimeType != null) {
            if (mimeType.equalsIgnoreCase("text/html")) {
                mvt.put("content-type", mimeType + "; charset=UTF-8");
            } else {
                mvt.put("content-type", mimeType);
            }
        }
        if (contentLength >= 0L) {
            mvt.put("content-length", Long.toString(contentLength));
        }
        String expiresTime = mTime == null ? "Thu, 01 Jan 1970 00:00:00 GMT" : ToadletContextImpl.makeHTTPDate(mTime.getTime() + 86400000L);
        mvt.put("expires", expiresTime);
        String nowString = ToadletContextImpl.makeHTTPDate(System.currentTimeMillis());
        String lastModString = mTime == null ? nowString : ToadletContextImpl.makeHTTPDate(mTime.getTime());
        mvt.put("last-modified", lastModString);
        mvt.put("date", nowString);
        if (mTime == null) {
            mvt.put("pragma", "no-cache");
            mvt.put("cache-control", "max-age=0, must-revalidate, no-cache, no-store, post-check=0, pre-check=0");
        }
        if (disconnect) {
            mvt.put("connection", "close");
        } else {
            mvt.put("connection", "keep-alive");
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("HTTP/1.1 ");
        buf.append(replyCode);
        buf.append(' ');
        buf.append(replyDescription);
        buf.append("\r\n");
        Enumeration<String> e = mvt.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object[] list = mvt.getArray(key);
            key = ToadletContextImpl.fixKey(key);
            for (int i = 0; i < list.length; ++i) {
                String val = (String)list[i];
                buf.append(key);
                buf.append(": ");
                buf.append(val);
                buf.append("\r\n");
            }
        }
        buf.append("\r\n");
        sockOutputStream.write(buf.toString().getBytes("US-ASCII"));
    }

    private static String makeHTTPDate(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TZ_UTC);
        return sdf.format(new Date(time));
    }

    private static String fixKey(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        int prev = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (i == 0 || prev == 45) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            prev = c;
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static void handle(Socket sock, ToadletContainer container, PageMaker pageMaker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setActiveToadlet(Toadlet t) {
        this.activeToadlet = t;
    }

    @Override
    public Toadlet activeToadlet() {
        return this.activeToadlet;
    }

    private static boolean shouldDisconnectAfterHandled(boolean isHTTP10, MultiValueTable<String, String> headers) {
        String connection = headers.get("connection");
        if (connection != null) {
            if (connection.equalsIgnoreCase("close")) {
                return true;
            }
            if (connection.equalsIgnoreCase("keep-alive")) {
                return false;
            }
        }
        return isHTTP10;
    }

    @Override
    public void writeData(byte[] data, int offset, int length) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        this.sockOutputStream.write(data, offset, length);
    }

    @Override
    public void writeData(byte[] data) throws ToadletContextClosedException, IOException {
        this.writeData(data, 0, data.length);
    }

    @Override
    public void writeData(Bucket data) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        BucketTools.copyTo(data, this.sockOutputStream, Long.MAX_VALUE);
    }

    @Override
    public BucketFactory getBucketFactory() {
        return this.bf;
    }

    @Override
    public HTMLNode addFormChild(HTMLNode parentNode, String target, String name) {
        return this.container.addFormChild(parentNode, target, name);
    }

    @Override
    public boolean isAllowedFullAccess() {
        return this.container.isAllowedFullAccess(this.remoteAddr);
    }

    @Override
    public boolean doRobots() {
        return this.container.doRobots();
    }

    @Override
    public void forceDisconnect() {
        this.shouldDisconnect = true;
    }

    @Override
    public ToadletContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean disableProgressPage() {
        return this.container.disableProgressPage();
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = -1L;

        ParseException(String string) {
            super(string);
        }
    }
}

