/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.RequestClient;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Toadlet {
    private final HighLevelSimpleClient client;
    ToadletContainer container;

    public abstract String path();

    public Toadlet showAsToadlet() {
        return this;
    }

    protected Toadlet(HighLevelSimpleClient client) {
        this.client = client;
    }

    public void handleGet(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        this.handleUnhandledRequest(uri, null, ctx);
    }

    public void handlePost(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        this.handleUnhandledRequest(uri, null, ctx);
    }

    private void handleUnhandledRequest(URI uri, Bucket data, ToadletContext toadletContext) throws ToadletContextClosedException, IOException, RedirectException {
        PageNode page = toadletContext.getPageMaker().getPageNode(Toadlet.l10n("notSupportedTitle"), toadletContext);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-error");
        infobox.addChild("div", "class", "infobox-header", Toadlet.l10n("notSupportedTitle"));
        infobox.addChild("div", "class", "infobox-content", Toadlet.l10n("notSupportedWithClass", "class", this.getClass().getName()));
        MultiValueTable<String, String> hdrtbl = new MultiValueTable<String, String>();
        hdrtbl.put("Allow", this.supportedMethods());
        StringBuilder pageBuffer = new StringBuilder();
        pageNode.generate(pageBuffer);
        toadletContext.sendReplyHeaders(405, "Operation not Supported", hdrtbl, "text/html; charset=utf-8", pageBuffer.length());
        toadletContext.writeData(pageBuffer.toString().getBytes("UTF-8"));
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("Toadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key) {
        return L10n.getString("Toadlet." + key);
    }

    public abstract String supportedMethods();

    FetchResult fetch(FreenetURI uri, long maxSize, RequestClient clientContext) throws FetchException {
        return this.client.fetch(uri, maxSize, clientContext);
    }

    FreenetURI insert(InsertBlock insert, String filenameHint, boolean getCHKOnly) throws InsertException {
        insert.desiredURI.checkInsertURI();
        return this.client.insert(insert, getCHKOnly, filenameHint);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, byte[] data, int offset, int length) throws ToadletContextClosedException, IOException {
        ctx.sendReplyHeaders(code, desc, null, mimeType, length);
        ctx.writeData(data, offset, length);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, Bucket data) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, mimeType, desc, null, data);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, Bucket data) throws ToadletContextClosedException, IOException {
        context.sendReplyHeaders(code, desc, headers, mimeType, data.size());
        context.writeData(data);
    }

    protected void writeReply(ToadletContext ctx, int code, String mimeType, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, mimeType, desc, null, reply);
    }

    protected void writeHTMLReply(ToadletContext ctx, int code, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/html; charset=utf-8", desc, null, reply);
    }

    protected void writeTextReply(ToadletContext ctx, int code, String desc, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/plain; charset=utf-8", desc, null, reply);
    }

    protected void writeHTMLReply(ToadletContext ctx, int code, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/html; charset=utf-8", desc, headers, reply);
    }

    protected void writeTextReply(ToadletContext ctx, int code, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        this.writeReply(ctx, code, "text/plain; charset=utf-8", desc, headers, reply);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, String reply) throws ToadletContextClosedException, IOException {
        byte[] buffer = reply.getBytes("UTF-8");
        this.writeReply(context, code, mimeType, desc, headers, buffer, 0, buffer.length);
    }

    protected void writeReply(ToadletContext context, int code, String mimeType, String desc, MultiValueTable<String, String> headers, byte[] buffer, int startIndex, int length) throws ToadletContextClosedException, IOException {
        context.sendReplyHeaders(code, desc, headers, mimeType, length);
        context.writeData(buffer, startIndex, length);
    }

    static void writePermanentRedirect(ToadletContext ctx, String msg, String location) throws ToadletContextClosedException, IOException {
        byte[] buf;
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Location", location);
        msg = msg == null ? "" : HTMLEncoder.encode(msg);
        String redirDoc = "<html><head><title>" + msg + "</title></head><body><h1>" + Toadlet.l10n("permRedirectWithReason", "reason", msg) + "</h1><a href=\"" + HTMLEncoder.encode(location) + "\">" + Toadlet.l10n("clickHere") + "</a></body></html>";
        try {
            buf = redirDoc.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        ctx.sendReplyHeaders(301, "Moved Permanently", mvt, "text/html; charset=UTF-8", buf.length);
        ctx.writeData(buf, 0, buf.length);
    }

    protected void writeTemporaryRedirect(ToadletContext ctx, String msg, String location) throws ToadletContextClosedException, IOException {
        byte[] buf;
        MultiValueTable<String, String> mvt = new MultiValueTable<String, String>();
        mvt.put("Location", location);
        msg = msg == null ? "" : HTMLEncoder.encode(msg);
        String redirDoc = "<html><head><title>" + msg + "</title></head><body><h1>" + Toadlet.l10n("tempRedirectWithReason", "reason", msg) + "</h1><a href=\"" + HTMLEncoder.encode(location) + "\">" + Toadlet.l10n("clickHere") + "</a></body></html>";
        try {
            buf = redirDoc.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        ctx.sendReplyHeaders(302, "Found", mvt, "text/html; charset=UTF-8", buf.length);
        ctx.writeData(buf, 0, buf.length);
    }

    protected void sendErrorPage(ToadletContext ctx, int code, String desc, String message) throws ToadletContextClosedException, IOException {
        this.sendErrorPage(ctx, code, desc, new HTMLNode("#", message));
    }

    protected void sendErrorPage(ToadletContext ctx, int code, String desc, HTMLNode message) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(desc, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode);
        infoboxContent.addChild(message);
        infoboxContent.addChild("br");
        infoboxContent.addChild("a", "href", ".", Toadlet.l10n("returnToPrevPage"));
        infoboxContent.addChild("br");
        Toadlet.addHomepageLink(infoboxContent);
        this.writeHTMLReply(ctx, code, desc, pageNode.generate());
    }

    protected void sendErrorPage(ToadletContext ctx, String desc, String message, Throwable t) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(desc, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode);
        infoboxContent.addChild("#", message);
        infoboxContent.addChild("br");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t);
        t.printStackTrace(pw);
        pw.close();
        infoboxContent.addChild("pre", sw.toString());
        infoboxContent.addChild("br");
        infoboxContent.addChild("a", "href", ".", Toadlet.l10n("returnToPrevPage"));
        Toadlet.addHomepageLink(infoboxContent);
        this.writeHTMLReply(ctx, 500, desc, pageNode.generate());
    }

    protected void writeInternalError(Throwable t, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        Logger.error(this, "Caught " + t, t);
        String msg = "<html><head><title>" + L10n.getString("Toadlet.internalErrorTitle") + "</title></head><body><h1>" + L10n.getString("Toadlet.internalErrorPleaseReport") + "</h1><pre>";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        msg = msg + sw.toString() + "</pre></body></html>";
        this.writeHTMLReply(ctx, 500, "Internal Error", msg);
    }

    protected static void addHomepageLink(HTMLNode content) {
        content.addChild("a", new String[]{"href", "title"}, new String[]{"/", Toadlet.l10n("homepage")}, Toadlet.l10n("returnToNodeHomepage"));
    }

    protected HighLevelSimpleClient getClientImpl() {
        return this.client;
    }
}

