/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.PeerManager;
import freenet.node.PeerNodeStatus;
import freenet.node.RequestStarterGroup;
import freenet.node.Version;
import freenet.support.HTMLNode;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class StatisticsToadlet
extends Toadlet {
    static final NumberFormat thousendPoint = NumberFormat.getInstance();
    private final Node node;
    private final NodeClientCore core;
    private final NodeStats stats;
    private final PeerManager peers;
    private final DecimalFormat fix1p1 = new DecimalFormat("0.0");
    private final DecimalFormat fix1p2 = new DecimalFormat("0.00");
    private final DecimalFormat fix1p4 = new DecimalFormat("0.0000");
    private final DecimalFormat fix1p6sci = new DecimalFormat("0.######E0");
    private final DecimalFormat fix3p1pct = new DecimalFormat("##0.0%");
    private final DecimalFormat fix3p1US = new DecimalFormat("##0.0", new DecimalFormatSymbols(Locale.US));
    private final DecimalFormat fix3pctUS = new DecimalFormat("##0%", new DecimalFormatSymbols(Locale.US));
    private final DecimalFormat fix6p6 = new DecimalFormat("#####0.0#####");
    private static final int PEER_CIRCLE_RADIUS = 100;
    private static final int PEER_CIRCLE_INNER_RADIUS = 60;
    private static final int PEER_CIRCLE_ADDITIONAL_FREE_SPACE = 10;
    private static final long MAX_CIRCLE_AGE_THRESHOLD = 86400000L;
    private static final int HISTOGRAM_LENGTH = 10;

    protected StatisticsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.stats = this.node.nodeStats;
        this.peers = this.node.peers;
    }

    public String supportedMethods() {
        return "GET";
    }

    private int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        int peerCount = peerNodeStatuses.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            if (!peerNodeStatuses[peerIndex].recordStatus() || peerNodeStatuses[peerIndex].getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedServers(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (int peerIndex = 0; peerIndex < peerNodeStatuses.length; ++peerIndex) {
            if (!peerNodeStatuses[peerIndex].isSeedServer()) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedClients(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (int peerIndex = 0; peerIndex < peerNodeStatuses.length; ++peerIndex) {
            if (!peerNodeStatuses[peerIndex].isSeedClient()) continue;
            ++count;
        }
        return count;
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        SubConfig nodeConfig = this.node.config.get("node");
        PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
        Arrays.sort(peerNodeStatuses, new Comparator<PeerNodeStatus>(){

            @Override
            public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
                int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                if (statusDifference != 0) {
                    return statusDifference;
                }
                return 0;
            }
        });
        int numberOfConnected = this.getPeerStatusCount(peerNodeStatuses, 1);
        int numberOfRoutingBackedOff = this.getPeerStatusCount(peerNodeStatuses, 2);
        int numberOfTooNew = this.getPeerStatusCount(peerNodeStatuses, 3);
        int numberOfTooOld = this.getPeerStatusCount(peerNodeStatuses, 4);
        int numberOfDisconnected = this.getPeerStatusCount(peerNodeStatuses, 5);
        int numberOfNeverConnected = this.getPeerStatusCount(peerNodeStatuses, 6);
        int numberOfDisabled = this.getPeerStatusCount(peerNodeStatuses, 7);
        int numberOfBursting = this.getPeerStatusCount(peerNodeStatuses, 8);
        int numberOfListening = this.getPeerStatusCount(peerNodeStatuses, 9);
        int numberOfListenOnly = this.getPeerStatusCount(peerNodeStatuses, 10);
        int numberOfSeedServers = this.getCountSeedServers(peerNodeStatuses);
        int numberOfSeedClients = this.getCountSeedClients(peerNodeStatuses);
        int numberOfRoutingDisabled = this.getPeerStatusCount(peerNodeStatuses, 14);
        int numberOfClockProblem = this.getPeerStatusCount(peerNodeStatuses, 11);
        int numberOfConnError = this.getPeerStatusCount(peerNodeStatuses, 12);
        int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
        PageNode page = ctx.getPageMaker().getPageNode(StatisticsToadlet.l10n("fullTitle", new String[]{"name"}, new String[]{this.node.getMyName()}), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        long now = System.currentTimeMillis();
        double myLocation = this.node.getLocation();
        long nodeUptimeSeconds = (now - this.node.startupTime) / 1000L;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createSummary());
        }
        int mode = ctx.getPageMaker().drawModeSelectionArray(this.core, request, contentNode);
        double swaps = this.node.getSwaps();
        double noSwaps = this.node.getNoSwaps();
        HTMLNode overviewTable = contentNode.addChild("table", "class", "column");
        HTMLNode overviewTableRow = overviewTable.addChild("tr");
        HTMLNode nextTableCell = overviewTableRow.addChild("td", "class", "first");
        HTMLNode versionInfobox = nextTableCell.addChild("div", "class", "infobox");
        this.drawNodeVersionBox(versionInfobox);
        HTMLNode jvmStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
        this.drawJVMStatsBox(jvmStatsInfobox);
        HTMLNode statGatheringContent = ctx.getPageMaker().getInfobox("#", StatisticsToadlet.l10n("statisticGatheringTitle"), nextTableCell);
        if (this.node.isUsingWrapper()) {
            HTMLNode threadDumpForm = ctx.addFormChild(statGatheringContent, "/", "threadDumpForm");
            threadDumpForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "getThreadDump", StatisticsToadlet.l10n("threadDumpButton")});
        }
        HTMLNode JEStatsForm = ctx.addFormChild(statGatheringContent, "/", "JEStatsForm");
        JEStatsForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "getJEStatsDump", StatisticsToadlet.l10n("jeDumpButton")});
        HTMLNode logsList = statGatheringContent.addChild("ul");
        if (nodeConfig.config.get("logger").getBoolean("enabled")) {
            logsList.addChild("li").addChild("a", new String[]{"href", "target"}, new String[]{"/?latestlog", "_blank"}, StatisticsToadlet.l10n("getLogs"));
        }
        logsList.addChild("li").addChild("a", "href", "/translation/?getOverrideTranlationFile").addChild("#", L10n.getString("TranslationToadlet.downloadTranslationsFile"));
        if (mode >= 2) {
            HTMLNode storeSizeInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawStoreSizeBox(storeSizeInfobox, myLocation, nodeUptimeSeconds);
            if (numberOfConnected + numberOfRoutingBackedOff > 0) {
                RequestStarterGroup starters = this.core.requestStarters;
                double window = starters.getWindow();
                double realWindow = starters.getRealWindow();
                HTMLNode loadStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                loadStatsInfobox.addChild("div", "class", "infobox-header", "Load limiting");
                HTMLNode loadStatsContent = loadStatsInfobox.addChild("div", "class", "infobox-content");
                HTMLNode loadStatsList = loadStatsContent.addChild("ul");
                loadStatsList.addChild("li", "Global window: " + window);
                loadStatsList.addChild("li", "Real global window: " + realWindow);
                loadStatsList.addChild("li", starters.statsPageLine(false, false));
                loadStatsList.addChild("li", starters.statsPageLine(true, false));
                loadStatsList.addChild("li", starters.statsPageLine(false, true));
                loadStatsList.addChild("li", starters.statsPageLine(true, true));
                loadStatsList.addChild("li", starters.diagnosticThrottlesLine(false));
                loadStatsList.addChild("li", starters.diagnosticThrottlesLine(true));
                HTMLNode successRateBox = nextTableCell.addChild("div", "class", "infobox");
                successRateBox.addChild("div", "class", "infobox-header", "Success rates");
                HTMLNode successRateContent = successRateBox.addChild("div", "class", "infobox-content");
                this.stats.fillSuccessRateBox(successRateContent);
                HTMLNode timeDetailBox = nextTableCell.addChild("div", "class", "infobox");
                timeDetailBox.addChild("div", "class", "infobox-header", "Detailed timings (local CHK fetches)");
                HTMLNode timingsContent = timeDetailBox.addChild("div", "class", "infobox-content");
                this.stats.fillDetailedTimingsBox(timingsContent);
            }
        }
        if (mode >= 2 || numberOfConnected + numberOfRoutingBackedOff > 0) {
            nextTableCell = overviewTableRow.addChild("td", "class", "last");
            HTMLNode activityInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawActivityBox(activityInfobox, mode >= 2);
            if (mode >= 2) {
                HTMLNode overviewInfobox = nextTableCell.addChild("div", "class", "infobox");
                this.drawOverviewBox(overviewInfobox, nodeUptimeSeconds, now, swaps, noSwaps);
            }
            HTMLNode peerStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
            StatisticsToadlet.drawPeerStatsBox(peerStatsInfobox, mode >= 2, numberOfConnected, numberOfRoutingBackedOff, numberOfTooNew, numberOfTooOld, numberOfDisconnected, numberOfNeverConnected, numberOfDisabled, numberOfBursting, numberOfListening, numberOfListenOnly, numberOfSeedServers, numberOfSeedClients, numberOfRoutingDisabled, numberOfClockProblem, numberOfConnError, numberOfDisconnecting);
            HTMLNode bandwidthInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawBandwidthBox(bandwidthInfobox, nodeUptimeSeconds, mode >= 2);
        }
        if (mode >= 2) {
            HTMLNode backoffReasonInfobox = nextTableCell.addChild("div", "class", "infobox");
            backoffReasonInfobox.addChild("div", "class", "infobox-header", "Peer backoff reasons");
            HTMLNode backoffReasonContent = backoffReasonInfobox.addChild("div", "class", "infobox-content");
            String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons();
            if (routingBackoffReasons.length == 0) {
                backoffReasonContent.addChild("#", "Good, your node is not backed off from any peers!");
            } else {
                HTMLNode reasonList = backoffReasonContent.addChild("ul");
                for (int i = 0; i < routingBackoffReasons.length; ++i) {
                    int reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReasons[i]);
                    if (reasonCount <= 0) continue;
                    reasonList.addChild("li", routingBackoffReasons[i] + '\u00a0' + reasonCount);
                }
            }
            HTMLNode locationSwapInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawSwapStatsBox(locationSwapInfobox, myLocation, nodeUptimeSeconds, swaps, noSwaps);
            HTMLNode unclaimedFIFOMessageCountsInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawUnclaimedFIFOMessageCountsBox(unclaimedFIFOMessageCountsInfobox);
            HTMLNode threadsPriorityInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawThreadPriorityStatsBox(threadsPriorityInfobox);
            nextTableCell = overviewTableRow.addChild("td");
            HTMLNode threadUsageInfobox = nextTableCell.addChild("div", "class", "infobox");
            threadUsageInfobox.addChild("div", "class", "infobox-header", "Thread usage");
            HTMLNode threadUsageContent = threadUsageInfobox.addChild("div", "class", "infobox-content");
            HTMLNode threadUsageList = threadUsageContent.addChild("ul");
            this.getThreadNames(threadUsageList);
            this.drawRejectReasonsBox(nextTableCell, false);
            this.drawRejectReasonsBox(nextTableCell, true);
            HTMLNode databaseJobsInfobox = nextTableCell.addChild("div", "class", "infobox");
            this.drawDatabaseJobsBox(databaseJobsInfobox);
            overviewTableRow = overviewTable.addChild("tr");
            nextTableCell = overviewTableRow.addChild("td", "class", "first");
            HTMLNode peerCircleInfobox = nextTableCell.addChild("div", "class", "infobox");
            peerCircleInfobox.addChild("div", "class", "infobox-header", "Peer\u00a0Location\u00a0Distribution (w/pReject)");
            HTMLNode peerCircleTable = peerCircleInfobox.addChild("div", "class", "infobox-content").addChild("table");
            this.addPeerCircle(peerCircleTable, peerNodeStatuses, myLocation);
            nextTableCell = overviewTableRow.addChild("td");
            HTMLNode nodeCircleInfobox = nextTableCell.addChild("div", "class", "infobox");
            nodeCircleInfobox.addChild("div", "class", "infobox-header", "Node\u00a0Location\u00a0Distribution (w/Swap\u00a0Age)");
            HTMLNode nodeCircleTable = nodeCircleInfobox.addChild("div", "class", "infobox-content").addChild("table");
            this.addNodeCircle(nodeCircleTable, myLocation);
            overviewTableRow = overviewTable.addChild("tr");
            nextTableCell = overviewTableRow.addChild("td", "class", "first");
            int[] incomingRequestCountArray = new int[1];
            int[] incomingRequestLocation = this.stats.getIncomingRequestLocation(incomingRequestCountArray);
            int incomingRequestsCount = incomingRequestCountArray[0];
            if (incomingRequestsCount > 0) {
                HTMLNode nodeSpecialisationInfobox = nextTableCell.addChild("div", "class", "infobox");
                nodeSpecialisationInfobox.addChild("div", "class", "infobox-header", "Incoming\u00a0Request\u00a0Distribution");
                HTMLNode nodeSpecialisationTable = nodeSpecialisationInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addSpecialisation(nodeSpecialisationTable, myLocation, incomingRequestsCount, incomingRequestLocation);
            }
            nextTableCell = overviewTableRow.addChild("td");
            int[] outgoingLocalRequestCountArray = new int[1];
            int[] outgoingLocalRequestLocation = this.stats.getOutgoingLocalRequestLocation(outgoingLocalRequestCountArray);
            int outgoingLocalRequestsCount = outgoingLocalRequestCountArray[0];
            int[] outgoingRequestCountArray = new int[1];
            int[] outgoingRequestLocation = this.stats.getOutgoingRequestLocation(outgoingRequestCountArray);
            int outgoingRequestsCount = outgoingRequestCountArray[0];
            if (outgoingLocalRequestsCount > 0 && outgoingRequestsCount > 0) {
                HTMLNode nodeSpecialisationInfobox = nextTableCell.addChild("div", "class", "infobox");
                nodeSpecialisationInfobox.addChild("div", "class", "infobox-header", "Outgoing\u00a0Request\u00a0Distribution");
                HTMLNode nodeSpecialisationTable = nodeSpecialisationInfobox.addChild("div", "class", "infobox-content").addChild("table");
                this.addCombinedSpecialisation(nodeSpecialisationTable, myLocation, outgoingLocalRequestsCount, outgoingLocalRequestLocation, outgoingRequestsCount, outgoingRequestLocation);
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void drawRejectReasonsBox(HTMLNode nextTableCell, boolean local) {
        boolean success;
        HTMLNode rejectReasonsTable = new HTMLNode("table");
        NodeStats stats = this.node.nodeStats;
        boolean bl = success = local ? stats.getLocalRejectReasonsTable(rejectReasonsTable) : stats.getRejectReasonsTable(rejectReasonsTable);
        if (!success) {
            return;
        }
        HTMLNode rejectReasonsInfobox = nextTableCell.addChild("div", "class", "infobox");
        rejectReasonsInfobox.addChild("div", "class", "infobox-header", (local ? "Local " : "") + "Preemptive Rejection Reasons");
        rejectReasonsInfobox.addChild("div", "class", "infobox-content").addChild(rejectReasonsTable);
    }

    private void drawNodeVersionBox(HTMLNode versionInfobox) {
        versionInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("versionTitle"));
        HTMLNode versionInfoboxContent = versionInfobox.addChild("div", "class", "infobox-content");
        HTMLNode versionInfoboxList = versionInfoboxContent.addChild("ul");
        versionInfoboxList.addChild("li", L10n.getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{"0.7", Integer.toString(Version.buildNumber()), "build01217"}));
        if (NodeStarter.extBuildNumber < 26) {
            versionInfoboxList.addChild("li", L10n.getString("WelcomeToadlet.extVersionWithRecommended", new String[]{"build", "recbuild", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), Integer.toString(26), NodeStarter.extRevisionNumber}));
        } else {
            versionInfoboxList.addChild("li", L10n.getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber}));
        }
    }

    private void drawJVMStatsBox(HTMLNode jvmStatsInfobox) {
        jvmStatsInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("jvmInfoTitle"));
        HTMLNode jvmStatsInfoboxContent = jvmStatsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode jvmStatsList = jvmStatsInfoboxContent.addChild("ul");
        Runtime rt = Runtime.getRuntime();
        long freeMemory = rt.freeMemory();
        long totalMemory = rt.totalMemory();
        long maxMemory = rt.maxMemory();
        long usedJavaMem = totalMemory - freeMemory;
        long allocatedJavaMem = totalMemory;
        long maxJavaMem = maxMemory;
        int availableCpus = rt.availableProcessors();
        int threadCount = this.stats.getActiveThreadCount();
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("usedMemory", "memory", SizeUtil.formatSize(usedJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("allocMemory", "memory", SizeUtil.formatSize(allocatedJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("maxMemory", "memory", SizeUtil.formatSize(maxJavaMem, true)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("threads", new String[]{"running", "max"}, new String[]{thousendPoint.format(threadCount), Integer.toString(this.stats.getThreadLimit())}));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("cpus", "count", Integer.toString(availableCpus)));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("javaVersion", "version", System.getProperty("java.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("jvmVendor", "vendor", System.getProperty("java.vendor")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("jvmVersion", "version", System.getProperty("java.vm.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osName", "name", System.getProperty("os.name")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osVersion", "version", System.getProperty("os.version")));
        jvmStatsList.addChild("li", StatisticsToadlet.l10n("osArch", "arch", System.getProperty("os.arch")));
    }

    private void drawThreadPriorityStatsBox(HTMLNode node) {
        node.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("threadsByPriority"));
        HTMLNode threadsInfoboxContent = node.addChild("div", "class", "infobox-content");
        int[] activeThreadsByPriority = this.stats.getActiveThreadsByPriority();
        int[] waitingThreadsByPriority = this.stats.getWaitingThreadsByPriority();
        HTMLNode threadsByPriorityTable = threadsInfoboxContent.addChild("table", "border", "0");
        HTMLNode row = threadsByPriorityTable.addChild("tr");
        row.addChild("th", StatisticsToadlet.l10n("priority"));
        row.addChild("th", StatisticsToadlet.l10n("running"));
        row.addChild("th", StatisticsToadlet.l10n("waiting"));
        for (int i = 0; i < activeThreadsByPriority.length; ++i) {
            row = threadsByPriorityTable.addChild("tr");
            row.addChild("td", String.valueOf(i + 1));
            row.addChild("td", String.valueOf(activeThreadsByPriority[i]));
            row.addChild("td", String.valueOf(waitingThreadsByPriority[i]));
        }
    }

    private void drawDatabaseJobsBox(HTMLNode node) {
        node.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("databaseJobsByPriority"));
        HTMLNode threadsInfoboxContent = node.addChild("div", "class", "infobox-content");
        int[] jobsByPriority = this.core.clientDatabaseExecutor.queuedJobs();
        HTMLNode threadsByPriorityTable = threadsInfoboxContent.addChild("table", "border", "0");
        HTMLNode row = threadsByPriorityTable.addChild("tr");
        row.addChild("th", StatisticsToadlet.l10n("priority"));
        row.addChild("th", StatisticsToadlet.l10n("waiting"));
        for (int i = 0; i < jobsByPriority.length; ++i) {
            row = threadsByPriorityTable.addChild("tr");
            row.addChild("td", String.valueOf(i));
            row.addChild("td", String.valueOf(jobsByPriority[i]));
        }
    }

    private void drawStoreSizeBox(HTMLNode storeSizeInfobox, double loc, long nodeUptimeSeconds) {
        storeSizeInfobox.addChild("div", "class", "infobox-header", "Datastore");
        HTMLNode storeSizeInfoboxContent = storeSizeInfobox.addChild("div", "class", "infobox-content");
        HTMLNode storeSizeTable = storeSizeInfoboxContent.addChild("table", "border", "0");
        HTMLNode row = storeSizeTable.addChild("tr");
        row.addChild("th", "");
        row.addChild("th", "Store");
        row.addChild("th", "Cache");
        long fix32kb = 32768L;
        long cachedKeys = this.node.getChkDatacache().keyCount();
        long cachedSize = cachedKeys * 32768L;
        long storeKeys = this.node.getChkDatastore().keyCount();
        long storeSize = storeKeys * 32768L;
        long maxCachedKeys = this.node.getChkDatacache().getMaxKeys();
        long maxStoreKeys = this.node.getChkDatastore().getMaxKeys();
        long cacheHits = this.node.getChkDatacache().hits();
        long cacheMisses = this.node.getChkDatacache().misses();
        long cacheAccesses = cacheHits + cacheMisses;
        long storeHits = this.node.getChkDatastore().hits();
        long storeMisses = this.node.getChkDatastore().misses();
        long storeAccesses = storeHits + storeMisses;
        long cacheWrites = this.node.getChkDatacache().writes();
        long storeWrites = this.node.getChkDatastore().writes();
        long cacheFalsePos = this.node.getChkDatacache().getBloomFalsePositive();
        long storeFalsePos = this.node.getChkDatastore().getBloomFalsePositive();
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Keys");
        row.addChild("td", thousendPoint.format(storeKeys));
        row.addChild("td", thousendPoint.format(cachedKeys));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Capacity");
        row.addChild("td", thousendPoint.format(maxStoreKeys));
        row.addChild("td", thousendPoint.format(maxCachedKeys));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Data Size");
        row.addChild("td", SizeUtil.formatSize(storeSize, true));
        row.addChild("td", SizeUtil.formatSize(cachedSize, true));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Utilization");
        row.addChild("td", this.fix3p1pct.format(1.0 * (double)storeKeys / (double)maxStoreKeys));
        row.addChild("td", this.fix3p1pct.format(1.0 * (double)cachedKeys / (double)maxCachedKeys));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Read-Requests");
        row.addChild("td", thousendPoint.format(storeAccesses));
        row.addChild("td", thousendPoint.format(cacheAccesses));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Successful Reads");
        if (storeAccesses > 0L) {
            row.addChild("td", thousendPoint.format(storeHits));
        } else {
            row.addChild("td", "0");
        }
        if (cacheAccesses > 0L) {
            row.addChild("td", thousendPoint.format(cacheHits));
        } else {
            row.addChild("td", "0");
        }
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Success Rate");
        if (storeAccesses > 0L) {
            row.addChild("td", this.fix1p4.format(100.0 * (double)storeHits / (double)storeAccesses) + "%");
        } else {
            row.addChild("td", "N/A");
        }
        if (cacheAccesses > 0L) {
            row.addChild("td", this.fix1p4.format(100.0 * (double)cacheHits / (double)cacheAccesses) + "%");
        } else {
            row.addChild("td", "N/A");
        }
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Writes");
        row.addChild("td", thousendPoint.format(storeWrites));
        row.addChild("td", thousendPoint.format(cacheWrites));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Access Rate");
        row.addChild("td", this.fix1p2.format(1.0 * (double)storeAccesses / (double)nodeUptimeSeconds) + " /sec");
        row.addChild("td", this.fix1p2.format(1.0 * (double)cacheAccesses / (double)nodeUptimeSeconds) + " /sec");
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Write Rate");
        row.addChild("td", this.fix1p2.format(1.0 * (double)storeWrites / (double)nodeUptimeSeconds) + " /sec");
        row.addChild("td", this.fix1p2.format(1.0 * (double)cacheWrites / (double)nodeUptimeSeconds) + " /sec");
        if (storeFalsePos != -1L || cacheFalsePos != -1L) {
            row = storeSizeTable.addChild("tr");
            row.addChild("td", "False Pos.");
            row.addChild("td", thousendPoint.format(storeFalsePos));
            row.addChild("td", thousendPoint.format(cacheFalsePos));
        }
        double nodeLoc = 0.0;
        double avgCacheLocation = this.node.nodeStats.avgCacheLocation.currentValue();
        double avgStoreLocation = this.node.nodeStats.avgStoreLocation.currentValue();
        double avgCacheSuccess = this.node.nodeStats.avgCacheSuccess.currentValue();
        double avgStoreSuccess = this.node.nodeStats.avgStoreSuccess.currentValue();
        double furthestCacheSuccess = this.node.nodeStats.furthestCacheSuccess;
        double furthestStoreSuccess = this.node.nodeStats.furthestStoreSuccess;
        double storeDist = Location.distance(nodeLoc, avgStoreLocation);
        double cacheDist = Location.distance(nodeLoc, avgCacheLocation);
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Avg. Location");
        row.addChild("td", this.fix1p4.format(avgStoreLocation));
        row.addChild("td", this.fix1p4.format(avgCacheLocation));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Avg. Success Loc.");
        row.addChild("td", this.fix1p4.format(avgStoreSuccess));
        row.addChild("td", this.fix1p4.format(avgCacheSuccess));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Furthest Success");
        row.addChild("td", this.fix1p4.format(furthestStoreSuccess));
        row.addChild("td", this.fix1p4.format(furthestCacheSuccess));
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Avg. Distance");
        row.addChild("td", this.fix1p4.format(storeDist));
        row.addChild("td", this.fix1p4.format(cacheDist));
        long cacheLocationReports = this.node.nodeStats.avgCacheLocation.countReports();
        long storeLocationReports = this.node.nodeStats.avgStoreLocation.countReports();
        double storePercent = 1.0 * (double)storeLocationReports / (double)storeKeys;
        double cachePercent = 1.0 * (double)cacheLocationReports / (double)cachedKeys;
        if (storePercent > 1.0) {
            storePercent = 1.0;
        }
        if (cachePercent > 1.0) {
            cachePercent = 1.0;
        }
        row = storeSizeTable.addChild("tr");
        row.addChild("td", "Distance Stats");
        row.addChild("td", this.fix3p1pct.format(storePercent));
        row.addChild("td", this.fix3p1pct.format(cachePercent));
    }

    private void drawUnclaimedFIFOMessageCountsBox(HTMLNode unclaimedFIFOMessageCountsInfobox) {
        unclaimedFIFOMessageCountsInfobox.addChild("div", "class", "infobox-header", "unclaimedFIFO Message Counts");
        HTMLNode unclaimedFIFOMessageCountsInfoboxContent = unclaimedFIFOMessageCountsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode unclaimedFIFOMessageCountsList = unclaimedFIFOMessageCountsInfoboxContent.addChild("ul");
        Map<String, Integer> unclaimedFIFOMessageCountsMap = this.node.getUSM().getUnclaimedFIFOMessageCounts();
        STMessageCount[] unclaimedFIFOMessageCountsArray = new STMessageCount[unclaimedFIFOMessageCountsMap.size()];
        int i = 0;
        int totalCount = 0;
        for (Map.Entry<String, Integer> e : unclaimedFIFOMessageCountsMap.entrySet()) {
            String messageName = e.getKey();
            int messageCount = e.getValue();
            totalCount += messageCount;
            unclaimedFIFOMessageCountsArray[i++] = new STMessageCount(messageName, messageCount);
        }
        Arrays.sort(unclaimedFIFOMessageCountsArray, new Comparator<STMessageCount>(){

            @Override
            public int compare(STMessageCount firstCount, STMessageCount secondCount) {
                return secondCount.messageCount - firstCount.messageCount;
            }
        });
        for (STMessageCount messageCountItem : unclaimedFIFOMessageCountsArray) {
            int thisMessageCount = messageCountItem.messageCount;
            double thisMessagePercentOfTotal = (double)thisMessageCount / (double)totalCount;
            unclaimedFIFOMessageCountsList.addChild("li", "" + messageCountItem.messageName + ":\u00a0" + thisMessageCount + "\u00a0(" + this.fix3p1pct.format(thisMessagePercentOfTotal) + ')');
        }
        unclaimedFIFOMessageCountsList.addChild("li", "Unclaimed Messages Considered:\u00a0" + totalCount);
    }

    private void drawSwapStatsBox(HTMLNode locationSwapInfobox, double location, long nodeUptimeSeconds, double swaps, double noSwaps) {
        locationSwapInfobox.addChild("div", "class", "infobox-header", "Location swaps");
        int startedSwaps = this.node.getStartedSwaps();
        int swapsRejectedAlreadyLocked = this.node.getSwapsRejectedAlreadyLocked();
        int swapsRejectedNowhereToGo = this.node.getSwapsRejectedNowhereToGo();
        int swapsRejectedRateLimit = this.node.getSwapsRejectedRateLimit();
        int swapsRejectedRecognizedID = this.node.getSwapsRejectedRecognizedID();
        double locChangeSession = this.node.getLocationChangeSession();
        int averageSwapTime = this.node.getAverageOutgoingSwapTime();
        int sendSwapInterval = this.node.getSendSwapInterval();
        HTMLNode locationSwapInfoboxContent = locationSwapInfobox.addChild("div", "class", "infobox-content");
        HTMLNode locationSwapList = locationSwapInfoboxContent.addChild("ul");
        locationSwapList.addChild("li", "location:\u00a0" + location);
        if (swaps > 0.0) {
            locationSwapList.addChild("li", "locChangeSession:\u00a0" + this.fix1p6sci.format(locChangeSession));
            locationSwapList.addChild("li", "locChangePerSwap:\u00a0" + this.fix1p6sci.format(locChangeSession / swaps));
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "locChangePerMinute:\u00a0" + this.fix1p6sci.format(locChangeSession / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "swapsPerMinute:\u00a0" + this.fix1p6sci.format(swaps / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (noSwaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationSwapList.addChild("li", "noSwapsPerMinute:\u00a0" + this.fix1p6sci.format(noSwaps / ((double)nodeUptimeSeconds / 60.0)));
        }
        if (swaps > 0.0 && noSwaps > 0.0) {
            locationSwapList.addChild("li", "swapsPerNoSwaps:\u00a0" + this.fix1p6sci.format(swaps / noSwaps));
        }
        if (swaps > 0.0) {
            locationSwapList.addChild("li", "swaps:\u00a0" + (int)swaps);
        }
        if (noSwaps > 0.0) {
            locationSwapList.addChild("li", "noSwaps:\u00a0" + (int)noSwaps);
        }
        if (startedSwaps > 0) {
            locationSwapList.addChild("li", "startedSwaps:\u00a0" + startedSwaps);
        }
        if (swapsRejectedAlreadyLocked > 0) {
            locationSwapList.addChild("li", "swapsRejectedAlreadyLocked:\u00a0" + swapsRejectedAlreadyLocked);
        }
        if (swapsRejectedNowhereToGo > 0) {
            locationSwapList.addChild("li", "swapsRejectedNowhereToGo:\u00a0" + swapsRejectedNowhereToGo);
        }
        if (swapsRejectedRateLimit > 0) {
            locationSwapList.addChild("li", "swapsRejectedRateLimit:\u00a0" + swapsRejectedRateLimit);
        }
        if (swapsRejectedRecognizedID > 0) {
            locationSwapList.addChild("li", "swapsRejectedRecognizedID:\u00a0" + swapsRejectedRecognizedID);
        }
        locationSwapList.addChild("li", "averageSwapTime:\u00a0" + TimeUtil.formatTime(averageSwapTime, 2, true));
        locationSwapList.addChild("li", "sendSwapInterval:\u00a0" + TimeUtil.formatTime(sendSwapInterval, 2, true));
    }

    protected static void drawPeerStatsBox(HTMLNode peerStatsInfobox, boolean advancedModeEnabled, int numberOfConnected, int numberOfRoutingBackedOff, int numberOfTooNew, int numberOfTooOld, int numberOfDisconnected, int numberOfNeverConnected, int numberOfDisabled, int numberOfBursting, int numberOfListening, int numberOfListenOnly, int numberOfSeedServers, int numberOfSeedClients, int numberOfRoutingDisabled, int numberOfClockProblem, int numberOfConnError, int numberOfDisconnecting) {
        HTMLNode peerStatsRoutingDisabledListItem;
        HTMLNode peerStatsListenOnlyListItem;
        peerStatsInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("peerStatsTitle"));
        HTMLNode peerStatsContent = peerStatsInfobox.addChild("div", "class", "infobox-content");
        HTMLNode peerStatsList = peerStatsContent.addChild("ul");
        if (numberOfConnected > 0) {
            HTMLNode peerStatsConnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsConnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_connected", StatisticsToadlet.l10nDark("connected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("connectedShort"));
            peerStatsConnectedListItem.addChild("span", ":\u00a0" + numberOfConnected);
        }
        if (numberOfRoutingBackedOff > 0) {
            HTMLNode peerStatsRoutingBackedOffListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingBackedOffListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_backed_off", StatisticsToadlet.l10nDark(advancedModeEnabled ? "backedOff" : "busy"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark((advancedModeEnabled ? "backedOff" : "busy") + "Short"));
            peerStatsRoutingBackedOffListItem.addChild("span", ":\u00a0" + numberOfRoutingBackedOff);
        }
        if (numberOfTooNew > 0) {
            HTMLNode peerStatsTooNewListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsTooNewListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_too_new", StatisticsToadlet.l10nDark("tooNew"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("tooNewShort"));
            peerStatsTooNewListItem.addChild("span", ":\u00a0" + numberOfTooNew);
        }
        if (numberOfTooOld > 0) {
            HTMLNode peerStatsTooOldListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsTooOldListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_too_old", StatisticsToadlet.l10nDark("tooOld"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("tooOldShort"));
            peerStatsTooOldListItem.addChild("span", ":\u00a0" + numberOfTooOld);
        }
        if (numberOfDisconnected > 0) {
            HTMLNode peerStatsDisconnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsDisconnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disconnected", StatisticsToadlet.l10nDark("notConnected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("notConnectedShort"));
            peerStatsDisconnectedListItem.addChild("span", ":\u00a0" + numberOfDisconnected);
        }
        if (numberOfNeverConnected > 0) {
            HTMLNode peerStatsNeverConnectedListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsNeverConnectedListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_never_connected", StatisticsToadlet.l10nDark("neverConnected"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("neverConnectedShort"));
            peerStatsNeverConnectedListItem.addChild("span", ":\u00a0" + numberOfNeverConnected);
        }
        if (numberOfDisabled > 0) {
            HTMLNode peerStatsDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disabled", StatisticsToadlet.l10nDark("disabled"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("disabledShort"));
            peerStatsDisabledListItem.addChild("span", ":\u00a0" + numberOfDisabled);
        }
        if (numberOfBursting > 0) {
            HTMLNode peerStatsBurstingListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsBurstingListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_bursting", StatisticsToadlet.l10nDark("bursting"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("burstingShort"));
            peerStatsBurstingListItem.addChild("span", ":\u00a0" + numberOfBursting);
        }
        if (numberOfListening > 0) {
            HTMLNode peerStatsListeningListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListeningListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("listening"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("listeningShort"));
            peerStatsListeningListItem.addChild("span", ":\u00a0" + numberOfListening);
        }
        if (numberOfListenOnly > 0) {
            peerStatsListenOnlyListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListenOnlyListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listen_only", StatisticsToadlet.l10nDark("listenOnly"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("listenOnlyShort"));
            peerStatsListenOnlyListItem.addChild("span", ":\u00a0" + numberOfListenOnly);
        }
        if (numberOfClockProblem > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_clock_problem", StatisticsToadlet.l10nDark("clockProblem"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("clockProblemShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfClockProblem);
        }
        if (numberOfConnError > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_routing_disabled", StatisticsToadlet.l10nDark("connError"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("connErrorShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfClockProblem);
        }
        if (numberOfDisconnecting > 0) {
            peerStatsListenOnlyListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsListenOnlyListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_disconnecting", StatisticsToadlet.l10nDark("disconnecting"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("disconnectingShort"));
            peerStatsListenOnlyListItem.addChild("span", ":\u00a0" + numberOfDisconnecting);
        }
        if (numberOfSeedServers > 0) {
            HTMLNode peerStatsSeedServersListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsSeedServersListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("seedServers"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("seedServersShort"));
            peerStatsSeedServersListItem.addChild("span", ":\u00a0" + numberOfSeedServers);
        }
        if (numberOfSeedClients > 0) {
            HTMLNode peerStatsSeedClientsListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsSeedClientsListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_listening", StatisticsToadlet.l10nDark("seedClients"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("seedClientsShort"));
            peerStatsSeedClientsListItem.addChild("span", ":\u00a0" + numberOfSeedClients);
        }
        if (numberOfRoutingDisabled > 0) {
            peerStatsRoutingDisabledListItem = peerStatsList.addChild("li").addChild("span");
            peerStatsRoutingDisabledListItem.addChild("span", new String[]{"class", "title", "style"}, new String[]{"peer_routing_disabled", StatisticsToadlet.l10nDark("routingDisabled"), "border-bottom: 1px dotted; cursor: help;"}, StatisticsToadlet.l10nDark("routingDisabledShort"));
            peerStatsRoutingDisabledListItem.addChild("span", ":\u00a0" + numberOfRoutingDisabled);
        }
    }

    private static String l10n(String key) {
        return L10n.getString("StatisticsToadlet." + key);
    }

    private static String l10nDark(String key) {
        return L10n.getString("DarknetConnectionsToadlet." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("StatisticsToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("StatisticsToadlet." + key, patterns, values);
    }

    private void drawActivityBox(HTMLNode activityInfobox, boolean advancedModeEnabled) {
        activityInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10nDark("activityTitle"));
        HTMLNode activityInfoboxContent = activityInfobox.addChild("div", "class", "infobox-content");
        HTMLNode activityList = StatisticsToadlet.drawActivity(activityInfoboxContent, this.node);
        int numARKFetchers = this.node.getNumARKFetchers();
        if (advancedModeEnabled && activityList != null) {
            if (numARKFetchers > 0) {
                activityList.addChild("li", "ARK\u00a0Fetch\u00a0Requests:\u00a0" + numARKFetchers);
            }
            activityList.addChild("li", "FetcherByUSKSize:\u00a0" + this.node.clientCore.uskManager.getFetcherByUSKSize());
            activityList.addChild("li", "BackgroundFetcherByUSKSize:\u00a0" + this.node.clientCore.uskManager.getBackgroundFetcherByUSKSize());
            activityList.addChild("li", "temporaryBackgroundFetchersLRUSize:\u00a0" + this.node.clientCore.uskManager.getTemporaryBackgroundFetchersLRU());
        }
    }

    static void drawBandwidth(HTMLNode activityList, Node node, long nodeUptimeSeconds, boolean isAdvancedModeEnabled) {
        long[] total = node.collector.getTotalIO();
        if (total[0] == 0L || total[1] == 0L) {
            return;
        }
        long total_output_rate = total[0] / nodeUptimeSeconds;
        long total_input_rate = total[1] / nodeUptimeSeconds;
        long totalPayload = node.getTotalPayloadSent();
        long total_payload_rate = totalPayload / nodeUptimeSeconds;
        int percent = (int)(100L * totalPayload / total[0]);
        long[] rate = node.nodeStats.getNodeIOStats();
        long delta = (rate[5] - rate[2]) / 1000L;
        if (delta > 0L) {
            long output_rate = (rate[3] - rate[0]) / delta;
            long input_rate = (rate[4] - rate[1]) / delta;
            SubConfig nodeConfig = node.config.get("node");
            int outputBandwidthLimit = nodeConfig.getInt("outputBandwidthLimit");
            int inputBandwidthLimit = nodeConfig.getInt("inputBandwidthLimit");
            if (inputBandwidthLimit == -1) {
                inputBandwidthLimit = outputBandwidthLimit * 4;
            }
            activityList.addChild("li", StatisticsToadlet.l10n("inputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(input_rate, true), SizeUtil.formatSize(inputBandwidthLimit, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("outputRate", new String[]{"rate", "max"}, new String[]{SizeUtil.formatSize(output_rate, true), SizeUtil.formatSize(outputBandwidthLimit, true)}));
        }
        activityList.addChild("li", StatisticsToadlet.l10n("totalInput", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[1], true), SizeUtil.formatSize(total_input_rate, true)}));
        activityList.addChild("li", StatisticsToadlet.l10n("totalOutput", new String[]{"total", "rate"}, new String[]{SizeUtil.formatSize(total[0], true), SizeUtil.formatSize(total_output_rate, true)}));
        activityList.addChild("li", StatisticsToadlet.l10n("payloadOutput", new String[]{"total", "rate", "percent"}, new String[]{SizeUtil.formatSize(totalPayload, true), SizeUtil.formatSize(total_payload_rate, true), Integer.toString(percent)}));
        if (isAdvancedModeEnabled) {
            long totalBytesSentCHKRequests = node.nodeStats.getCHKRequestTotalBytesSent();
            long totalBytesSentSSKRequests = node.nodeStats.getSSKRequestTotalBytesSent();
            long totalBytesSentCHKInserts = node.nodeStats.getCHKInsertTotalBytesSent();
            long totalBytesSentSSKInserts = node.nodeStats.getSSKInsertTotalBytesSent();
            long totalBytesSentOfferedKeys = node.nodeStats.getOfferedKeysTotalBytesSent();
            long totalBytesSendOffers = node.nodeStats.getOffersSentBytesSent();
            long totalBytesSentSwapOutput = node.nodeStats.getSwappingTotalBytesSent();
            long totalBytesSentAuth = node.nodeStats.getTotalAuthBytesSent();
            long totalBytesSentAckOnly = node.nodeStats.getNotificationOnlyPacketsSentBytes();
            long totalBytesSentResends = node.nodeStats.getResendBytesSent();
            long totalBytesSentUOM = node.nodeStats.getUOMBytesSent();
            long totalBytesSentAnnounce = node.nodeStats.getAnnounceBytesSent();
            long totalBytesSentRoutingStatus = node.nodeStats.getRoutingStatusBytes();
            long totalBytesSentNetworkColoring = node.nodeStats.getNetworkColoringSentBytes();
            long totalBytesSentPing = node.nodeStats.getPingSentBytes();
            long totalBytesSentProbeRequest = node.nodeStats.getProbeRequestSentBytes();
            long totalBytesSentRouted = node.nodeStats.getRoutedMessageSentBytes();
            long totalBytesSentDisconn = node.nodeStats.getDisconnBytesSent();
            long totalBytesSentInitial = node.nodeStats.getInitialMessagesBytesSent();
            long totalBytesSentChangedIP = node.nodeStats.getChangedIPBytesSent();
            long totalBytesSentNodeToNode = node.nodeStats.getNodeToNodeBytesSent();
            long totalBytesSentRemaining = total[0] - (totalPayload + totalBytesSentCHKRequests + totalBytesSentSSKRequests + totalBytesSentCHKInserts + totalBytesSentSSKInserts + totalBytesSentOfferedKeys + totalBytesSendOffers + totalBytesSentSwapOutput + totalBytesSentAuth + totalBytesSentAckOnly + totalBytesSentResends + totalBytesSentUOM + totalBytesSentAnnounce + totalBytesSentRoutingStatus + totalBytesSentNetworkColoring + totalBytesSentPing + totalBytesSentProbeRequest + totalBytesSentRouted + totalBytesSentDisconn + totalBytesSentInitial + totalBytesSentChangedIP + totalBytesSentNodeToNode);
            activityList.addChild("li", StatisticsToadlet.l10n("requestOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKRequests, true), SizeUtil.formatSize(totalBytesSentSSKRequests, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("insertOutput", new String[]{"chk", "ssk"}, new String[]{SizeUtil.formatSize(totalBytesSentCHKInserts, true), SizeUtil.formatSize(totalBytesSentSSKInserts, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("offeredKeyOutput", new String[]{"total", "offered"}, new String[]{SizeUtil.formatSize(totalBytesSentOfferedKeys, true), SizeUtil.formatSize(totalBytesSendOffers, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("swapOutput", "total", SizeUtil.formatSize(totalBytesSentSwapOutput, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("authBytes", "total", SizeUtil.formatSize(totalBytesSentAuth, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("ackOnlyBytes", "total", SizeUtil.formatSize(totalBytesSentAckOnly, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("resendBytes", "total", SizeUtil.formatSize(totalBytesSentResends, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("uomBytes", "total", SizeUtil.formatSize(totalBytesSentUOM, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("announceBytes", "total", SizeUtil.formatSize(totalBytesSentAnnounce, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("adminBytes", new String[]{"routingStatus", "disconn", "initial", "changedIP"}, new String[]{SizeUtil.formatSize(totalBytesSentRoutingStatus, true), SizeUtil.formatSize(totalBytesSentDisconn, true), SizeUtil.formatSize(totalBytesSentInitial, true), SizeUtil.formatSize(totalBytesSentChangedIP, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("debuggingBytes", new String[]{"netColoring", "ping", "probe", "routed"}, new String[]{SizeUtil.formatSize(totalBytesSentNetworkColoring, true), SizeUtil.formatSize(totalBytesSentPing, true), SizeUtil.formatSize(totalBytesSentProbeRequest, true), SizeUtil.formatSize(totalBytesSentRouted, true)}));
            activityList.addChild("li", StatisticsToadlet.l10n("nodeToNodeBytes", "total", SizeUtil.formatSize(totalBytesSentNodeToNode, true)));
            activityList.addChild("li", StatisticsToadlet.l10n("unaccountedBytes", new String[]{"total", "percent"}, new String[]{SizeUtil.formatSize(totalBytesSentRemaining, true), Integer.toString((int)(totalBytesSentRemaining * 100L / total[0]))}));
            double sentOverheadPerSecond = node.nodeStats.getSentOverheadPerSecond();
            activityList.addChild("li", StatisticsToadlet.l10n("totalOverhead", new String[]{"rate", "percent"}, new String[]{SizeUtil.formatSize((long)sentOverheadPerSecond), Integer.toString((int)(100.0 * sentOverheadPerSecond / (double)total_output_rate))}));
        }
    }

    static HTMLNode drawActivity(HTMLNode activityInfoboxContent, Node node) {
        int numInserts = node.getNumInsertSenders();
        int numLocalCHKInserts = node.getNumLocalCHKInserts();
        int numRemoteCHKInserts = node.getNumRemoteCHKInserts();
        int numLocalSSKInserts = node.getNumLocalSSKInserts();
        int numRemoteSSKInserts = node.getNumRemoteSSKInserts();
        int numRequests = node.getNumRequestSenders();
        int numLocalCHKRequests = node.getNumLocalCHKRequests();
        int numRemoteCHKRequests = node.getNumRemoteCHKRequests();
        int numLocalSSKRequests = node.getNumLocalSSKRequests();
        int numRemoteSSKRequests = node.getNumRemoteSSKRequests();
        int numTransferringRequests = node.getNumTransferringRequestSenders();
        int numTransferringRequestHandlers = node.getNumTransferringRequestHandlers();
        int numCHKOfferReplys = node.getNumCHKOfferReplies();
        int numSSKOfferReplys = node.getNumSSKOfferReplies();
        int numCHKRequests = numLocalCHKRequests + numRemoteCHKRequests;
        int numSSKRequests = numLocalSSKRequests + numRemoteSSKRequests;
        int numCHKInserts = numLocalCHKInserts + numRemoteCHKInserts;
        int numSSKInserts = numLocalSSKInserts + numRemoteSSKInserts;
        int numIncomingTurtles = node.getNumIncomingTurtles();
        if (numInserts == 0 && numRequests == 0 && numTransferringRequests == 0 && numCHKRequests == 0 && numSSKRequests == 0 && numCHKInserts == 0 && numSSKInserts == 0 && numTransferringRequestHandlers == 0 && numCHKOfferReplys == 0 && numSSKOfferReplys == 0) {
            activityInfoboxContent.addChild("#", StatisticsToadlet.l10n("noRequests"));
            return null;
        }
        HTMLNode activityList = activityInfoboxContent.addChild("ul");
        if (numInserts > 0 || numCHKInserts > 0 || numSSKInserts > 0) {
            activityList.addChild("li", L10n.getString("StatisticsToadlet.activityInserts", new String[]{"totalSenders", "CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numInserts), Integer.toString(numCHKInserts), Integer.toString(numSSKInserts), Integer.toString(numLocalCHKInserts + numLocalSSKInserts)}));
        }
        if (numRequests > 0 || numCHKRequests > 0 || numSSKRequests > 0) {
            activityList.addChild("li", L10n.getString("StatisticsToadlet.activityRequests", new String[]{"totalSenders", "CHKhandlers", "SSKhandlers", "local"}, new String[]{Integer.toString(numRequests), Integer.toString(numCHKRequests), Integer.toString(numSSKRequests), Integer.toString(numLocalCHKRequests + numLocalSSKRequests)}));
        }
        if (numTransferringRequests > 0 || numTransferringRequestHandlers > 0 || numIncomingTurtles > 0) {
            activityList.addChild("li", L10n.getString("StatisticsToadlet.transferringRequests", new String[]{"senders", "receivers", "turtles"}, new String[]{Integer.toString(numTransferringRequests), Integer.toString(numTransferringRequestHandlers), Integer.toString(numIncomingTurtles)}));
        }
        if (numCHKOfferReplys > 0 || numSSKOfferReplys > 0) {
            activityList.addChild("li", L10n.getString("StatisticsToadlet.offerReplys", new String[]{"chk", "ssk"}, new String[]{Integer.toString(numCHKOfferReplys), Integer.toString(numSSKOfferReplys)}));
        }
        return activityList;
    }

    private void drawOverviewBox(HTMLNode overviewInfobox, long nodeUptimeSeconds, long now, double swaps, double noSwaps) {
        overviewInfobox.addChild("div", "class", "infobox-header", "Node status overview");
        HTMLNode overviewInfoboxContent = overviewInfobox.addChild("div", "class", "infobox-content");
        HTMLNode overviewList = overviewInfoboxContent.addChild("ul");
        int bwlimitDelayTime = (int)this.stats.getBwlimitDelayTime();
        int nodeAveragePingTime = (int)this.stats.getNodeAveragePingTime();
        double numberOfRemotePeerLocationsSeenInSwaps = this.node.getNumberOfRemotePeerLocationsSeenInSwaps();
        int darknetSizeEstimateSession = this.stats.getDarknetSizeEstimate(-1L);
        int darknetSizeEstimate24h = 0;
        int darknetSizeEstimate48h = 0;
        if (nodeUptimeSeconds > 86400L) {
            darknetSizeEstimate24h = this.stats.getDarknetSizeEstimate(now - 86400000L);
        }
        if (nodeUptimeSeconds > 172800L) {
            darknetSizeEstimate48h = this.stats.getDarknetSizeEstimate(now - 172800000L);
        }
        int opennetSizeEstimateSession = this.stats.getOpennetSizeEstimate(-1L);
        int opennetSizeEstimate24h = 0;
        int opennetSizeEstimate48h = 0;
        if (nodeUptimeSeconds > 86400L) {
            opennetSizeEstimate24h = this.stats.getOpennetSizeEstimate(now - 86400000L);
        }
        if (nodeUptimeSeconds > 172800L) {
            opennetSizeEstimate48h = this.stats.getOpennetSizeEstimate(now - 172800000L);
        }
        double routingMissDistance = this.stats.routingMissDistance.currentValue();
        double backedOffPercent = this.stats.backedOffPercent.currentValue();
        String nodeUptimeString = TimeUtil.formatTime(nodeUptimeSeconds * 1000L);
        overviewList.addChild("li", "bwlimitDelayTime:\u00a0" + bwlimitDelayTime + "ms");
        overviewList.addChild("li", "nodeAveragePingTime:\u00a0" + nodeAveragePingTime + "ms");
        overviewList.addChild("li", "darknetSizeEstimateSession:\u00a0" + darknetSizeEstimateSession + "\u00a0nodes");
        if (nodeUptimeSeconds > 86400L) {
            overviewList.addChild("li", "darknetSizeEstimate24h:\u00a0" + darknetSizeEstimate24h + "\u00a0nodes");
        }
        if (nodeUptimeSeconds > 172800L) {
            overviewList.addChild("li", "darknetSizeEstimate48h:\u00a0" + darknetSizeEstimate48h + "\u00a0nodes");
        }
        overviewList.addChild("li", "opennetSizeEstimateSession:\u00a0" + opennetSizeEstimateSession + "\u00a0nodes");
        if (nodeUptimeSeconds > 86400L) {
            overviewList.addChild("li", "opennetSizeEstimate24h:\u00a0" + opennetSizeEstimate24h + "\u00a0nodes");
        }
        if (nodeUptimeSeconds > 172800L) {
            overviewList.addChild("li", "opennetSizeEstimate48h:\u00a0" + opennetSizeEstimate48h + "\u00a0nodes");
        }
        if (numberOfRemotePeerLocationsSeenInSwaps > 0.0 && (swaps > 0.0 || noSwaps > 0.0)) {
            overviewList.addChild("li", "avrConnPeersPerNode:\u00a0" + this.fix6p6.format(numberOfRemotePeerLocationsSeenInSwaps / (swaps + noSwaps)) + "\u00a0peers");
        }
        overviewList.addChild("li", "nodeUptime:\u00a0" + nodeUptimeString);
        overviewList.addChild("li", "routingMissDistance:\u00a0" + this.fix1p4.format(routingMissDistance));
        overviewList.addChild("li", "backedOffPercent:\u00a0" + this.fix3p1pct.format(backedOffPercent));
        overviewList.addChild("li", "pInstantReject:\u00a0" + this.fix3p1pct.format(this.stats.pRejectIncomingInstantly()));
        overviewList.addChild("li", "unclaimedFIFOSize:\u00a0" + this.node.getUnclaimedFIFOSize());
        overviewList.addChild("li", "RAMBucketPoolSize:\u00a0" + SizeUtil.formatSize(this.core.tempBucketFactory.getRamUsed()) + " / " + SizeUtil.formatSize(this.core.tempBucketFactory.getMaxRamUsed()));
        overviewList.addChild("li", "uptimeAverage:\u00a0" + this.fix3p1pct.format(this.node.uptime.getUptime()));
    }

    private void drawBandwidthBox(HTMLNode bandwidthInfobox, long nodeUptimeSeconds, boolean isAdvancedModeEnabled) {
        bandwidthInfobox.addChild("div", "class", "infobox-header", StatisticsToadlet.l10n("bandwidthTitle"));
        HTMLNode bandwidthInfoboxContent = bandwidthInfobox.addChild("div", "class", "infobox-content");
        HTMLNode bandwidthList = bandwidthInfoboxContent.addChild("ul");
        StatisticsToadlet.drawBandwidth(bandwidthList, this.node, nodeUptimeSeconds, isAdvancedModeEnabled);
    }

    private void getThreadNames(HTMLNode threadUsageList) {
        Thread[] threads;
        int count = 0;
        do {
            count = Math.max(this.stats.rootThreadGroup.activeCount(), count);
            threads = new Thread[count * 2 + 50];
            this.stats.rootThreadGroup.enumerate(threads);
        } while (threads[threads.length - 1] != null);
        LinkedHashMap<String, ThreadBunch> map = new LinkedHashMap<String, ThreadBunch>();
        int totalCount = 0;
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            ThreadBunch bunch;
            String name = threads[i].getName();
            if (name.indexOf(" for ") != -1) {
                name = name.substring(0, name.indexOf(" for "));
            }
            if (name.indexOf("@") != -1) {
                name = name.substring(0, name.indexOf("@"));
            }
            if (name.indexOf("(") != -1) {
                name = name.substring(0, name.indexOf("("));
            }
            if ((bunch = (ThreadBunch)map.get(name)) != null) {
                ++bunch.count;
            } else {
                map.put(name, new ThreadBunch(name, 1));
            }
            ++totalCount;
        }
        ThreadBunch[] bunches = map.values().toArray(new ThreadBunch[map.size()]);
        Arrays.sort(bunches, new Comparator<ThreadBunch>(){

            @Override
            public int compare(ThreadBunch b0, ThreadBunch b1) {
                if (b0.count > b1.count) {
                    return -1;
                }
                if (b0.count < b1.count) {
                    return 1;
                }
                return b0.name.compareTo(b1.name);
            }
        });
        for (int i = 0; i < bunches.length; ++i) {
            double thisThreadPercentOfTotal = (double)bunches[i].count / (double)totalCount;
            threadUsageList.addChild("li", "" + bunches[i].name + ":\u00a0" + Integer.toString(bunches[i].count) + "\u00a0(" + this.fix3p1pct.format(thisThreadPercentOfTotal) + ')');
        }
    }

    private void addNodeCircle(HTMLNode circleTable, double myLocation) {
        int[] histogram = new int[10];
        for (int i = 0; i < 10; ++i) {
            histogram[i] = 0;
        }
        HTMLNode nodeCircleTableRow = circleTable.addChild("tr");
        HTMLNode nodeHistogramLegendTableRow = circleTable.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = circleTable.addChild("tr");
        HTMLNode nodeCircleTableCell = nodeCircleTableRow.addChild("td", new String[]{"class", "colspan"}, new String[]{"first", "10"});
        HTMLNode nodeCircleInfoboxContent = nodeCircleTableCell.addChild("div", new String[]{"style", "class"}, new String[]{"position: relative; height: 220px; width: 220px", "peercircle"});
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.0, false, 1.0), "mark"}, "|");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.125, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.25, false, 1.0), "mark"}, "--");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.375, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.5, false, 1.0), "mark"}, "|");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.625, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.75, false, 1.0), "mark"}, "--");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.875, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.875, false, 1.0), "mark"}, "+");
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{"position: absolute; top: 100px; left: 110px", "mark"}, "+");
        Object[] knownLocsCopy = this.stats.getKnownLocations(-1L);
        Double[] locations = (Double[])knownLocsCopy[0];
        Long[] timestamps = (Long[])knownLocsCopy[1];
        double strength = 1.0;
        long now = System.currentTimeMillis();
        long age = 1L;
        int nodeCount = 0;
        for (int i = 0; i < locations.length; ++i) {
            int histogramIndex;
            ++nodeCount;
            Double location = locations[i];
            Long locationTime = timestamps[i];
            age = now - locationTime;
            if (age > 86400000L) {
                age = 86400000L;
            }
            strength = 1.0 - (double)age / 8.64E7;
            int n = histogramIndex = (int)Math.floor(location * 10.0);
            histogram[n] = histogram[n] + 1;
            nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(location, false, strength), "connected"}, "x");
        }
        nodeCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(myLocation, true, 1.0), "me"}, "x");
        for (int i = 0; i < 10; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            nodeHistogramLegendCell.addChild("div", "class", "histogramLabel").addChild("#", this.fix1p1.format((double)i / 10.0));
            double histogramPercent = (double)histogram[i] / (double)nodeCount;
            nodeHistogramGraphCell.addChild("%", "<div class=\"histogramConnected\" style=\"height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;\">\u00a0</div>");
        }
    }

    private void addSpecialisation(HTMLNode table, double peerLocation, int incomingRequestsCount, int[] incomingRequestLocation) {
        HTMLNode nodeHistogramLegendTableRow = table.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = table.addChild("tr");
        int myIndex = (int)(peerLocation * (double)incomingRequestLocation.length);
        for (int i = 0; i < incomingRequestLocation.length; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            HTMLNode nodeHistogramGraphCell2 = nodeHistogramLegendCell.addChild("div", "class", "histogramLabel");
            if (i == myIndex) {
                nodeHistogramGraphCell2 = nodeHistogramGraphCell2.addChild("span", "class", "me");
            }
            nodeHistogramGraphCell2.addChild("#", this.fix1p1.format((double)i / (double)incomingRequestLocation.length));
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format((double)incomingRequestLocation[i] / (double)incomingRequestsCount) + "; width: 100%;"}, "\u00a0");
        }
    }

    private void addCombinedSpecialisation(HTMLNode table, double peerLocation, int locallyOriginatingRequestsCount, int[] locallyOriginatingRequests, int remotelyOriginatingRequestsCount, int[] remotelyOriginatingRequests) {
        assert (locallyOriginatingRequests.length == remotelyOriginatingRequests.length);
        HTMLNode nodeHistogramLegendTableRow = table.addChild("tr");
        HTMLNode nodeHistogramGraphTableRow = table.addChild("tr");
        int myIndex = (int)(peerLocation * (double)locallyOriginatingRequests.length);
        for (int i = 0; i < locallyOriginatingRequests.length; ++i) {
            HTMLNode nodeHistogramLegendCell = nodeHistogramLegendTableRow.addChild("td");
            HTMLNode nodeHistogramGraphCell = nodeHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            HTMLNode nodeHistogramGraphCell2 = nodeHistogramLegendCell.addChild("div", "class", "histogramLabel");
            if (i == myIndex) {
                nodeHistogramGraphCell2 = nodeHistogramGraphCell2.addChild("span", "class", "me");
            }
            nodeHistogramGraphCell2.addChild("#", this.fix1p1.format((double)i / (double)locallyOriginatingRequests.length));
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format((double)locallyOriginatingRequests[i] / (double)locallyOriginatingRequestsCount) + "; width: 100%;"}, "\u00a0");
            nodeHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramDisconnected", "height: " + this.fix3pctUS.format((double)remotelyOriginatingRequests[i] / (double)remotelyOriginatingRequestsCount) + "; width: 100%;"}, "\u00a0");
        }
    }

    private void addPeerCircle(HTMLNode circleTable, PeerNodeStatus[] peerNodeStatuses, double myLocation) {
        int[] histogramConnected = new int[10];
        int[] histogramDisconnected = new int[10];
        for (int i = 0; i < 10; ++i) {
            histogramConnected[i] = 0;
            histogramDisconnected[i] = 0;
        }
        HTMLNode peerCircleTableRow = circleTable.addChild("tr");
        HTMLNode peerHistogramLegendTableRow = circleTable.addChild("tr");
        HTMLNode peerHistogramGraphTableRow = circleTable.addChild("tr");
        HTMLNode peerCircleTableCell = peerCircleTableRow.addChild("td", new String[]{"class", "colspan"}, new String[]{"first", "10"});
        HTMLNode peerCircleInfoboxContent = peerCircleTableCell.addChild("div", new String[]{"style", "class"}, new String[]{"position: relative; height: 220px; width: 220px", "peercircle"});
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.0, false, 1.0), "mark"}, "|");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.125, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.25, false, 1.0), "mark"}, "--");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.375, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.5, false, 1.0), "mark"}, "|");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.625, false, 1.0), "mark"}, "+");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(0.75, false, 1.0), "mark"}, "--");
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{"position: absolute; top: 100px; left: 110px", "mark"}, "+");
        int peerCount = peerNodeStatuses.length;
        int newPeerCount = 0;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            PeerNodeStatus peerNodeStatus = peerNodeStatuses[peerIndex];
            double peerLocation = peerNodeStatus.getLocation();
            if (!peerNodeStatus.isSearchable() || peerLocation < 0.0 || peerLocation > 1.0) continue;
            ++newPeerCount;
            double peerDistance = Location.distance(myLocation, peerLocation);
            int histogramIndex = (int)Math.floor(peerDistance * 10.0 * 2.0);
            if (peerNodeStatus.isConnected()) {
                int n = histogramIndex;
                histogramConnected[n] = histogramConnected[n] + 1;
            } else {
                int n = histogramIndex;
                histogramDisconnected[n] = histogramDisconnected[n] + 1;
            }
            peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(peerLocation, false, 1.0 - peerNodeStatus.getPReject()), peerNodeStatus.isConnected() ? "connected" : "disconnected"}, peerNodeStatus.isOpennet() ? "o" : "x");
        }
        peerCircleInfoboxContent.addChild("span", new String[]{"style", "class"}, new String[]{this.generatePeerCircleStyleString(myLocation, true, 1.0), "me"}, "x");
        for (int i = 0; i < 10; ++i) {
            HTMLNode peerHistogramLegendCell = peerHistogramLegendTableRow.addChild("td");
            HTMLNode peerHistogramGraphCell = peerHistogramGraphTableRow.addChild("td", "style", "height: 100px;");
            peerHistogramLegendCell.addChild("div", "class", "histogramLabel").addChild("#", this.fix1p2.format((double)i / 20.0));
            double histogramPercent = (double)histogramConnected[i] / (double)newPeerCount;
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramConnected", "height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;"}, "\u00a0");
            histogramPercent = (double)histogramDisconnected[i] / (double)newPeerCount;
            peerHistogramGraphCell.addChild("div", new String[]{"class", "style"}, new String[]{"histogramDisconnected", "height: " + this.fix3pctUS.format(histogramPercent) + "; width: 100%;"}, "\u00a0");
        }
    }

    private String generatePeerCircleStyleString(double peerLocation, boolean offsetMe, double strength) {
        int offset = 0;
        offset = offsetMe ? -10 : (int)(60.0 * (1.0 - strength));
        double x = 110.0 + Math.sin(peerLocation *= Math.PI * 2) * (double)(100 - offset);
        double y = 100.0 - Math.cos(peerLocation) * (double)(100 - offset);
        return "position: absolute; top: " + this.fix3p1US.format(y) + "px; left: " + this.fix3p1US.format(x) + "px";
    }

    public String path() {
        return "/stats/";
    }

    private static class ThreadBunch {
        String name;
        int count;

        public ThreadBunch(String name2, int i) {
            this.name = name2;
            this.count = i;
        }
    }

    private static class STMessageCount {
        public String messageName;
        public int messageCount;

        STMessageCount(String messageName, int messageCount) {
            this.messageName = messageName;
            this.messageCount = messageCount;
        }
    }
}

