/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.DefaultMIMETypes;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;

public class StaticToadlet
extends Toadlet {
    public static final String ROOT_URL = "/static/";
    public static final String ROOT_PATH = "staticfiles/";

    StaticToadlet() {
        super(null);
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        int r;
        String path = uri.getPath();
        if (!path.startsWith(ROOT_URL)) {
            return;
        }
        try {
            path = path.substring(ROOT_URL.length());
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathNotFound"));
            return;
        }
        if (!path.matches("^[A-Za-z0-9\\._\\/\\-]*$") || path.indexOf("..") != -1) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
            return;
        }
        InputStream strm = this.getClass().getResourceAsStream(ROOT_PATH + path);
        if (strm == null) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathNotFound"));
            return;
        }
        Bucket data = ctx.getBucketFactory().makeBucket(strm.available());
        OutputStream os = data.getOutputStream();
        byte[] cbuf = new byte[4096];
        while ((r = strm.read(cbuf)) != -1) {
            os.write(cbuf, 0, r);
        }
        strm.close();
        os.close();
        URL url = this.getClass().getResource(ROOT_PATH + path);
        Date mTime = this.getUrlMTime(url);
        ctx.sendReplyHeaders(200, "OK", null, DefaultMIMETypes.guessMIMEType(path, false), data.size(), mTime);
        ctx.writeData(data);
        data.free();
    }

    private Date getUrlMTime(URL url) {
        if (url.getProtocol().equals("jar")) {
            File f = new File(url.getPath().substring(0, url.getPath().indexOf(33)));
            return new Date(f.lastModified());
        }
        if (url.getProtocol().equals("file")) {
            File f = new File(url.getPath());
            return new Date(f.lastModified());
        }
        return null;
    }

    private String l10n(String key) {
        return L10n.getString("StaticToadlet." + key);
    }

    public String supportedMethods() {
        return "GET";
    }

    public String path() {
        return ROOT_URL;
    }
}

