/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.StaticToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.WelcomeToadlet;
import freenet.l10n.L10n;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class StartupToadlet
extends Toadlet {
    private StaticToadlet staticToadlet;
    private volatile boolean isPRNGReady = false;

    public StartupToadlet(StaticToadlet staticToadlet) {
        super(null);
        this.staticToadlet = staticToadlet;
    }

    public void handleGet(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        ctx.forceDisconnect();
        String path = uri.getPath();
        if (path.startsWith("/static/") && this.staticToadlet != null) {
            this.staticToadlet.handleGet(uri, req, ctx);
        } else {
            String desc = L10n.getString("StartupToadlet.title");
            PageNode page = ctx.getPageMaker().getPageNode(desc, false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode headNode = page.headNode;
            headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "20; url="});
            HTMLNode contentNode = page.content;
            if (!this.isPRNGReady) {
                HTMLNode prngInfoboxContent = ctx.getPageMaker().getInfobox("infobox-error", L10n.getString("StartupToadlet.entropyErrorTitle"), contentNode);
                prngInfoboxContent.addChild("#", L10n.getString("StartupToadlet.entropyErrorContent"));
            }
            HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode);
            infoboxContent.addChild("#", L10n.getString("StartupToadlet.isStartingUp"));
            WelcomeToadlet.maybeDisplayWrapperLogfile(ctx, contentNode);
            this.writeHTMLReply(ctx, 503, desc, pageNode.generate());
        }
    }

    public String supportedMethods() {
        return "GET";
    }

    public void setIsPRNGReady() {
        this.isPRNGReady = true;
    }

    public String path() {
        return "/";
    }
}

