/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PermanentRedirectException;
import freenet.clients.http.StartupToadlet;
import freenet.clients.http.StaticToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContextImpl;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.SSL;
import freenet.io.AllowedHosts;
import freenet.io.NetworkInterface;
import freenet.io.SSLNetworkInterface;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.pluginmanager.FredPluginL10n;
import freenet.support.Executor;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.api.BooleanCallback;
import freenet.support.api.BucketFactory;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.ArrayBucketFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;

public final class SimpleToadletServer
implements ToadletContainer,
Runnable {
    private final LinkedList<ToadletElement> toadlets;
    private final int port;
    private String bindTo;
    private String allowedHosts;
    private NetworkInterface networkInterface;
    private boolean ssl = false;
    public static final int DEFAULT_FPROXY_PORT = 8888;
    private final AllowedHosts allowedFullAccess;
    private boolean publicGatewayMode;
    private PageMaker.THEME cssTheme;
    private File cssOverride;
    private boolean advancedModeEnabled;
    private final PageMaker pageMaker;
    private Thread myThread;
    private final Executor executor;
    private BucketFactory bf;
    private NodeClientCore core;
    private boolean doRobots;
    private boolean enablePersistentConnections;
    private boolean enableInlinePrefetch;
    private boolean enableActivelinks;
    static boolean isPanicButtonToBeShown;
    public BookmarkManager bookmarkManager;
    private volatile boolean fProxyJavascriptEnabled;
    private volatile boolean fproxyHasCompletedWizard;
    private volatile boolean disableProgressPage;
    private boolean haveCalledFProxy = false;
    public StartupToadlet startupToadlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFproxy() {
        SimpleToadletServer simpleToadletServer = this;
        synchronized (simpleToadletServer) {
            if (this.haveCalledFProxy) {
                return;
            }
            this.haveCalledFProxy = true;
        }
        this.bookmarkManager = new BookmarkManager(this.core);
        try {
            FProxyToadlet.maybeCreateFProxyEtc(this.core, this.core.node, this.core.node.config, this, this.bookmarkManager);
        }
        catch (IOException e) {
            Logger.error(this, "Could not start fproxy: " + e, e);
            System.err.println("Could not start fproxy:");
            e.printStackTrace();
        }
    }

    public synchronized void setCore(NodeClientCore core) {
        this.core = core;
    }

    public SimpleToadletServer(SubConfig fproxyConfig, BucketFactory bucketFactory, Executor executor) throws IOException, InvalidConfigValueException {
        this.executor = executor;
        int configItemOrder = 0;
        fproxyConfig.register("enabled", true, configItemOrder++, true, true, "SimpleToadletServer.enabled", "SimpleToadletServer.enabledLong", new FProxyEnabledCallback());
        boolean enabled = fproxyConfig.getBoolean("enabled");
        fproxyConfig.register("ssl", false, configItemOrder++, true, true, "SimpleToadletServer.ssl", "SimpleToadletServer.sslLong", new FProxySSLCallback());
        fproxyConfig.register("port", 8888, configItemOrder++, true, true, "SimpleToadletServer.port", "SimpleToadletServer.portLong", (IntCallback)new FProxyPortCallback(), false);
        fproxyConfig.register("bindTo", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.bindTo", "SimpleToadletServer.bindToLong", new FProxyBindtoCallback());
        fproxyConfig.register("css", "clean", configItemOrder++, false, false, "SimpleToadletServer.cssName", "SimpleToadletServer.cssNameLong", new FProxyCSSNameCallback());
        fproxyConfig.register("CSSOverride", "", configItemOrder++, true, false, "SimpleToadletServer.cssOverride", "SimpleToadletServer.cssOverrideLong", new FProxyCSSOverrideCallback());
        fproxyConfig.register("advancedModeEnabled", false, configItemOrder++, true, false, "SimpleToadletServer.advancedMode", "SimpleToadletServer.advancedModeLong", new FProxyAdvancedModeEnabledCallback(this));
        fproxyConfig.register("javascriptEnabled", true, configItemOrder++, true, false, "SimpleToadletServer.enableJS", "SimpleToadletServer.enableJSLong", new FProxyJavascriptEnabledCallback(this));
        fproxyConfig.register("hasCompletedWizard", false, configItemOrder++, true, false, "SimpleToadletServer.hasCompletedWizard", "SimpleToadletServer.hasCompletedWizardLong", new BooleanCallback(){

            public Boolean get() {
                return SimpleToadletServer.this.fproxyHasCompletedWizard;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (this.get().equals(val)) {
                    return;
                }
                SimpleToadletServer.this.fproxyHasCompletedWizard = val;
            }
        });
        fproxyConfig.register("disableProgressPage", false, configItemOrder++, true, false, "SimpleToadletServer.disableProgressPage", "SimpleToadletServer.disableProgressPageLong", new BooleanCallback(){

            public Boolean get() {
                return SimpleToadletServer.this.disableProgressPage;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.disableProgressPage = val;
            }
        });
        this.fproxyHasCompletedWizard = fproxyConfig.getBoolean("hasCompletedWizard");
        this.fProxyJavascriptEnabled = fproxyConfig.getBoolean("javascriptEnabled");
        this.disableProgressPage = fproxyConfig.getBoolean("disableProgressPage");
        fproxyConfig.register("showPanicButton", false, configItemOrder++, true, true, "SimpleToadletServer.panicButton", "SimpleToadletServer.panicButtonLong", new BooleanCallback(){

            public Boolean get() {
                return isPanicButtonToBeShown;
            }

            public void set(Boolean value) {
                if (value == isPanicButtonToBeShown) {
                    return;
                }
                isPanicButtonToBeShown = value;
            }
        });
        fproxyConfig.register("publicGatewayMode", false, configItemOrder++, true, true, "SimpleToadletServer.publicGatewayMode", "SimpleToadletServer.publicGatewayModeLong", new BooleanCallback(){

            public Boolean get() {
                return SimpleToadletServer.this.publicGatewayMode;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.publicGatewayMode = val;
            }
        });
        this.publicGatewayMode = fproxyConfig.getBoolean("publicGatewayMode");
        fproxyConfig.register("enablePersistentConnections", false, configItemOrder++, true, false, "SimpleToadletServer.enablePersistentConnections", "SimpleToadletServer.enablePersistentConnectionsLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    return SimpleToadletServer.this.enablePersistentConnections;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.enablePersistentConnections = val;
                }
            }
        });
        this.enablePersistentConnections = fproxyConfig.getBoolean("enablePersistentConnections");
        fproxyConfig.register("enableInlinePrefetch", false, configItemOrder++, true, false, "SimpleToadletServer.enableInlinePrefetch", "SimpleToadletServer.enableInlinePrefetchLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    return SimpleToadletServer.this.enableInlinePrefetch;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.enableInlinePrefetch = val;
                }
            }
        });
        this.enableInlinePrefetch = fproxyConfig.getBoolean("enableInlinePrefetch");
        fproxyConfig.register("enableActivelinks", false, configItemOrder++, false, false, "SimpleToadletServer.enableActivelinks", "SimpleToadletServer.enableActivelinksLong", new BooleanCallback(){

            public Boolean get() {
                return SimpleToadletServer.this.enableActivelinks;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.enableActivelinks = val;
            }
        });
        this.enableActivelinks = fproxyConfig.getBoolean("enableActivelinks");
        fproxyConfig.register("passthroughMaxSize", 0x200000L, configItemOrder++, true, false, "SimpleToadletServer.passthroughMaxSize", "SimpleToadletServer.passthroughMaxSizeLong", (LongCallback)new FProxyPassthruMaxSize(), true);
        FProxyToadlet.MAX_LENGTH = fproxyConfig.getLong("passthroughMaxSize");
        fproxyConfig.register("allowedHosts", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.allowedHosts", "SimpleToadletServer.allowedHostsLong", new FProxyAllowedHostsCallback());
        fproxyConfig.register("allowedHostsFullAccess", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.allowedFullAccess", "SimpleToadletServer.allowedFullAccessLong", new StringCallback(){

            public String get() {
                return SimpleToadletServer.this.allowedFullAccess.getAllowedHosts();
            }

            public void set(String val) throws InvalidConfigValueException {
                SimpleToadletServer.this.allowedFullAccess.setAllowedHosts(val);
            }
        });
        this.allowedFullAccess = new AllowedHosts(fproxyConfig.getString("allowedHostsFullAccess"));
        fproxyConfig.register("doRobots", false, configItemOrder++, true, false, "SimpleToadletServer.doRobots", "SimpleToadletServer.doRobotsLong", new BooleanCallback(){

            public Boolean get() {
                return SimpleToadletServer.this.doRobots;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer.this.doRobots = val;
            }
        });
        this.doRobots = fproxyConfig.getBoolean("doRobots");
        isPanicButtonToBeShown = fproxyConfig.getBoolean("showPanicButton");
        this.bf = bucketFactory;
        this.port = fproxyConfig.getInt("port");
        this.bindTo = fproxyConfig.getString("bindTo");
        String cssName = fproxyConfig.getString("css");
        if (cssName.indexOf(58) != -1 || cssName.indexOf(47) != -1) {
            throw new InvalidConfigValueException("CSS name must not contain slashes or colons!");
        }
        this.cssTheme = PageMaker.THEME.themeFromName(cssName);
        this.pageMaker = new PageMaker(this.cssTheme);
        if (!fproxyConfig.getOption("CSSOverride").isDefault()) {
            this.cssOverride = new File(fproxyConfig.getString("CSSOverride"));
            this.pageMaker.setOverride(this.cssOverride);
        } else {
            this.cssOverride = null;
        }
        this.advancedModeEnabled = fproxyConfig.getBoolean("advancedModeEnabled");
        this.toadlets = new LinkedList();
        if (SSL.available()) {
            this.ssl = fproxyConfig.getBoolean("ssl");
        }
        this.allowedHosts = fproxyConfig.getString("allowedHosts");
        if (!enabled) {
            Logger.normal(this, "Not starting FProxy as it's disabled");
            System.out.println("Not starting FProxy as it's disabled");
        } else {
            this.maybeGetNetworkInterface();
            this.myThread = new Thread((Runnable)this, "SimpleToadletServer");
            this.myThread.setDaemon(true);
        }
        StaticToadlet statictoadlet = new StaticToadlet();
        this.register(statictoadlet, null, "/static/", false, false);
        this.startupToadlet = new StartupToadlet(statictoadlet);
        this.register(this.startupToadlet, null, "/", false, false);
    }

    public void removeStartupToadlet() {
        this.unregister(this.startupToadlet);
        this.startupToadlet = null;
    }

    private void maybeGetNetworkInterface() throws IOException {
        if (this.networkInterface != null) {
            return;
        }
        this.networkInterface = this.ssl ? SSLNetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.executor, true) : NetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.executor, true);
    }

    public boolean doRobots() {
        return this.doRobots;
    }

    public boolean publicGatewayMode() {
        return this.publicGatewayMode;
    }

    public void start() {
        if (this.myThread != null) {
            try {
                this.maybeGetNetworkInterface();
                this.myThread.start();
                Logger.normal(this, "Starting FProxy on " + this.bindTo + ':' + this.port);
                System.out.println("Starting FProxy on " + this.bindTo + ':' + this.port);
            }
            catch (IOException e) {
                Logger.error(this, "Could not bind network port for FProxy?", e);
            }
        }
    }

    public void register(Toadlet t, String menu, String urlPrefix, boolean atFront, boolean fullOnly) {
        this.register(t, menu, urlPrefix, atFront, null, null, fullOnly, null);
    }

    public void register(Toadlet t, String menu, String urlPrefix, boolean atFront, String name, String title, boolean fullOnly, LinkEnabledCallback cb) {
        ToadletElement te = new ToadletElement(t, urlPrefix);
        if (atFront) {
            this.toadlets.addFirst(te);
        } else {
            this.toadlets.addLast(te);
        }
        t.container = this;
        if (name != null) {
            this.pageMaker.addNavigationLink(menu, urlPrefix, name, title, fullOnly, cb);
        }
    }

    public void registerMenu(String link, String name, String title, FredPluginL10n plugin) {
        this.pageMaker.addNavigationCategory(link, name, title, plugin);
    }

    public synchronized void unregister(Toadlet t) {
        Iterator i = this.toadlets.iterator();
        while (i.hasNext()) {
            ToadletElement e = (ToadletElement)i.next();
            if (e.t != t) continue;
            i.remove();
            return;
        }
    }

    public StartupToadlet getStartupToadlet() {
        return this.startupToadlet;
    }

    public Toadlet findToadlet(URI uri) throws PermanentRedirectException {
        String path = uri.getPath();
        if (!(this.fproxyHasCompletedWizard || this.core != null && this.core.node != null && (this.core.node.isOpennetEnabled() || this.core.node.getPeerNodes().length > 0) || path.startsWith("/wizard/") || path.startsWith("/static/"))) {
            try {
                throw new PermanentRedirectException(new URI("/wizard/"));
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
        }
        for (ToadletElement te : this.toadlets) {
            URI newURI;
            if (path.startsWith(te.prefix)) {
                return te.t;
            }
            if (te.prefix.length() <= 0 || te.prefix.charAt(te.prefix.length() - 1) != '/' || !path.equals(te.prefix.substring(0, te.prefix.length() - 1))) continue;
            try {
                newURI = new URI(te.prefix);
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
            throw new PermanentRedirectException(newURI);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.networkInterface.setSoTimeout(500);
        }
        catch (SocketException e1) {
            Logger.error(this, "Could not set so-timeout to 500ms; on-the-fly disabling of the interface will not work");
        }
        while (true) {
            SimpleToadletServer e1 = this;
            synchronized (e1) {
                if (this.myThread == null) {
                    return;
                }
            }
            Socket conn = this.networkInterface.accept();
            if (conn == null) continue;
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Accepted connection");
            }
            SocketHandler sh = new SocketHandler(conn);
            sh.start();
        }
    }

    public PageMaker.THEME getTheme() {
        return this.cssTheme;
    }

    public void setCSSName(PageMaker.THEME theme) {
        this.cssTheme = theme;
    }

    public synchronized boolean isAdvancedModeEnabled() {
        return this.advancedModeEnabled;
    }

    public synchronized void enableAdvancedMode(boolean b) {
        this.advancedModeEnabled = b;
    }

    public synchronized boolean isFProxyJavascriptEnabled() {
        return this.fProxyJavascriptEnabled;
    }

    public synchronized void enableFProxyJavascript(boolean b) {
        this.fProxyJavascriptEnabled = b;
    }

    public String getFormPassword() {
        if (this.core == null) {
            return "";
        }
        return this.core.formPassword;
    }

    public boolean isAllowedFullAccess(InetAddress remoteAddr) {
        return this.allowedFullAccess.allowed(remoteAddr);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("SimpleToadletServer." + key, pattern, value);
    }

    private static String l10n(String key) {
        return L10n.getString("SimpleToadletServer." + key);
    }

    public HTMLNode addFormChild(HTMLNode parentNode, String target, String id) {
        HTMLNode formNode = parentNode.addChild("form", new String[]{"action", "method", "enctype", "id", "accept-charset"}, new String[]{target, "post", "multipart/form-data", id, "utf-8"}).addChild("div");
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.getFormPassword()});
        return formNode;
    }

    public void setBucketFactory(BucketFactory tempBucketFactory) {
        this.bf = tempBucketFactory;
    }

    public boolean isEnabled() {
        return this.myThread != null;
    }

    public BookmarkManager getBookmarks() {
        return this.bookmarkManager;
    }

    public FreenetURI[] getBookmarkURIs() {
        if (this.bookmarkManager == null) {
            return new FreenetURI[0];
        }
        return this.bookmarkManager.getBookmarkURIs();
    }

    public boolean enablePersistentConnections() {
        return this.enablePersistentConnections;
    }

    public boolean enableInlinePrefetch() {
        return this.enableInlinePrefetch;
    }

    public synchronized boolean allowPosts() {
        return !(this.bf instanceof ArrayBucketFactory);
    }

    public synchronized BucketFactory getBucketFactory() {
        return this.bf;
    }

    public boolean enableActivelinks() {
        return this.enableActivelinks;
    }

    public boolean disableProgressPage() {
        return this.disableProgressPage;
    }

    public PageMaker getPageMaker() {
        return this.pageMaker;
    }

    public class SocketHandler
    implements Runnable {
        Socket sock;

        public SocketHandler(Socket conn) {
            this.sock = conn;
        }

        void start() {
            SimpleToadletServer.this.executor.execute(this, "HTTP socket handler@" + this.hashCode());
        }

        public void run() {
            Logger.OSThread.logPID(this);
            boolean logMINOR = Logger.shouldLog(4, this);
            if (logMINOR) {
                Logger.minor(this, "Handling connection");
            }
            try {
                ToadletContextImpl.handle(this.sock, SimpleToadletServer.this, SimpleToadletServer.this.pageMaker);
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                System.err.println("SimpleToadletServer request above failed.");
                Logger.error(this, "OOM in SocketHandler");
            }
            catch (Throwable t) {
                System.err.println("Caught in SimpleToadletServer: " + t);
                t.printStackTrace();
                Logger.error(this, "Caught in SimpleToadletServer: " + t, t);
            }
            if (logMINOR) {
                Logger.minor(this, "Handled connection");
            }
        }
    }

    private static class FProxyJavascriptEnabledCallback
    extends BooleanCallback {
        private final SimpleToadletServer ts;

        FProxyJavascriptEnabledCallback(SimpleToadletServer ts) {
            this.ts = ts;
        }

        public Boolean get() {
            return this.ts.isFProxyJavascriptEnabled();
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.ts.enableFProxyJavascript(val);
        }
    }

    private static class FProxyAdvancedModeEnabledCallback
    extends BooleanCallback {
        private final SimpleToadletServer ts;

        FProxyAdvancedModeEnabledCallback(SimpleToadletServer ts) {
            this.ts = ts;
        }

        public Boolean get() {
            return this.ts.isAdvancedModeEnabled();
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.ts.enableAdvancedMode(val);
        }
    }

    private class FProxyEnabledCallback
    extends BooleanCallback {
        private FProxyEnabledCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean get() {
            SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
            synchronized (simpleToadletServer) {
                return SimpleToadletServer.this.myThread != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
            synchronized (simpleToadletServer) {
                if (!val.booleanValue()) {
                    SimpleToadletServer.this.myThread.interrupt();
                    SimpleToadletServer.this.myThread = null;
                    return;
                }
                SimpleToadletServer.this.myThread = new Thread((Runnable)SimpleToadletServer.this, "SimpleToadletServer");
            }
            SimpleToadletServer.this.createFproxy();
            SimpleToadletServer.this.myThread.setDaemon(true);
            SimpleToadletServer.this.myThread.start();
        }
    }

    private class FProxyCSSOverrideCallback
    extends StringCallback {
        private FProxyCSSOverrideCallback() {
        }

        public String get() {
            return SimpleToadletServer.this.cssOverride == null ? "" : SimpleToadletServer.this.cssOverride.toString();
        }

        public void set(String val) throws InvalidConfigValueException {
            if (SimpleToadletServer.this.core == null) {
                return;
            }
            if (val.equals(this.get()) || val.equals("")) {
                SimpleToadletServer.this.cssOverride = null;
            } else {
                File tmp = new File(val.trim());
                if (!SimpleToadletServer.this.core.allowUploadFrom(tmp)) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("cssOverrideNotInUploads", "filename", tmp.toString()));
                }
                if (!tmp.canRead() || !tmp.isFile()) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("cssOverrideCantRead", "filename", tmp.toString()));
                }
                SimpleToadletServer.this.cssOverride = tmp.getAbsoluteFile();
            }
            SimpleToadletServer.this.pageMaker.setOverride(SimpleToadletServer.this.cssOverride);
        }
    }

    private class FProxyCSSNameCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private FProxyCSSNameCallback() {
        }

        public String get() {
            return ((SimpleToadletServer)SimpleToadletServer.this).cssTheme.code;
        }

        public void set(String CSSName) throws InvalidConfigValueException {
            if (CSSName.indexOf(58) != -1 || CSSName.indexOf(47) != -1) {
                throw new InvalidConfigValueException(SimpleToadletServer.l10n("illegalCSSName"));
            }
            SimpleToadletServer.this.cssTheme = PageMaker.THEME.themeFromName(CSSName);
            SimpleToadletServer.this.pageMaker.setTheme(SimpleToadletServer.this.cssTheme);
            if (((SimpleToadletServer)SimpleToadletServer.this).core.node.pluginManager != null) {
                ((SimpleToadletServer)SimpleToadletServer.this).core.node.pluginManager.setFProxyTheme(SimpleToadletServer.this.cssTheme);
            }
        }

        public String[] getPossibleValues() {
            return PageMaker.THEME.possibleValues;
        }
    }

    private class FProxyAllowedHostsCallback
    extends StringCallback {
        private FProxyAllowedHostsCallback() {
        }

        public String get() {
            return SimpleToadletServer.this.networkInterface.getAllowedHosts();
        }

        public void set(String allowedHosts) {
            if (!allowedHosts.equals(this.get())) {
                SimpleToadletServer.this.networkInterface.setAllowedHosts(allowedHosts);
            }
        }
    }

    private class FProxyBindtoCallback
    extends StringCallback {
        private FProxyBindtoCallback() {
        }

        public String get() {
            return SimpleToadletServer.this.bindTo;
        }

        public void set(String bindTo) throws InvalidConfigValueException {
            if (!bindTo.equals(this.get())) {
                try {
                    SimpleToadletServer.this.networkInterface.setBindTo(bindTo, false);
                    SimpleToadletServer.this.bindTo = bindTo;
                }
                catch (IOException e) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("couldNotChangeBindTo", "error", e.getLocalizedMessage()));
                }
            }
        }
    }

    private class FProxyPortCallback
    extends IntCallback {
        private Integer savedPort;

        private FProxyPortCallback() {
        }

        public Integer get() {
            if (this.savedPort == null) {
                this.savedPort = SimpleToadletServer.this.port;
            }
            return this.savedPort;
        }

        public void set(Integer newPort) throws NodeNeedRestartException {
            if (this.savedPort.intValue() != newPort.intValue()) {
                this.savedPort = SimpleToadletServer.this.port;
                throw new NodeNeedRestartException("Port cannot change on the fly");
            }
        }
    }

    private static class FProxyPassthruMaxSize
    extends LongCallback {
        private FProxyPassthruMaxSize() {
        }

        public Long get() {
            return FProxyToadlet.MAX_LENGTH;
        }

        public void set(Long val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            FProxyToadlet.MAX_LENGTH = val;
        }
    }

    private class FProxySSLCallback
    extends BooleanCallback {
        private FProxySSLCallback() {
        }

        public Boolean get() {
            return SimpleToadletServer.this.ssl;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (!SSL.available()) {
                throw new InvalidConfigValueException("Enable SSL support before use ssl with Fproxy");
            }
            SimpleToadletServer.this.ssl = val;
            throw new InvalidConfigValueException("Cannot change SSL on the fly, please restart freenet");
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    private static class ToadletElement {
        Toadlet t;
        String prefix;

        public ToadletElement(Toadlet t2, String urlPrefix) {
            this.t = t2;
            this.prefix = urlPrefix;
        }
    }
}

