/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class SimpleHelpToadlet
extends Toadlet {
    final NodeClientCore core;

    SimpleHelpToadlet(HighLevelSimpleClient client, NodeClientCore c) {
        super(client);
        this.core = c;
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode("Freenet " + L10n.getString("FProxyToadlet.help"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createSummary());
        }
        HTMLNode helpScreenContent1 = ctx.getPageMaker().getInfobox("infobox-content", L10n.getString("SimpleHelpToadlet.descriptionTitle"), contentNode);
        helpScreenContent1.addChild("#", L10n.getString("SimpleHelpToadlet.descriptionText"));
        HTMLNode helpScreenContent2 = ctx.getPageMaker().getInfobox("infobox-content", L10n.getString("SimpleHelpToadlet.definitionsTitle"), contentNode);
        HTMLNode table = helpScreenContent2.addChild("table", new String[]{"border", "style"}, new String[]{"0", "border: none"});
        HTMLNode row = table.addChild("tr");
        HTMLNode cell = row.addChild("td", "style", "border: none");
        row.addChild("#", L10n.getString("SimpleHelpToadlet.CHK"));
        row.addChild("br");
        row.addChild("#", L10n.getString("SimpleHelpToadlet.SSK"));
        row.addChild("br");
        row.addChild("#", L10n.getString("SimpleHelpToadlet.USK"));
        HTMLNode helpScreenContent3 = ctx.getPageMaker().getInfobox("infobox-content", L10n.getString("SimpleHelpToadlet.connectivityTitle"), contentNode);
        helpScreenContent3.addChild("#", L10n.getString("SimpleHelpToadlet.connectivityText"));
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public String supportedMethods() {
        return "GET";
    }

    public String path() {
        return "/help/";
    }
}

