/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.support.HTMLNode;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class SecurityLevelsToadlet
extends Toadlet {
    private final NodeClientCore core;
    private final Node node;

    SecurityLevelsToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.core = core;
        this.node = node;
    }

    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        String pass = request.getPartAsString("formPassword", 32);
        if (pass == null || !pass.equals(this.core.formPassword)) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", "/seclevels/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        if (request.isPartSet("seclevels")) {
            HTMLNode pageNode = null;
            HTMLNode content = null;
            HTMLNode ul = null;
            HTMLNode formNode = null;
            boolean changedAnything = false;
            String configName = "security-levels.networkThreatLevel";
            String confirm = "security-levels.networkThreatLevel.confirm";
            String tryConfirm = "security-levels.networkThreatLevel.tryConfirm";
            String networkThreatLevel = request.getPartAsString(configName, 128);
            SecurityLevels.NETWORK_THREAT_LEVEL newThreatLevel = SecurityLevels.parseNetworkThreatLevel(networkThreatLevel);
            if (newThreatLevel != null && newThreatLevel != this.node.securityLevels.getNetworkThreatLevel()) {
                if (!request.isPartSet(confirm) && !request.isPartSet(tryConfirm)) {
                    HTMLNode warning = this.node.securityLevels.getConfirmWarning(newThreatLevel, confirm);
                    if (warning != null) {
                        if (pageNode == null) {
                            PageNode page = ctx.getPageMaker().getPageNode(L10n.getString("ConfigToadlet.fullTitle", new String[]{"name"}, new String[]{this.node.getMyName()}), ctx);
                            pageNode = page.outer;
                            content = page.content;
                            formNode = ctx.addFormChild(content, ".", "configFormSecLevels");
                            ul = formNode.addChild("ul", "class", "config");
                        }
                        HTMLNode seclevelGroup = ul.addChild("li");
                        seclevelGroup.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", configName, networkThreatLevel});
                        HTMLNode infobox = seclevelGroup.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", this.l10nSec("networkThreatLevelConfirmTitle", "mode", SecurityLevels.localisedName(newThreatLevel)));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addChild(warning);
                        infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", tryConfirm, "on"});
                    } else {
                        this.node.securityLevels.setThreatLevel(newThreatLevel);
                        changedAnything = true;
                    }
                } else if (request.isPartSet(confirm)) {
                    this.node.securityLevels.setThreatLevel(newThreatLevel);
                    changedAnything = true;
                }
            }
            configName = "security-levels.friendsThreatLevel";
            confirm = "security-levels.friendsThreatLevel.confirm";
            tryConfirm = "security-levels.friendsThreatLevel.tryConfirm";
            String friendsThreatLevel = request.getPartAsString(configName, 128);
            SecurityLevels.FRIENDS_THREAT_LEVEL newFriendsLevel = SecurityLevels.parseFriendsThreatLevel(friendsThreatLevel);
            if (newFriendsLevel != null && newFriendsLevel != this.node.securityLevels.getFriendsThreatLevel()) {
                if (!request.isPartSet(confirm) && !request.isPartSet(tryConfirm)) {
                    HTMLNode warning = this.node.securityLevels.getConfirmWarning(newFriendsLevel, confirm);
                    if (warning != null) {
                        if (pageNode == null) {
                            PageNode page = ctx.getPageMaker().getPageNode(L10n.getString("ConfigToadlet.fullTitle", new String[]{"name"}, new String[]{this.node.getMyName()}), ctx);
                            pageNode = page.outer;
                            content = page.content;
                            formNode = ctx.addFormChild(content, ".", "configFormSecLevels");
                            ul = formNode.addChild("ul", "class", "config");
                        }
                        HTMLNode seclevelGroup = ul.addChild("li");
                        seclevelGroup.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", configName, friendsThreatLevel});
                        HTMLNode infobox = seclevelGroup.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", this.l10nSec("friendsThreatLevelConfirmTitle", "mode", SecurityLevels.localisedName(newFriendsLevel)));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addChild(warning);
                        infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", tryConfirm, "on"});
                    } else {
                        this.node.securityLevels.setThreatLevel(newFriendsLevel);
                        changedAnything = true;
                    }
                } else if (request.isPartSet(confirm)) {
                    this.node.securityLevels.setThreatLevel(newFriendsLevel);
                    changedAnything = true;
                }
            }
            configName = "security-levels.physicalThreatLevel";
            confirm = "security-levels.physicalThreatLevel.confirm";
            tryConfirm = "security-levels.physicalThreatLevel.tryConfirm";
            String physicalThreatLevel = request.getPartAsString(configName, 128);
            SecurityLevels.PHYSICAL_THREAT_LEVEL newPhysicalLevel = SecurityLevels.parsePhysicalThreatLevel(physicalThreatLevel);
            if (newPhysicalLevel != null && newPhysicalLevel != this.node.securityLevels.getPhysicalThreatLevel()) {
                this.node.securityLevels.setThreatLevel(newPhysicalLevel);
                changedAnything = true;
            }
            if (changedAnything) {
                this.core.storeConfig();
            }
            if (pageNode != null) {
                formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
                formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", SecurityLevelsToadlet.l10n("apply")});
                formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", SecurityLevelsToadlet.l10n("reset")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", "/seclevels/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        try {
            throw new RedirectException("/seclevels/");
        }
        catch (URISyntaxException e) {
            return;
        }
    }

    public void handleGet(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(L10n.getString("SecurityLevelsToadlet.fullTitle", new String[]{"name"}, new String[]{this.node.getMyName()}), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(this.core.alerts.createSummary());
        this.drawSecurityLevelsPage(contentNode, ctx);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void drawSecurityLevelsPage(HTMLNode contentNode, ToadletContext ctx) {
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", this.l10nSec("title"));
        HTMLNode configNode = infobox.addChild("div", "class", "infobox-content");
        HTMLNode formNode = ctx.addFormChild(configNode, ".", "configFormSecLevels");
        formNode.addChild("div", "class", "configprefix", this.l10nSec("networkThreatLevelShort"));
        HTMLNode ul = formNode.addChild("ul", "class", "config");
        HTMLNode seclevelGroup = ul.addChild("li");
        seclevelGroup.addChild("#", this.l10nSec("networkThreatLevel"));
        SecurityLevels.NETWORK_THREAT_LEVEL networkLevel = this.node.securityLevels.getNetworkThreatLevel();
        String controlName = "security-levels.networkThreatLevel";
        for (SecurityLevels.NETWORK_THREAT_LEVEL level : SecurityLevels.NETWORK_THREAT_LEVEL.values()) {
            HTMLNode input = level == networkLevel ? seclevelGroup.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : seclevelGroup.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input.addChild("b", this.l10nSec("networkThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            L10n.addL10nSubstitution(input, "SecurityLevels.networkThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            HTMLNode inner = input.addChild("p").addChild("i");
            L10n.addL10nSubstitution(inner, "SecurityLevels.networkThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
        }
        formNode.addChild("div", "class", "configprefix", this.l10nSec("friendsThreatLevelShort"));
        ul = formNode.addChild("ul", "class", "config");
        seclevelGroup = ul.addChild("li");
        seclevelGroup.addChild("#", this.l10nSec("friendsThreatLevel"));
        SecurityLevels.FRIENDS_THREAT_LEVEL friendsLevel = this.node.securityLevels.getFriendsThreatLevel();
        controlName = "security-levels.friendsThreatLevel";
        for (SecurityLevels.FRIENDS_THREAT_LEVEL level : SecurityLevels.FRIENDS_THREAT_LEVEL.values()) {
            HTMLNode input = level == friendsLevel ? seclevelGroup.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : seclevelGroup.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input.addChild("b", this.l10nSec("friendsThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            L10n.addL10nSubstitution(input, "SecurityLevels.friendsThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            HTMLNode inner = input.addChild("p").addChild("i");
            L10n.addL10nSubstitution(inner, "SecurityLevels.friendsThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
        }
        formNode.addChild("div", "class", "configprefix", this.l10nSec("physicalThreatLevelShort"));
        ul = formNode.addChild("ul", "class", "config");
        seclevelGroup = ul.addChild("li");
        seclevelGroup.addChild("#", this.l10nSec("physicalThreatLevel"));
        SecurityLevels.PHYSICAL_THREAT_LEVEL physicalLevel = this.node.securityLevels.getPhysicalThreatLevel();
        controlName = "security-levels.physicalThreatLevel";
        for (SecurityLevels.PHYSICAL_THREAT_LEVEL level : SecurityLevels.PHYSICAL_THREAT_LEVEL.values()) {
            HTMLNode input = level == physicalLevel ? seclevelGroup.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : seclevelGroup.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input.addChild("b", this.l10nSec("physicalThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            L10n.addL10nSubstitution(input, "SecurityLevels.physicalThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            HTMLNode inner = input.addChild("p").addChild("i");
            L10n.addL10nSubstitution(inner, "SecurityLevels.physicalThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
        }
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", SecurityLevelsToadlet.l10n("apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", SecurityLevelsToadlet.l10n("reset")});
    }

    public String path() {
        return "/seclevels/";
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    private static final String l10n(String string) {
        return L10n.getString("ConfigToadlet." + string);
    }

    private String l10nSec(String key) {
        return L10n.getString("SecurityLevels." + key);
    }

    private String l10nSec(String key, String pattern, String value) {
        return L10n.getString("SecurityLevels." + key, pattern, value);
    }
}

