/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.client.HighLevelSimpleClient;
import freenet.client.MetadataUnresolvedException;
import freenet.client.TempFetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientPutDir;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.RequestCompletionCallback;
import freenet.node.useralerts.SimpleHTMLUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.MutableBoolean;
import freenet.support.SizeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import freenet.support.api.HTTPUploadedFile;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueToadlet
extends Toadlet
implements RequestCompletionCallback,
LinkEnabledCallback {
    private static final int LIST_IDENTIFIER = 1;
    private static final int LIST_SIZE = 2;
    private static final int LIST_MIME_TYPE = 3;
    private static final int LIST_DOWNLOAD = 4;
    private static final int LIST_PERSISTENCE = 5;
    private static final int LIST_KEY = 6;
    private static final int LIST_FILENAME = 7;
    private static final int LIST_PRIORITY = 8;
    private static final int LIST_FILES = 9;
    private static final int LIST_TOTAL_SIZE = 10;
    private static final int LIST_PROGRESS = 11;
    private static final int LIST_REASON = 12;
    private static final int MAX_IDENTIFIER_LENGTH = 0x100000;
    private static final int MAX_FILENAME_LENGTH = 0x100000;
    private static final int MAX_TYPE_LENGTH = 1024;
    static final int MAX_KEY_LENGTH = 0x100000;
    private NodeClientCore core;
    final FCPServer fcp;
    private boolean isReversed = false;
    private final boolean uploads;
    private final HashSet<String> completedRequestIdentifiers = new HashSet();
    private final HashMap<String, UserAlert> alertsByIdentifier = new HashMap();

    public QueueToadlet(NodeClientCore core, FCPServer fcp, HighLevelSimpleClient client, boolean uploads) {
        super(client);
        this.core = core;
        this.fcp = fcp;
        this.uploads = uploads;
        if (fcp == null) {
            throw new NullPointerException();
        }
        fcp.setCompletionCallback(this);
        try {
            this.loadCompletedIdentifiers();
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handlePost(URI uri, HTTPRequest request, final ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        block96: {
            block97: {
                block95: {
                    block94: {
                        block93: {
                            block92: {
                                block91: {
                                    block90: {
                                        block89: {
                                            block88: {
                                                block87: {
                                                    if (!this.core.hasLoadedQueue()) {
                                                        this.writeError(L10n.getString("QueueToadlet.notLoadedYetTitle"), L10n.getString("QueueToadlet.notLoadedYet"), ctx, false);
                                                        return;
                                                    }
                                                    if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
                                                        super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
                                                        return;
                                                    }
                                                    boolean logMINOR = Logger.shouldLog(4, this);
                                                    try {
                                                        FreenetURI furi;
                                                        if (request.getPartAsString("insert-local", 128).length() > 0) {
                                                            FreenetURI insertURI;
                                                            String keyType = request.getPartAsString("keytype", 3);
                                                            if ("chk".equals(keyType)) {
                                                                insertURI = new FreenetURI("CHK@");
                                                            } else {
                                                                try {
                                                                    String u = request.getPartAsString("key", 128);
                                                                    insertURI = new FreenetURI(u);
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Inserting key: " + insertURI + " (" + u + ")");
                                                                    }
                                                                }
                                                                catch (MalformedURLException mue1) {
                                                                    this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                    Object var23_30 = null;
                                                                    request.freeParts();
                                                                    return;
                                                                }
                                                            }
                                                            MultiValueTable<String, String> responseHeaders = new MultiValueTable<String, String>();
                                                            responseHeaders.put("Location", "/files/?key=" + insertURI.toASCIIString());
                                                            ctx.sendReplyHeaders(302, "Found", responseHeaders, null, 0L);
                                                            Object var23_31 = null;
                                                            request.freeParts();
                                                            return;
                                                        }
                                                        String pass = request.getPartAsString("formPassword", 32);
                                                        if (pass.length() == 0 || !pass.equals(this.core.formPassword)) {
                                                            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                                                            headers.put("Location", this.path());
                                                            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                                                            if (logMINOR) {
                                                                Logger.minor(this, "No formPassword: " + pass);
                                                            }
                                                            break block87;
                                                        }
                                                        if (request.isPartSet("remove_request") && request.getPartAsString("remove_request", 32).length() > 0) {
                                                            String identifier = request.getPartAsString("identifier", 0x100000);
                                                            if (logMINOR) {
                                                                Logger.minor(this, "Removing " + identifier);
                                                            }
                                                            try {
                                                                this.fcp.removeGlobalRequestBlocking(identifier);
                                                            }
                                                            catch (MessageInvalidException e) {
                                                                this.sendErrorPage(ctx, 200, L10n.getString("QueueToadlet.failedToRemoveRequest"), L10n.getString("QueueToadlet.failedToRemove", new String[]{"id", "message"}, new String[]{identifier, e.getMessage()}));
                                                                Object var23_33 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            catch (DatabaseDisabledException e) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_34 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                            break block88;
                                                        }
                                                        if (request.isPartSet("restart_request") && request.getPartAsString("restart_request", 32).length() > 0) {
                                                            String identifier = request.getPartAsString("identifier", 0x100000);
                                                            if (logMINOR) {
                                                                Logger.minor(this, "Restarting " + identifier);
                                                            }
                                                            try {
                                                                this.fcp.restartBlocking(identifier);
                                                            }
                                                            catch (DatabaseDisabledException e) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_36 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                            break block89;
                                                        }
                                                        if (request.isPartSet("remove_AllRequests") && request.getPartAsString("remove_AllRequests", 32).length() > 0) {
                                                            boolean success = false;
                                                            try {
                                                                success = this.fcp.removeAllGlobalRequestsBlocking();
                                                            }
                                                            catch (Exception e) {
                                                                Logger.error(this, "Exception on remove all", e);
                                                            }
                                                            if (!success) {
                                                                this.sendErrorPage(ctx, 200, L10n.getString("QueueToadlet.failedToRemoveRequest"), L10n.getString("QueueToadlet.failedToRemoveAll"));
                                                                break block90;
                                                            } else {
                                                                QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                            }
                                                            break block90;
                                                        }
                                                        if (request.isPartSet("download")) {
                                                            FreenetURI fetchURI;
                                                            if (!request.isPartSet("key")) {
                                                                this.writeError(L10n.getString("QueueToadlet.errorNoKey"), L10n.getString("QueueToadlet.errorNoKeyToD"), ctx);
                                                                break block91;
                                                            }
                                                            String expectedMIMEType = null;
                                                            if (request.isPartSet("type")) {
                                                                expectedMIMEType = request.getPartAsString("type", 1024);
                                                            }
                                                            try {
                                                                fetchURI = new FreenetURI(request.getPartAsString("key", 0x100000));
                                                            }
                                                            catch (MalformedURLException e) {
                                                                this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToD"), ctx);
                                                                Object var23_40 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            String persistence = request.getPartAsString("persistence", 32);
                                                            String returnType = request.getPartAsString("return-type", 32);
                                                            try {
                                                                this.fcp.makePersistentGlobalRequestBlocking(fetchURI, expectedMIMEType, persistence, returnType);
                                                            }
                                                            catch (NotAllowedException e) {
                                                                this.writeError(L10n.getString("QueueToadlet.errorDToDisk"), L10n.getString("QueueToadlet.errorDToDiskConfig"), ctx);
                                                                Object var23_41 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            catch (DatabaseDisabledException e) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_42 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                            break block92;
                                                        }
                                                        if (request.isPartSet("bulkDownloads")) {
                                                            String bulkDownloadsAsString = request.getPartAsString("bulkDownloads", Integer.MAX_VALUE);
                                                            String[] keys = bulkDownloadsAsString.split("\n");
                                                            if ("".equals(bulkDownloadsAsString) || keys.length < 1) {
                                                                QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                                break block93;
                                                            } else {
                                                                HTMLNode line;
                                                                Iterator it;
                                                                LinkedList<String> success = new LinkedList<String>();
                                                                LinkedList<String> failure = new LinkedList<String>();
                                                                for (int i = 0; i < keys.length; ++i) {
                                                                    String currentKey = keys[i];
                                                                    if ((currentKey = currentKey.trim()).length() == 0) continue;
                                                                    try {
                                                                        FreenetURI fetchURI = new FreenetURI(currentKey);
                                                                        this.fcp.makePersistentGlobalRequestBlocking(fetchURI, null, "forever", "disk");
                                                                        success.add(currentKey);
                                                                        continue;
                                                                    }
                                                                    catch (Exception e) {
                                                                        failure.add(currentKey);
                                                                        Logger.error(this, "An error occured while attempting to download key(" + i + ") : " + currentKey + " : " + e.getMessage());
                                                                    }
                                                                }
                                                                boolean displayFailureBox = failure.size() > 0;
                                                                boolean displaySuccessBox = success.size() > 0;
                                                                PageNode page = ctx.getPageMaker().getPageNode(L10n.getString("QueueToadlet.downloadFiles"), ctx);
                                                                HTMLNode pageNode = page.outer;
                                                                HTMLNode contentNode = page.content;
                                                                HTMLNode alertContent = ctx.getPageMaker().getInfobox(displayFailureBox ? "infobox-warning" : "infobox-info", L10n.getString("QueueToadlet.downloadFiles"), contentNode);
                                                                if (displaySuccessBox) {
                                                                    HTMLNode successDiv = alertContent.addChild("ul");
                                                                    successDiv.addChild("#", L10n.getString("QueueToadlet.enqueuedSuccessfully", "number", String.valueOf(success.size())));
                                                                    it = success.iterator();
                                                                    while (it.hasNext()) {
                                                                        line = successDiv.addChild("li");
                                                                        line.addChild("#", (String)it.next());
                                                                    }
                                                                    successDiv.addChild("br");
                                                                }
                                                                if (displayFailureBox) {
                                                                    HTMLNode failureDiv = alertContent.addChild("ul");
                                                                    if (displayFailureBox) {
                                                                        failureDiv.addChild("#", L10n.getString("QueueToadlet.enqueuedFailure", "number", String.valueOf(failure.size())));
                                                                        it = failure.iterator();
                                                                        while (it.hasNext()) {
                                                                            line = failureDiv.addChild("li");
                                                                            line.addChild("#", (String)it.next());
                                                                        }
                                                                    }
                                                                    failureDiv.addChild("br");
                                                                }
                                                                alertContent.addChild("a", "href", this.path(), L10n.getString("Toadlet.returnToQueuepage"));
                                                                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                                                                Object var23_45 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                        }
                                                        if (request.isPartSet("change_priority")) {
                                                            String identifier = request.getPartAsString("identifier", 0x100000);
                                                            short newPriority = Short.parseShort(request.getPartAsString("priority", 32));
                                                            try {
                                                                this.fcp.modifyGlobalRequestBlocking(identifier, null, newPriority);
                                                            }
                                                            catch (DatabaseDisabledException e) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_46 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
                                                            break block94;
                                                        }
                                                        if (request.getPartAsString("insert", 128).length() > 0) {
                                                            FreenetURI insertURI;
                                                            String keyType = request.getPartAsString("keytype", 3);
                                                            if ("chk".equals(keyType)) {
                                                                insertURI = new FreenetURI("CHK@");
                                                            } else {
                                                                try {
                                                                    String u = request.getPartAsString("key", 128);
                                                                    insertURI = new FreenetURI(u);
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Inserting key: " + insertURI + " (" + u + ")");
                                                                    }
                                                                }
                                                                catch (MalformedURLException mue1) {
                                                                    this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                    Object var23_48 = null;
                                                                    request.freeParts();
                                                                    return;
                                                                }
                                                            }
                                                            final HTTPUploadedFile file = request.getUploadedFile("filename");
                                                            if (file == null || file.getFilename().trim().length() == 0) {
                                                                this.writeError(L10n.getString("QueueToadlet.errorNoFileSelected"), L10n.getString("QueueToadlet.errorNoFileSelectedU"), ctx);
                                                                break block95;
                                                            }
                                                            final boolean compress = request.getPartAsString("compress", 128).length() > 0;
                                                            final String identifier = file.getFilename() + "-fred-" + System.currentTimeMillis();
                                                            final String fnam = insertURI.getKeyType().equals("CHK") ? file.getFilename() : null;
                                                            final Bucket copiedBucket = this.core.persistentTempBucketFactory.makeBucket(file.getData().size());
                                                            BucketTools.copy(file.getData(), copiedBucket);
                                                            final MutableBoolean done = new MutableBoolean();
                                                            try {
                                                                this.core.queue(new DBJob(){

                                                                    /*
                                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                                     * Enabled aggressive block sorting
                                                                     * Enabled unnecessary exception pruning
                                                                     * Enabled aggressive exception aggregation
                                                                     */
                                                                    public boolean run(ObjectContainer container, ClientContext context) {
                                                                        try {
                                                                            MutableBoolean mutableBoolean;
                                                                            boolean e2;
                                                                            try {
                                                                                try {
                                                                                    ClientPut clientPut = new ClientPut(QueueToadlet.this.fcp.getGlobalForeverClient(), insertURI, identifier, Integer.MAX_VALUE, 4, 2, null, false, !compress, -1, 0, null, file.getContentType(), copiedBucket, null, fnam, false, QueueToadlet.this.fcp, container);
                                                                                    if (clientPut != null) {
                                                                                        try {
                                                                                            QueueToadlet.this.fcp.startBlocking(clientPut, container, context);
                                                                                        }
                                                                                        catch (IdentifierCollisionException e2) {
                                                                                            Logger.error(this, "Cannot put same file twice in same millisecond");
                                                                                            Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                            boolean bl = false;
                                                                                            Object var7_21 = null;
                                                                                            MutableBoolean mutableBoolean2 = done;
                                                                                            synchronized (mutableBoolean2) {
                                                                                                done.value = true;
                                                                                                done.notifyAll();
                                                                                                return bl;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    e2 = true;
                                                                                    Object var7_22 = null;
                                                                                    mutableBoolean = done;
                                                                                }
                                                                                catch (IdentifierCollisionException e3) {
                                                                                    Logger.error(this, "Cannot put same file twice in same millisecond");
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    boolean bl = false;
                                                                                    Object var7_23 = null;
                                                                                    MutableBoolean mutableBoolean3 = done;
                                                                                    synchronized (mutableBoolean3) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (NotAllowedException e4) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorAccessDenied"), L10n.getString("QueueToadlet.errorAccessDeniedFile", new String[]{"file"}, new String[]{file.getFilename()}), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_24 = null;
                                                                                    MutableBoolean mutableBoolean4 = done;
                                                                                    synchronized (mutableBoolean4) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (FileNotFoundException e5) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorNoFileOrCannotRead"), L10n.getString("QueueToadlet.errorAccessDeniedFile", new String[]{"file"}, new String[]{file.getFilename()}), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_25 = null;
                                                                                    MutableBoolean mutableBoolean5 = done;
                                                                                    synchronized (mutableBoolean5) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (MalformedURLException mue1) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_26 = null;
                                                                                    MutableBoolean mutableBoolean6 = done;
                                                                                    synchronized (mutableBoolean6) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (MetadataUnresolvedException e6) {
                                                                                    Logger.error(this, "Unresolved metadata in starting insert from data uploaded from browser: " + e6, e6);
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    boolean bl = false;
                                                                                    Object var7_27 = null;
                                                                                    MutableBoolean mutableBoolean7 = done;
                                                                                    synchronized (mutableBoolean7) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (Throwable t) {
                                                                                    QueueToadlet.this.writeInternalError(t, ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_28 = null;
                                                                                    MutableBoolean mutableBoolean8 = done;
                                                                                    synchronized (mutableBoolean8) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var7_29 = null;
                                                                                MutableBoolean mutableBoolean9 = done;
                                                                                synchronized (mutableBoolean9) {
                                                                                    done.value = true;
                                                                                    done.notifyAll();
                                                                                    throw throwable;
                                                                                }
                                                                            }
                                                                            synchronized (mutableBoolean) {
                                                                                done.value = true;
                                                                                done.notifyAll();
                                                                                return e2;
                                                                            }
                                                                        }
                                                                        catch (IOException e) {
                                                                            return false;
                                                                        }
                                                                        catch (ToadletContextClosedException e) {
                                                                            return false;
                                                                        }
                                                                    }
                                                                }, 8, false);
                                                            }
                                                            catch (DatabaseDisabledException e1) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_50 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            MutableBoolean e1 = done;
                                                            synchronized (e1) {
                                                                while (!done.value) {
                                                                    try {
                                                                        done.wait();
                                                                    }
                                                                    catch (InterruptedException e) {}
                                                                }
                                                            }
                                                            Object var23_51 = null;
                                                            request.freeParts();
                                                            return;
                                                        }
                                                        if (request.isPartSet("insert-local-file")) {
                                                            FreenetURI furi2;
                                                            String filename = request.getPartAsString("filename", 0x100000);
                                                            if (logMINOR) {
                                                                Logger.minor(this, "Inserting local file: " + filename);
                                                            }
                                                            final File file = new File(filename);
                                                            final String identifier = file.getName() + "-fred-" + System.currentTimeMillis();
                                                            final String contentType = DefaultMIMETypes.guessMIMEType(filename, false);
                                                            String key = request.getPartAsString("key", 128);
                                                            if (key != null) {
                                                                try {
                                                                    furi2 = new FreenetURI(key);
                                                                }
                                                                catch (MalformedURLException e) {
                                                                    this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                    Object var23_52 = null;
                                                                    request.freeParts();
                                                                    return;
                                                                }
                                                            } else {
                                                                furi2 = new FreenetURI("CHK@");
                                                            }
                                                            final String target = !furi2.getKeyType().equals("CHK") ? null : file.getName();
                                                            final MutableBoolean done = new MutableBoolean();
                                                            try {
                                                                this.core.queue(new DBJob(){

                                                                    /*
                                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                                     * Enabled aggressive block sorting
                                                                     * Enabled unnecessary exception pruning
                                                                     * Enabled aggressive exception aggregation
                                                                     */
                                                                    public boolean run(ObjectContainer container, ClientContext context) {
                                                                        try {
                                                                            MutableBoolean mutableBoolean;
                                                                            boolean e3;
                                                                            try {
                                                                                try {
                                                                                    ClientPut clientPut = new ClientPut(QueueToadlet.this.fcp.getGlobalForeverClient(), furi2, identifier, Integer.MAX_VALUE, 4, 2, null, false, false, -1, 1, file, contentType, new FileBucket(file, true, false, false, false, false), null, target, false, QueueToadlet.this.fcp, container);
                                                                                    if (Logger.shouldLog(4, this)) {
                                                                                        Logger.minor(this, "Started global request to insert " + file + " to CHK@ as " + identifier);
                                                                                    }
                                                                                    if (clientPut != null) {
                                                                                        try {
                                                                                            QueueToadlet.this.fcp.startBlocking(clientPut, container, context);
                                                                                        }
                                                                                        catch (IdentifierCollisionException e2) {
                                                                                            Logger.error(this, "Cannot put same file twice in same millisecond");
                                                                                            Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                            boolean bl = false;
                                                                                            Object var7_20 = null;
                                                                                            MutableBoolean mutableBoolean2 = done;
                                                                                            synchronized (mutableBoolean2) {
                                                                                                done.value = true;
                                                                                                done.notifyAll();
                                                                                                return bl;
                                                                                            }
                                                                                        }
                                                                                        catch (DatabaseDisabledException e3) {
                                                                                            // empty catch block
                                                                                        }
                                                                                    }
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    e3 = true;
                                                                                    Object var7_21 = null;
                                                                                    mutableBoolean = done;
                                                                                }
                                                                                catch (IdentifierCollisionException e4) {
                                                                                    Logger.error(this, "Cannot put same file twice in same millisecond");
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    boolean bl = false;
                                                                                    Object var7_22 = null;
                                                                                    MutableBoolean mutableBoolean3 = done;
                                                                                    synchronized (mutableBoolean3) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (MalformedURLException e5) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_23 = null;
                                                                                    MutableBoolean mutableBoolean4 = done;
                                                                                    synchronized (mutableBoolean4) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (FileNotFoundException e6) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorNoFileOrCannotRead"), L10n.getString("QueueToadlet.errorAccessDeniedFile", new String[]{"file"}, new String[]{target}), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_24 = null;
                                                                                    MutableBoolean mutableBoolean5 = done;
                                                                                    synchronized (mutableBoolean5) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (NotAllowedException e7) {
                                                                                    QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorAccessDenied"), L10n.getString("QueueToadlet.errorAccessDeniedFile", new String[]{"file"}, new String[]{file.getName()}), ctx);
                                                                                    boolean bl = false;
                                                                                    Object var7_25 = null;
                                                                                    MutableBoolean mutableBoolean6 = done;
                                                                                    synchronized (mutableBoolean6) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                                catch (MetadataUnresolvedException e8) {
                                                                                    Logger.error(this, "Unresolved metadata in starting insert from data from file: " + e8, e8);
                                                                                    Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                    boolean bl = false;
                                                                                    Object var7_26 = null;
                                                                                    MutableBoolean mutableBoolean7 = done;
                                                                                    synchronized (mutableBoolean7) {
                                                                                        done.value = true;
                                                                                        done.notifyAll();
                                                                                        return bl;
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var7_27 = null;
                                                                                MutableBoolean mutableBoolean8 = done;
                                                                                synchronized (mutableBoolean8) {
                                                                                    done.value = true;
                                                                                    done.notifyAll();
                                                                                    throw throwable;
                                                                                }
                                                                            }
                                                                            synchronized (mutableBoolean) {
                                                                                done.value = true;
                                                                                done.notifyAll();
                                                                                return e3;
                                                                            }
                                                                        }
                                                                        catch (IOException e) {
                                                                            return false;
                                                                        }
                                                                        catch (ToadletContextClosedException e) {
                                                                            return false;
                                                                        }
                                                                    }
                                                                }, 8, false);
                                                            }
                                                            catch (DatabaseDisabledException e1) {
                                                                this.sendPersistenceDisabledError(ctx);
                                                                Object var23_53 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                            MutableBoolean mutableBoolean = done;
                                                            synchronized (mutableBoolean) {
                                                                while (!done.value) {
                                                                    try {
                                                                        done.wait();
                                                                    }
                                                                    catch (InterruptedException e) {}
                                                                }
                                                            }
                                                            Object var23_54 = null;
                                                            request.freeParts();
                                                            return;
                                                        }
                                                        if (!request.isPartSet("insert-local-dir")) break block96;
                                                        String filename = request.getPartAsString("filename", 0x100000);
                                                        if (logMINOR) {
                                                            Logger.minor(this, "Inserting local directory: " + filename);
                                                        }
                                                        final File file = new File(filename);
                                                        final String identifier = file.getName() + "-fred-" + System.currentTimeMillis();
                                                        String key = request.getPartAsString("key", 128);
                                                        if (key != null) {
                                                            try {
                                                                furi = new FreenetURI(key);
                                                            }
                                                            catch (MalformedURLException e) {
                                                                this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                Object var23_55 = null;
                                                                request.freeParts();
                                                                return;
                                                            }
                                                        } else {
                                                            furi = new FreenetURI("CHK@");
                                                        }
                                                        final MutableBoolean done = new MutableBoolean();
                                                        try {
                                                            this.core.queue(new DBJob(){

                                                                /*
                                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                                 * Enabled aggressive block sorting
                                                                 * Enabled unnecessary exception pruning
                                                                 * Enabled aggressive exception aggregation
                                                                 */
                                                                public boolean run(ObjectContainer container, ClientContext context) {
                                                                    try {
                                                                        MutableBoolean mutableBoolean;
                                                                        boolean bl;
                                                                        try {
                                                                            try {
                                                                                boolean logMINOR = Logger.shouldLog(4, this);
                                                                                ClientPutDir clientPutDir = new ClientPutDir(QueueToadlet.this.fcp.getGlobalForeverClient(), furi, identifier, Integer.MAX_VALUE, 4, 2, null, false, false, -1, file, null, false, true, false, QueueToadlet.this.fcp, container);
                                                                                if (logMINOR) {
                                                                                    Logger.minor(this, "Started global request to insert dir " + file + " to " + furi + " as " + identifier);
                                                                                }
                                                                                if (clientPutDir != null) {
                                                                                    try {
                                                                                        QueueToadlet.this.fcp.startBlocking(clientPutDir, container, context);
                                                                                    }
                                                                                    catch (IdentifierCollisionException e) {
                                                                                        Logger.error(this, "Cannot put same file twice in same millisecond");
                                                                                        Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                        boolean bl2 = false;
                                                                                        Object var8_18 = null;
                                                                                        MutableBoolean mutableBoolean2 = done;
                                                                                        synchronized (mutableBoolean2) {
                                                                                            done.value = true;
                                                                                            done.notifyAll();
                                                                                            return bl2;
                                                                                        }
                                                                                    }
                                                                                    catch (DatabaseDisabledException e) {
                                                                                        QueueToadlet.this.sendPersistenceDisabledError(ctx);
                                                                                        boolean bl3 = false;
                                                                                        Object var8_19 = null;
                                                                                        MutableBoolean mutableBoolean3 = done;
                                                                                        synchronized (mutableBoolean3) {
                                                                                            done.value = true;
                                                                                            done.notifyAll();
                                                                                            return bl3;
                                                                                        }
                                                                                    }
                                                                                }
                                                                                Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                bl = true;
                                                                                Object var8_20 = null;
                                                                                mutableBoolean = done;
                                                                            }
                                                                            catch (IdentifierCollisionException e) {
                                                                                Logger.error(this, "Cannot put same directory twice in same millisecond");
                                                                                Toadlet.writePermanentRedirect(ctx, "Done", QueueToadlet.this.path());
                                                                                boolean bl4 = false;
                                                                                Object var8_21 = null;
                                                                                MutableBoolean mutableBoolean4 = done;
                                                                                synchronized (mutableBoolean4) {
                                                                                    done.value = true;
                                                                                    done.notifyAll();
                                                                                    return bl4;
                                                                                }
                                                                            }
                                                                            catch (MalformedURLException e) {
                                                                                QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorInvalidURI"), L10n.getString("QueueToadlet.errorInvalidURIToU"), ctx);
                                                                                boolean bl5 = false;
                                                                                Object var8_22 = null;
                                                                                MutableBoolean mutableBoolean5 = done;
                                                                                synchronized (mutableBoolean5) {
                                                                                    done.value = true;
                                                                                    done.notifyAll();
                                                                                    return bl5;
                                                                                }
                                                                            }
                                                                            catch (FileNotFoundException e) {
                                                                                QueueToadlet.this.writeError(L10n.getString("QueueToadlet.errorNoFileOrCannotRead"), L10n.getString("QueueToadlet.errorAccessDeniedFile", new String[]{"file"}, new String[]{file.toString()}), ctx);
                                                                                boolean bl6 = false;
                                                                                Object var8_23 = null;
                                                                                MutableBoolean mutableBoolean6 = done;
                                                                                synchronized (mutableBoolean6) {
                                                                                    done.value = true;
                                                                                    done.notifyAll();
                                                                                    return bl6;
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Object var8_24 = null;
                                                                            MutableBoolean mutableBoolean7 = done;
                                                                            synchronized (mutableBoolean7) {
                                                                                done.value = true;
                                                                                done.notifyAll();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        synchronized (mutableBoolean) {
                                                                            done.value = true;
                                                                            done.notifyAll();
                                                                            return bl;
                                                                        }
                                                                    }
                                                                    catch (IOException e) {
                                                                        return false;
                                                                    }
                                                                    catch (ToadletContextClosedException e) {
                                                                        return false;
                                                                    }
                                                                }
                                                            }, 8, false);
                                                        }
                                                        catch (DatabaseDisabledException e1) {
                                                            this.sendPersistenceDisabledError(ctx);
                                                            Object var23_56 = null;
                                                            request.freeParts();
                                                            return;
                                                        }
                                                        MutableBoolean mutableBoolean = done;
                                                        synchronized (mutableBoolean) {
                                                            while (!done.value) {
                                                                try {
                                                                    done.wait();
                                                                }
                                                                catch (InterruptedException e) {}
                                                            }
                                                        }
                                                        break block97;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var23_59 = null;
                                                        request.freeParts();
                                                        throw throwable;
                                                    }
                                                }
                                                Object var23_32 = null;
                                                request.freeParts();
                                                return;
                                            }
                                            Object var23_35 = null;
                                            request.freeParts();
                                            return;
                                        }
                                        Object var23_37 = null;
                                        request.freeParts();
                                        return;
                                    }
                                    Object var23_38 = null;
                                    request.freeParts();
                                    return;
                                }
                                Object var23_39 = null;
                                request.freeParts();
                                return;
                            }
                            Object var23_43 = null;
                            request.freeParts();
                            return;
                        }
                        Object var23_44 = null;
                        request.freeParts();
                        return;
                    }
                    Object var23_47 = null;
                    request.freeParts();
                    return;
                }
                Object var23_49 = null;
                request.freeParts();
                return;
            }
            Object var23_57 = null;
            request.freeParts();
            return;
        }
        Object var23_58 = null;
        request.freeParts();
        this.handleGet(uri, new HTTPRequestImpl(uri, "GET"), ctx);
    }

    private void sendPersistenceDisabledError(ToadletContext ctx) {
        try {
            if (this.core.node.isStopping()) {
                this.sendErrorPage(ctx, 200, L10n.getString("QueueToadlet.shuttingDownTitle"), L10n.getString("QueueToadlet.shuttingDown"));
            } else {
                this.sendErrorPage(ctx, 200, L10n.getString("QueueToadlet.persistenceBrokenTitle"), L10n.getString("QueueToadlet.persistenceBroken", new String[]{"TEMPDIR", "DBFILE"}, new String[]{FileUtil.getCanonicalFile(this.core.getPersistentTempDir()).toString() + File.separator, FileUtil.getCanonicalFile(this.core.node.getNodeDir()) + File.separator + "node.db4o"}));
            }
        }
        catch (ToadletContextClosedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeError(String header, String message, ToadletContext context) throws ToadletContextClosedException, IOException {
        this.writeError(header, message, context, true);
    }

    private void writeError(String header, String message, ToadletContext context, boolean returnToQueuePage) throws ToadletContextClosedException, IOException {
        PageMaker pageMaker = context.getPageMaker();
        PageNode page = pageMaker.getPageNode(header, context);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (context.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createSummary());
        }
        HTMLNode infoboxContent = pageMaker.getInfobox("infobox-error", header, contentNode);
        infoboxContent.addChild("#", message);
        if (returnToQueuePage) {
            L10n.addL10nSubstitution(infoboxContent.addChild("div"), "QueueToadlet.returnToQueuePage", new String[]{"link", "/link"}, new String[]{"<a href=\"" + this.path() + "\">", "</a>"});
        }
        this.writeHTMLReply(context, 400, "Bad request", pageNode.generate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleGet(URI uri, final HTTPRequest request, final ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        HTMLNode pageNode;
        if (!this.fcp.enabled) {
            this.writeError(L10n.getString("QueueToadlet.fcpIsMissing"), L10n.getString("QueueToadlet.pleaseEnableFCP"), ctx, false);
            return;
        }
        if (!this.core.hasLoadedQueue()) {
            this.writeError(L10n.getString("QueueToadlet.notLoadedYetTitle"), L10n.getString("QueueToadlet.notLoadedYet"), ctx, false);
            return;
        }
        if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        String requestPath = request.getPath().substring(this.path().length());
        boolean countRequests = false;
        if (requestPath.length() > 0) {
            if (requestPath.equals("countRequests.html") || requestPath.equals("/countRequests.html")) {
                countRequests = true;
            } else {
                try {
                    FreenetURI key = new FreenetURI(requestPath);
                    TempFetchResult result = this.fcp.getCompletedRequestBlocking(key);
                    if (result != null) {
                        Bucket data = result.asBucket();
                        String mimeType = result.getMimeType();
                        String requestedMimeType = request.getParam("type", null);
                        String forceString = request.getParam("force");
                        FProxyToadlet.handleDownload(ctx, data, ctx.getBucketFactory(), mimeType, requestedMimeType, forceString, request.isParameterSet("forcedownload"), "/downloads/", key, "", "/downloads/", false, ctx, this.core, false);
                        if (result.freeWhenDone) {
                            data.free();
                        }
                        return;
                    }
                }
                catch (MalformedURLException mue1) {
                }
                catch (DatabaseDisabledException e) {
                    this.sendPersistenceDisabledError(ctx);
                    return;
                }
            }
        }
        class OutputWrapper {
            boolean done;
            HTMLNode pageNode;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        final PageMaker pageMaker = ctx.getPageMaker();
        final boolean count = countRequests;
        try {
            this.core.clientContext.jobRunner.queue(new DBJob(){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean run(ObjectContainer container, ClientContext context) {
                    HTMLNode pageNode;
                    block13: {
                        OutputWrapper outputWrapper;
                        boolean bl;
                        pageNode = null;
                        try {
                            if (!count) break block13;
                            long queued = ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchScheduler.countPersistentWaitingKeys(container);
                            System.err.println("Total waiting CHKs: " + queued);
                            long reallyQueued = ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchScheduler.countPersistentQueuedRequests(container);
                            System.err.println("Total queued CHK requests: " + reallyQueued);
                            PageNode page = pageMaker.getPageNode(L10n.getString("QueueToadlet.title", new String[]{"nodeName"}, new String[]{QueueToadlet.this.core.getMyName()}), ctx);
                            pageNode = page.outer;
                            HTMLNode contentNode = page.content;
                            if (ctx.isAllowedFullAccess()) {
                                contentNode.addChild(((QueueToadlet)QueueToadlet.this).core.alerts.createSummary());
                            }
                            HTMLNode infoboxContent = pageMaker.getInfobox("infobox-information", "Queued requests status", contentNode);
                            infoboxContent.addChild("p", "Total awaiting CHKs: " + queued);
                            infoboxContent.addChild("p", "Total queued CHK requests: " + reallyQueued);
                            bl = false;
                            Object var13_12 = null;
                            outputWrapper = ow;
                        }
                        catch (Throwable throwable) {
                            Object var13_14 = null;
                            OutputWrapper outputWrapper2 = ow;
                            synchronized (outputWrapper2) {
                                ow.done = true;
                                ow.pageNode = pageNode;
                                ow.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (outputWrapper) {
                            ow.done = true;
                            ow.pageNode = pageNode;
                            ow.notifyAll();
                        }
                        return bl;
                    }
                    try {
                        pageNode = QueueToadlet.this.handleGetInner(pageMaker, container, context, request, ctx);
                    }
                    catch (DatabaseDisabledException e) {
                        pageNode = null;
                    }
                    boolean bl = false;
                    Object var13_13 = null;
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.done = true;
                        ow.pageNode = pageNode;
                        ow.notifyAll();
                    }
                    return bl;
                }
            }, 7, false);
        }
        catch (DatabaseDisabledException e1) {
            this.sendPersistenceDisabledError(ctx);
            return;
        }
        OutputWrapper requestedMimeType = ow;
        synchronized (requestedMimeType) {
            while (true) {
                if (ow.done) break;
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
            pageNode = ow.pageNode;
        }
        MultiValueTable<String, String> pageHeaders = new MultiValueTable<String, String>();
        if (pageNode != null) {
            this.writeHTMLReply(ctx, 200, "OK", pageHeaders, pageNode.generate());
        } else if (this.core.killedDatabase()) {
            this.sendPersistenceDisabledError(ctx);
        } else {
            this.writeError("Internal error", "Internal error", ctx);
        }
    }

    private HTMLNode handleGetInner(PageMaker pageMaker, final ObjectContainer container, ClientContext context, final HTTPRequest request, ToadletContext ctx) throws DatabaseDisabledException {
        LinkedList<ClientRequest> completedDownloadToDisk = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> completedDownloadToTemp = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> completedUpload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> completedDirUpload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> failedDownload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> failedUpload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> failedDirUpload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> uncompletedDownload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> uncompletedUpload = new LinkedList<ClientRequest>();
        LinkedList<ClientRequest> uncompletedDirUpload = new LinkedList<ClientRequest>();
        ClientRequest[] reqs = this.fcp.getGlobalRequests(container);
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Request count: " + reqs.length);
        }
        if (reqs.length < 1) {
            PageNode page = pageMaker.getPageNode(L10n.getString("QueueToadlet.title", new String[]{"nodeName"}, new String[]{this.core.getMyName()}), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (ctx.isAllowedFullAccess()) {
                contentNode.addChild(this.core.alerts.createSummary());
            }
            HTMLNode infoboxContent = pageMaker.getInfobox("infobox-information", L10n.getString("QueueToadlet.globalQueueIsEmpty"), contentNode);
            infoboxContent.addChild("#", L10n.getString("QueueToadlet.noTaskOnGlobalQueue"));
            if (this.uploads) {
                contentNode.addChild(this.createInsertBox(pageMaker, ctx, this.core.isAdvancedModeEnabled()));
            }
            if (!this.uploads) {
                contentNode.addChild(this.createBulkDownloadForm(ctx, pageMaker));
            }
            return pageNode;
        }
        int lowestQueuedPrio = 6;
        long totalQueuedDownloadSize = 0L;
        long totalQueuedUploadSize = 0L;
        for (int i = 0; i < reqs.length; ++i) {
            ClientPutBase cp;
            int prio;
            ClientRequest req = reqs[i];
            if (req instanceof ClientGet && !this.uploads) {
                ClientGet cg = (ClientGet)req;
                if (cg.hasSucceeded()) {
                    if (cg.isDirect()) {
                        completedDownloadToTemp.add(cg);
                        continue;
                    }
                    if (cg.isToDisk()) {
                        completedDownloadToDisk.add(cg);
                        continue;
                    }
                    Logger.error(this, "Don't know what to do with " + cg);
                    continue;
                }
                if (cg.hasFinished()) {
                    failedDownload.add(cg);
                    continue;
                }
                prio = cg.getPriority();
                if (prio < lowestQueuedPrio) {
                    lowestQueuedPrio = prio;
                }
                uncompletedDownload.add(cg);
                long size = cg.getDataSize(container);
                if (size <= 0L) continue;
                totalQueuedDownloadSize += size;
                continue;
            }
            if (req instanceof ClientPut && this.uploads) {
                cp = (ClientPut)req;
                if (((ClientPut)cp).hasSucceeded()) {
                    completedUpload.add(cp);
                } else if (cp.hasFinished()) {
                    failedUpload.add(cp);
                } else {
                    prio = req.getPriority();
                    if (prio < lowestQueuedPrio) {
                        lowestQueuedPrio = prio;
                    }
                    uncompletedUpload.add(cp);
                }
                long size = ((ClientPut)cp).getDataSize(container);
                if (size <= 0L) continue;
                totalQueuedUploadSize += size;
                continue;
            }
            if (!(req instanceof ClientPutDir) || !this.uploads) continue;
            cp = (ClientPutDir)req;
            if (((ClientPutDir)cp).hasSucceeded()) {
                completedDirUpload.add(cp);
            } else if (cp.hasFinished()) {
                failedDirUpload.add(cp);
            } else {
                prio = req.getPriority();
                if (prio < lowestQueuedPrio) {
                    lowestQueuedPrio = prio;
                }
                uncompletedDirUpload.add(cp);
            }
            long size = ((ClientPutDir)cp).getTotalDataSize();
            if (size <= 0L) continue;
            totalQueuedUploadSize += size;
        }
        System.err.println("Total queued downloads: " + SizeUtil.formatSize(totalQueuedDownloadSize));
        System.err.println("Total queued uploads: " + SizeUtil.formatSize(totalQueuedUploadSize));
        Comparator<ClientRequest> jobComparator = new Comparator<ClientRequest>(){

            @Override
            public int compare(ClientRequest firstRequest, ClientRequest secondRequest) {
                int result = 0;
                boolean isSet = true;
                if (request.isParameterSet("sortBy")) {
                    String sortBy = request.getParam("sortBy");
                    if (sortBy.equals("id")) {
                        result = firstRequest.getIdentifier().compareToIgnoreCase(secondRequest.getIdentifier());
                    } else if (sortBy.equals("size")) {
                        result = firstRequest.getTotalBlocks(container) - secondRequest.getTotalBlocks(container) < 0.0 ? -1 : 1;
                    } else if (sortBy.equals("progress")) {
                        result = firstRequest.getFetchedBlocks(container) / firstRequest.getMinBlocks(container) - secondRequest.getFetchedBlocks(container) / secondRequest.getMinBlocks(container) < 0.0 ? -1 : 1;
                    } else {
                        isSet = false;
                    }
                } else {
                    isSet = false;
                }
                if (!isSet) {
                    int priorityDifference = firstRequest.getPriority() - secondRequest.getPriority();
                    result = priorityDifference != 0 ? (priorityDifference < 0 ? -1 : 1) : firstRequest.getIdentifier().compareTo(secondRequest.getIdentifier());
                }
                if (result == 0) {
                    return 0;
                }
                if (request.isParameterSet("reversed")) {
                    QueueToadlet.this.isReversed = true;
                    return result > 0 ? -1 : 1;
                }
                QueueToadlet.this.isReversed = false;
                return result < 0 ? -1 : 1;
            }
        };
        Collections.sort(completedDownloadToDisk, jobComparator);
        Collections.sort(completedDownloadToTemp, jobComparator);
        Collections.sort(completedUpload, jobComparator);
        Collections.sort(completedDirUpload, jobComparator);
        Collections.sort(failedDownload, jobComparator);
        Collections.sort(failedUpload, jobComparator);
        Collections.sort(failedDirUpload, jobComparator);
        Collections.sort(uncompletedDownload, jobComparator);
        Collections.sort(uncompletedUpload, jobComparator);
        Collections.sort(uncompletedDirUpload, jobComparator);
        String pageName = this.uploads ? "(" + (uncompletedDirUpload.size() + uncompletedUpload.size()) + '/' + (failedDirUpload.size() + failedUpload.size()) + '/' + (completedDirUpload.size() + completedUpload.size()) + ") " + L10n.getString("QueueToadlet.titleUploads", "nodeName", this.core.getMyName()) : "(" + uncompletedDownload.size() + '/' + failedDownload.size() + '/' + (completedDownloadToDisk.size() + completedDownloadToTemp.size()) + ") " + L10n.getString("QueueToadlet.titleDownloads", "nodeName", this.core.getMyName());
        PageNode page = pageMaker.getPageNode(pageName, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createSummary());
        }
        int mode = pageMaker.drawModeSelectionArray(this.core, request, contentNode);
        if (this.uploads) {
            contentNode.addChild(this.createInsertBox(pageMaker, ctx, mode >= 2));
        }
        InfoboxNode infobox = pageMaker.getInfobox("navbar", L10n.getString("QueueToadlet.requestNavigation"));
        HTMLNode navigationBar = infobox.outer;
        HTMLNode navigationContent = infobox.content.addChild("ul");
        boolean includeNavigationBar = false;
        if (!completedDownloadToTemp.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDownloadToTemp", L10n.getString("QueueToadlet.completedDtoTemp", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToTemp.size())}));
            includeNavigationBar = true;
        }
        if (!completedDownloadToDisk.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDownloadToDisk", L10n.getString("QueueToadlet.completedDtoDisk", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToDisk.size())}));
            includeNavigationBar = true;
        }
        if (!completedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedUpload", L10n.getString("QueueToadlet.completedU", new String[]{"size"}, new String[]{String.valueOf(completedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!completedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDirUpload", L10n.getString("QueueToadlet.completedDU", new String[]{"size"}, new String[]{String.valueOf(completedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (!failedDownload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedDownload", L10n.getString("QueueToadlet.failedD", new String[]{"size"}, new String[]{String.valueOf(failedDownload.size())}));
            includeNavigationBar = true;
        }
        if (!failedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedUpload", L10n.getString("QueueToadlet.failedU", new String[]{"size"}, new String[]{String.valueOf(failedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!failedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedDirUpload", L10n.getString("QueueToadlet.failedDU", new String[]{"size"}, new String[]{String.valueOf(failedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (!uncompletedDownload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedDownload", L10n.getString("QueueToadlet.DinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedDownload.size())}));
            includeNavigationBar = true;
        }
        if (!uncompletedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedUpload", L10n.getString("QueueToadlet.UinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!uncompletedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedDirUpload", L10n.getString("QueueToadlet.DUinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (totalQueuedDownloadSize > 0L) {
            navigationContent.addChild("li", L10n.getString("QueueToadlet.totalQueuedDownloads", "size", SizeUtil.formatSize(totalQueuedDownloadSize)));
            includeNavigationBar = true;
        }
        if (totalQueuedUploadSize > 0L) {
            navigationContent.addChild("li", L10n.getString("QueueToadlet.totalQueuedUploads", "size", SizeUtil.formatSize(totalQueuedUploadSize)));
            includeNavigationBar = true;
        }
        if (includeNavigationBar) {
            contentNode.addChild(navigationBar);
        }
        String[] priorityClasses = new String[]{L10n.getString("QueueToadlet.priority0"), L10n.getString("QueueToadlet.priority1"), L10n.getString("QueueToadlet.priority2"), L10n.getString("QueueToadlet.priority3"), L10n.getString("QueueToadlet.priority4"), L10n.getString("QueueToadlet.priority5"), L10n.getString("QueueToadlet.priority6")};
        boolean advancedModeEnabled = mode >= 2;
        HTMLNode legendContent = pageMaker.getInfobox("legend", L10n.getString("QueueToadlet.legend"), contentNode);
        HTMLNode legendTable = legendContent.addChild("table", "class", "queue");
        HTMLNode legendRow = legendTable.addChild("tr");
        for (int i = 0; i < 7; ++i) {
            if (i <= 1 && !advancedModeEnabled && i > lowestQueuedPrio) continue;
            legendRow.addChild("td", "class", "priority" + i, priorityClasses[i]);
        }
        if (reqs.length > 1 && SimpleToadletServer.isPanicButtonToBeShown) {
            contentNode.addChild(this.createPanicBox(pageMaker, ctx));
        }
        if (!completedDownloadToTemp.isEmpty()) {
            contentNode.addChild("a", "id", "completedDownloadToTemp");
            HTMLNode completedDownloadsToTempContent = pageMaker.getInfobox("completed_requests", L10n.getString("QueueToadlet.completedDinTempDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToTemp.size())}), contentNode);
            if (advancedModeEnabled) {
                completedDownloadsToTempContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToTemp, new int[]{1, 2, 3, 4, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            } else {
                completedDownloadsToTempContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToTemp, new int[]{2, 4, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            }
        }
        if (!completedDownloadToDisk.isEmpty()) {
            contentNode.addChild("a", "id", "completedDownloadToDisk");
            HTMLNode completedToDiskInfoboxContent = pageMaker.getInfobox("completed_requests", L10n.getString("QueueToadlet.completedDinDownloadDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToDisk.size())}), contentNode);
            if (advancedModeEnabled) {
                completedToDiskInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToDisk, new int[]{1, 7, 2, 3, 4, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            } else {
                completedToDiskInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToDisk, new int[]{7, 2, 4, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            }
        }
        if (!completedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "completedUpload");
            HTMLNode completedUploadInfoboxContent = pageMaker.getInfobox("completed_requests", L10n.getString("QueueToadlet.completedU", new String[]{"size"}, new String[]{String.valueOf(completedUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                completedUploadInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedUpload, new int[]{1, 7, 2, 3, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                completedUploadInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedUpload, new int[]{7, 2, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!completedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "completedDirUpload");
            HTMLNode completedUploadDirContent = pageMaker.getInfobox("completed_requests", L10n.getString("QueueToadlet.completedUDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDirUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                completedUploadDirContent.addChild(this.createRequestTable(pageMaker, ctx, completedDirUpload, new int[]{1, 9, 10, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                completedUploadDirContent.addChild(this.createRequestTable(pageMaker, ctx, completedDirUpload, new int[]{9, 10, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!failedDownload.isEmpty()) {
            contentNode.addChild("a", "id", "failedDownload");
            HTMLNode failedContent = pageMaker.getInfobox("failed_requests", L10n.getString("QueueToadlet.failedD", new String[]{"size"}, new String[]{String.valueOf(failedDownload.size())}), contentNode);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDownload, new int[]{1, 7, 2, 3, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDownload, new int[]{7, 2, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, false, container));
            }
        }
        if (!failedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "failedUpload");
            HTMLNode failedContent = pageMaker.getInfobox("failed_requests", L10n.getString("QueueToadlet.failedU", new String[]{"size"}, new String[]{String.valueOf(failedUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedUpload, new int[]{1, 7, 2, 3, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedUpload, new int[]{7, 2, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!failedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "failedDirUpload");
            HTMLNode failedContent = pageMaker.getInfobox("failed_requests", L10n.getString("QueueToadlet.failedU", new String[]{"size"}, new String[]{String.valueOf(failedDirUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDirUpload, new int[]{1, 9, 10, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDirUpload, new int[]{9, 10, 11, 12, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!uncompletedDownload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedDownload");
            HTMLNode uncompletedContent = pageMaker.getInfobox("requests_in_progress", L10n.getString("QueueToadlet.wipD", new String[]{"size"}, new String[]{String.valueOf(uncompletedDownload.size())}), contentNode);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDownload, new int[]{1, 8, 2, 3, 11, 5, 7, 6}, priorityClasses, advancedModeEnabled, false, container));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDownload, new int[]{7, 2, 11, 8, 6, 5}, priorityClasses, advancedModeEnabled, false, container));
            }
        }
        if (!uncompletedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedUpload");
            HTMLNode uncompletedContent = pageMaker.getInfobox("requests_in_progress", L10n.getString("QueueToadlet.wipU", new String[]{"size"}, new String[]{String.valueOf(uncompletedUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedUpload, new int[]{1, 8, 2, 3, 11, 5, 7, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedUpload, new int[]{7, 2, 11, 8, 6, 5}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!uncompletedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedDirUpload");
            HTMLNode uncompletedContent = pageMaker.getInfobox("requests_in_progress", L10n.getString("QueueToadlet.wipDU", new String[]{"size"}, new String[]{String.valueOf(uncompletedDirUpload.size())}), contentNode);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDirUpload, new int[]{1, 9, 8, 10, 11, 5, 6}, priorityClasses, advancedModeEnabled, true, container));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDirUpload, new int[]{9, 10, 11, 8, 6, 5}, priorityClasses, advancedModeEnabled, true, container));
            }
        }
        if (!this.uploads) {
            contentNode.addChild(this.createBulkDownloadForm(ctx, pageMaker));
        }
        return pageNode;
    }

    private HTMLNode createReasonCell(String failureReason) {
        HTMLNode reasonCell = new HTMLNode("td", "class", "request-reason");
        if (failureReason == null) {
            reasonCell.addChild("span", "class", "failure_reason_unknown", L10n.getString("QueueToadlet.unknown"));
        } else {
            reasonCell.addChild("span", "class", "failure_reason_is", failureReason);
        }
        return reasonCell;
    }

    private HTMLNode createProgressCell(boolean started, int fetched, int failed, int fatallyFailed, int min, int total, boolean finalized, boolean upload) {
        HTMLNode progressCell = new HTMLNode("td", "class", "request-progress");
        if (!started) {
            progressCell.addChild("#", L10n.getString("QueueToadlet.starting"));
            return progressCell;
        }
        if (!this.core.isAdvancedModeEnabled() || total < min) {
            total = min;
        }
        if (fetched < 0 || total <= 0) {
            progressCell.addChild("span", "class", "progress_fraction_unknown", L10n.getString("QueueToadlet.unknown"));
        } else {
            int fetchedPercent = (int)((double)fetched / (double)total * 100.0);
            int failedPercent = (int)((double)failed / (double)total * 100.0);
            int fatallyFailedPercent = (int)((double)fatallyFailed / (double)total * 100.0);
            int minPercent = (int)((double)min / (double)total * 100.0);
            HTMLNode progressBar = progressCell.addChild("div", "class", "progressbar");
            progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-done", "width: " + fetchedPercent + "%;"});
            if (failed > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed", "width: " + failedPercent + "%;"});
            }
            if (fatallyFailed > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed2", "width: " + fatallyFailedPercent + "%;"});
            }
            if (fetched + failed + fatallyFailed < min) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-min", "width: " + (minPercent - fetchedPercent) + "%;"});
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            String prefix = '(' + Integer.toString(fetched) + "/ " + Integer.toString(min) + "): ";
            if (finalized) {
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_finalized", prefix + L10n.getString("QueueToadlet.progressbarAccurate")}, nf.format((double)((int)((double)fetched / (double)min * 1000.0)) / 10.0) + '%');
            } else {
                String text = nf.format((double)((int)((double)fetched / (double)min * 1000.0)) / 10.0) + '%';
                if (!finalized) {
                    text = "" + fetched + " (" + text + "??)";
                }
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_not_finalized", prefix + L10n.getString(upload ? "QueueToadlet.uploadProgressbarNotAccurate" : "QueueToadlet.progressbarNotAccurate")}, text);
            }
        }
        return progressCell;
    }

    private HTMLNode createNumberCell(int numberOfFiles) {
        HTMLNode numberCell = new HTMLNode("td", "class", "request-files");
        numberCell.addChild("span", "class", "number_of_files", String.valueOf(numberOfFiles));
        return numberCell;
    }

    private HTMLNode createFilenameCell(File filename) {
        HTMLNode filenameCell = new HTMLNode("td", "class", "request-filename");
        if (filename != null) {
            filenameCell.addChild("span", "class", "filename_is", filename.toString());
        } else {
            filenameCell.addChild("span", "class", "filename_none", L10n.getString("QueueToadlet.none"));
        }
        return filenameCell;
    }

    private HTMLNode createPriorityCell(PageMaker pageMaker, String identifier, short priorityClass, ToadletContext ctx, String[] priorityClasses, boolean advancedModeEnabled) {
        HTMLNode priorityCell = new HTMLNode("td", "class", "request-priority nowrap");
        HTMLNode priorityForm = ctx.addFormChild(priorityCell, this.path(), "queueChangePriorityCell-" + identifier.hashCode());
        priorityForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "identifier", identifier});
        HTMLNode prioritySelect = priorityForm.addChild("select", "name", "priority");
        for (int p = 0; p < 7; ++p) {
            if (p <= 1 && !advancedModeEnabled) continue;
            if (p == priorityClass) {
                prioritySelect.addChild("option", new String[]{"value", "selected"}, new String[]{String.valueOf(p), "selected"}, priorityClasses[p]);
                continue;
            }
            prioritySelect.addChild("option", "value", String.valueOf(p), priorityClasses[p]);
        }
        priorityForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "change_priority", L10n.getString("QueueToadlet.change")});
        return priorityCell;
    }

    private HTMLNode createDeleteCell(PageMaker pageMaker, String identifier, ClientRequest clientRequest, ToadletContext ctx) {
        HTMLNode deleteNode = new HTMLNode("td", "class", "request-delete");
        HTMLNode deleteForm = ctx.addFormChild(deleteNode, this.path(), "queueDeleteForm-" + identifier.hashCode());
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "identifier", identifier});
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_request", L10n.getString("QueueToadlet.remove")});
        if (clientRequest.hasFinished() && !clientRequest.hasSucceeded() && clientRequest.canRestart()) {
            HTMLNode retryForm = ctx.addFormChild(deleteNode, this.path(), "queueRestartForm-" + identifier.hashCode());
            String restartName = L10n.getString(clientRequest instanceof ClientGet && ((ClientGet)clientRequest).hasPermRedirect() ? "QueueToadlet.follow" : "QueueToadlet.restart");
            retryForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "identifier", identifier});
            retryForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart_request", restartName});
        }
        return deleteNode;
    }

    private HTMLNode createPanicBox(PageMaker pageMaker, ToadletContext ctx) {
        InfoboxNode infobox = pageMaker.getInfobox("infobox-alert", L10n.getString("QueueToadlet.panicButton"));
        HTMLNode panicBox = infobox.outer;
        HTMLNode panicForm = ctx.addFormChild(infobox.content, this.path(), "queuePanicForm");
        panicForm.addChild("#", L10n.getString("QueueToadlet.panicButtonConfirmation") + ' ');
        panicForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_AllRequests", L10n.getString("QueueToadlet.remove")});
        return panicBox;
    }

    private HTMLNode createIdentifierCell(FreenetURI uri, String identifier, boolean directory) {
        HTMLNode identifierCell = new HTMLNode("td", "class", "request-identifier");
        if (uri != null) {
            identifierCell.addChild("span", "class", "identifier_with_uri").addChild("a", "href", "/" + uri + (directory ? "/" : ""), identifier);
        } else {
            identifierCell.addChild("span", "class", "identifier_without_uri", identifier);
        }
        return identifierCell;
    }

    private HTMLNode createPersistenceCell(boolean persistent, boolean persistentForever) {
        HTMLNode persistenceCell = new HTMLNode("td", "class", "request-persistence");
        if (persistentForever) {
            persistenceCell.addChild("span", "class", "persistence_forever", L10n.getString("QueueToadlet.persistenceForever"));
        } else if (persistent) {
            persistenceCell.addChild("span", "class", "persistence_reboot", L10n.getString("QueueToadlet.persistenceReboot"));
        } else {
            persistenceCell.addChild("span", "class", "persistence_none", L10n.getString("QueueToadlet.persistenceNone"));
        }
        return persistenceCell;
    }

    private HTMLNode createDownloadCell(PageMaker pageMaker, ClientGet p, ObjectContainer container) {
        HTMLNode downloadCell = new HTMLNode("td", "class", "request-download");
        FreenetURI uri = p.getURI(container);
        if (uri == null) {
            Logger.error(this, "NO URI FOR " + p, new Exception("error"));
        } else {
            downloadCell.addChild("a", "href", uri.toString(), L10n.getString("QueueToadlet.download"));
        }
        return downloadCell;
    }

    private HTMLNode createTypeCell(String type) {
        HTMLNode typeCell = new HTMLNode("td", "class", "request-type");
        if (type != null) {
            typeCell.addChild("span", "class", "mimetype_is", type);
        } else {
            typeCell.addChild("span", "class", "mimetype_unknown", L10n.getString("QueueToadlet.unknown"));
        }
        return typeCell;
    }

    private HTMLNode createSizeCell(long dataSize, boolean confirmed, boolean advancedModeEnabled) {
        HTMLNode sizeCell = new HTMLNode("td", "class", "request-size");
        if (dataSize > 0L && (confirmed || advancedModeEnabled)) {
            sizeCell.addChild("span", "class", "filesize_is", (confirmed ? "" : ">= ") + SizeUtil.formatSize(dataSize) + (confirmed ? "" : " ??"));
        } else {
            sizeCell.addChild("span", "class", "filesize_unknown", L10n.getString("QueueToadlet.unknown"));
        }
        return sizeCell;
    }

    private HTMLNode createKeyCell(FreenetURI uri, boolean addSlash) {
        HTMLNode keyCell = new HTMLNode("td", "class", "request-key");
        if (uri != null) {
            keyCell.addChild("span", "class", "key_is").addChild("a", "href", '/' + uri.toString() + (addSlash ? "/" : ""), uri.toShortString() + (addSlash ? "/" : ""));
        } else {
            keyCell.addChild("span", "class", "key_unknown", L10n.getString("QueueToadlet.unknown"));
        }
        return keyCell;
    }

    private HTMLNode createInsertBox(PageMaker pageMaker, ToadletContext ctx, boolean isAdvancedModeEnabled) {
        InfoboxNode infobox = pageMaker.getInfobox(L10n.getString("QueueToadlet.insertFile"));
        HTMLNode insertBox = infobox.outer;
        HTMLNode insertContent = infobox.content;
        HTMLNode insertForm = ctx.addFormChild(insertContent, this.path(), "queueInsertForm");
        insertForm.addChild("#", L10n.getString("QueueToadlet.insertAs") + ' ');
        insertForm.addChild("input", new String[]{"type", "name", "value", "checked"}, new String[]{"radio", "keytype", "chk", "checked"});
        insertForm.addChild("#", " CHK \u00a0 ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "keytype", "ksk"});
        insertForm.addChild("#", " KSK/SSK/USK \u00a0 ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "key", "KSK@"});
        if (ctx.isAllowedFullAccess()) {
            insertForm.addChild("br");
            insertForm.addChild("#", L10n.getString("QueueToadlet.insertFileBrowseLabel") + ":");
            insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert-local", L10n.getString("QueueToadlet.insertFileBrowseButton") + "..."});
            insertForm.addChild("br");
        }
        insertForm.addChild("#", L10n.getString("QueueToadlet.insertFileLabel") + ": ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"file", "filename", ""});
        insertForm.addChild("#", " \u00a0 ");
        insertForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert", L10n.getString("QueueToadlet.insertFileInsertFileLabel")});
        insertForm.addChild("#", " \u00a0 ");
        if (isAdvancedModeEnabled) {
            insertForm.addChild("input", new String[]{"type", "name", "checked"}, new String[]{"checkbox", "compress", "checked"});
            insertForm.addChild("#", " " + L10n.getString("QueueToadlet.insertFileCompressLabel") + " \u00a0 ");
        } else {
            insertForm.addChild("input", new String[]{"type", "value"}, new String[]{"hidden", "true"});
        }
        insertForm.addChild("input", new String[]{"type", "name"}, new String[]{"reset", L10n.getString("QueueToadlet.insertFileResetForm")});
        return insertBox;
    }

    private HTMLNode createBulkDownloadForm(ToadletContext ctx, PageMaker pageMaker) {
        InfoboxNode infobox = pageMaker.getInfobox(L10n.getString("QueueToadlet.downloadFiles"));
        HTMLNode downloadBox = infobox.outer;
        HTMLNode downloadBoxContent = infobox.content;
        HTMLNode downloadForm = ctx.addFormChild(downloadBoxContent, this.path(), "queueDownloadForm");
        downloadForm.addChild("#", L10n.getString("QueueToadlet.downloadFilesInstructions"));
        downloadForm.addChild("br");
        downloadForm.addChild("textarea", new String[]{"id", "name", "cols", "rows"}, new String[]{"bulkDownloads", "bulkDownloads", "120", "8"});
        downloadForm.addChild("br");
        downloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert", L10n.getString("QueueToadlet.download")});
        return downloadBox;
    }

    private HTMLNode createRequestTable(PageMaker pageMaker, ToadletContext ctx, List<ClientRequest> requests, int[] columns, String[] priorityClasses, boolean advancedModeEnabled, boolean isUpload, ObjectContainer container) {
        HTMLNode table = new HTMLNode("table", "class", "requests");
        HTMLNode headerRow = table.addChild("tr", "class", "table-header");
        headerRow.addChild("th");
        int columnCount = columns.length;
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int column = columns[columnIndex];
            if (column == 1) {
                headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=id" : "?sortBy=id&reversed").addChild("#", L10n.getString("QueueToadlet.identifier"));
                continue;
            }
            if (column == 2) {
                headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=size" : "?sortBy=size&reversed").addChild("#", L10n.getString("QueueToadlet.size"));
                continue;
            }
            if (column == 4) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.download"));
                continue;
            }
            if (column == 3) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.mimeType"));
                continue;
            }
            if (column == 5) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.persistence"));
                continue;
            }
            if (column == 6) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.key"));
                continue;
            }
            if (column == 7) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.fileName"));
                continue;
            }
            if (column == 8) {
                headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=priority" : "?sortBy=priority&reversed").addChild("#", L10n.getString("QueueToadlet.priority"));
                continue;
            }
            if (column == 9) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.files"));
                continue;
            }
            if (column == 10) {
                headerRow.addChild("th", L10n.getString("QueueToadlet.totalSize"));
                continue;
            }
            if (column == 11) {
                headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=progress" : "?sortBy=progress&reversed").addChild("#", L10n.getString("QueueToadlet.progress"));
                continue;
            }
            if (column != 12) continue;
            headerRow.addChild("th", L10n.getString("QueueToadlet.reason"));
        }
        for (ClientRequest clientRequest : requests) {
            container.activate((Object)clientRequest, 1);
            HTMLNode requestRow = table.addChild("tr", "class", "priority" + clientRequest.getPriority());
            requestRow.addChild(this.createDeleteCell(pageMaker, clientRequest.getIdentifier(), clientRequest, ctx));
            for (int column : columns) {
                if (column == 1) {
                    if (clientRequest instanceof ClientGet) {
                        requestRow.addChild(this.createIdentifierCell(((ClientGet)clientRequest).getURI(container), clientRequest.getIdentifier(), false));
                        continue;
                    }
                    if (clientRequest instanceof ClientPutDir) {
                        requestRow.addChild(this.createIdentifierCell(((ClientPutDir)clientRequest).getFinalURI(container), clientRequest.getIdentifier(), true));
                        continue;
                    }
                    if (!(clientRequest instanceof ClientPut)) continue;
                    requestRow.addChild(this.createIdentifierCell(((ClientPut)clientRequest).getFinalURI(container), clientRequest.getIdentifier(), false));
                    continue;
                }
                if (column == 2) {
                    if (clientRequest instanceof ClientGet) {
                        requestRow.addChild(this.createSizeCell(((ClientGet)clientRequest).getDataSize(container), ((ClientGet)clientRequest).isTotalFinalized(container), advancedModeEnabled));
                        continue;
                    }
                    if (!(clientRequest instanceof ClientPut)) continue;
                    requestRow.addChild(this.createSizeCell(((ClientPut)clientRequest).getDataSize(container), true, advancedModeEnabled));
                    continue;
                }
                if (column == 4) {
                    requestRow.addChild(this.createDownloadCell(pageMaker, (ClientGet)clientRequest, container));
                    continue;
                }
                if (column == 3) {
                    if (clientRequest instanceof ClientGet) {
                        requestRow.addChild(this.createTypeCell(((ClientGet)clientRequest).getMIMEType(container)));
                        continue;
                    }
                    if (!(clientRequest instanceof ClientPut)) continue;
                    requestRow.addChild(this.createTypeCell(((ClientPut)clientRequest).getMIMEType()));
                    continue;
                }
                if (column == 5) {
                    requestRow.addChild(this.createPersistenceCell(clientRequest.isPersistent(), clientRequest.isPersistentForever()));
                    continue;
                }
                if (column == 6) {
                    if (clientRequest instanceof ClientGet) {
                        requestRow.addChild(this.createKeyCell(((ClientGet)clientRequest).getURI(container), false));
                        continue;
                    }
                    if (clientRequest instanceof ClientPut) {
                        requestRow.addChild(this.createKeyCell(((ClientPut)clientRequest).getFinalURI(container), false));
                        continue;
                    }
                    requestRow.addChild(this.createKeyCell(((ClientPutDir)clientRequest).getFinalURI(container), true));
                    continue;
                }
                if (column == 7) {
                    if (clientRequest instanceof ClientGet) {
                        requestRow.addChild(this.createFilenameCell(((ClientGet)clientRequest).getDestFilename(container)));
                        continue;
                    }
                    if (!(clientRequest instanceof ClientPut)) continue;
                    requestRow.addChild(this.createFilenameCell(((ClientPut)clientRequest).getOrigFilename(container)));
                    continue;
                }
                if (column == 8) {
                    requestRow.addChild(this.createPriorityCell(pageMaker, clientRequest.getIdentifier(), clientRequest.getPriority(), ctx, priorityClasses, advancedModeEnabled));
                    continue;
                }
                if (column == 9) {
                    requestRow.addChild(this.createNumberCell(((ClientPutDir)clientRequest).getNumberOfFiles()));
                    continue;
                }
                if (column == 10) {
                    requestRow.addChild(this.createSizeCell(((ClientPutDir)clientRequest).getTotalDataSize(), true, advancedModeEnabled));
                    continue;
                }
                if (column == 11) {
                    requestRow.addChild(this.createProgressCell(clientRequest.isStarted(), (int)clientRequest.getFetchedBlocks(container), (int)clientRequest.getFailedBlocks(container), (int)clientRequest.getFatalyFailedBlocks(container), (int)clientRequest.getMinBlocks(container), (int)clientRequest.getTotalBlocks(container), clientRequest.isTotalFinalized(container) || clientRequest instanceof ClientPut, isUpload));
                    continue;
                }
                if (column != 12) continue;
                requestRow.addChild(this.createReasonCell(clientRequest.getFailureReason(container)));
            }
        }
        return table;
    }

    @Override
    public String supportedMethods() {
        return "GET, POST";
    }

    @Override
    public void notifyFailure(ClientRequest req, ObjectContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySuccess(ClientRequest req, ObjectContainer container) {
        if (this.uploads == req instanceof ClientGet) {
            return;
        }
        HashSet<String> hashSet = this.completedRequestIdentifiers;
        synchronized (hashSet) {
            this.completedRequestIdentifiers.add(req.getIdentifier());
        }
        this.registerAlert(req, container);
        this.saveCompletedIdentifiersOffThread();
    }

    private void saveCompletedIdentifiersOffThread() {
        this.core.getExecutor().execute(new Runnable(){

            public void run() {
                QueueToadlet.this.saveCompletedIdentifiers();
            }
        }, "Save completed identifiers");
    }

    private void loadCompletedIdentifiers() throws DatabaseDisabledException {
        String dl = this.uploads ? "uploads" : "downloads";
        File completedIdentifiersList = new File(this.core.node.getNodeDir(), "completed.list." + dl);
        File completedIdentifiersListNew = new File(this.core.node.getNodeDir(), "completed.list." + dl + ".bak");
        File oldCompletedIdentifiersList = new File(this.core.node.getNodeDir(), "completed.list");
        boolean migrated = false;
        if (!this.readCompletedIdentifiers(completedIdentifiersList)) {
            if (!this.readCompletedIdentifiers(completedIdentifiersListNew)) {
                this.readCompletedIdentifiers(oldCompletedIdentifiersList);
                migrated = true;
            }
        } else {
            oldCompletedIdentifiersList.delete();
        }
        final boolean writeAnyway = migrated;
        this.core.clientContext.jobRunner.queue(new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                String[] identifiers;
                boolean changed = writeAnyway;
                HashSet hashSet = QueueToadlet.this.completedRequestIdentifiers;
                synchronized (hashSet) {
                    identifiers = QueueToadlet.this.completedRequestIdentifiers.toArray(new String[QueueToadlet.this.completedRequestIdentifiers.size()]);
                }
                for (int i = 0; i < identifiers.length; ++i) {
                    ClientRequest req = QueueToadlet.this.fcp.getGlobalRequest(identifiers[i], container);
                    if (req == null || req instanceof ClientGet == QueueToadlet.this.uploads) {
                        HashSet hashSet2 = QueueToadlet.this.completedRequestIdentifiers;
                        synchronized (hashSet2) {
                            QueueToadlet.this.completedRequestIdentifiers.remove(identifiers[i]);
                        }
                        changed = true;
                        continue;
                    }
                    QueueToadlet.this.registerAlert(req, container);
                }
                if (changed) {
                    QueueToadlet.this.saveCompletedIdentifiers();
                }
                return false;
            }
        }, 7, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readCompletedIdentifiers(File file) {
        boolean bl;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                InputStreamReader isr = new InputStreamReader((InputStream)bis, "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                HashSet<String> hashSet = this.completedRequestIdentifiers;
                synchronized (hashSet) {
                    this.completedRequestIdentifiers.clear();
                    while (true) {
                        String identifier;
                        if ((identifier = br.readLine()) == null) {
                            bl = true;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 10, 11] lbl14 : MonitorExitStatement: MONITOREXIT : var6_13
                            Object var11_16 = null;
                            break;
                        }
                        this.completedRequestIdentifiers.add(identifier);
                    }
                }
            }
            catch (EOFException e) {
                boolean bl2 = true;
                Object var11_17 = null;
                Closer.close(fis);
                return bl2;
            }
            catch (FileNotFoundException e) {
                boolean bl3 = false;
                Object var11_18 = null;
                Closer.close(fis);
                return bl3;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            catch (IOException e) {
                Logger.error(this, "Could not read completed identifiers list from " + file);
                boolean bl4 = false;
                Object var11_19 = null;
                Closer.close(fis);
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(fis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveCompletedIdentifiers() {
        File temp;
        File completedIdentifiersListNew;
        File completedIdentifiersList;
        block33: {
            BufferedWriter bw;
            FileOutputStream fos;
            block32: {
                String[] identifiers;
                fos = null;
                bw = null;
                String dl = this.uploads ? "uploads" : "downloads";
                completedIdentifiersList = new File(this.core.node.getNodeDir(), "completed.list." + dl);
                completedIdentifiersListNew = new File(this.core.node.getNodeDir(), "completed.list." + dl + ".bak");
                temp = File.createTempFile("completed.list", ".tmp", this.core.node.getNodeDir());
                temp.deleteOnExit();
                fos = new FileOutputStream(temp);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                bw = new BufferedWriter(osw);
                HashSet<String> hashSet = this.completedRequestIdentifiers;
                synchronized (hashSet) {
                    identifiers = this.completedRequestIdentifiers.toArray(new String[this.completedRequestIdentifiers.size()]);
                }
                for (int i = 0; i < identifiers.length; ++i) {
                    bw.write(identifiers[i] + '\n');
                }
                Object var12_14 = null;
                if (bw == null) break block32;
                try {
                    bw.close();
                }
                catch (IOException e2) {
                    try {
                        fos.close();
                        break block33;
                    }
                    catch (IOException e1) {}
                }
                break block33;
            }
            try {
                fos.close();
            }
            catch (IOException e1) {}
            break block33;
            {
                catch (FileNotFoundException e) {
                    Logger.error(this, "Unable to save completed requests list (can't find node directory?!!?): " + e, e);
                    Object var12_15 = null;
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException e2) {
                            try {
                                fos.close();
                            }
                            catch (IOException e1) {}
                        }
                    } else {
                        try {
                            fos.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    Logger.error(this, "Unable to save completed requests list: " + e, e);
                    Object var12_16 = null;
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException e2) {
                            try {
                                fos.close();
                            }
                            catch (IOException e1) {}
                        }
                    } else {
                        try {
                            fos.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        try {
                            fos.close();
                        }
                        catch (IOException e1) {}
                    }
                } else {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        completedIdentifiersListNew.delete();
        temp.renameTo(completedIdentifiersListNew);
        if (!completedIdentifiersListNew.renameTo(completedIdentifiersList)) {
            completedIdentifiersList.delete();
            if (!completedIdentifiersListNew.renameTo(completedIdentifiersList)) {
                Logger.error(this, "Unable to store completed identifiers list because unable to rename " + completedIdentifiersListNew + " to " + completedIdentifiersList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAlert(ClientRequest req, ObjectContainer container) {
        final String identifier = req.getIdentifier();
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Registering alert for " + identifier);
        }
        if (!req.hasFinished()) {
            if (logMINOR) {
                Logger.minor(this, "Request hasn't finished: " + req + " for " + identifier, (Throwable)new Exception("debug"));
            }
            return;
        }
        if (req instanceof ClientGet) {
            FreenetURI uri = ((ClientGet)req).getURI(container);
            if (req.isPersistentForever() && uri != null) {
                container.activate((Object)uri, 5);
            }
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientGet)req).getDataSize(container);
            String name = uri.getPreferredFilename();
            String title = this.l10n("downloadSucceededTitle", "filename", name);
            HTMLNode text = new HTMLNode("div");
            L10n.addL10nSubstitution(text, "QueueToadlet.downloadSucceeded", new String[]{"link", "/link", "origlink", "/origlink", "filename", "size"}, new String[]{"<a href=\"" + this.path() + uri.toASCIIString() + "\">", "</a>", "<a href=\"/" + uri.toASCIIString() + "\">", "</a>", name, SizeUtil.formatSize(size)});
            SimpleHTMLUserAlert alert = new SimpleHTMLUserAlert(true, title, title, text, 3){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDismiss() {
                    Cloneable cloneable = QueueToadlet.this.completedRequestIdentifiers;
                    synchronized (cloneable) {
                        QueueToadlet.this.completedRequestIdentifiers.remove(identifier);
                    }
                    cloneable = QueueToadlet.this.alertsByIdentifier;
                    synchronized (cloneable) {
                        QueueToadlet.this.alertsByIdentifier.remove(identifier);
                    }
                    QueueToadlet.this.saveCompletedIdentifiersOffThread();
                }

                public boolean isEventNotification() {
                    return true;
                }
            };
            this.core.alerts.register(alert);
            HashMap<String, UserAlert> hashMap = this.alertsByIdentifier;
            synchronized (hashMap) {
                this.alertsByIdentifier.put(identifier, alert);
            }
        }
        if (req instanceof ClientPut) {
            FreenetURI uri = ((ClientPut)req).getFinalURI(container);
            if (req.isPersistentForever() && uri != null) {
                container.activate((Object)uri, 5);
            }
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientPut)req).getDataSize(container);
            String name = uri.getPreferredFilename();
            String title = this.l10n("uploadSucceededTitle", "filename", name);
            HTMLNode text = new HTMLNode("div");
            L10n.addL10nSubstitution(text, "QueueToadlet.uploadSucceeded", new String[]{"link", "/link", "filename", "size"}, new String[]{"<a href=\"/" + uri.toASCIIString() + "\">", "</a>", name, SizeUtil.formatSize(size)});
            SimpleHTMLUserAlert alert = new SimpleHTMLUserAlert(true, title, title, text, 3){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDismiss() {
                    Cloneable cloneable = QueueToadlet.this.completedRequestIdentifiers;
                    synchronized (cloneable) {
                        QueueToadlet.this.completedRequestIdentifiers.remove(identifier);
                    }
                    cloneable = QueueToadlet.this.alertsByIdentifier;
                    synchronized (cloneable) {
                        QueueToadlet.this.alertsByIdentifier.remove(identifier);
                    }
                    QueueToadlet.this.saveCompletedIdentifiersOffThread();
                }

                public boolean isEventNotification() {
                    return true;
                }
            };
            this.core.alerts.register(alert);
            HashMap<String, UserAlert> hashMap = this.alertsByIdentifier;
            synchronized (hashMap) {
                this.alertsByIdentifier.put(identifier, alert);
            }
        }
        if (req instanceof ClientPutDir) {
            FreenetURI uri = ((ClientPutDir)req).getFinalURI(container);
            if (req.isPersistentForever() && uri != null) {
                container.activate((Object)uri, 5);
            }
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientPutDir)req).getTotalDataSize();
            int files = ((ClientPutDir)req).getNumberOfFiles();
            String name = uri.getPreferredFilename();
            String title = this.l10n("siteUploadSucceededTitle", "filename", name);
            HTMLNode text = new HTMLNode("div");
            L10n.addL10nSubstitution(text, "QueueToadlet.siteUploadSucceeded", new String[]{"link", "/link", "filename", "size", "files"}, new String[]{"<a href=\"/" + uri.toASCIIString() + "\">", "</a>", name, SizeUtil.formatSize(size), Integer.toString(files)});
            SimpleHTMLUserAlert alert = new SimpleHTMLUserAlert(true, title, title, text, 3){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDismiss() {
                    Cloneable cloneable = QueueToadlet.this.completedRequestIdentifiers;
                    synchronized (cloneable) {
                        QueueToadlet.this.completedRequestIdentifiers.remove(identifier);
                    }
                    cloneable = QueueToadlet.this.alertsByIdentifier;
                    synchronized (cloneable) {
                        QueueToadlet.this.alertsByIdentifier.remove(identifier);
                    }
                    QueueToadlet.this.saveCompletedIdentifiersOffThread();
                }

                public boolean isEventNotification() {
                    return true;
                }
            };
            this.core.alerts.register(alert);
            HashMap<String, UserAlert> hashMap = this.alertsByIdentifier;
            synchronized (hashMap) {
                this.alertsByIdentifier.put(identifier, alert);
            }
        }
    }

    String l10n(String key, String pattern, String value) {
        return L10n.getString("QueueToadlet." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemove(ClientRequest req, ObjectContainer container) {
        UserAlert alert;
        String identifier = req.getIdentifier();
        HashSet<String> hashSet = this.completedRequestIdentifiers;
        synchronized (hashSet) {
            this.completedRequestIdentifiers.remove(identifier);
        }
        HashMap<String, UserAlert> hashMap = this.alertsByIdentifier;
        synchronized (hashMap) {
            alert = this.alertsByIdentifier.remove(identifier);
        }
        this.core.alerts.unregister(alert);
        this.saveCompletedIdentifiersOffThread();
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        return !this.container.publicGatewayMode() || ctx != null && ctx.isAllowedFullAccess();
    }

    @Override
    public String path() {
        if (this.uploads) {
            return "/uploads/";
        }
        return "/downloads/";
    }
}

