/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.AccessDeniedPluginHTTPException;
import freenet.pluginmanager.DownloadPluginHTTPException;
import freenet.pluginmanager.NotFoundPluginHTTPException;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.RedirectPluginHTTPException;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PproxyToadlet
extends Toadlet {
    private static final int MAX_PLUGIN_NAME_LENGTH = 1024;
    private static final int MAX_THREADED_UNLOAD_WAIT_TIME = 60000;
    private final Node node;
    private final NodeClientCore core;

    public PproxyToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.node = node;
        this.core = core;
    }

    @Override
    public String supportedMethods() {
        return "GET, POST";
    }

    @Override
    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        String pass = request.getPartAsString("formPassword", 32);
        if (pass == null || !pass.equals(this.core.formPassword)) {
            headers.put("Location", "/plugins/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, this.l10n("unauthorizedTitle"), this.l10n("unauthorized"));
            return;
        }
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("plugins/")) {
            path = path.substring("plugins/".length());
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Pproxy received POST on " + path);
        }
        PluginManager pm = this.node.pluginManager;
        if (path.length() > 0) {
            try {
                String plugin = null;
                int to = path.indexOf("/");
                plugin = to == -1 ? path : path.substring(0, to);
                this.writeHTMLReply(ctx, 200, "OK", pm.handleHTTPPost(plugin, request));
            }
            catch (RedirectPluginHTTPException e) {
                this.writeTemporaryRedirect(ctx, e.message, e.newLocation);
            }
            catch (NotFoundPluginHTTPException e) {
                this.sendErrorPage(ctx, 404, e.message, e.location);
            }
            catch (AccessDeniedPluginHTTPException e) {
                this.sendErrorPage(ctx, 403, e.message, e.location);
            }
            catch (DownloadPluginHTTPException e) {
                MultiValueTable<String, String> head = new MultiValueTable<String, String>();
                head.put("Content-Disposition", "attachment; filename=\"" + e.filename + '\"');
                ctx.sendReplyHeaders(200, "Found", head, e.mimeType, e.data.length);
                ctx.writeData(e.data);
            }
            catch (PluginHTTPException e) {
                this.sendErrorPage(ctx, 400, e.message, e.location);
            }
            catch (Throwable t) {
                this.writeInternalError(t, ctx);
            }
        } else {
            PageMaker pageMaker = ctx.getPageMaker();
            if (request.isPartSet("submit-official")) {
                String pluginName = null;
                pluginName = request.getPartAsString("plugin-name", 40);
                pm.startPluginOfficial(pluginName, true);
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("submit-other")) {
                String pluginName = null;
                pluginName = request.getPartAsString("plugin-url", 200);
                boolean fileonly = "on".equalsIgnoreCase(request.getPartAsString("fileonly", 20));
                if (fileonly) {
                    pm.startPluginFile(pluginName, true);
                } else {
                    pm.startPluginURL(pluginName, true);
                }
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("submit-freenet")) {
                String pluginName = null;
                pluginName = request.getPartAsString("plugin-uri", 300);
                pm.startPluginFreenet(pluginName, true);
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("dismiss-user-alert")) {
                int userAlertHashCode = request.getIntPart("disable", -1);
                this.core.alerts.dismissAlert(userAlertHashCode);
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("cancel")) {
                headers.put("Location", "/plugins/");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.getPartAsString("unloadconfirm", 1024).length() > 0) {
                String pluginThreadName = request.getPartAsString("unloadconfirm", 1024);
                String pluginSpecification = this.getPluginSpecification(pm, pluginThreadName);
                pm.killPlugin(pluginThreadName, 60000);
                if (request.isPartSet("purge")) {
                    pm.removeCachedCopy(pluginSpecification);
                }
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-success");
                infobox.addChild("div", "class", "infobox-header", this.l10n("pluginUnloaded"));
                HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                infoboxContent.addChild("#", this.l10n("pluginUnloadedWithName", "name", pluginThreadName));
                infoboxContent.addChild("br");
                infoboxContent.addChild("a", "href", "/plugins/", this.l10n("returnToPluginPage"));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsString("unload", 1024).length() > 0) {
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-query");
                infobox.addChild("div", "class", "infobox-header", this.l10n("unloadPluginTitle"));
                HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                infoboxContent.addChild("#", this.l10n("unloadPluginWithName", "name", request.getPartAsString("unload", 1024)));
                HTMLNode unloadForm = ctx.addFormChild(infoboxContent, "/plugins/", "unloadPluginConfirmForm");
                unloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "unloadconfirm", request.getPartAsString("unload", 1024)});
                HTMLNode tempNode = unloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "purge"});
                tempNode.addChild("#", this.l10n("unloadPurge"));
                tempNode = unloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirm", this.l10n("unload")});
                tempNode.addChild("#", " ");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsString("reload", 1024).length() > 0) {
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode reloadContent = pageMaker.getInfobox("infobox infobox-query", this.l10n("reloadPluginTitle"), contentNode);
                reloadContent.addChild("p", this.l10n("reloadExplanation"));
                reloadContent.addChild("p", this.l10n("reloadWarning"));
                HTMLNode reloadForm = ctx.addFormChild(reloadContent, "/plugins/", "reloadPluginConfirmForm");
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "reloadconfirm", request.getPartAsString("reload", 1024)});
                HTMLNode tempNode = reloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "purge"});
                tempNode.addChild("#", this.l10n("reloadPurgeWarning"));
                tempNode = reloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirm", this.l10n("reload")});
                tempNode.addChild("#", " ");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsString("reloadconfirm", 1024).length() > 0) {
                boolean purge = request.isPartSet("purge");
                String pluginThreadName = request.getPartAsString("reloadconfirm", 1024);
                String fn = this.getPluginSpecification(pm, pluginThreadName);
                if (fn == null) {
                    this.sendErrorPage(ctx, 404, this.l10n("pluginNotFoundReloadTitle"), L10n.getString("PluginToadlet.pluginNotFoundReload"));
                } else {
                    pm.killPlugin(pluginThreadName, 60000);
                    if (purge) {
                        pm.removeCachedCopy(fn);
                    }
                    pm.startPluginAuto(fn, true);
                    headers.put("Location", ".");
                    ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                }
                return;
            }
            headers.put("Location", ".");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
        }
    }

    private String getPluginSpecification(PluginManager pluginManager, String pluginThreadName) {
        for (PluginInfoWrapper pi : pluginManager.getPlugins()) {
            if (!pi.getThreadName().equals(pluginThreadName)) continue;
            return pi.getFilename();
        }
        return null;
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("PproxyToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key) {
        return L10n.getString("PproxyToadlet." + key);
    }

    @Override
    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("plugins/")) {
            path = path.substring("plugins/".length());
        }
        PluginManager pm = this.node.pluginManager;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Pproxy fetching " + path);
        }
        try {
            if (path.equals("")) {
                String pluginName;
                if (!ctx.isAllowedFullAccess()) {
                    super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
                    return;
                }
                Iterator<PluginManager.PluginProgress> loadingPlugins = pm.getStartingPlugins().iterator();
                PageNode page = ctx.getPageMaker().getPageNode(this.l10n("pluginsWithNodeName", "name", this.core.getMyName()), ctx);
                HTMLNode pageNode = page.outer;
                if (loadingPlugins.hasNext()) {
                    page.headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "10; url="});
                }
                HTMLNode contentNode = page.content;
                contentNode.addChild(this.core.alerts.createSummary());
                for (UserAlert userAlert : this.core.alerts.getAlerts()) {
                    if (!userAlert.isValid() || userAlert.getUserIdentifier() != PluginManager.class) continue;
                    contentNode.addChild(this.core.alerts.renderAlert(userAlert));
                }
                List<String> availablePlugins = pm.findAvailablePlugins();
                for (PluginInfoWrapper pluginInfoWrapper : pm.getPlugins()) {
                    pluginName = pluginInfoWrapper.getPluginClassName();
                    String shortPluginName = pluginName.substring(pluginName.lastIndexOf(46) + 1);
                    availablePlugins.remove(shortPluginName);
                }
                while (loadingPlugins.hasNext()) {
                    PluginManager.PluginProgress pluginProgress = loadingPlugins.next();
                    pluginName = pluginProgress.getName();
                    availablePlugins.remove(pluginName);
                }
                this.showStartingPlugins(pm, contentNode);
                this.showPluginList(ctx, pm, contentNode);
                this.showOfficialPluginLoader(ctx, contentNode, availablePlugins);
                this.showUnofficialPluginLoader(ctx, contentNode);
                this.showFreenetPluginLoader(ctx, contentNode);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            } else {
                int to = path.indexOf("/");
                String plugin = to == -1 ? path : path.substring(0, to);
                this.writeHTMLReply(ctx, 200, "OK", pm.handleHTTPGet(plugin, request));
            }
        }
        catch (RedirectPluginHTTPException e) {
            this.writeTemporaryRedirect(ctx, e.message, e.newLocation);
        }
        catch (NotFoundPluginHTTPException e) {
            this.sendErrorPage(ctx, 404, e.message, e.location);
        }
        catch (AccessDeniedPluginHTTPException e) {
            this.sendErrorPage(ctx, 403, e.message, e.location);
        }
        catch (DownloadPluginHTTPException e) {
            MultiValueTable<String, String> head = new MultiValueTable<String, String>();
            head.put("Content-Disposition", "attachment; filename=\"" + e.filename + '\"');
            ctx.sendReplyHeaders(200, "Found", head, e.mimeType, e.data.length);
            ctx.writeData(e.data);
        }
        catch (PluginHTTPException e) {
            this.sendErrorPage(ctx, 400, e.message, e.location);
        }
        catch (Throwable t) {
            ctx.forceDisconnect();
            this.writeInternalError(t, ctx);
        }
    }

    private void showStartingPlugins(PluginManager pluginManager, HTMLNode contentNode) {
        Set<PluginManager.PluginProgress> startingPlugins = pluginManager.getStartingPlugins();
        if (!startingPlugins.isEmpty()) {
            HTMLNode startingPluginsBox = contentNode.addChild("div", "class", "infobox infobox-normal");
            startingPluginsBox.addChild("div", "class", "infobox-header", this.l10n("startingPluginsTitle"));
            HTMLNode startingPluginsContent = startingPluginsBox.addChild("div", "class", "infobox-content");
            HTMLNode startingPluginsTable = startingPluginsContent.addChild("table");
            HTMLNode startingPluginsHeader = startingPluginsTable.addChild("tr");
            startingPluginsHeader.addChild("th", this.l10n("startingPluginName"));
            startingPluginsHeader.addChild("th", this.l10n("startingPluginStatus"));
            startingPluginsHeader.addChild("th", this.l10n("startingPluginTime"));
            for (PluginManager.PluginProgress pluginProgress : startingPlugins) {
                HTMLNode startingPluginsRow = startingPluginsTable.addChild("tr");
                startingPluginsRow.addChild("td", pluginProgress.getName());
                startingPluginsRow.addChild("td", this.l10n("startingPluginStatus." + pluginProgress.getProgress().toString()));
                startingPluginsRow.addChild("td", "aligh", "right", TimeUtil.formatTime(pluginProgress.getTime()));
            }
        }
    }

    private void showPluginList(ToadletContext ctx, PluginManager pm, HTMLNode contentNode) throws ToadletContextClosedException, IOException {
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", L10n.getString("PluginToadlet.pluginListTitle"));
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        if (pm.getPlugins().isEmpty()) {
            infoboxContent.addChild("div", this.l10n("noPlugins"));
        } else {
            HTMLNode pluginTable = infoboxContent.addChild("table", "class", "plugins");
            HTMLNode headerRow = pluginTable.addChild("tr");
            headerRow.addChild("th", this.l10n("classNameTitle"));
            headerRow.addChild("th", this.l10n("versionTitle"));
            headerRow.addChild("th", this.l10n("internalIDTitle"));
            headerRow.addChild("th", this.l10n("startedAtTitle"));
            headerRow.addChild("th");
            headerRow.addChild("th");
            headerRow.addChild("th");
            for (PluginInfoWrapper pi : pm.getPlugins()) {
                HTMLNode pluginRow = pluginTable.addChild("tr");
                pluginRow.addChild("td", pi.getPluginClassName());
                long ver = pi.getPluginLongVersion();
                if (ver != -1L) {
                    pluginRow.addChild("td", pi.getPluginVersion() + " (" + ver + ")");
                } else {
                    pluginRow.addChild("td", pi.getPluginVersion());
                }
                pluginRow.addChild("td", pi.getThreadName());
                pluginRow.addChild("td", new Date(pi.getStarted()).toString());
                if (pi.isStopping()) {
                    pluginRow.addChild("td", this.l10n("pluginStopping"));
                    pluginRow.addChild("td");
                    pluginRow.addChild("td");
                    continue;
                }
                if (pi.isPproxyPlugin()) {
                    HTMLNode visitForm = pluginRow.addChild("td").addChild("form", new String[]{"method", "action", "target"}, new String[]{"get", pi.getPluginClassName(), "_blank"});
                    visitForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.core.formPassword});
                    visitForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", L10n.getString("PluginToadlet.visit")});
                }
                HTMLNode unloadForm = ctx.addFormChild(pluginRow.addChild("td"), ".", "unloadPluginForm");
                unloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "unload", pi.getThreadName()});
                unloadForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("unload")});
                HTMLNode reloadForm = ctx.addFormChild(pluginRow.addChild("td"), ".", "reloadPluginForm");
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "reload", pi.getThreadName()});
                reloadForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("reload")});
            }
        }
    }

    private void showOfficialPluginLoader(ToadletContext toadletContext, HTMLNode contentNode, List<String> availablePlugins) {
        HTMLNode addOfficialPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addOfficialPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadOfficialPlugin"));
        HTMLNode addOfficialPluginContent = addOfficialPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addOfficialForm = toadletContext.addFormChild(addOfficialPluginContent, ".", "addOfficialPluginForm");
        addOfficialForm.addChild("div", this.l10n("loadOfficialPluginText"));
        addOfficialForm.addChild("p").addChild("b").addChild("font", new String[]{"color"}, new String[]{"red"}, this.l10n("loadOfficialPluginWarning"));
        addOfficialForm.addChild("#", this.l10n("loadOfficialPluginLabel") + ": ");
        HTMLNode selectNode = addOfficialForm.addChild("select", "name", "plugin-name");
        for (String pluginName : availablePlugins) {
            selectNode.addChild("option", "value", pluginName, pluginName);
        }
        addOfficialForm.addChild("#", " ");
        addOfficialForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", this.l10n("Load")});
    }

    private void showUnofficialPluginLoader(ToadletContext toadletContext, HTMLNode contentNode) {
        HTMLNode addOtherPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addOtherPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadOtherPlugin"));
        HTMLNode addOtherPluginContent = addOtherPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addOtherForm = toadletContext.addFormChild(addOtherPluginContent, ".", "addOtherPluginForm");
        addOtherForm.addChild("div", this.l10n("loadOtherPluginText"));
        addOtherForm.addChild("#", this.l10n("loadOtherURLLabel") + ": ");
        addOtherForm.addChild("input", new String[]{"type", "name", "size"}, new String[]{"text", "plugin-url", "80"});
        addOtherForm.addChild("#", " ");
        addOtherForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-other", this.l10n("Load")});
        addOtherForm.addChild("br");
        addOtherForm.addChild("input", new String[]{"type", "name", "checked"}, new String[]{"checkbox", "fileonly", "checked"});
        addOtherForm.addChild("#", " " + this.l10n("fileonly"));
    }

    private void showFreenetPluginLoader(ToadletContext toadletContext, HTMLNode contentNode) {
        HTMLNode addFreenetPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addFreenetPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadFreenetPlugin"));
        HTMLNode addFreenetPluginContent = addFreenetPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addFreenetForm = toadletContext.addFormChild(addFreenetPluginContent, ".", "addFreenetPluginForm");
        addFreenetForm.addChild("div", this.l10n("loadFreenetPluginText"));
        addFreenetForm.addChild("#", this.l10n("loadFreenetURLLabel") + ": ");
        addFreenetForm.addChild("input", new String[]{"type", "name", "size"}, new String[]{"text", "plugin-uri", "80"});
        addFreenetForm.addChild("#", " ");
        addFreenetForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-freenet", this.l10n("Load")});
    }

    @Override
    public String path() {
        return "/plugins/";
    }
}

