/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.pluginmanager.FredPluginL10n;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PageMaker {
    public static final int MODE_SIMPLE = 1;
    public static final int MODE_ADVANCED = 2;
    private THEME theme;
    private File override;
    private List<SubMenu> menuList = new ArrayList<SubMenu>();
    private Map<String, SubMenu> subMenus = new HashMap<String, SubMenu>();

    protected PageMaker(THEME t) {
        this.setTheme(t);
    }

    void setOverride(File f) {
        this.override = f;
    }

    public void setTheme(THEME theme2) {
        URL themeurl;
        this.theme = theme2 == null ? THEME.getDefault() : ((themeurl = this.getClass().getResource("staticfiles/themes/" + theme2.code + "/theme.css")) == null ? THEME.getDefault() : theme2);
    }

    public void addNavigationCategory(String link, String name, String title, FredPluginL10n plugin) {
        SubMenu menu = new SubMenu(link, name, title, plugin);
        this.subMenus.put(name, menu);
        this.menuList.add(menu);
    }

    public void removeNavigationCategory(String name) {
        SubMenu menu = this.subMenus.remove(name);
        if (menu == null) {
            Logger.error(this, "can't remove navigation category, name=" + name);
            return;
        }
        this.menuList.remove(menu);
    }

    public void addNavigationLink(String menutext, String path, String name, String title, boolean fullOnly, LinkEnabledCallback cb) {
        SubMenu menu = this.subMenus.get(menutext);
        menu.addNavigationLink(path, name, title, fullOnly, cb);
    }

    @Deprecated
    public void removeNavigationLink(String menutext, String name) {
        SubMenu menu = this.subMenus.get(menutext);
        menu.removeNavigationLink(name);
    }

    @Deprecated
    public void removeAllNavigationLinks() {
        for (SubMenu menu : this.subMenus.values()) {
            menu.removeAllNavigationLinks();
        }
    }

    public HTMLNode createBackLink(ToadletContext toadletContext, String name) {
        String referer = toadletContext.getHeaders().get("referer");
        if (referer != null) {
            return new HTMLNode("a", new String[]{"href", "title"}, new String[]{referer, name}, name);
        }
        return new HTMLNode("a", new String[]{"href", "title"}, new String[]{"javascript:back()", name}, name);
    }

    public PageNode getPageNode(String title, ToadletContext ctx) {
        return this.getPageNode(title, true, ctx);
    }

    public PageNode getPageNode(String title, boolean renderNavigationLinks, ToadletContext ctx) {
        Toadlet t;
        boolean fullAccess = ctx == null ? false : ctx.isAllowedFullAccess();
        HTMLNode.HTMLDoctype pageNode = new HTMLNode.HTMLDoctype("html", "-//W3C//DTD XHTML 1.1//EN");
        HTMLNode htmlNode = pageNode.addChild("html", "xml:lang", L10n.getSelectedLanguage().isoCode);
        HTMLNode headNode = htmlNode.addChild("head");
        headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"Content-Type", "text/html; charset=utf-8"});
        headNode.addChild("title", title + " - Freenet");
        if (this.override == null) {
            headNode.addChild("link", new String[]{"rel", "href", "type", "title"}, new String[]{"stylesheet", "/static/themes/" + this.theme.code + "/theme.css", "text/css", this.theme.code});
        } else {
            headNode.addChild(this.getOverrideContent());
        }
        for (THEME t2 : THEME.values()) {
            String themeName = t2.code;
            headNode.addChild("link", new String[]{"rel", "href", "type", "media", "title"}, new String[]{"alternate stylesheet", "/static/themes/" + themeName + "/theme.css", "text/css", "screen", themeName});
        }
        if (ctx != null) {
            t = ctx.activeToadlet();
            t = t.showAsToadlet();
        } else {
            t = null;
        }
        String activePath = "";
        if (t != null) {
            activePath = t.path();
        }
        HTMLNode bodyNode = htmlNode.addChild("body");
        HTMLNode pageDiv = bodyNode.addChild("div", "id", "page");
        HTMLNode topBarDiv = pageDiv.addChild("div", "id", "topbar");
        topBarDiv.addChild("h1", title);
        if (renderNavigationLinks) {
            SubMenu selected = null;
            HTMLNode navbarDiv = pageDiv.addChild("div", "id", "navbar");
            HTMLNode navbarUl = navbarDiv.addChild("ul", "id", "navlist");
            for (SubMenu menu : this.menuList) {
                HTMLNode listItem;
                HTMLNode subnavlist = new HTMLNode("ul");
                boolean isSelected = false;
                boolean nonEmpty = false;
                for (String navigationLink : fullAccess ? menu.navigationLinkTexts : menu.navigationLinkTextsNonFull) {
                    HTMLNode sublistItem;
                    LinkEnabledCallback cb = (LinkEnabledCallback)menu.navigationLinkCallbacks.get(navigationLink);
                    if (cb != null && !cb.isEnabled(ctx)) continue;
                    nonEmpty = true;
                    String navigationTitle = (String)menu.navigationLinkTitles.get(navigationLink);
                    String navigationPath = (String)menu.navigationLinks.get(navigationLink);
                    if (activePath.equals(navigationPath)) {
                        sublistItem = subnavlist.addChild("li", "class", "submenuitem-selected");
                        isSelected = true;
                    } else {
                        sublistItem = subnavlist.addChild("li");
                    }
                    if (menu.plugin != null) {
                        if (navigationTitle != null) {
                            navigationTitle = menu.plugin.getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = menu.plugin.getString(navigationLink);
                        }
                    } else {
                        if (navigationTitle != null) {
                            navigationTitle = L10n.getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = L10n.getString(navigationLink);
                        }
                    }
                    if (navigationTitle != null) {
                        sublistItem.addChild("a", new String[]{"href", "title"}, new String[]{navigationPath, navigationTitle}, navigationLink);
                        continue;
                    }
                    sublistItem.addChild("a", "href", navigationPath, navigationLink);
                }
                if (!nonEmpty) continue;
                if (isSelected) {
                    selected = menu;
                    subnavlist.addAttribute("class", "subnavlist-selected");
                    listItem = new HTMLNode("li", "id", "navlist-selected");
                } else {
                    subnavlist.addAttribute("class", "subnavlist");
                    listItem = new HTMLNode("li");
                }
                String menuItemTitle = menu.defaultNavigationLinkTitle;
                String text = menu.navigationLinkText;
                if (menu.plugin == null) {
                    menuItemTitle = L10n.getString(menuItemTitle);
                    text = L10n.getString(text);
                } else {
                    menuItemTitle = menu.plugin.getString(menuItemTitle);
                    text = menu.plugin.getString(text);
                }
                listItem.addChild("a", new String[]{"href", "title"}, new String[]{menu.defaultNavigationLink, menuItemTitle}, text);
                listItem.addChild(subnavlist);
                navbarUl.addChild(listItem);
            }
            if (selected != null) {
                HTMLNode div = new HTMLNode("div", "id", "selected-subnavbar");
                HTMLNode subnavlist = div.addChild("ul", "id", "selected-subnavbar-list");
                boolean nonEmpty = false;
                for (String navigationLink : fullAccess ? selected.navigationLinkTexts : selected.navigationLinkTextsNonFull) {
                    LinkEnabledCallback cb = (LinkEnabledCallback)selected.navigationLinkCallbacks.get(navigationLink);
                    if (cb != null && !cb.isEnabled(ctx)) continue;
                    nonEmpty = true;
                    String navigationTitle = (String)selected.navigationLinkTitles.get(navigationLink);
                    String navigationPath = (String)selected.navigationLinks.get(navigationLink);
                    HTMLNode sublistItem = activePath.equals(navigationPath) ? subnavlist.addChild("li", "class", "submenuitem-selected") : subnavlist.addChild("li");
                    if (selected.plugin != null) {
                        if (navigationTitle != null) {
                            navigationTitle = selected.plugin.getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = selected.plugin.getString(navigationLink);
                        }
                    } else {
                        if (navigationTitle != null) {
                            navigationTitle = L10n.getString(navigationTitle);
                        }
                        if (navigationLink != null) {
                            navigationLink = L10n.getString(navigationLink);
                        }
                    }
                    if (navigationTitle != null) {
                        sublistItem.addChild("a", new String[]{"href", "title"}, new String[]{navigationPath, navigationTitle}, navigationLink);
                        continue;
                    }
                    sublistItem.addChild("a", "href", navigationPath, navigationLink);
                }
                if (nonEmpty) {
                    pageDiv.addChild(div);
                }
            }
        }
        HTMLNode contentDiv = pageDiv.addChild("div", "id", "content");
        return new PageNode(pageNode, headNode, contentDiv);
    }

    public InfoboxNode getInfobox(String header) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(new HTMLNode("#", header));
    }

    public InfoboxNode getInfobox(HTMLNode header) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(null, header);
    }

    public InfoboxNode getInfobox(String category, String header) {
        if (header == null) {
            throw new NullPointerException();
        }
        return this.getInfobox(category, new HTMLNode("#", header));
    }

    public HTMLNode getInfobox(String category, String header, HTMLNode parent) {
        InfoboxNode node = this.getInfobox(category, header);
        parent.addChild(node.outer);
        return node.content;
    }

    public InfoboxNode getInfobox(String category, HTMLNode header) {
        if (header == null) {
            throw new NullPointerException();
        }
        HTMLNode infobox = new HTMLNode("div", "class", "infobox" + (category == null ? "" : ' ' + category));
        infobox.addChild("div", "class", "infobox-header").addChild(header);
        return new InfoboxNode(infobox, infobox.addChild("div", "class", "infobox-content"));
    }

    private HTMLNode getOverrideContent() {
        HTMLNode result = new HTMLNode("style", "type", "text/css");
        try {
            result.addChild("#", FileUtil.readUTF(this.override));
        }
        catch (IOException e) {
            Logger.error(this, "Got an IOE: " + e.getMessage(), e);
        }
        return result;
    }

    protected int drawModeSelectionArray(NodeClientCore core, HTTPRequest req, HTMLNode contentNode) {
        return this.drawModeSelectionArray(core, req, contentNode, -1, null, null);
    }

    protected int drawModeSelectionArray(NodeClientCore core, HTTPRequest req, HTMLNode contentNode, int alternateMode, String alternateModeTitleKey, String alternateModeTooltipKey) {
        int mode;
        int n = mode = core.isAdvancedModeEnabled() ? 2 : 1;
        if (req.isParameterSet("mode")) {
            mode = req.getIntParam("mode", mode);
        }
        HTMLNode table = contentNode.addChild("table", "border", "1");
        HTMLNode row = table.addChild("tr");
        HTMLNode cell = row.addChild("td");
        if (alternateMode > -1) {
            if (mode != alternateMode) {
                cell.addChild("a", new String[]{"href", "title"}, new String[]{"?mode=" + alternateMode, L10n.getString(alternateModeTooltipKey)}, L10n.getString(alternateModeTitleKey));
            } else {
                cell.addChild("b", "title", L10n.getString(alternateModeTooltipKey), L10n.getString(alternateModeTitleKey));
            }
            cell = row.addChild("td");
        }
        if (mode != 1) {
            cell.addChild("a", new String[]{"href", "title"}, new String[]{"?mode=1", PageMaker.l10n("modeSimpleTooltip")}, PageMaker.l10n("modeSimple"));
        } else {
            cell.addChild("b", "title", PageMaker.l10n("modeSimpleTooltip"), PageMaker.l10n("modeSimple"));
        }
        cell = row.addChild("td");
        if (mode != 2) {
            cell.addChild("a", new String[]{"href", "title"}, new String[]{"?mode=2", PageMaker.l10n("modeAdvancedTooltip")}, PageMaker.l10n("modeAdvanced"));
        } else {
            cell.addChild("b", "title", PageMaker.l10n("modeAdvancedTooltip"), PageMaker.l10n("modeAdvanced"));
        }
        return mode;
    }

    private static final String l10n(String string) {
        return L10n.getString("PageMaker." + string);
    }

    private class SubMenu {
        private final String navigationLinkText;
        private final String defaultNavigationLink;
        private final String defaultNavigationLinkTitle;
        private final FredPluginL10n plugin;
        private final List<String> navigationLinkTexts = new ArrayList<String>();
        private final List<String> navigationLinkTextsNonFull = new ArrayList<String>();
        private final Map<String, String> navigationLinkTitles = new HashMap<String, String>();
        private final Map<String, String> navigationLinks = new HashMap<String, String>();
        private final Map<String, LinkEnabledCallback> navigationLinkCallbacks = new HashMap<String, LinkEnabledCallback>();

        public SubMenu(String link, String name, String title, FredPluginL10n plugin) {
            this.navigationLinkText = name;
            this.defaultNavigationLink = link;
            this.defaultNavigationLinkTitle = title;
            this.plugin = plugin;
        }

        public void addNavigationLink(String path, String name, String title, boolean fullOnly, LinkEnabledCallback cb) {
            this.navigationLinkTexts.add(name);
            if (!fullOnly) {
                this.navigationLinkTextsNonFull.add(name);
            }
            this.navigationLinkTitles.put(name, title);
            this.navigationLinks.put(name, path);
            if (cb != null) {
                this.navigationLinkCallbacks.put(name, cb);
            }
        }

        @Deprecated
        public void removeNavigationLink(String name) {
            this.navigationLinkTexts.remove(name);
            this.navigationLinkTextsNonFull.remove(name);
            this.navigationLinkTitles.remove(name);
            this.navigationLinks.remove(name);
        }

        @Deprecated
        public void removeAllNavigationLinks() {
            this.navigationLinkTexts.clear();
            this.navigationLinkTextsNonFull.clear();
            this.navigationLinkTitles.clear();
            this.navigationLinks.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum THEME {
        BOXED("boxed", "Boxed", ""),
        CLEAN("clean", "Clean", "Mr. Proper"),
        CLEAN_DROPDOWN("clean-dropdown", "Clean (Dropdown menu)", "Clean theme with a dropdown menu."),
        CLEAN_STATIC("clean-static", "Clean (Static menu)", "Clean theme with a static menu."),
        GRAYANDBLUE("grayandblue", "Gray And Blue", ""),
        SKY("sky", "Sky", ""),
        MINIMALBLUE("minimalblue", "Minimal Blue", "A minimalistic theme in blue");

        public static final String[] possibleValues;
        public final String code;
        public final String name;
        public final String description;

        private THEME(String code, String name, String description) {
            this.code = code;
            this.name = name;
            this.description = description;
        }

        public static THEME themeFromName(String cssName) {
            for (THEME t : THEME.values()) {
                if (!t.code.equalsIgnoreCase(cssName) && !t.name.equalsIgnoreCase(cssName)) continue;
                return t;
            }
            return THEME.getDefault();
        }

        public static THEME getDefault() {
            return CLEAN;
        }

        static {
            possibleValues = new String[]{THEME.BOXED.code, THEME.CLEAN.code, THEME.CLEAN_DROPDOWN.code, THEME.CLEAN_STATIC.code, THEME.GRAYANDBLUE.code, THEME.SKY.code, THEME.MINIMALBLUE.code};
        }
    }
}

