/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.ConnectionsToadlet;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.ToadletContext;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.OpennetPeerNodeStatus;
import freenet.node.PeerNodeStatus;
import freenet.support.HTMLNode;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpennetConnectionsToadlet
extends ConnectionsToadlet
implements LinkEnabledCallback {
    protected OpennetConnectionsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(n, core, client);
    }

    @Override
    protected void drawNameColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus) {
    }

    @Override
    protected void drawPrivateNoteColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean fProxyJavascriptEnabled) {
    }

    @Override
    protected boolean hasNameColumn() {
        return false;
    }

    @Override
    protected boolean hasPrivateNoteColumn() {
        return false;
    }

    @Override
    protected SimpleFieldSet getNoderef() {
        return this.node.exportOpennetPublicFieldSet();
    }

    @Override
    protected PeerNodeStatus[] getPeerNodeStatuses(boolean noHeavy) {
        return this.node.peers.getOpennetPeerNodeStatuses(noHeavy);
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        return this.node.isOpennetEnabled();
    }

    @Override
    protected String getPageTitle(String titleCountString, String myName) {
        return L10n.getString("OpennetConnectionsToadlet.fullTitle", new String[]{"counts", "name"}, new String[]{titleCountString, this.node.getMyName()});
    }

    @Override
    protected boolean shouldDrawNoderefBox(boolean advancedModeEnabled) {
        return advancedModeEnabled;
    }

    @Override
    protected boolean showPeerActionsBox() {
        return false;
    }

    @Override
    protected void drawPeerActionSelectBox(HTMLNode peerForm, boolean advancedModeEnabled) {
    }

    @Override
    protected String getPeerListTitle() {
        return L10n.getString("OpennetConnectionsToadlet.peersListTitle");
    }

    @Override
    protected boolean acceptRefPosts() {
        return true;
    }

    @Override
    protected String defaultRedirectLocation() {
        return "/opennet/";
    }

    @Override
    protected boolean isOpennet() {
        return true;
    }

    @Override
    protected Comparator<PeerNodeStatus> comparator(String sortBy, boolean reversed) {
        return new OpennetComparator(sortBy, reversed);
    }

    @Override
    ConnectionsToadlet.SimpleColumn[] endColumnHeaders(boolean advancedMode) {
        if (!advancedMode) {
            return null;
        }
        return new ConnectionsToadlet.SimpleColumn[]{new ConnectionsToadlet.SimpleColumn(){

            protected void drawColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus) {
                OpennetPeerNodeStatus status = (OpennetPeerNodeStatus)peerNodeStatus;
                long tLastSuccess = status.timeLastSuccess;
                peerRow.addChild("td", "class", "peer-last-success", tLastSuccess > 0L ? TimeUtil.formatTime(System.currentTimeMillis() - tLastSuccess) : "NEVER");
            }

            public String getExplanationKey() {
                return "OpennetConnectionsToadlet.successTime";
            }

            public String getSortString() {
                return "successTime";
            }

            public String getTitleKey() {
                return "OpennetConnectionsToadlet.successTimeTitle";
            }
        }};
    }

    @Override
    public String path() {
        return "/strangers/";
    }

    protected class OpennetComparator
    extends ConnectionsToadlet.ComparatorByStatus {
        OpennetComparator(String sortBy, boolean reversed) {
            super(sortBy, reversed);
        }

        protected int customCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode, String sortBy) {
            if (sortBy.equals("successTime")) {
                long t1 = ((OpennetPeerNodeStatus)firstNode).timeLastSuccess;
                long t2 = ((OpennetPeerNodeStatus)secondNode).timeLastSuccess;
                if (t1 > t2) {
                    return this.reversed ? 1 : -1;
                }
                if (t2 > t1) {
                    return this.reversed ? -1 : 1;
                }
            }
            return super.customCompare(firstNode, secondNode, sortBy);
        }
    }
}

