/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class N2NTMToadlet
extends Toadlet {
    private Node node;
    private NodeClientCore core;

    protected N2NTMToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
    }

    @Override
    public String supportedMethods() {
        return "GET, POST";
    }

    @Override
    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        if (request.isParameterSet("peernode_hashcode")) {
            PageNode page = ctx.getPageMaker().getPageNode(N2NTMToadlet.l10n("sendMessage"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            String peernode_name = null;
            String input_hashcode_string = request.getParam("peernode_hashcode");
            int input_hashcode = -1;
            try {
                input_hashcode = Integer.valueOf(input_hashcode_string);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (input_hashcode != -1) {
                DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
                for (int i = 0; i < peerNodes.length; ++i) {
                    int peer_hashcode = peerNodes[i].hashCode();
                    if (peer_hashcode != input_hashcode) continue;
                    peernode_name = peerNodes[i].getName();
                    break;
                }
            }
            if (peernode_name == null) {
                contentNode.addChild(N2NTMToadlet.createPeerInfobox("infobox-error", N2NTMToadlet.l10n("peerNotFoundTitle"), this.l10n("peerNotFoundWithHash", "hash", input_hashcode_string)));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            HashMap<String, String> peers = new HashMap<String, String>();
            peers.put(input_hashcode_string, peernode_name);
            N2NTMToadlet.createN2NTMSendForm(pageNode, contentNode, ctx, peers);
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("N2NTMToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key) {
        return L10n.getString("N2NTMToadlet." + key);
    }

    private static HTMLNode createPeerInfobox(String infoboxType, String header, String message) {
        HTMLNode infobox = new HTMLNode("div", "class", "infobox " + infoboxType);
        infobox.addChild("div", "class", "infobox-header", header);
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        infoboxContent.addChild("#", message);
        HTMLNode list = infoboxContent.addChild("ul");
        Toadlet.addHomepageLink(list);
        list.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/friends/", N2NTMToadlet.l10n("returnToFriends")}, N2NTMToadlet.l10n("friends"));
        return infobox;
    }

    @Override
    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String pass = request.getPartAsString("formPassword", 32);
        if (pass == null || !pass.equals(this.core.formPassword)) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", "/send_n2ntm/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        if (request.isPartSet("send")) {
            String message = request.getPartAsString("message", 5120);
            if ((message = message.trim()).length() > 1024) {
                this.writeTextReply(ctx, 400, "Bad request", N2NTMToadlet.l10n("tooLong"));
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(N2NTMToadlet.l10n("processingSend"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode peerTableInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            String fnam = request.getPartAsString("filename", 1024);
            File filename = null;
            if (!(fnam == null || fnam.length() <= 0 || (filename = new File(fnam)).exists() && filename.canRead())) {
                peerTableInfobox.addChild("#", N2NTMToadlet.l10n("noSuchFileOrCannotRead"));
                Toadlet.addHomepageLink(peerTableInfobox);
                this.writeHTMLReply(ctx, 400, "OK", pageNode.generate());
                return;
            }
            HTMLNode peerTable = peerTableInfobox.addChild("table", "class", "n2ntm-send-statuses");
            HTMLNode peerTableHeaderRow = peerTable.addChild("tr");
            peerTableHeaderRow.addChild("th", N2NTMToadlet.l10n("peerName"));
            peerTableHeaderRow.addChild("th", N2NTMToadlet.l10n("sendStatus"));
            for (int i = 0; i < peerNodes.length; ++i) {
                String sendStatusClass;
                String sendStatusLong;
                String sendStatusShort;
                int status;
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                DarknetPeerNode pn = peerNodes[i];
                if (filename != null) {
                    try {
                        status = pn.sendFileOffer(filename, message);
                    }
                    catch (IOException e) {
                        peerTableInfobox.addChild("#", N2NTMToadlet.l10n("noSuchFileOrCannotRead"));
                        Toadlet.addHomepageLink(peerTableInfobox);
                        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                        return;
                    }
                } else {
                    status = pn.sendTextMessage(message);
                }
                if (status == 2) {
                    sendStatusShort = N2NTMToadlet.l10n("delayedTitle");
                    sendStatusLong = N2NTMToadlet.l10n("delayed");
                    sendStatusClass = "n2ntm-send-delayed";
                    Logger.normal(this, "Sent N2NTM to '" + pn.getName() + "': " + message);
                } else if (status == 1) {
                    sendStatusShort = N2NTMToadlet.l10n("sentTitle");
                    sendStatusLong = N2NTMToadlet.l10n("sent");
                    sendStatusClass = "n2ntm-send-sent";
                    Logger.normal(this, "Sent N2NTM to '" + pn.getName() + "': " + message);
                } else {
                    sendStatusShort = N2NTMToadlet.l10n("queuedTitle");
                    sendStatusLong = N2NTMToadlet.l10n("queued");
                    sendStatusClass = "n2ntm-send-queued";
                    Logger.normal(this, "Queued N2NTM to '" + pn.getName() + "': " + message);
                }
                HTMLNode peerRow = peerTable.addChild("tr");
                peerRow.addChild("td", "class", "peer-name").addChild("#", pn.getName());
                peerRow.addChild("td", "class", sendStatusClass).addChild("span", new String[]{"title", "style"}, new String[]{sendStatusLong, "border-bottom: 1px dotted; cursor: help;"}, sendStatusShort);
            }
            HTMLNode infoboxContent = peerTableInfobox.addChild("div", "class", "n2ntm-message-text");
            infoboxContent.addChild("#", message);
            HTMLNode list = peerTableInfobox.addChild("ul");
            Toadlet.addHomepageLink(list);
            list.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/friends/", N2NTMToadlet.l10n("returnToFriends")}, N2NTMToadlet.l10n("friends"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    public static void createN2NTMSendForm(HTMLNode pageNode, HTMLNode contentNode, ToadletContext ctx, HashMap<String, String> peers) throws ToadletContextClosedException, IOException {
        HTMLNode infobox = contentNode.addChild("div", new String[]{"class", "id"}, new String[]{"infobox", "n2nbox"});
        infobox.addChild("div", "class", "infobox-header", N2NTMToadlet.l10n("sendMessage"));
        HTMLNode messageTargets = infobox.addChild("div", "class", "infobox-content");
        messageTargets.addChild("p", N2NTMToadlet.l10n("composingMessageLabel"));
        HTMLNode messageTargetList = messageTargets.addChild("ul");
        for (String peer_name : peers.values()) {
            messageTargetList.addChild("li", peer_name);
        }
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        HTMLNode messageForm = ctx.addFormChild(infoboxContent, "/send_n2ntm/", "sendN2NTMForm");
        for (String peerNodeHash : peers.keySet()) {
            messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "node_" + peerNodeHash, "1"});
        }
        messageForm.addChild("textarea", new String[]{"id", "name", "rows", "cols"}, new String[]{"n2ntmtext", "message", "8", "74"});
        messageForm.addChild("br");
        messageForm.addChild("#", "You may attach a file:");
        messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "filename", ""});
        messageForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "send", N2NTMToadlet.l10n("sendMessageShort")});
    }

    @Override
    public String path() {
        return "/send_n2ntm/";
    }
}

