/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.URLEncoder;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;

public class LocalFileInsertToadlet
extends Toadlet {
    private final NodeClientCore core;
    private File currentPath;

    public LocalFileInsertToadlet(NodeClientCore core, HighLevelSimpleClient highLevelSimpleClient) {
        super(highLevelSimpleClient);
        this.core = core;
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext toadletContext) throws ToadletContextClosedException, IOException, RedirectException {
        HTMLNode pageNode;
        PageNode page;
        String path;
        FreenetURI furi = null;
        String key = request.getParam("key");
        if (key != null) {
            try {
                furi = new FreenetURI(key);
            }
            catch (MalformedURLException e) {
                furi = null;
            }
        }
        String extra = "";
        if (furi != null) {
            extra = "&key=" + furi.toASCIIString();
        }
        if ((path = request.getParam("path")).length() == 0) {
            if (this.currentPath == null) {
                this.currentPath = new File(System.getProperty("user.home"));
            }
            LocalFileInsertToadlet.writePermanentRedirect(toadletContext, "Found", "?path=" + URLEncoder.encode(this.currentPath.getAbsolutePath(), true) + extra);
            return;
        }
        File thisPath = new File(path).getCanonicalFile();
        PageMaker pageMaker = toadletContext.getPageMaker();
        if (!this.core.allowUploadFrom(thisPath)) {
            PageNode page2 = pageMaker.getPageNode(this.l10n("listingTitle", "path", thisPath.getAbsolutePath()), toadletContext);
            pageMaker.getInfobox("infobox-error", "Forbidden", page2.content).addChild("#", this.l10n("dirAccessDenied"));
            thisPath = this.currentPath;
            if (!this.core.allowUploadFrom(thisPath)) {
                File[] allowedDirs = this.core.getAllowedUploadDirs();
                if (allowedDirs.length == 0) {
                    this.sendErrorPage(toadletContext, 403, "Forbidden", this.l10n("dirAccessDenied"));
                    return;
                }
                thisPath = allowedDirs[this.core.node.fastWeakRandom.nextInt(allowedDirs.length)];
            }
        }
        if (this.currentPath == null) {
            this.currentPath = thisPath;
        }
        if (this.currentPath.exists() && this.currentPath.isDirectory() && this.currentPath.canRead()) {
            this.currentPath = thisPath;
            page = pageMaker.getPageNode(this.l10n("listingTitle", "path", this.currentPath.getAbsolutePath()), toadletContext);
            pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (toadletContext.isAllowedFullAccess()) {
                contentNode.addChild(this.core.alerts.createSummary());
            }
            HTMLNode infoboxDiv = contentNode.addChild("div", "class", "infobox");
            infoboxDiv.addChild("div", "class", "infobox-header", this.l10n("listing", "path", this.currentPath.getAbsolutePath()));
            HTMLNode listingDiv = infoboxDiv.addChild("div", "class", "infobox-content");
            File[] files = this.currentPath.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File firstFile, File secondFile) {
                    if (firstFile.isDirectory() && !secondFile.isDirectory()) {
                        return -1;
                    }
                    if (!firstFile.isDirectory() && secondFile.isDirectory()) {
                        return 1;
                    }
                    return firstFile.getName().compareToIgnoreCase(secondFile.getName());
                }
            });
            HTMLNode listingTable = listingDiv.addChild("table");
            HTMLNode headerRow = listingTable.addChild("tr");
            headerRow.addChild("th");
            headerRow.addChild("th", this.l10n("fileHeader"));
            headerRow.addChild("th", this.l10n("sizeHeader"));
            for (File currentRoot : File.listRoots()) {
                HTMLNode rootRow = listingTable.addChild("tr");
                rootRow.addChild("td");
                HTMLNode rootLinkCellNode = rootRow.addChild("td");
                rootLinkCellNode.addChild("a", "href", "?path=" + URLEncoder.encode(currentRoot.getCanonicalPath(), false) + extra, currentRoot.getCanonicalPath());
                rootRow.addChild("td");
            }
            if (this.currentPath.getParent() != null) {
                HTMLNode backlinkRow = listingTable.addChild("tr");
                backlinkRow.addChild("td");
                HTMLNode backlinkCellNode = backlinkRow.addChild("td");
                backlinkCellNode.addChild("a", "href", "?path=" + URLEncoder.encode(this.currentPath.getParent(), false) + extra, "..");
                backlinkRow.addChild("td");
            }
            for (File currentFile : files) {
                HTMLNode formNode;
                HTMLNode cellNode;
                HTMLNode fileRow = listingTable.addChild("tr");
                if (currentFile.isDirectory()) {
                    if (currentFile.canRead()) {
                        cellNode = fileRow.addChild("td");
                        formNode = toadletContext.addFormChild(cellNode, "/uploads/", "insertLocalFileForm");
                        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "filename", currentFile.getAbsolutePath()});
                        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert-local-dir", this.l10n("insert")});
                        if (furi != null) {
                            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", furi.toASCIIString()});
                        }
                        HTMLNode directoryCellNode = fileRow.addChild("td");
                        directoryCellNode.addChild("a", "href", "?path=" + URLEncoder.encode(currentFile.getAbsolutePath(), false) + extra, currentFile.getName());
                    } else {
                        fileRow.addChild("td");
                        fileRow.addChild("td", "class", "unreadable-file", currentFile.getName());
                    }
                    fileRow.addChild("td");
                    continue;
                }
                if (currentFile.canRead()) {
                    cellNode = fileRow.addChild("td");
                    formNode = toadletContext.addFormChild(cellNode, "/uploads/", "insertLocalFileForm");
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "filename", currentFile.getAbsolutePath()});
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert-local-file", this.l10n("insert")});
                    if (furi != null) {
                        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", furi.toASCIIString()});
                    }
                    fileRow.addChild("td", currentFile.getName());
                    fileRow.addChild("td", "class", "right-align", String.valueOf(currentFile.length()));
                    continue;
                }
                fileRow.addChild("td");
                fileRow.addChild("td", "class", "unreadable-file", currentFile.getName());
                fileRow.addChild("td", "class", "right-align", String.valueOf(currentFile.length()));
            }
        } else {
            page = pageMaker.getPageNode(this.l10n("listingTitle", "path", this.currentPath.getAbsolutePath()), toadletContext);
            pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (toadletContext.isAllowedFullAccess()) {
                contentNode.addChild(this.core.alerts.createSummary());
            }
            HTMLNode infoboxDiv = contentNode.addChild("div", "class", "infobox");
            infoboxDiv.addChild("div", "class", "infobox-header", this.l10n("listing", "path", this.currentPath.getAbsolutePath()));
            HTMLNode listingDiv = infoboxDiv.addChild("div", "class", "infobox-content");
            listingDiv.addChild("#", this.l10n("dirCannotBeRead", "path", this.currentPath.getAbsolutePath()));
            HTMLNode ulNode = listingDiv.addChild("ul");
            ulNode.addChild("li", this.l10n("checkPathExist"));
            ulNode.addChild("li", this.l10n("checkPathIsDir"));
            ulNode.addChild("li", this.l10n("checkPathReadable"));
        }
        this.writeHTMLReply(toadletContext, 200, "OK", pageNode.generate());
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("LocalFileInsertToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String msg) {
        return L10n.getString("LocalFileInsertToadlet." + msg);
    }

    public String supportedMethods() {
        return "GET,POST";
    }

    public String path() {
        return "/files/";
    }
}

