/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.ToadletContext;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.api.HTTPUploadedFile;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.LineReadingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRequestImpl
implements HTTPRequest {
    private final Map<String, List<String>> parameterNameValuesMap = new HashMap<String, List<String>>();
    private URI uri;
    private MultiValueTable<String, String> headers;
    private Bucket data;
    private HashMap<String, Bucket> parts;
    private Map<String, HTTPUploadedFileImpl> uploadedFiles = new HashMap<String, HTTPUploadedFileImpl>();
    private final BucketFactory bucketfactory;
    private final String method;

    public HTTPRequestImpl(URI uri, String method) {
        this.uri = uri;
        this.parseRequestParameters(uri.getRawQuery(), true, false);
        this.data = null;
        this.parts = null;
        this.bucketfactory = null;
        this.method = method;
    }

    public HTTPRequestImpl(String path, String encodedQueryString, String method) throws URISyntaxException {
        this.data = null;
        this.parts = null;
        this.bucketfactory = null;
        this.uri = encodedQueryString != null && encodedQueryString.length() > 0 ? new URI(path + '?' + encodedQueryString) : new URI(path);
        this.method = method;
        this.parseRequestParameters(this.uri.getRawQuery(), true, false);
    }

    public HTTPRequestImpl(URI uri, Bucket d, ToadletContext ctx, String method) {
        this.uri = uri;
        this.headers = ctx.getHeaders();
        this.parseRequestParameters(uri.getRawQuery(), true, false);
        this.data = d;
        this.parts = new HashMap();
        this.bucketfactory = ctx.getBucketFactory();
        this.method = method;
        if (this.data != null) {
            try {
                this.parseMultiPartData();
            }
            catch (IOException ioe) {
                Logger.error(this, "Temporary files error ? Could not parse: " + ioe, ioe);
            }
        }
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public boolean hasParameters() {
        return !this.parameterNameValuesMap.isEmpty();
    }

    private void parseRequestParameters(String queryString, boolean doUrlDecoding, boolean asParts) {
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "queryString is " + queryString + ", doUrlDecoding=" + doUrlDecoding);
        }
        if (queryString == null || queryString.length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String nameValueToken = tokenizer.nextToken();
            if (logMINOR) {
                Logger.minor(this, "Token: " + nameValueToken);
            }
            String name = null;
            String value = "";
            int indexOfEqualsChar = nameValueToken.indexOf(61);
            if (indexOfEqualsChar < 0) {
                name = nameValueToken;
                if (logMINOR) {
                    Logger.minor(this, "Name: " + name);
                }
            } else if (indexOfEqualsChar == nameValueToken.length() - 1) {
                name = nameValueToken.substring(0, indexOfEqualsChar);
                if (logMINOR) {
                    Logger.minor(this, "Name: " + name);
                }
            } else {
                name = nameValueToken.substring(0, indexOfEqualsChar);
                value = nameValueToken.substring(indexOfEqualsChar + 1);
                if (logMINOR) {
                    Logger.minor(this, "Name: " + name + " Value: " + value);
                }
            }
            if (doUrlDecoding) {
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                if (logMINOR) {
                    Logger.minor(this, "Decoded name: " + name);
                    Logger.minor(this, "Decoded value: " + value);
                }
            }
            if (asParts) {
                byte[] buf;
                try {
                    buf = value.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                SimpleReadOnlyArrayBucket b = new SimpleReadOnlyArrayBucket(buf);
                this.parts.put(name, b);
                if (!logMINOR) continue;
                Logger.minor(this, "Added as part: name=" + name + " value=" + value);
                continue;
            }
            List<String> valueList = this.getParameterValueList(name);
            valueList.add(value);
        }
    }

    private String getParameterValue(String name) {
        if (!this.isParameterSet(name)) {
            return null;
        }
        List<String> allValues = this.getParameterValueList(name);
        return allValues.get(0);
    }

    private List<String> getParameterValueList(String name) {
        List<String> values = this.parameterNameValuesMap.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.parameterNameValuesMap.put(name, values);
        }
        return values;
    }

    @Override
    public boolean isParameterSet(String name) {
        return this.parameterNameValuesMap.containsKey(name);
    }

    @Override
    public String getParam(String name) {
        return this.getParam(name, "");
    }

    @Override
    public String getParam(String name, String defaultValue) {
        String value = this.getParameterValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public int getIntParam(String name) {
        return this.getIntParam(name, 0);
    }

    @Override
    public int getIntParam(String name, int defaultValue) {
        if (!this.isParameterSet(name)) {
            return defaultValue;
        }
        String value = this.getParameterValue(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public int getIntPart(String name, int defaultValue) {
        if (!this.isPartSet(name)) {
            return defaultValue;
        }
        String value = this.getPartAsString(name, 32);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String[] getMultipleParam(String name) {
        List<String> valueList = this.getParameterValueList(name);
        String[] values = new String[valueList.size()];
        valueList.toArray(values);
        return values;
    }

    @Override
    public int[] getMultipleIntParam(String name) {
        List<String> valueList = this.getParameterValueList(name);
        ArrayList<Integer> intValueList = new ArrayList<Integer>();
        for (int i = 0; i < valueList.size(); ++i) {
            try {
                intValueList.add(Integer.valueOf(valueList.get(i)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int[] values = new int[intValueList.size()];
        for (int i = 0; i < intValueList.size(); ++i) {
            values[i] = (Integer)intValueList.get(i);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseMultiPartData() throws IOException {
        BufferedOutputStream bbos;
        OutputStream bucketos;
        LineReadingInputStream lis;
        BufferedInputStream bis;
        InputStream is;
        block29: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            is = null;
                            bis = null;
                            lis = null;
                            bucketos = null;
                            bbos = null;
                            try {
                                String[] ctypeparts;
                                boolean logMINOR = Logger.shouldLog(4, this);
                                if (this.data == null) {
                                    Object var23_7 = null;
                                    break block25;
                                }
                                String ctype = this.headers.get("content-type");
                                if (ctype == null) {
                                    break block26;
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Uploaded content-type: " + ctype);
                                }
                                if ((ctypeparts = ctype.split(";"))[0].equalsIgnoreCase("application/x-www-form-urlencoded")) {
                                    if (this.data.size() > 0x100000L) {
                                        throw new IOException("Too big");
                                    }
                                    byte[] buf = BucketTools.toByteArray(this.data);
                                    String s = new String(buf, "us-ascii");
                                    this.parseRequestParameters(s, true, true);
                                }
                                if (!ctypeparts[0].trim().equalsIgnoreCase("multipart/form-data")) break block27;
                                if (ctypeparts.length < 2) {
                                    break block27;
                                }
                                String boundary = null;
                                for (int i = 0; i < ctypeparts.length; ++i) {
                                    String[] subparts = ctypeparts[i].split("=");
                                    if (subparts.length != 2 || !subparts[0].trim().equalsIgnoreCase("boundary")) continue;
                                    boundary = subparts[1];
                                }
                                if (boundary == null) break block28;
                                if (boundary.length() == 0) {
                                    break block28;
                                }
                                if (boundary.charAt(0) == '\"') {
                                    boundary = boundary.substring(1);
                                }
                                if (boundary.charAt(boundary.length() - 1) == '\"') {
                                    boundary = boundary.substring(0, boundary.length() - 1);
                                }
                                boundary = "--" + boundary;
                                if (logMINOR) {
                                    Logger.minor(this, "Boundary is: " + boundary);
                                }
                                is = this.data.getInputStream();
                                bis = new BufferedInputStream(is, 32768);
                                lis = new LineReadingInputStream(bis);
                                String line = lis.readLine(100, 100, false);
                                while (bis.available() > 0 && !line.equals(boundary)) {
                                    line = lis.readLine(100, 100, false);
                                }
                                boundary = "\r\n" + boundary;
                                Bucket filedata = null;
                                String name = null;
                                String filename = null;
                                String contentType = null;
                                while (bis.available() > 0) {
                                    name = null;
                                    filename = null;
                                    contentType = null;
                                    while ((line = lis.readLine(200, 200, true)) != null && line.length() != 0) {
                                        String[] lineparts = line.split(":");
                                        if (lineparts == null || lineparts.length == 0) continue;
                                        String hdrname = lineparts[0].trim();
                                        if (hdrname.equalsIgnoreCase("Content-Disposition")) {
                                            if (lineparts.length < 2) continue;
                                            String[] valueparts = lineparts[1].split(";");
                                            for (int i = 0; i < valueparts.length; ++i) {
                                                String[] subparts = valueparts[i].split("=");
                                                if (subparts.length != 2) continue;
                                                String fieldname = subparts[0].trim();
                                                String value = subparts[1].trim();
                                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                                    value = value.substring(1, value.length() - 1);
                                                }
                                                if (fieldname.equalsIgnoreCase("name")) {
                                                    name = value;
                                                    continue;
                                                }
                                                if (!fieldname.equalsIgnoreCase("filename")) continue;
                                                filename = value;
                                            }
                                            continue;
                                        }
                                        if (!hdrname.equalsIgnoreCase("Content-Type")) continue;
                                        contentType = lineparts[1].trim();
                                        if (!Logger.shouldLog(4, this)) continue;
                                        Logger.minor(this, "Parsed type: " + contentType);
                                    }
                                    if (name == null) continue;
                                    filedata = this.bucketfactory.makeBucket(bis.available());
                                    bucketos = filedata.getOutputStream();
                                    bbos = new BufferedOutputStream(bucketos, 32768);
                                    byte[] bbound = boundary.getBytes("UTF-8");
                                    int offset = 0;
                                    while (bis.available() > 0 && offset < bbound.length) {
                                        byte b = (byte)bis.read();
                                        if (b == bbound[offset]) {
                                            ++offset;
                                            continue;
                                        }
                                        if (b != bbound[offset] && offset > 0) {
                                            ((OutputStream)bbos).write(bbound, 0, offset);
                                            offset = 0;
                                            if (b == bbound[0]) {
                                                offset = 1;
                                                continue;
                                            }
                                            ((OutputStream)bbos).write(b);
                                            continue;
                                        }
                                        ((OutputStream)bbos).write(b);
                                    }
                                    ((OutputStream)bbos).flush();
                                    ((OutputStream)bbos).close();
                                    this.parts.put(name, filedata);
                                    if (logMINOR) {
                                        Logger.minor(this, "Name = " + name + " length = " + filedata.size() + " filename = " + filename);
                                    }
                                    if (filename == null) continue;
                                    this.uploadedFiles.put(name, new HTTPUploadedFileImpl(filename, contentType, filedata));
                                }
                                break block29;
                            }
                            catch (Throwable throwable) {
                                Object var23_12 = null;
                                Closer.close(bbos);
                                Closer.close(bucketos);
                                Closer.close(lis);
                                Closer.close(bis);
                                Closer.close(is);
                                throw throwable;
                            }
                        }
                        Closer.close(bbos);
                        Closer.close(bucketos);
                        Closer.close(lis);
                        Closer.close(bis);
                        Closer.close(is);
                        return;
                    }
                    Object var23_8 = null;
                    Closer.close(bbos);
                    Closer.close(bucketos);
                    Closer.close(lis);
                    Closer.close(bis);
                    Closer.close(is);
                    return;
                }
                Object var23_9 = null;
                Closer.close(bbos);
                Closer.close(bucketos);
                Closer.close(lis);
                Closer.close(bis);
                Closer.close(is);
                return;
            }
            Object var23_10 = null;
            Closer.close(bbos);
            Closer.close(bucketos);
            Closer.close(lis);
            Closer.close(bis);
            Closer.close(is);
            return;
        }
        Object var23_11 = null;
        Closer.close(bbos);
        Closer.close(bucketos);
        Closer.close(lis);
        Closer.close(bis);
        Closer.close(is);
    }

    @Override
    public HTTPUploadedFile getUploadedFile(String name) {
        return this.uploadedFiles.get(name);
    }

    @Override
    public Bucket getPart(String name) {
        return this.parts.get(name);
    }

    @Override
    public boolean isPartSet(String name) {
        if (this.parts == null) {
            return false;
        }
        return this.parts.containsKey(name);
    }

    @Override
    public String getPartAsString(String name, int maxlength) {
        try {
            return new String(this.getPartAsBytes(name, maxlength), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getPartAsBytes(String name, int maxlength) {
        byte[] byArray;
        Bucket part = this.parts.get(name);
        if (part == null) {
            return new byte[0];
        }
        if (part.size() > (long)maxlength) {
            return new byte[0];
        }
        InputStream is = null;
        DataInputStream dis = null;
        try {
            is = part.getInputStream();
            dis = new DataInputStream(is);
            byte[] buf = new byte[is.available()];
            dis.readFully(buf);
            byArray = buf;
            Object var9_9 = null;
        }
        catch (IOException ioe) {
            try {
                Logger.error(this, "Caught IOE:" + ioe.getMessage());
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Closer.close(dis);
                Closer.close(is);
                throw throwable;
            }
            Closer.close(dis);
            Closer.close(is);
            return new byte[0];
        }
        Closer.close(dis);
        Closer.close(is);
        return byArray;
    }

    @Override
    public void freeParts() {
        if (this.parts == null) {
            return;
        }
        for (Bucket b : this.parts.values()) {
            b.free();
        }
        this.parts.clear();
    }

    @Override
    public long getLongParam(String name, long defaultValue) {
        if (!this.isParameterSet(name)) {
            return defaultValue;
        }
        String value = this.getParameterValue(name);
        try {
            return Fields.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    public static class HTTPUploadedFileImpl
    implements HTTPUploadedFile {
        private final String filename;
        private final String contentType;
        private final Bucket data;

        public HTTPUploadedFileImpl(String filename, String contentType, Bucket data) {
            this.filename = filename;
            this.contentType = contentType;
            this.data = data;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Bucket getData() {
            return this.data;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

