/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.Config;
import freenet.config.ConfigException;
import freenet.config.Option;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;

public class FirstTimeWizardToadlet
extends Toadlet {
    private final NodeClientCore core;
    private final Config config;
    public static final String TOADLET_URL = "/wizard/";

    FirstTimeWizardToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.core = core;
        this.config = node.config;
    }

    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        WIZARD_STEP currentStep = WIZARD_STEP.valueOf(request.getParam("step", WIZARD_STEP.WELCOME.toString()));
        if (currentStep == WIZARD_STEP.BROWSER_WARNING) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("browserWarningPageTitle"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode infoboxHeader = infobox.addChild("div", "class", "infobox-header");
            HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
            infoboxHeader.addChild("#", this.l10n("browserWarningShort"));
            L10n.addL10nSubstitution(infoboxContent, "FirstTimeWizardToadlet.browserWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            infoboxContent.addChild("p", this.l10n("browserWarningSuggestion"));
            infoboxContent.addChild("p").addChild("a", "href", "?step=" + (Object)((Object)WIZARD_STEP.MISC), L10n.getString("FirstTimeWizardToadlet.clickContinue"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.SECURITY_NETWORK) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("networkSecurityPageTitle"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode infoboxHeader = infobox.addChild("div", "class", "infobox-header");
            HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
            infoboxHeader.addChild("#", this.l10nSec("networkThreatLevelShort"));
            infoboxContent.addChild("p", this.l10nSec("networkThreatLevel"));
            HTMLNode form = ctx.addFormChild(infoboxContent, ".", "networkSecurityForm");
            HTMLNode div = form.addChild("div", "class", "opennetDiv");
            String controlName = "security-levels.networkThreatLevel";
            for (SecurityLevels.NETWORK_THREAT_LEVEL level : SecurityLevels.NETWORK_THREAT_LEVEL.values()) {
                HTMLNode input = div.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
                input.addChild("b", this.l10nSec("networkThreatLevel.name." + (Object)((Object)level)));
                input.addChild("#", ": ");
                L10n.addL10nSubstitution(input, "SecurityLevels.networkThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                HTMLNode inner = input.addChild("p").addChild("i");
                L10n.addL10nSubstitution(inner, "SecurityLevels.networkThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            }
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "networkSecurityF", L10n.getString("FirstTimeWizardToadlet.continue")});
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.SECURITY_FRIENDS) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("friendsSecurityPageTitle"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode infoboxHeader = infobox.addChild("div", "class", "infobox-header");
            HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
            infoboxHeader.addChild("#", this.l10nSec("friendsThreatLevelShort"));
            infoboxContent.addChild("p", this.l10nSec("friendsThreatLevel"));
            HTMLNode form = ctx.addFormChild(infoboxContent, ".", "friendsSecurityForm");
            HTMLNode div = form.addChild("div", "class", "opennetDiv");
            String controlName = "security-levels.friendsThreatLevel";
            for (SecurityLevels.FRIENDS_THREAT_LEVEL level : SecurityLevels.FRIENDS_THREAT_LEVEL.values()) {
                HTMLNode input = div.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
                input.addChild("b", this.l10nSec("friendsThreatLevel.name." + (Object)((Object)level)));
                input.addChild("#", ": ");
                L10n.addL10nSubstitution(input, "SecurityLevels.friendsThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                HTMLNode inner = input.addChild("p").addChild("i");
                L10n.addL10nSubstitution(inner, "SecurityLevels.friendsThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            }
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "friendsSecurityF", L10n.getString("FirstTimeWizardToadlet.continue")});
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.SECURITY_PHYSICAL) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("physicalSecurityPageTitle"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode infoboxHeader = infobox.addChild("div", "class", "infobox-header");
            HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
            infoboxHeader.addChild("#", this.l10nSec("physicalThreatLevelShort"));
            infoboxContent.addChild("p", this.l10nSec("physicalThreatLevel"));
            HTMLNode form = ctx.addFormChild(infoboxContent, ".", "physicalSecurityForm");
            HTMLNode div = form.addChild("div", "class", "opennetDiv");
            String controlName = "security-levels.physicalThreatLevel";
            for (SecurityLevels.PHYSICAL_THREAT_LEVEL level : SecurityLevels.PHYSICAL_THREAT_LEVEL.values()) {
                HTMLNode input = div.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
                input.addChild("b", this.l10nSec("physicalThreatLevel.name." + (Object)((Object)level)));
                input.addChild("#", ": ");
                L10n.addL10nSubstitution(input, "SecurityLevels.physicalThreatLevel.choice." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                HTMLNode inner = input.addChild("p").addChild("i");
                L10n.addL10nSubstitution(inner, "SecurityLevels.physicalThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            }
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "physicalSecurityF", L10n.getString("FirstTimeWizardToadlet.continue")});
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.NAME_SELECTION) {
            if (Boolean.valueOf(request.getParam("opennet")).booleanValue()) {
                super.writeTemporaryRedirect(ctx, "step3", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.BANDWIDTH));
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("step2Title"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode nnameInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode nnameInfoboxHeader = nnameInfobox.addChild("div", "class", "infobox-header");
            HTMLNode nnameInfoboxContent = nnameInfobox.addChild("div", "class", "infobox-content");
            nnameInfoboxHeader.addChild("#", this.l10n("chooseNodeName"));
            nnameInfoboxContent.addChild("#", this.l10n("chooseNodeNameLong"));
            HTMLNode nnameForm = ctx.addFormChild(nnameInfoboxContent, ".", "nnameForm");
            nnameForm.addChild("input", "name", "nname");
            nnameForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "nnameF", L10n.getString("FirstTimeWizardToadlet.continue")});
            nnameForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.BANDWIDTH) {
            int autodetectedLimit = this.canAutoconfigureBandwidth();
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("step3Title"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode bandwidthInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode bandwidthnfoboxHeader = bandwidthInfobox.addChild("div", "class", "infobox-header");
            HTMLNode bandwidthInfoboxContent = bandwidthInfobox.addChild("div", "class", "infobox-content");
            bandwidthnfoboxHeader.addChild("#", this.l10n("bandwidthLimit"));
            bandwidthInfoboxContent.addChild("#", this.l10n("bandwidthLimitLong"));
            HTMLNode bandwidthForm = ctx.addFormChild(bandwidthInfoboxContent, ".", "bwForm");
            HTMLNode result = bandwidthForm.addChild("select", "name", "bw");
            Option<?> sizeOption = this.config.get("node").getOption("outputBandwidthLimit");
            if (!sizeOption.isDefault()) {
                int current = (Integer)sizeOption.getValue();
                result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(current), "on"}, this.l10n("currentSpeed") + " " + SizeUtil.formatSize(current) + "/s");
            } else if (autodetectedLimit != -1) {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(autodetectedLimit), "on"}, this.l10n("autodetectedSuggestedLimit") + " " + SizeUtil.formatSize(autodetectedLimit) + "/s");
            }
            if (autodetectedLimit != 8192) {
                result.addChild("option", "value", "8K", this.l10n("bwlimitLowerSpeed"));
            }
            result.addChild("option", "value", "12K", "512+/128 kbps (12KB/s)");
            if (autodetectedLimit != -1 || !sizeOption.isDefault()) {
                result.addChild("option", "value", "16K", "1024+/256 kbps (16KB/s)");
            } else {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{"16K", "selected"}, "1024+/256 kbps (16KB/s)");
            }
            result.addChild("option", "value", "32K", "1024+/512 kbps (32K/s)");
            result.addChild("option", "value", "64K", "1024+/1024 kbps (64K/s)");
            result.addChild("option", "value", "1000K", this.l10n("bwlimitHigherSpeed"));
            bandwidthForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "bwF", L10n.getString("FirstTimeWizardToadlet.continue")});
            bandwidthForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            bandwidthInfoboxContent.addChild("#", this.l10n("bandwidthLimitAfter"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.DATASTORE_SIZE) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("step4Title"), false, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode bandwidthInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode bandwidthnfoboxHeader = bandwidthInfobox.addChild("div", "class", "infobox-header");
            HTMLNode bandwidthInfoboxContent = bandwidthInfobox.addChild("div", "class", "infobox-content");
            bandwidthnfoboxHeader.addChild("#", this.l10n("datastoreSize"));
            bandwidthInfoboxContent.addChild("#", this.l10n("datastoreSizeLong"));
            HTMLNode bandwidthForm = ctx.addFormChild(bandwidthInfoboxContent, ".", "dsForm");
            HTMLNode result = bandwidthForm.addChild("select", "name", "ds");
            long autodetectedSize = this.canAutoconfigureDatastoreSize();
            Option<?> sizeOption = this.config.get("node").getOption("storeSize");
            if (!sizeOption.isDefault()) {
                long current = (Long)sizeOption.getValue();
                result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(current), "on"}, this.l10n("currentPrefix") + " " + SizeUtil.formatSize(current));
            } else if (autodetectedSize != -1L) {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{SizeUtil.formatSize(autodetectedSize), "on"}, SizeUtil.formatSize(autodetectedSize));
            }
            if (autodetectedSize != 0x20000000L) {
                result.addChild("option", "value", "512M", "512 MiB");
            }
            result.addChild("option", "value", "1G", "1 GiB");
            if (autodetectedSize != -1L || !sizeOption.isDefault()) {
                result.addChild("option", "value", "2G", "2 GiB");
            } else {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{"2G", "on"}, "2GiB");
            }
            result.addChild("option", "value", "3G", "3 GiB");
            result.addChild("option", "value", "5G", "5 GiB");
            result.addChild("option", "value", "10G", "10 GiB");
            result.addChild("option", "value", "20G", "20 GiB");
            result.addChild("option", "value", "30G", "30 GiB");
            result.addChild("option", "value", "50G", "50 GiB");
            result.addChild("option", "value", "100G", "100 GiB");
            bandwidthForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "dsF", L10n.getString("FirstTimeWizardToadlet.continue")});
            bandwidthForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.MISC) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("stepMiscTitle"), true, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode form = ctx.addFormChild(contentNode, ".", "miscForm");
            HTMLNode miscInfobox = form.addChild("div", "class", "infobox infobox-normal");
            HTMLNode miscInfoboxHeader = miscInfobox.addChild("div", "class", "infobox-header");
            HTMLNode miscInfoboxContent = miscInfobox.addChild("div", "class", "infobox-content");
            miscInfoboxHeader.addChild("#", this.l10n("autoUpdate"));
            miscInfoboxContent.addChild("p", this.l10n("autoUpdateLong"));
            miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", "autodeploy", "true"}, this.l10n("autoUpdateAutodeploy"));
            miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "autodeploy", "false"}, this.l10n("autoUpdateNoAutodeploy"));
            miscInfobox = form.addChild("div", "class", "infobox infobox-normal");
            miscInfoboxHeader = miscInfobox.addChild("div", "class", "infobox-header");
            miscInfoboxContent = miscInfobox.addChild("div", "class", "infobox-content");
            miscInfoboxHeader.addChild("#", this.l10n("plugins"));
            miscInfoboxContent.addChild("p", this.l10n("pluginsLong"));
            miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"checkbox", "on", "upnp", "true"}, this.l10n("enableUPnP"));
            miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"checkbox", "on", "jstun", "true"}, this.l10n("enableJSTUN"));
            miscInfoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "miscF", L10n.getString("FirstTimeWizardToadlet.continue")});
            miscInfoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.CONGRATZ) {
            PageNode page = ctx.getPageMaker().getPageNode(this.l10n("step7Title"), true, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode congratzInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode congratzInfoboxHeader = congratzInfobox.addChild("div", "class", "infobox-header");
            HTMLNode congratzInfoboxContent = congratzInfobox.addChild("div", "class", "infobox-content");
            congratzInfoboxHeader.addChild("#", this.l10n("congratz"));
            congratzInfoboxContent.addChild("p", this.l10n("congratzLong"));
            congratzInfoboxContent.addChild("a", "href", "?step=" + (Object)((Object)WIZARD_STEP.FINAL), L10n.getString("FirstTimeWizardToadlet.continueEnd"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (currentStep == WIZARD_STEP.FINAL) {
            try {
                this.config.get("fproxy").set("hasCompletedWizard", true);
                this.config.store();
                this.writeTemporaryRedirect(ctx, "Return to home", "/");
            }
            catch (ConfigException e) {
                Logger.error(this, e.getMessage(), e);
            }
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("homepageTitle"), false, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode welcomeInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        HTMLNode welcomeInfoboxHeader = welcomeInfobox.addChild("div", "class", "infobox-header");
        HTMLNode welcomeInfoboxContent = welcomeInfobox.addChild("div", "class", "infobox-content");
        welcomeInfoboxHeader.addChild("#", this.l10n("welcomeInfoboxTitle"));
        HTMLNode firstParagraph = welcomeInfoboxContent.addChild("p");
        firstParagraph.addChild("#", this.l10n("welcomeInfoboxContent1"));
        HTMLNode secondParagraph = welcomeInfoboxContent.addChild("p");
        secondParagraph.addChild("a", "href", "?step=" + (Object)((Object)WIZARD_STEP.BROWSER_WARNING)).addChild("#", L10n.getString("FirstTimeWizardToadlet.clickContinue"));
        HTMLNode thirdParagraph = welcomeInfoboxContent.addChild("p");
        thirdParagraph.addChild("a", "href", "?step=" + (Object)((Object)WIZARD_STEP.FINAL)).addChild("#", this.l10n("skipWizard"));
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private String l10nSec(String key) {
        return L10n.getString("SecurityLevels." + key);
    }

    private String l10nSec(String key, String pattern, String value) {
        return L10n.getString("SecurityLevels." + key, pattern, value);
    }

    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        boolean noPassword;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
            return;
        }
        String passwd = request.getPartAsString("formPassword", 32);
        boolean bl = noPassword = passwd == null || !passwd.equals(this.core.formPassword);
        if (noPassword) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "No password (" + passwd + " should be " + this.core.formPassword + ')');
            }
            super.writeTemporaryRedirect(ctx, "invalid/unhandled data", "/");
            return;
        }
        if (request.isPartSet("security-levels.networkThreatLevel")) {
            String networkThreatLevel = request.getPartAsString("security-levels.networkThreatLevel", 128);
            SecurityLevels.NETWORK_THREAT_LEVEL newThreatLevel = SecurityLevels.parseNetworkThreatLevel(networkThreatLevel);
            if (newThreatLevel == null) {
                super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_NETWORK));
                return;
            }
            if (newThreatLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM || newThreatLevel == SecurityLevels.NETWORK_THREAT_LEVEL.HIGH) {
                if (!request.isPartSet("security-levels.networkThreatLevel.confirm") && !request.isPartSet("security-levels.networkThreatLevel.tryConfirm")) {
                    PageNode page = ctx.getPageMaker().getPageNode(this.l10n("networkSecurityPageTitle"), ctx);
                    HTMLNode pageNode = page.outer;
                    HTMLNode content = page.content;
                    HTMLNode formNode = ctx.addFormChild(content, ".", "configFormSecLevels");
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.networkThreatLevel", networkThreatLevel});
                    HTMLNode infobox = formNode.addChild("div", "class", "infobox infobox-information");
                    infobox.addChild("div", "class", "infobox-header", this.l10nSec("networkThreatLevelConfirmTitle", "mode", SecurityLevels.localisedName(newThreatLevel)));
                    HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    if (newThreatLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                        HTMLNode p = infoboxContent.addChild("p");
                        L10n.addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                        p.addChild("#", " ");
                        L10n.addL10nSubstitution(p, "SecurityLevels.maxSecurityYouNeedFriends", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                        infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "security-levels.networkThreatLevel.confirm", "off"}, this.l10nSec("maximumNetworkThreatLevelCheckbox"));
                    } else {
                        HTMLNode p = infoboxContent.addChild("p");
                        L10n.addL10nSubstitution(p, "FirstTimeWizardToadlet.highNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                        infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "security-levels.networkThreatLevel.confirm", "off"}, this.l10n("highNetworkThreatLevelCheckbox"));
                    }
                    infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.networkThreatLevel.tryConfirm", "on"});
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
                    formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", L10n.getString("ConfigToadlet.apply")});
                    formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", L10n.getString("ConfigToadlet.reset")});
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    return;
                }
                if (!request.isPartSet("security-levels.networkThreatLevel.confirm") && request.isPartSet("security-levels.networkThreatLevel.tryConfirm")) {
                    super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_NETWORK));
                    return;
                }
            }
            this.core.node.securityLevels.setThreatLevel(newThreatLevel);
            super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_FRIENDS));
            return;
        }
        if (request.isPartSet("security-levels.friendsThreatLevel")) {
            String friendsThreatLevel = request.getPartAsString("security-levels.friendsThreatLevel", 128);
            SecurityLevels.FRIENDS_THREAT_LEVEL newThreatLevel = SecurityLevels.parseFriendsThreatLevel(friendsThreatLevel);
            if (newThreatLevel == null) {
                super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_FRIENDS));
                return;
            }
            if (newThreatLevel == SecurityLevels.FRIENDS_THREAT_LEVEL.HIGH) {
                if (!request.isPartSet("security-levels.friendsThreatLevel.confirm") && !request.isPartSet("security-levels.friendsThreatLevel.tryConfirm")) {
                    PageNode page = ctx.getPageMaker().getPageNode(this.l10n("friendsSecurityPageTitle"), ctx);
                    HTMLNode pageNode = page.outer;
                    HTMLNode content = page.content;
                    HTMLNode formNode = ctx.addFormChild(content, ".", "configFormSecLevels");
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.friendsThreatLevel", friendsThreatLevel});
                    HTMLNode infobox = formNode.addChild("div", "class", "infobox infobox-information");
                    infobox.addChild("div", "class", "infobox-header", this.l10nSec("friendsThreatLevelConfirmTitle", "mode", SecurityLevels.localisedName(newThreatLevel)));
                    HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    HTMLNode p = infoboxContent.addChild("p");
                    L10n.addL10nSubstitution(p, "FirstTimeWizardToadlet.highFriendsThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                    infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "security-levels.friendsThreatLevel.confirm", "off"}, this.l10nSec("highFriendsThreatLevelCheckbox"));
                    infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.friendsThreatLevel.tryConfirm", "on"});
                    formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
                    formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", L10n.getString("ConfigToadlet.apply")});
                    formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", L10n.getString("ConfigToadlet.reset")});
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    return;
                }
                if (!request.isPartSet("security-levels.friendsThreatLevel.confirm") && request.isPartSet("security-levels.friendsThreatLevel.tryConfirm")) {
                    super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_FRIENDS));
                    return;
                }
            }
            this.core.node.securityLevels.setThreatLevel(newThreatLevel);
            super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_PHYSICAL));
            return;
        }
        if (request.isPartSet("security-levels.physicalThreatLevel")) {
            String physicalThreatLevel = request.getPartAsString("security-levels.physicalThreatLevel", 128);
            SecurityLevels.PHYSICAL_THREAT_LEVEL newThreatLevel = SecurityLevels.parsePhysicalThreatLevel(physicalThreatLevel);
            if (newThreatLevel == null) {
                super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_PHYSICAL));
                return;
            }
            this.core.node.securityLevels.setThreatLevel(newThreatLevel);
            this.core.storeConfig();
            super.writeTemporaryRedirect(ctx, "step1", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.NAME_SELECTION) + "&opennet=" + this.core.node.isOpennetEnabled());
            return;
        }
        if (request.isPartSet("nnameF")) {
            String selectedNName = request.getPartAsString("nname", 128);
            try {
                this.config.get("node").set("name", selectedNName);
                Logger.normal(this, "The node name has been set to " + selectedNName);
            }
            catch (ConfigException e) {
                Logger.error(this, "Should not happen, please report!" + e, e);
            }
            super.writeTemporaryRedirect(ctx, "step3", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.BANDWIDTH));
            return;
        }
        if (request.isPartSet("bwF")) {
            this._setUpstreamBandwidthLimit(request.getPartAsString("bw", 20));
            super.writeTemporaryRedirect(ctx, "step4", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.DATASTORE_SIZE));
            return;
        }
        if (request.isPartSet("dsF")) {
            this._setDatastoreSize(request.getPartAsString("ds", 20));
            super.writeTemporaryRedirect(ctx, "step5", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.CONGRATZ));
            return;
        }
        if (request.isPartSet("miscF")) {
            try {
                this.config.get("node.updater").set("autoupdate", Boolean.parseBoolean(request.getPartAsString("autodeploy", 10)));
            }
            catch (ConfigException e) {
                Logger.error(this, "Should not happen, please report!" + e, e);
            }
            boolean enableUPnP = request.isPartSet("upnp");
            boolean enableJSTUN = request.isPartSet("jstun");
            if (enableUPnP != this.core.node.pluginManager.isPluginLoaded("plugins.UPnP.UPnP")) {
                if (enableUPnP) {
                    this.core.node.pluginManager.startPluginOfficial("UPnP", true);
                } else {
                    this.core.node.pluginManager.killPluginByClass("plugins.UPnP.UPnP", 5000);
                }
            }
            if (enableJSTUN != this.core.node.pluginManager.isPluginLoaded("plugins.JSTUN.JSTUN")) {
                if (enableJSTUN) {
                    this.core.node.pluginManager.startPluginOfficial("JSTUN", true);
                } else {
                    this.core.node.pluginManager.killPluginByClass("plugins.JSTUN.JSTUN", 5000);
                }
            }
            super.writeTemporaryRedirect(ctx, "step7", "/wizard/?step=" + (Object)((Object)WIZARD_STEP.SECURITY_NETWORK));
            return;
        }
        super.writeTemporaryRedirect(ctx, "invalid/unhandled data", TOADLET_URL);
    }

    private String l10n(String key) {
        return L10n.getString("FirstTimeWizardToadlet." + key);
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    private void _setDatastoreSize(String selectedStoreSize) {
        try {
            this.config.get("node").set("storeSize", selectedStoreSize);
            Logger.normal(this, "The storeSize has been set to " + selectedStoreSize);
        }
        catch (ConfigException e) {
            Logger.error(this, "Should not happen, please report!" + e, e);
        }
    }

    private void _setUpstreamBandwidthLimit(String selectedUploadSpeed) {
        try {
            this.config.get("node").set("outputBandwidthLimit", selectedUploadSpeed);
            Logger.normal(this, "The outputBandwidthLimit has been set to " + selectedUploadSpeed);
        }
        catch (ConfigException e) {
            Logger.error(this, "Should not happen, please report!" + e, e);
        }
    }

    private void _setDownstreamBandwidthLimit(String selectedDownloadSpeed) {
        try {
            this.config.get("node").set("inputBandwidthLimit", selectedDownloadSpeed);
            Logger.normal(this, "The inputBandwidthLimit has been set to " + selectedDownloadSpeed);
        }
        catch (ConfigException e) {
            Logger.error(this, "Should not happen, please report!" + e, e);
        }
    }

    private int canAutoconfigureBandwidth() {
        int upstreamBWLimit;
        if (!this.config.get("node").getOption("outputBandwidthLimit").isDefault()) {
            return -1;
        }
        FredPluginBandwidthIndicator bwIndicator = this.core.node.ipDetector.getBandwidthIndicator();
        if (bwIndicator == null) {
            return -1;
        }
        int downstreamBWLimit = bwIndicator.getDownstreamMaxBitRate();
        if (downstreamBWLimit > 0) {
            int bytes = downstreamBWLimit / 8 - 1;
            String downstreamBWLimitString = SizeUtil.formatSize(bytes * 2 / 3);
            this._setDownstreamBandwidthLimit(downstreamBWLimitString);
            Logger.normal(this, "The node has a bandwidthIndicator: it has reported downstream=" + downstreamBWLimit + "bits/sec... we will use " + downstreamBWLimitString + " and skip the bandwidth selection step of the wizard.");
        }
        if ((upstreamBWLimit = bwIndicator.getUpstramMaxBitRate()) > 0) {
            int bytes = upstreamBWLimit / 8 - 1;
            if (bytes < 16384) {
                return 8192;
            }
            return bytes / 2;
        }
        return -1;
    }

    private long canAutoconfigureDatastoreSize() {
        if (!this.config.get("node").getOption("storeSize").isDefault()) {
            return -1L;
        }
        long freeSpace = -1L;
        File dir = FileUtil.getCanonicalFile(this.core.node.getNodeDir());
        try {
            Long lFreeSpace;
            Class<?> c = dir.getClass();
            Method m = c.getDeclaredMethod("getFreeSpace", new Class[0]);
            if (m != null && (lFreeSpace = (Long)m.invoke((Object)dir, new Object[0])) != null) {
                freeSpace = lFreeSpace;
                System.err.println("Found free space on node's partition: on " + dir + " = " + SizeUtil.formatSize(freeSpace));
            }
        }
        catch (NoSuchMethodException e) {
            freeSpace = -1L;
        }
        catch (Throwable t) {
            System.err.println("Trying to access 1.6 getFreeSpace(), caught " + t);
            freeSpace = -1L;
        }
        if (freeSpace <= 0L) {
            return -1L;
        }
        long shortSize = -1L;
        shortSize = freeSpace / 20L > 0x40000000L ? Math.min(freeSpace / 20L, 0x4000000000L) : (freeSpace / 10L > 0x40000000L ? freeSpace / 10L : (freeSpace / 5L > 0x40000000L ? 0x20000000L : 0x10000000L));
        return shortSize;
    }

    public String path() {
        return TOADLET_URL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WIZARD_STEP {
        WELCOME,
        BROWSER_WARNING,
        MISC,
        SECURITY_NETWORK,
        SECURITY_FRIENDS,
        SECURITY_PHYSICAL,
        NAME_SELECTION,
        BANDWIDTH,
        DATASTORE_SIZE,
        CONGRATZ,
        FINAL;

    }
}

