/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.clients.http.BookmarkEditorToadlet;
import freenet.clients.http.BrowserTestToadlet;
import freenet.clients.http.ChatForumsToadlet;
import freenet.clients.http.ConfigToadlet;
import freenet.clients.http.ConnectivityToadlet;
import freenet.clients.http.DarknetAddRefToadlet;
import freenet.clients.http.DarknetConnectionsToadlet;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.HTTPRangeException;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.InsertFreesiteToadlet;
import freenet.clients.http.LocalFileInsertToadlet;
import freenet.clients.http.N2NTMToadlet;
import freenet.clients.http.OpennetConnectionsToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.PproxyToadlet;
import freenet.clients.http.QueueToadlet;
import freenet.clients.http.RedirectException;
import freenet.clients.http.SecurityLevelsToadlet;
import freenet.clients.http.SimpleHelpToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.StatisticsToadlet;
import freenet.clients.http.SymlinkerToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.TranslationToadlet;
import freenet.clients.http.UserAlertsToadlet;
import freenet.clients.http.WelcomeToadlet;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.clients.http.filter.ContentFilter;
import freenet.clients.http.filter.FoundURICallback;
import freenet.clients.http.filter.UnsafeContentTypeException;
import freenet.config.Config;
import freenet.config.SubConfig;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.URIPreEncoder;
import freenet.support.URLEncoder;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FProxyToadlet
extends Toadlet
implements RequestClient {
    private static byte[] random;
    final NodeClientCore core;
    final ClientContext context;
    final FProxyFetchTracker fetchTracker;
    private static FoundURICallback prefetchHook;
    static final Set<String> prefetchAllowedTypes;
    private static final long FORCE_GRAIN_INTERVAL = 3600000L;
    public static long MAX_LENGTH;
    static final URI welcome;
    public static final short PRIORITY = 1;

    public FProxyToadlet(final HighLevelSimpleClient client, NodeClientCore core) {
        super(client);
        client.setMaxLength(MAX_LENGTH);
        client.setMaxIntermediateLength(MAX_LENGTH);
        this.core = core;
        this.context = core.clientContext;
        prefetchHook = new FoundURICallback(){

            public void foundURI(FreenetURI uri) {
            }

            public void foundURI(FreenetURI uri, boolean inline) {
                if (!inline) {
                    return;
                }
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Prefetching " + uri);
                }
                client.prefetch(uri, 60000L, 524288L, prefetchAllowedTypes);
            }

            public void onText(String text, String type, URI baseURI) {
            }
        };
        this.fetchTracker = new FProxyFetchTracker(this.context, this.getClientImpl().getFetchContext(), this);
    }

    public String supportedMethods() {
        return "GET";
    }

    public void handlePost(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String ks = uri.getPath();
        if (ks.equals("/") || ks.startsWith("/servlet/")) {
            try {
                throw new RedirectException("/welcome/");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void handleDownload(ToadletContext context, Bucket data, BucketFactory bucketFactory, String mimeType, String requestedMimeType, String forceString, boolean forceDownload, String basePath, FreenetURI key, String extras, String referrer, boolean downloadLink, ToadletContext ctx, NodeClientCore core, boolean dontFreeData) throws ToadletContextClosedException, IOException {
        Bucket tmpRange;
        Bucket toFree;
        block32: {
            ToadletContainer container = context.getContainer();
            if (Logger.shouldLog(4, FProxyToadlet.class)) {
                Logger.minor(FProxyToadlet.class, "handleDownload(data.size=" + data.size() + ", mimeType=" + mimeType + ", requestedMimeType=" + requestedMimeType + ", forceDownload=" + forceDownload + ", basePath=" + basePath + ", key=" + key);
            }
            String extrasNoMime = extras;
            if (requestedMimeType != null) {
                if (mimeType == null || !requestedMimeType.equals(mimeType)) {
                    if (extras == null) {
                        extras = "";
                    }
                    extras = extras + "&type=" + requestedMimeType;
                }
                mimeType = requestedMimeType;
            }
            long size = data.size();
            long now = System.currentTimeMillis();
            boolean force = false;
            if (forceString != null && (forceString.equals(FProxyToadlet.getForceValue(key, now)) || forceString.equals(FProxyToadlet.getForceValue(key, now - 3600000L)))) {
                force = true;
            }
            toFree = null;
            tmpRange = null;
            try {
                try {
                    if (!force && !forceDownload) {
                        ContentFilter.FilterOutput fo = ContentFilter.filter(data, bucketFactory, mimeType, key.toURI(basePath), container.enableInlinePrefetch() ? prefetchHook : null);
                        if (data != fo.data) {
                            toFree = fo.data;
                        }
                        data = fo.data;
                        mimeType = fo.type;
                        if (FProxyToadlet.horribleEvilHack(data) && !mimeType.startsWith("application/rss+xml")) {
                            boolean mimeRSS;
                            PageNode page = context.getPageMaker().getPageNode(FProxyToadlet.l10n("dangerousRSSTitle"), context);
                            HTMLNode pageNode = page.outer;
                            HTMLNode contentNode = page.content;
                            HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-alert");
                            infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("dangerousRSSSubtitle"));
                            HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                            infoboxContent.addChild("#", L10n.getString("FProxyToadlet.dangerousRSS", new String[]{"type"}, new String[]{mimeType}));
                            infoboxContent.addChild("p", FProxyToadlet.l10n("options"));
                            HTMLNode optionList = infoboxContent.addChild("ul");
                            HTMLNode option = optionList.addChild("li");
                            L10n.addL10nSubstitution(option, "FProxyToadlet.openPossRSSAsPlainText", new String[]{"link", "/link", "bold", "/bold"}, new String[]{"<a href=\"" + basePath + key.toString() + "?type=text/plain&force=" + FProxyToadlet.getForceValue(key, now) + extrasNoMime + "\">", "</a>", "<b>", "</b>"});
                            option = optionList.addChild("li");
                            L10n.addL10nSubstitution(option, "FProxyToadlet.openPossRSSForceDisk", new String[]{"link", "/link", "bold", "/bold"}, new String[]{"<a href=\"" + basePath + key.toString() + "?forcedownload" + extras + "\">", "</a>", "<b>", "</b>"});
                            boolean bl = mimeRSS = mimeType.startsWith("application/xml+rss") || mimeType.startsWith("text/xml");
                            if (!mimeRSS && !mimeType.startsWith("text/plain")) {
                                option = optionList.addChild("li");
                                L10n.addL10nSubstitution(option, "FProxyToadlet.openRSSForce", new String[]{"link", "/link", "bold", "/bold", "mime"}, new String[]{"<a href=\"" + basePath + key.toString() + "?force=" + FProxyToadlet.getForceValue(key, now) + extras + "\">", "</a>", "<b>", "</b>", HTMLEncoder.encode(mimeType)});
                            }
                            option = optionList.addChild("li");
                            L10n.addL10nSubstitution(option, "FProxyToadlet.openRSSAsRSS", new String[]{"link", "/link", "bold", "/bold"}, new String[]{"<a href=\"" + basePath + key.toString() + "?type=application/xml+rss&force=" + FProxyToadlet.getForceValue(key, now) + extrasNoMime + "\">", "</a>", "<b>", "</b>"});
                            if (referrer != null) {
                                option = optionList.addChild("li");
                                L10n.addL10nSubstitution(option, "FProxyToadlet.backToReferrer", new String[]{"link", "/link"}, new String[]{"<a href=\"" + HTMLEncoder.encode(referrer) + "\">", "</a>"});
                            }
                            option = optionList.addChild("li");
                            L10n.addL10nSubstitution(option, "FProxyToadlet.backToFProxy", new String[]{"link", "/link"}, new String[]{"<a href=\"/\">", "</a>"});
                            byte[] pageBytes = pageNode.generate().getBytes("UTF-8");
                            context.sendReplyHeaders(200, "OK", new MultiValueTable<String, String>(), "text/html; charset=utf-8", pageBytes.length);
                            context.writeData(pageBytes);
                            Object var35_49 = null;
                            if (toFree != null && !dontFreeData) {
                                toFree.free();
                            }
                            if (tmpRange == null) return;
                            tmpRange.free();
                            return;
                        }
                    }
                    if (forceDownload) {
                        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                        headers.put("Content-Disposition", "attachment; filename=\"" + key.getPreferredFilename() + '\"');
                        context.sendReplyHeaders(200, "OK", headers, "application/x-msdownload", data.size());
                        context.writeData(data);
                        break block32;
                    }
                    MultiValueTable<String, String> hdr = context.getHeaders();
                    String rangeStr = hdr.get("range");
                    if (rangeStr != null) {
                        long[] range = FProxyToadlet.parseRange(rangeStr);
                        if (range[1] == -1L || range[1] >= data.size()) {
                            range[1] = data.size() - 1L;
                        }
                        tmpRange = bucketFactory.makeBucket(range[1] - range[0]);
                        InputStream is = data.getInputStream();
                        OutputStream os = tmpRange.getOutputStream();
                        if (range[0] > 0L) {
                            is.skip(range[0]);
                        }
                        FileUtil.copy(is, os, range[1] - range[0] + 1L);
                        os.close();
                        is.close();
                        MultiValueTable<String, String> retHdr = new MultiValueTable<String, String>();
                        retHdr.put("Content-Range", "bytes " + range[0] + "-" + range[1] + "/" + data.size());
                        context.sendReplyHeaders(206, "Partial content", retHdr, mimeType, tmpRange.size());
                        context.writeData(tmpRange);
                    } else {
                        context.sendReplyHeaders(200, "OK", new MultiValueTable<String, String>(), mimeType, data.size());
                        context.writeData(data);
                    }
                }
                catch (URISyntaxException use1) {
                    use1.printStackTrace();
                    Logger.error(FProxyToadlet.class, "could not create URI", use1);
                    Object var35_51 = null;
                    if (toFree != null && !dontFreeData) {
                        toFree.free();
                    }
                    if (tmpRange == null) return;
                    tmpRange.free();
                    return;
                }
                catch (UnsafeContentTypeException e) {
                    HTMLNode option;
                    PageNode page = context.getPageMaker().getPageNode(FProxyToadlet.l10n("dangerousContentTitle"), context);
                    HTMLNode pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-alert");
                    infobox.addChild("div", "class", "infobox-header", e.getRawTitle());
                    HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    HTMLNode list = infoboxContent.addChild("ul");
                    FProxyToadlet.writeSizeAndMIME(list, size, mimeType, true);
                    infoboxContent.addChild("p").addChild(e.getHTMLExplanation());
                    infoboxContent.addChild("p", FProxyToadlet.l10n("options"));
                    HTMLNode optionList = infoboxContent.addChild("ul");
                    if (mimeType.equals("application/x-freenet-index") && core.node.pluginManager.isPluginLoaded("plugins.ThawIndexBrowser.ThawIndexBrowser")) {
                        option = optionList.addChild("li");
                        L10n.addL10nSubstitution(option, "FProxyToadlet.openAsThawIndex", new String[]{"link", "/link"}, new String[]{"<b><a href=\"" + basePath + "plugins/plugins.ThawIndexBrowser.ThawIndexBrowser/?key=" + key.toString() + "\">", "</a></b>"});
                    }
                    option = optionList.addChild("li");
                    L10n.addL10nSubstitution(option, "FProxyToadlet.openAsText", new String[]{"link", "/link"}, new String[]{"<a href=\"" + basePath + key.toString() + "?type=text/plain" + extrasNoMime + "\">", "</a>"});
                    option = optionList.addChild("li");
                    L10n.addL10nSubstitution(option, "FProxyToadlet.openForceDisk", new String[]{"link", "/link"}, new String[]{"<a href=\"" + basePath + key.toString() + "?forcedownload" + extras + "\">", "</a>"});
                    if (!mimeType.equals("application/octet-stream") && !mimeType.equals("application/x-msdownload")) {
                        option = optionList.addChild("li");
                        L10n.addL10nSubstitution(option, "FProxyToadlet.openForce", new String[]{"link", "/link", "mime"}, new String[]{"<a href=\"" + basePath + key.toString() + "?force=" + FProxyToadlet.getForceValue(key, now) + extras + "\">", "</a>", HTMLEncoder.encode(mimeType)});
                    }
                    if (referrer != null) {
                        option = optionList.addChild("li");
                        L10n.addL10nSubstitution(option, "FProxyToadlet.backToReferrer", new String[]{"link", "/link"}, new String[]{"<a href=\"" + HTMLEncoder.encode(referrer) + "\">", "</a>"});
                    }
                    option = optionList.addChild("li");
                    L10n.addL10nSubstitution(option, "FProxyToadlet.backToFProxy", new String[]{"link", "/link"}, new String[]{"<a href=\"/\">", "</a>"});
                    if (ctx.isAllowedFullAccess() || !container.publicGatewayMode()) {
                        option = optionList.addChild("li");
                        HTMLNode optionForm = ctx.addFormChild(option, "/downloads/", "tooBigQueueForm");
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "disk"});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", mimeType});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToDisk")});
                    }
                    byte[] pageBytes = pageNode.generate().getBytes("UTF-8");
                    context.sendReplyHeaders(200, "OK", new MultiValueTable<String, String>(), "text/html; charset=utf-8", pageBytes.length);
                    context.writeData(pageBytes);
                    Object var35_52 = null;
                    if (toFree != null && !dontFreeData) {
                        toFree.free();
                    }
                    if (tmpRange == null) return;
                    tmpRange.free();
                    return;
                }
                catch (HTTPRangeException e) {
                    ctx.sendReplyHeaders(416, "Requested Range Not Satisfiable", null, null, 0L);
                    Object var35_53 = null;
                    if (toFree != null && !dontFreeData) {
                        toFree.free();
                    }
                    if (tmpRange == null) return;
                    tmpRange.free();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var35_54 = null;
                if (toFree != null && !dontFreeData) {
                    toFree.free();
                }
                if (tmpRange == null) throw throwable;
                tmpRange.free();
                throw throwable;
            }
        }
        Object var35_50 = null;
        if (toFree != null && !dontFreeData) {
            toFree.free();
        }
        if (tmpRange == null) return;
        tmpRange.free();
    }

    private static String l10n(String msg) {
        return L10n.getString("FProxyToadlet." + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean horribleEvilHack(Bucket data) throws IOException {
        InputStream is;
        block9: {
            byte[] buf;
            block8: {
                block7: {
                    int sz;
                    block6: {
                        boolean bl;
                        is = null;
                        try {
                            sz = (int)Math.min(data.size(), 512L);
                            if (sz != 0) break block6;
                            bl = false;
                            Object var6_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            Closer.close(is);
                            throw throwable;
                        }
                        Closer.close(is);
                        return bl;
                    }
                    is = data.getInputStream();
                    buf = new byte[sz];
                    is.read(buf);
                    if (!FProxyToadlet.checkForString(buf, "<rss")) break block7;
                    boolean bl = true;
                    Object var6_6 = null;
                    Closer.close(is);
                    return bl;
                }
                if (!FProxyToadlet.checkForString(buf, "<feed")) break block8;
                boolean bl = true;
                Object var6_7 = null;
                Closer.close(is);
                return bl;
            }
            if (!FProxyToadlet.checkForString(buf, "<rdf:RDF")) break block9;
            boolean bl = true;
            Object var6_8 = null;
            Closer.close(is);
            return bl;
        }
        Object var6_9 = null;
        Closer.close(is);
        return false;
    }

    private static boolean checkForString(byte[] buf, String find) {
        int offset = 0;
        int bufProgress = 0;
        while (offset < buf.length) {
            byte b = buf[offset];
            if (b == find.charAt(bufProgress)) {
                if (++bufProgress == find.length()) {
                    return true;
                }
            } else {
                bufProgress = 0;
                if (bufProgress != 0) continue;
            }
            ++offset;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleGet(URI uri, HTTPRequest httprequest, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        block84: {
            String override;
            FreenetURI key;
            String ks = uri.getPath();
            boolean logMINOR = Logger.shouldLog(4, this);
            if (ks.equals("/")) {
                if (httprequest.isParameterSet("key")) {
                    FreenetURI newURI;
                    String k = httprequest.getParam("key");
                    try {
                        newURI = new FreenetURI(k);
                    }
                    catch (MalformedURLException e) {
                        Logger.normal(this, "Invalid key: " + e + " for " + k, e);
                        this.sendErrorPage(ctx, 404, FProxyToadlet.l10n("notFoundTitle"), L10n.getString("FProxyToadlet.invalidKeyWithReason", new String[]{"reason"}, new String[]{e.toString()}));
                        return;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Redirecting to FreenetURI: " + newURI);
                    }
                    String requestedMimeType = httprequest.getParam("type");
                    long maxSize = httprequest.getLongParam("max-size", MAX_LENGTH);
                    String location = this.getLink(newURI, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"));
                    this.writeTemporaryRedirect(ctx, null, location);
                    return;
                }
                try {
                    String querystring = uri.getQuery();
                    if (querystring == null) {
                        throw new RedirectException(welcome);
                    }
                    querystring = querystring.replace(' ', '+');
                    throw new RedirectException("/welcome/?" + querystring);
                }
                catch (URISyntaxException e) {}
            } else {
                if (ks.equals("/favicon.ico")) {
                    int len;
                    byte[] buf = new byte[1024];
                    InputStream strm = this.getClass().getResourceAsStream("staticfiles/favicon.ico");
                    if (strm == null) {
                        this.sendErrorPage(ctx, 404, FProxyToadlet.l10n("pathNotFoundTitle"), FProxyToadlet.l10n("pathNotFound"));
                        return;
                    }
                    ctx.sendReplyHeaders(200, "OK", null, "image/x-icon", strm.available());
                    while ((len = strm.read(buf)) > 0) {
                        ctx.writeData(buf, 0, len);
                    }
                    strm.close();
                    return;
                }
                if (ks.equals("/robots.txt") && ctx.doRobots()) {
                    this.writeTextReply(ctx, 200, "Ok", "User-agent: *\nDisallow: /");
                    return;
                }
                if (ks.startsWith("/darknet/") || ks.equals("/darknet")) {
                    FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/friends/");
                    return;
                }
                if (ks.startsWith("/opennet/") || ks.equals("/opennet")) {
                    FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/strangers/");
                    return;
                }
                if (ks.startsWith("/queue/")) {
                    FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/downloads/");
                    return;
                }
                if (ks.startsWith("/config/")) {
                    FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/config/node");
                    return;
                }
            }
            if (ks.startsWith("/")) {
                ks = ks.substring(1);
            }
            boolean restricted = this.container.publicGatewayMode() && !ctx.isAllowedFullAccess();
            long maxSize = restricted ? MAX_LENGTH : httprequest.getLongParam("max-size", MAX_LENGTH);
            String rangeStr = ctx.getHeaders().get("range");
            if (rangeStr != null) {
                try {
                    FProxyToadlet.parseRange(rangeStr);
                }
                catch (HTTPRangeException e) {
                    Logger.normal(this, "Invalid Range Header: " + rangeStr, e);
                    ctx.sendReplyHeaders(416, "Requested Range Not Satisfiable", null, null, 0L);
                    return;
                }
            }
            try {
                key = new FreenetURI(ks);
            }
            catch (MalformedURLException e) {
                PageNode page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("invalidKeyTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode errorInfobox = contentNode.addChild("div", "class", "infobox infobox-error");
                errorInfobox.addChild("div", "class", "infobox-header", L10n.getString("FProxyToadlet.invalidKeyWithReason", new String[]{"reason"}, new String[]{e.toString()}));
                HTMLNode errorContent = errorInfobox.addChild("div", "class", "infobox-content");
                errorContent.addChild("#", FProxyToadlet.l10n("expectedKeyButGot"));
                errorContent.addChild("code", ks);
                errorContent.addChild("br");
                errorContent.addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBack")));
                errorContent.addChild("br");
                FProxyToadlet.addHomepageLink(errorContent);
                this.writeHTMLReply(ctx, 400, FProxyToadlet.l10n("invalidKeyTitle"), pageNode.generate());
                return;
            }
            String requestedMimeType = httprequest.getParam("type", null);
            String string = override = requestedMimeType == null ? "" : "?type=" + URLEncoder.encode(requestedMimeType, true);
            if (httprequest.isParameterSet("forcedownload")) {
                override = override.length() == 0 ? "?forcedownload" : override + "&forcedownload";
            }
            Bucket data = null;
            String mimeType = null;
            String referer = this.sanitizeReferer(ctx);
            FetchException fe = null;
            MultiValueTable<String, String> headers = ctx.getHeaders();
            String ua = headers.get("user-agent");
            String accept = headers.get("accept");
            FProxyFetchResult fr = null;
            if (logMINOR) {
                Logger.minor(this, "UA = " + ua + " accept = " + accept);
            }
            if (this.isBrowser(ua) && !ctx.disableProgressPage() && (accept == null || accept.indexOf("text/html") > -1)) {
                FProxyFetchWaiter fetch = null;
                try {
                    fetch = this.fetchTracker.makeFetcher(key, maxSize);
                }
                catch (FetchException e) {
                    fe = fr.failed;
                }
                if (fetch != null) {
                    fr = fetch.getResult();
                    if (fr.hasData()) {
                        if (logMINOR) {
                            Logger.minor(this, "Found data");
                        }
                        data = fr.data;
                        mimeType = fr.mimeType;
                        fetch.close();
                    } else if (fr.failed != null) {
                        if (logMINOR) {
                            Logger.minor(this, "Request failed");
                        }
                        fe = fr.failed;
                        fetch.close();
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "Still in progress");
                        }
                        boolean isJsEnabled = ctx.getContainer().isFProxyJavascriptEnabled();
                        PageNode page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("fetchingPageTitle"), ctx);
                        HTMLNode pageNode = page.outer;
                        String location = this.getLink(key, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"));
                        HTMLNode headNode = page.headNode;
                        if (isJsEnabled) {
                            headNode.addChild("noscript").addChild("meta", "http-equiv", "Refresh").addAttribute("content", "2;URL=" + location);
                            HTMLNode scriptNode = headNode.addChild("script", "//abc");
                            scriptNode.addAttribute("type", "text/javascript");
                            scriptNode.addAttribute("src", "/static/js/progresspage.js");
                        } else {
                            headNode.addChild("meta", "http-equiv", "Refresh").addAttribute("content", "2;URL=" + location);
                        }
                        HTMLNode contentNode = page.content;
                        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("fetchingPageBox"));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addAttribute("id", "infoContent");
                        infoboxContent.addChild("#", FProxyToadlet.l10n("filenameLabel") + " ");
                        infoboxContent.addChild("a", "href", "/" + key.toString(false, false), key.getPreferredFilename());
                        if (fr.mimeType != null) {
                            infoboxContent.addChild("br", FProxyToadlet.l10n("contentTypeLabel") + " " + fr.mimeType);
                        }
                        if (fr.size > 0L) {
                            infoboxContent.addChild("br", "Size: " + SizeUtil.formatSize(fr.size));
                        }
                        if (this.core.isAdvancedModeEnabled()) {
                            infoboxContent.addChild("br", this.l10n("blocksDetail", new String[]{"fetched", "required", "total", "failed", "fatallyfailed"}, new String[]{Integer.toString(fr.fetchedBlocks), Integer.toString(fr.requiredBlocks), Integer.toString(fr.totalBlocks), Integer.toString(fr.failedBlocks), Integer.toString(fr.fatallyFailedBlocks)}));
                        }
                        infoboxContent.addChild("br", FProxyToadlet.l10n("timeElapsedLabel") + " " + TimeUtil.formatTime(System.currentTimeMillis() - fr.timeStarted));
                        long eta = fr.eta;
                        if (eta > 0L) {
                            infoboxContent.addChild("br", "ETA: " + TimeUtil.formatTime(eta));
                        }
                        if (fr.goneToNetwork) {
                            infoboxContent.addChild("p", FProxyToadlet.l10n("progressDownloading"));
                        } else {
                            infoboxContent.addChild("p", FProxyToadlet.l10n("progressCheckingStore"));
                        }
                        if (!fr.finalizedBlocks) {
                            infoboxContent.addChild("p", FProxyToadlet.l10n("progressNotFinalized"));
                        }
                        HTMLNode table = infoboxContent.addChild("table", "border", "0");
                        HTMLNode progressCell = table.addChild("tr").addChild("td", "class", "request-progress");
                        if (fr.totalBlocks <= 0) {
                            progressCell.addChild("#", L10n.getString("QueueToadlet.unknown"));
                        } else {
                            int total = fr.requiredBlocks;
                            int fetchedPercent = (int)((double)fr.fetchedBlocks / (double)total * 100.0);
                            int failedPercent = (int)((double)fr.failedBlocks / (double)total * 100.0);
                            int fatallyFailedPercent = (int)((double)fr.fatallyFailedBlocks / (double)total * 100.0);
                            HTMLNode progressBar = progressCell.addChild("div", "class", "progressbar");
                            progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-done", "width: " + fetchedPercent + "%;"});
                            if (fr.failedBlocks > 0) {
                                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed", "width: " + failedPercent + "%;"});
                            }
                            if (fr.fatallyFailedBlocks > 0) {
                                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed2", "width: " + fatallyFailedPercent + "%;"});
                            }
                            NumberFormat nf = NumberFormat.getInstance();
                            nf.setMaximumFractionDigits(1);
                            String prefix = '(' + Integer.toString(fr.fetchedBlocks) + "/ " + Integer.toString(total) + "): ";
                            if (fr.finalizedBlocks) {
                                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_finalized", prefix + L10n.getString("QueueToadlet.progressbarAccurate")}, nf.format((double)((int)((double)fr.fetchedBlocks / (double)total * 1000.0)) / 10.0) + '%');
                            } else {
                                String text = nf.format((double)((int)((double)fr.fetchedBlocks / (double)total * 1000.0)) / 10.0) + '%';
                                text = "" + fr.fetchedBlocks + " (" + text + "??)";
                                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_not_finalized", prefix + L10n.getString("QueueToadlet.progressbarNotAccurate")}, text);
                            }
                        }
                        infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("fetchingPageOptions"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        HTMLNode ul = infoboxContent.addChild("ul");
                        ul.addChild("li").addChild("p", FProxyToadlet.l10n("progressOptionZero"));
                        HTMLNode optionForm = ctx.addFormChild(ul.addChild("li").addChild("p"), "/downloads/", "tooBigQueueForm");
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "disk"});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToDisk")});
                        ul.addChild("li").addChild("p").addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                        ul.addChild("li").addChild("p").addChild("a", new String[]{"href", "title"}, new String[]{"/", L10n.getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                        MultiValueTable<String, String> retHeaders = new MultiValueTable<String, String>();
                        this.writeHTMLReply(ctx, 200, "OK", retHeaders, pageNode.generate());
                        fr.close();
                        fetch.close();
                        return;
                    }
                }
            }
            try {
                try {
                    if (Logger.shouldLog(4, this)) {
                        Logger.minor(this, "FProxy fetching " + key + " (" + maxSize + ')');
                    }
                    if (data == null && fe == null) {
                        FetchResult result = this.fetch(key, maxSize, new RequestClient(){

                            public boolean persistent() {
                                return false;
                            }

                            public void removeFrom(ObjectContainer container) {
                                throw new UnsupportedOperationException();
                            }
                        });
                        data = result.asBucket();
                        mimeType = result.getMimeType();
                    } else if (fe != null) {
                        throw fe;
                    }
                    FProxyToadlet.handleDownload(ctx, data, ctx.getBucketFactory(), mimeType, requestedMimeType, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), "/", key, maxSize != MAX_LENGTH ? "&max-size=" + maxSize : "", referer, true, ctx, this.core, fr != null);
                }
                catch (FetchException e) {
                    String msg = e.getMessage();
                    if (Logger.shouldLog(4, this)) {
                        Logger.minor(this, "Failed to fetch " + uri + " : " + e);
                    }
                    if (e.newURI != null) {
                        Toadlet.writePermanentRedirect(ctx, msg, this.getLink(e.newURI, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload")));
                    } else if (e.mode == 21) {
                        PageNode page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("fileInformationTitle"), ctx);
                        HTMLNode pageNode = page.outer;
                        HTMLNode contentNode = page.content;
                        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("largeFile"));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        HTMLNode fileInformationList = infoboxContent.addChild("ul");
                        HTMLNode option = fileInformationList.addChild("li");
                        option.addChild("#", FProxyToadlet.l10n("filenameLabel") + ' ');
                        option.addChild("a", "href", '/' + key.toString(), this.getFilename(e, key, e.getExpectedMimeType()));
                        String mime = FProxyToadlet.writeSizeAndMIME(fileInformationList, e);
                        infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("explanationTitle"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addChild("#", FProxyToadlet.l10n("largeFileExplanationAndOptions"));
                        HTMLNode optionList = infoboxContent.addChild("ul");
                        if (!restricted) {
                            option = optionList.addChild("li");
                            HTMLNode optionForm = option.addChild("form", new String[]{"action", "method"}, new String[]{'/' + key.toString(), "get"});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "max-size", String.valueOf(e.expectedSize == -1L ? Long.MAX_VALUE : e.expectedSize * 2L)});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "fetch", FProxyToadlet.l10n("fetchLargeFileAnywayAndDisplay")});
                            option = optionList.addChild("li");
                            optionForm = ctx.addFormChild(option, "/downloads/", "tooBigQueueForm");
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "disk"});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
                            if (mime != null) {
                                optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", mime});
                            }
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToDisk")});
                        }
                        optionList.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/", L10n.getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                        option = optionList.addChild("li");
                        option.addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    } else {
                        PageNode page = ctx.getPageMaker().getPageNode(FetchException.getShortMessage(e.mode), ctx);
                        HTMLNode pageNode = page.outer;
                        HTMLNode contentNode = page.content;
                        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-error");
                        infobox.addChild("div", "class", "infobox-header", this.l10n("errorWithReason", "error", FetchException.getShortMessage(e.mode)));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        HTMLNode fileInformationList = infoboxContent.addChild("ul");
                        HTMLNode option = fileInformationList.addChild("li");
                        option.addChild("#", FProxyToadlet.l10n("filenameLabel") + ' ');
                        option.addChild("a", "href", '/' + key.toString(), this.getFilename(e, key, e.getExpectedMimeType()));
                        String mime = FProxyToadlet.writeSizeAndMIME(fileInformationList, e);
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("explanationTitle"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addChild("p", FProxyToadlet.l10n("unableToRetrieve"));
                        if (e.isFatal()) {
                            infoboxContent.addChild("p", FProxyToadlet.l10n("errorIsFatal"));
                        }
                        infoboxContent.addChild("p", msg);
                        if (e.errorCodes != null) {
                            infoboxContent.addChild("p").addChild("pre").addChild("#", e.errorCodes.toVerboseString());
                        }
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("options"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        HTMLNode optionList = infoboxContent.addChild("ul");
                        if (e.mode == 10 && this.core.node.pluginManager.isPluginLoaded("plugins.KeyExplorer.KeyExplorer")) {
                            option = optionList.addChild("li");
                            L10n.addL10nSubstitution(option, "FProxyToadlet.openWithKeyExplorer", new String[]{"link", "/link"}, new String[]{"<a href=\"/plugins/plugins.KeyExplorer.KeyExplorer/?key=" + key.toString() + "\">", "</a>"});
                        }
                        if (!(e.isFatal() || !ctx.isAllowedFullAccess() && this.container.publicGatewayMode())) {
                            option = optionList.addChild("li");
                            HTMLNode optionForm = ctx.addFormChild(option, "/downloads/", "dnfQueueForm");
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "disk"});
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
                            if (mime != null) {
                                optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", mime});
                            }
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToDisk")});
                            optionList.addChild("li").addChild("a", "href", this.getLink(key, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"))).addChild("#", FProxyToadlet.l10n("retryNow"));
                        }
                        optionList.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/", L10n.getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                        option = optionList.addChild("li");
                        option.addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                        this.writeHTMLReply(ctx, e.mode == 10 ? 404 : 500, "Internal Error", pageNode.generate());
                    }
                    Object var43_85 = null;
                    if (fr == null && data != null) {
                        data.free();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                    break block84;
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("Broken pipe")) {
                        if (Logger.shouldLog(4, this)) {
                            Logger.minor(this, "Caught " + e + " while handling GET", (Throwable)e);
                        }
                    } else {
                        Logger.normal(this, "Caught " + e);
                    }
                    throw e;
                }
                catch (Throwable t) {
                    this.writeInternalError(t, ctx);
                    Object var43_86 = null;
                    if (fr == null && data != null) {
                        data.free();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                Object var43_84 = null;
                if (fr == null && data != null) {
                    data.free();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Throwable throwable) {
                Object var43_87 = null;
                if (fr == null && data != null) {
                    data.free();
                }
                if (fr != null) {
                    fr.close();
                }
                throw throwable;
            }
        }
    }

    private boolean isBrowser(String ua) {
        if (ua == null) {
            return false;
        }
        if (ua.indexOf("Mozilla/") > -1) {
            return true;
        }
        return ua.indexOf("Opera/") > -1;
    }

    private static String writeSizeAndMIME(HTMLNode fileInformationList, FetchException e) {
        boolean finalized = e.finalizedSize();
        String mime = e.getExpectedMimeType();
        long size = e.expectedSize;
        FProxyToadlet.writeSizeAndMIME(fileInformationList, size, mime, finalized);
        return mime;
    }

    private static void writeSizeAndMIME(HTMLNode fileInformationList, long size, String mime, boolean finalized) {
        if (size > 0L) {
            if (finalized) {
                fileInformationList.addChild("li", FProxyToadlet.l10n("sizeLabel") + ' ' + SizeUtil.formatSize(size));
            } else {
                fileInformationList.addChild("li", FProxyToadlet.l10n("sizeLabel") + ' ' + SizeUtil.formatSize(size) + FProxyToadlet.l10n("mayChange"));
            }
        } else {
            fileInformationList.addChild("li", FProxyToadlet.l10n("sizeUnknown"));
        }
        if (mime != null) {
            fileInformationList.addChild("li", L10n.getString("FProxyToadlet." + (finalized ? "mimeType" : "expectedMimeType"), new String[]{"mime"}, new String[]{mime}));
        } else {
            fileInformationList.addChild("li", FProxyToadlet.l10n("unknownMIMEType"));
        }
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("FProxyToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return L10n.getString("FProxyToadlet." + key, pattern, value);
    }

    private String getLink(FreenetURI uri, String requestedMimeType, long maxSize, String force, boolean forceDownload) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(uri.toASCIIString());
        int c = 63;
        if (requestedMimeType != null && requestedMimeType != "") {
            sb.append((char)c).append("type=").append(URLEncoder.encode(requestedMimeType, false));
            c = 38;
        }
        if (maxSize > 0L && maxSize != MAX_LENGTH) {
            sb.append((char)c).append("max-size=").append(maxSize);
            c = 38;
        }
        if (force != null) {
            sb.append((char)c).append("force=").append(force);
            c = 38;
        }
        if (forceDownload) {
            sb.append((char)c).append("forcedownload=true");
            c = 38;
        }
        return sb.toString();
    }

    private String sanitizeReferer(ToadletContext ctx) {
        String referer = ctx.getHeaders().get("referer");
        if (referer != null) {
            try {
                URI refererURI = new URI(URIPreEncoder.encode(referer));
                String path = refererURI.getPath();
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ("".equals(path)) {
                    return "/";
                }
                FreenetURI furi = new FreenetURI(path);
                HTTPRequestImpl req = new HTTPRequestImpl(refererURI, "GET");
                String type = req.getParam("type");
                referer = "/" + furi.toString();
                if (type != null && type.length() > 0) {
                    referer = referer + "?type=" + type;
                }
            }
            catch (MalformedURLException e) {
                referer = "/";
                Logger.normal(this, "Caught MalformedURLException on the referer : " + e.getMessage());
            }
            catch (Throwable t) {
                Logger.error(this, "Caught handling referrer: " + t + " for " + referer, t);
                referer = null;
            }
        }
        return referer;
    }

    private static String getForceValue(FreenetURI key, long time) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(random);
            bos.write(key.toString().getBytes("UTF-8"));
            bos.write(Long.toString(time / 3600000L).getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new Error(e);
        }
        String f = HexUtil.bytesToHex(SHA256.digest(bos.toByteArray()));
        return f;
    }

    public static void maybeCreateFProxyEtc(NodeClientCore core, Node node, Config config, SimpleToadletServer server, BookmarkManager bookmarks) throws IOException {
        HighLevelSimpleClient client = core.makeClient((short)1, true);
        random = new byte[32];
        core.random.nextBytes(random);
        FProxyToadlet fproxy = new FProxyToadlet(client, core);
        core.setFProxy(fproxy);
        server.registerMenu("/", "FProxyToadlet.categoryBrowsing", "FProxyToadlet.categoryTitleBrowsing", null);
        server.registerMenu("/downloads/", "FProxyToadlet.categoryQueue", "FProxyToadlet.categoryTitleQueue", null);
        server.registerMenu("/friends/", "FProxyToadlet.categoryFriends", "FProxyToadlet.categoryTitleFriends", null);
        server.registerMenu("/chat/", "FProxyToadlet.categoryChat", "FProxyToadlet.categoryTitleChat", null);
        server.registerMenu("/alerts/", "FProxyToadlet.categoryStatus", "FProxyToadlet.categoryTitleStatus", null);
        server.registerMenu("/seclevels/", "FProxyToadlet.categoryConfig", "FProxyToadlet.categoryTitleConfig", null);
        server.register(fproxy, "FProxyToadlet.categoryBrowsing", "/", false, "FProxyToadlet.welcomeTitle", "FProxyToadlet.welcome", false, null);
        InsertFreesiteToadlet siteinsert = new InsertFreesiteToadlet(client, core.alerts);
        server.register(siteinsert, "FProxyToadlet.categoryBrowsing", "/insertsite/", true, "FProxyToadlet.insertFreesiteTitle", "FProxyToadlet.insertFreesite", false, null);
        UserAlertsToadlet alerts = new UserAlertsToadlet(client, node, core);
        server.register(alerts, "FProxyToadlet.categoryStatus", "/alerts/", true, "FProxyToadlet.alertsTitle", "FProxyToadlet.alerts", true, null);
        QueueToadlet downloadToadlet = new QueueToadlet(core, core.getFCPServer(), client, false);
        server.register(downloadToadlet, "FProxyToadlet.categoryQueue", "/downloads/", true, "FProxyToadlet.downloadsTitle", "FProxyToadlet.downloads", false, downloadToadlet);
        QueueToadlet uploadToadlet = new QueueToadlet(core, core.getFCPServer(), client, true);
        server.register(uploadToadlet, "FProxyToadlet.categoryQueue", "/uploads/", true, "FProxyToadlet.uploadsTitle", "FProxyToadlet.uploads", false, uploadToadlet);
        SymlinkerToadlet symlinkToadlet = new SymlinkerToadlet(client, node);
        server.register(symlinkToadlet, null, "/sl/", true, false);
        SecurityLevelsToadlet seclevels = new SecurityLevelsToadlet(client, node, core);
        server.register(seclevels, "FProxyToadlet.categoryConfig", "/seclevels/", true, "FProxyToadlet.seclevelsTitle", "FProxyToadlet.seclevels", true, null);
        PproxyToadlet pproxy = new PproxyToadlet(client, node, core);
        server.register(pproxy, "FProxyToadlet.categoryConfig", "/plugins/", true, "FProxyToadlet.pluginsTitle", "FProxyToadlet.plugins", true, null);
        Object[] sc = config.getConfigs();
        Arrays.sort(sc);
        for (Object cfg : sc) {
            String prefix = ((SubConfig)cfg).getPrefix();
            if (prefix.equals("security-levels") || prefix.equals("pluginmanager")) continue;
            ConfigToadlet configtoadlet = new ConfigToadlet(client, config, (SubConfig)cfg, node, core);
            server.register(configtoadlet, "FProxyToadlet.categoryConfig", "/config/" + prefix, true, "ConfigToadlet." + prefix, "ConfigToadlet.title." + prefix, true, configtoadlet);
        }
        WelcomeToadlet welcometoadlet = new WelcomeToadlet(client, core, node, bookmarks);
        server.register(welcometoadlet, null, "/welcome/", true, false);
        DarknetConnectionsToadlet friendsToadlet = new DarknetConnectionsToadlet(node, core, client);
        server.register(friendsToadlet, "FProxyToadlet.categoryFriends", "/friends/", true, "FProxyToadlet.friendsTitle", "FProxyToadlet.friends", true, null);
        DarknetAddRefToadlet addRefToadlet = new DarknetAddRefToadlet(node, core, client);
        server.register(addRefToadlet, "FProxyToadlet.categoryFriends", "/addfriend/", true, "FProxyToadlet.addFriendTitle", "FProxyToadlet.addFriend", true, null);
        OpennetConnectionsToadlet opennetToadlet = new OpennetConnectionsToadlet(node, core, client);
        server.register(opennetToadlet, "FProxyToadlet.categoryStatus", "/strangers/", true, "FProxyToadlet.opennetTitle", "FProxyToadlet.opennet", true, opennetToadlet);
        ChatForumsToadlet chatForumsToadlet = new ChatForumsToadlet(client, core.alerts, node.pluginManager);
        server.register(chatForumsToadlet, "FProxyToadlet.categoryChat", "/chat/", true, "FProxyToadlet.chatForumsTitle", "FProxyToadlet.chatForums", true, chatForumsToadlet);
        N2NTMToadlet n2ntmToadlet = new N2NTMToadlet(node, core, client);
        server.register(n2ntmToadlet, null, "/send_n2ntm/", true, true);
        LocalFileInsertToadlet localFileInsertToadlet = new LocalFileInsertToadlet(core, client);
        server.register(localFileInsertToadlet, null, "/files/", true, false);
        BookmarkEditorToadlet bookmarkEditorToadlet = new BookmarkEditorToadlet(client, core, bookmarks);
        server.register(bookmarkEditorToadlet, null, "/bookmarkEditor/", true, false);
        BrowserTestToadlet browsertTestToadlet = new BrowserTestToadlet(client, core);
        server.register(browsertTestToadlet, null, "/test/", true, false);
        StatisticsToadlet statisticsToadlet = new StatisticsToadlet(node, core, client);
        server.register(statisticsToadlet, "FProxyToadlet.categoryStatus", "/stats/", true, "FProxyToadlet.statsTitle", "FProxyToadlet.stats", true, null);
        ConnectivityToadlet connectivityToadlet = new ConnectivityToadlet(client, node, core);
        server.register(connectivityToadlet, "FProxyToadlet.categoryStatus", "/connectivity/", true, "ConnectivityToadlet.connectivityTitle", "ConnectivityToadlet.connectivity", true, null);
        TranslationToadlet translationToadlet = new TranslationToadlet(client, core);
        server.register(translationToadlet, "FProxyToadlet.categoryConfig", "/translation/", true, "TranslationToadlet.title", "TranslationToadlet.titleLong", true, null);
        FirstTimeWizardToadlet firstTimeWizardToadlet = new FirstTimeWizardToadlet(client, node, core);
        server.register(firstTimeWizardToadlet, null, "/wizard/", true, false);
        SimpleHelpToadlet simpleHelpToadlet = new SimpleHelpToadlet(client, core);
        server.register(simpleHelpToadlet, null, "/help/", true, false);
    }

    private String getFilename(FetchException e, FreenetURI uri, String expectedMimeType) {
        String s = uri.getPreferredFilename();
        int dotIdx = s.lastIndexOf(46);
        String ext = DefaultMIMETypes.getExtension(expectedMimeType);
        if (ext == null) {
            ext = "bin";
        }
        if (dotIdx == -1 && expectedMimeType != null) {
            s = s + '.' + ext;
            return s;
        }
        if (dotIdx != -1) {
            String oldExt = s.substring(dotIdx + 1);
            if (DefaultMIMETypes.isValidExt(expectedMimeType, oldExt)) {
                return s;
            }
            return s + '.' + ext;
        }
        return s + '.' + ext;
    }

    private static long[] parseRange(String hdrrange) throws HTTPRangeException {
        long[] result = new long[2];
        try {
            String[] units = hdrrange.split("=", 2);
            if (!"bytes".equals(units[0])) {
                throw new HTTPRangeException("Unknown unit, only 'bytes' supportet yet");
            }
            String[] range = units[1].split("-", 2);
            result[0] = Long.parseLong(range[0]);
            if (result[0] < 0L) {
                throw new HTTPRangeException("Negative 'from' value");
            }
            if (range[1].trim().length() > 0) {
                result[1] = Long.parseLong(range[1]);
                if (result[1] <= result[0]) {
                    throw new HTTPRangeException("'from' value must be less then 'to' value");
                }
            } else {
                result[1] = -1L;
            }
        }
        catch (NumberFormatException nfe) {
            throw new HTTPRangeException(nfe);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new HTTPRangeException(ioobe);
        }
        return result;
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    public String path() {
        return "/";
    }

    static {
        prefetchAllowedTypes = new HashSet<String>();
        prefetchAllowedTypes.add("image/png");
        prefetchAllowedTypes.add("image/jpeg");
        prefetchAllowedTypes.add("image/gif");
        MAX_LENGTH = 0x200000L;
        try {
            welcome = new URI("/welcome/");
        }
        catch (URISyntaxException e) {
            throw new Error("Broken URI constructor: " + e, e);
        }
    }
}

