/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class FProxyFetchTracker
implements Runnable {
    private static volatile boolean logMINOR;
    final MultiValueTable<FreenetURI, FProxyFetchInProgress> fetchers = new MultiValueTable();
    final ClientContext context;
    private long fetchIdentifiers;
    private final FetchContext fctx;
    private final RequestClient rc;
    private boolean queuedJob;
    private boolean requeue;

    FProxyFetchTracker(ClientContext context, FetchContext fctx, RequestClient rc) {
        this.context = context;
        this.fctx = fctx;
        this.rc = rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FProxyFetchWaiter makeFetcher(FreenetURI key, long maxSize) throws FetchException {
        FProxyFetchInProgress progress;
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            if (this.fetchers.containsKey(key)) {
                Object[] check = this.fetchers.getArray(key);
                for (int i = 0; i < check.length; ++i) {
                    progress = (FProxyFetchInProgress)check[i];
                    if ((progress.maxSize != maxSize || !progress.notFinishedOrFatallyFinished()) && !progress.hasData()) continue;
                    return progress.getWaiter();
                }
            }
            progress = new FProxyFetchInProgress(this, key, maxSize, this.fetchIdentifiers++, this.context, this.fctx, this.rc);
            this.fetchers.put(key, progress);
        }
        try {
            progress.start(this.context);
        }
        catch (FetchException e) {
            MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable2 = this.fetchers;
            synchronized (multiValueTable2) {
                this.fetchers.removeElement(key, progress);
            }
            throw e;
        }
        if (logMINOR) {
            Logger.minor(this, "Created new fetcher: " + progress);
        }
        return progress.getWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCancel(FProxyFetchInProgress progress) {
        if (logMINOR) {
            Logger.minor(this, "Queueing removal of old FProxyFetchInProgress's");
        }
        FProxyFetchTracker fProxyFetchTracker = this;
        synchronized (fProxyFetchTracker) {
            if (this.queuedJob) {
                this.requeue = true;
                return;
            }
            this.queuedJob = true;
        }
        this.context.ticker.queueTimedJob(this, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "Removing old FProxyFetchInProgress's");
        }
        ArrayList<FProxyFetchInProgress> toRemove = null;
        boolean needRequeue = false;
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            if (this.requeue) {
                this.requeue = false;
                needRequeue = true;
            } else {
                this.queuedJob = false;
            }
            Enumeration<FreenetURI> e = this.fetchers.keys();
            while (e.hasMoreElements()) {
                FreenetURI uri = e.nextElement();
                Vector list = (Vector)this.fetchers.iterateAll(uri);
                for (FProxyFetchInProgress f : list) {
                    if (!f.canCancel()) continue;
                    if (toRemove == null) {
                        toRemove = new ArrayList<FProxyFetchInProgress>();
                    }
                    toRemove.add(f);
                }
            }
            if (toRemove != null) {
                for (FProxyFetchInProgress r : toRemove) {
                    this.fetchers.removeElement(r.uri, r);
                }
            }
        }
        if (toRemove != null) {
            for (FProxyFetchInProgress r : toRemove) {
                r.finishCancel();
            }
        }
        if (needRequeue) {
            this.context.ticker.queueTimedJob(this, 30000L);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

