/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.util.ArrayList;

public class FProxyFetchInProgress
implements ClientEventListener,
ClientGetCallback {
    private static volatile boolean logMINOR;
    final FreenetURI uri;
    final long maxSize;
    private final long identifier;
    private final ClientGetter getter;
    private final ArrayList<FProxyFetchWaiter> waiters;
    private final ArrayList<FProxyFetchResult> results;
    private Bucket data;
    private final long timeStarted;
    private boolean finished;
    private long size;
    private String mimeType;
    private boolean goneToNetwork;
    private int totalBlocks;
    private int requiredBlocks;
    private int fetchedBlocks;
    private int failedBlocks;
    private int fatallyFailedBlocks;
    private int fetchedBlocksPreNetwork;
    private boolean finalizedBlocks;
    private FetchException failed;
    private boolean hasWaited;
    private boolean hasNotifiedFailure;
    private long lastTouched;
    final FProxyFetchTracker tracker;
    private long timeFailed;
    static final int LIFETIME = 30000;

    public FProxyFetchInProgress(FProxyFetchTracker tracker, FreenetURI key, long maxSize2, long identifier, ClientContext context, FetchContext fctx, RequestClient rc) {
        this.tracker = tracker;
        this.uri = key;
        this.maxSize = maxSize2;
        this.timeStarted = System.currentTimeMillis();
        this.identifier = identifier;
        fctx = new FetchContext(fctx, 0, false, null);
        fctx.maxOutputLength = fctx.maxTempLength = this.maxSize;
        fctx.eventProducer.addEventListener(this);
        this.waiters = new ArrayList();
        this.results = new ArrayList();
        this.getter = new ClientGetter(this, this.uri, fctx, 1, rc, null, null);
    }

    public synchronized FProxyFetchWaiter getWaiter() {
        this.lastTouched = System.currentTimeMillis();
        FProxyFetchWaiter waiter = new FProxyFetchWaiter(this);
        this.waiters.add(waiter);
        return waiter;
    }

    synchronized FProxyFetchResult innerGetResult(boolean hasWaited) {
        this.lastTouched = System.currentTimeMillis();
        FProxyFetchResult res = this.data != null ? new FProxyFetchResult(this, this.data, this.mimeType, this.timeStarted, this.goneToNetwork, this.getETA(), hasWaited) : new FProxyFetchResult(this, this.mimeType, this.size, this.timeStarted, this.goneToNetwork, this.totalBlocks, this.requiredBlocks, this.fetchedBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.finalizedBlocks, this.failed, this.getETA(), hasWaited);
        this.results.add(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientContext context) throws FetchException {
        try {
            context.start(this.getter);
        }
        catch (FetchException e) {
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.failed = e;
                this.finished = true;
            }
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Failed to start: " + e);
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.failed = new FetchException(17, (Throwable)e);
                this.finished = true;
            }
        }
    }

    public void onRemoveEventProducer(ObjectContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
        if (ce instanceof SplitfileProgressEvent) {
            SplitfileProgressEvent split = (SplitfileProgressEvent)ce;
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                int oldReq = this.requiredBlocks - (this.fetchedBlocks + this.failedBlocks + this.fatallyFailedBlocks);
                this.totalBlocks = split.totalBlocks;
                this.fetchedBlocks = split.succeedBlocks;
                this.requiredBlocks = split.minSuccessfulBlocks;
                this.failedBlocks = split.failedBlocks;
                this.fatallyFailedBlocks = split.fatallyFailedBlocks;
                this.finalizedBlocks = split.finalizedTotal;
                int req = this.requiredBlocks - (this.fetchedBlocks + this.failedBlocks + this.fatallyFailedBlocks);
                if (req <= 1024 || oldReq > 1024) {
                    return;
                }
            }
        }
        if (ce instanceof SendingToNetworkEvent) {
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                if (this.goneToNetwork) {
                    return;
                }
                this.goneToNetwork = true;
                this.fetchedBlocksPreNetwork = this.fetchedBlocks;
            }
        }
        if (ce instanceof ExpectedMIMEEvent) {
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.mimeType = ((ExpectedMIMEEvent)ce).expectedMIMEType;
            }
            if (!this.goneToNetwork) {
                return;
            }
        } else if (ce instanceof ExpectedFileSizeEvent) {
            FProxyFetchInProgress fProxyFetchInProgress = this;
            synchronized (fProxyFetchInProgress) {
                this.size = ((ExpectedFileSizeEvent)ce).expectedSize;
            }
            if (!this.goneToNetwork) {
                return;
            }
        } else {
            return;
        }
        this.wakeWaiters(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeWaiters(boolean finished) {
        FProxyFetchWaiter[] waiting;
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            waiting = this.waiters.toArray(new FProxyFetchWaiter[this.waiters.size()]);
        }
        for (FProxyFetchWaiter w : waiting) {
            w.wakeUp(finished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.failed = e;
            this.finished = true;
            this.timeFailed = System.currentTimeMillis();
        }
        this.wakeWaiters(true);
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.data = result.asBucket();
            this.mimeType = result.getMimeType();
            this.finished = true;
        }
        this.wakeWaiters(true);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean finished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FProxyFetchWaiter waiter) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.waiters.remove(waiter);
            if (!this.results.isEmpty()) {
                return;
            }
            if (!this.waiters.isEmpty()) {
                return;
            }
        }
        this.tracker.queueCancel(this);
    }

    public synchronized boolean canCancel() {
        if (!this.waiters.isEmpty()) {
            return false;
        }
        if (!this.results.isEmpty()) {
            return false;
        }
        if (this.lastTouched + 30000L >= System.currentTimeMillis()) {
            if (logMINOR) {
                Logger.minor(this, "Not able to cancel for " + this + " : " + this.uri + " : " + this.maxSize);
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Can cancel for " + this + " : " + this.uri + " : " + this.maxSize);
        }
        return true;
    }

    public void finishCancel() {
        if (logMINOR) {
            Logger.minor(this, "Finishing cancel for " + this + " : " + this.uri + " : " + this.maxSize);
        }
        if (this.data != null) {
            try {
                this.data.free();
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to free: " + t, t);
            }
        }
        try {
            this.getter.cancel();
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to cancel: " + t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FProxyFetchResult result) {
        FProxyFetchInProgress fProxyFetchInProgress = this;
        synchronized (fProxyFetchInProgress) {
            this.results.remove(result);
            if (!this.results.isEmpty()) {
                return;
            }
            if (!this.waiters.isEmpty()) {
                return;
            }
        }
        this.tracker.queueCancel(this);
    }

    public synchronized long getETA() {
        if (!this.goneToNetwork) {
            return -1L;
        }
        if (this.requiredBlocks <= 0) {
            return -1L;
        }
        if (this.fetchedBlocks >= this.requiredBlocks) {
            return -1L;
        }
        if (this.fetchedBlocks - this.fetchedBlocksPreNetwork < 5) {
            return -1L;
        }
        return (System.currentTimeMillis() - this.timeStarted) * (long)(this.requiredBlocks - this.fetchedBlocksPreNetwork) / (long)(this.fetchedBlocks - this.fetchedBlocksPreNetwork);
    }

    public synchronized boolean notFinishedOrFatallyFinished() {
        if (this.data == null && this.failed == null) {
            return true;
        }
        if (this.failed != null && this.failed.isFatal()) {
            return true;
        }
        if (this.failed != null && !this.hasNotifiedFailure) {
            this.hasNotifiedFailure = true;
            return true;
        }
        return this.failed != null && System.currentTimeMillis() - this.timeFailed < 5000L;
    }

    public synchronized boolean hasNotifiedFailure() {
        return true;
    }

    public synchronized boolean hasWaited() {
        return this.hasWaited;
    }

    public synchronized void setHasWaited() {
        this.hasWaited = true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

