/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.ConnectionsToadlet;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.N2NTMToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.L10n;
import freenet.node.DarknetPeerNode;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.PeerNodeStatus;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleFieldSet;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DarknetConnectionsToadlet
extends ConnectionsToadlet {
    DarknetConnectionsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(n, core, client);
    }

    @Override
    public String supportedMethods() {
        return "GET, POST";
    }

    private static String l10n(String string) {
        return L10n.getString("DarknetConnectionsToadlet." + string);
    }

    @Override
    protected Comparator<PeerNodeStatus> comparator(String sortBy, boolean reversed) {
        return new DarknetComparator(sortBy, reversed);
    }

    @Override
    protected boolean hasNameColumn() {
        return true;
    }

    @Override
    protected void drawNameColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus) {
        peerRow.addChild("td", "class", "peer-name").addChild("a", "href", "/send_n2ntm/?peernode_hashcode=" + peerNodeStatus.hashCode(), ((DarknetPeerNodeStatus)peerNodeStatus).getName());
    }

    @Override
    protected boolean hasPrivateNoteColumn() {
        return true;
    }

    @Override
    protected void drawPrivateNoteColumn(HTMLNode peerRow, PeerNodeStatus peerNodeStatus, boolean fProxyJavascriptEnabled) {
        DarknetPeerNodeStatus status = (DarknetPeerNodeStatus)peerNodeStatus;
        if (fProxyJavascriptEnabled) {
            peerRow.addChild("td", "class", "peer-private-darknet-comment-note").addChild("input", new String[]{"type", "name", "size", "maxlength", "onBlur", "onChange", "value"}, new String[]{"text", "peerPrivateNote_" + peerNodeStatus.hashCode(), "16", "250", "peerNoteBlur();", "peerNoteChange();", status.getPrivateDarknetCommentNote()});
        } else {
            peerRow.addChild("td", "class", "peer-private-darknet-comment-note").addChild("input", new String[]{"type", "name", "size", "maxlength", "value"}, new String[]{"text", "peerPrivateNote_" + peerNodeStatus.hashCode(), "16", "250", status.getPrivateDarknetCommentNote()});
        }
    }

    @Override
    protected SimpleFieldSet getNoderef() {
        return this.node.exportDarknetPublicFieldSet();
    }

    @Override
    protected PeerNodeStatus[] getPeerNodeStatuses(boolean noHeavy) {
        return this.node.peers.getDarknetPeerNodeStatuses(noHeavy);
    }

    @Override
    protected String getPageTitle(String titleCountString, String myName) {
        return L10n.getString("DarknetConnectionsToadlet.fullTitle", new String[]{"counts", "name"}, new String[]{titleCountString, this.node.getMyName()});
    }

    @Override
    protected boolean shouldDrawNoderefBox(boolean advancedModeEnabled) {
        return advancedModeEnabled;
    }

    @Override
    protected boolean showPeerActionsBox() {
        return true;
    }

    @Override
    protected void drawPeerActionSelectBox(HTMLNode peerForm, boolean advancedModeEnabled) {
        HTMLNode actionSelect = peerForm.addChild("select", new String[]{"id", "name"}, new String[]{"action", "action"});
        actionSelect.addChild("option", "value", "", DarknetConnectionsToadlet.l10n("selectAction"));
        actionSelect.addChild("option", "value", "send_n2ntm", DarknetConnectionsToadlet.l10n("sendMessageToPeers"));
        actionSelect.addChild("option", "value", "update_notes", DarknetConnectionsToadlet.l10n("updateChangedPrivnotes"));
        if (advancedModeEnabled) {
            actionSelect.addChild("option", "value", "enable", DarknetConnectionsToadlet.l10n("peersEnable"));
            actionSelect.addChild("option", "value", "disable", DarknetConnectionsToadlet.l10n("peersDisable"));
            actionSelect.addChild("option", "value", "set_burst_only", DarknetConnectionsToadlet.l10n("peersSetBurstOnly"));
            actionSelect.addChild("option", "value", "clear_burst_only", DarknetConnectionsToadlet.l10n("peersClearBurstOnly"));
            actionSelect.addChild("option", "value", "set_listen_only", DarknetConnectionsToadlet.l10n("peersSetListenOnly"));
            actionSelect.addChild("option", "value", "clear_listen_only", DarknetConnectionsToadlet.l10n("peersClearListenOnly"));
            actionSelect.addChild("option", "value", "set_allow_local", DarknetConnectionsToadlet.l10n("peersSetAllowLocal"));
            actionSelect.addChild("option", "value", "clear_allow_local", DarknetConnectionsToadlet.l10n("peersClearAllowLocal"));
            actionSelect.addChild("option", "value", "set_ignore_source_port", DarknetConnectionsToadlet.l10n("peersSetIgnoreSourcePort"));
            actionSelect.addChild("option", "value", "clear_ignore_source_port", DarknetConnectionsToadlet.l10n("peersClearIgnoreSourcePort"));
            actionSelect.addChild("option", "value", "set_dont_route", DarknetConnectionsToadlet.l10n("peersSetDontRoute"));
            actionSelect.addChild("option", "value", "clear_dont_route", DarknetConnectionsToadlet.l10n("peersClearDontRoute"));
        }
        actionSelect.addChild("option", "value", "", DarknetConnectionsToadlet.l10n("separator"));
        actionSelect.addChild("option", "value", "remove", DarknetConnectionsToadlet.l10n("removePeers"));
        peerForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "doAction", DarknetConnectionsToadlet.l10n("go")});
    }

    @Override
    protected String getPeerListTitle() {
        return DarknetConnectionsToadlet.l10n("myFriends");
    }

    @Override
    protected boolean acceptRefPosts() {
        return true;
    }

    @Override
    protected String defaultRedirectLocation() {
        return "/friends/";
    }

    @Override
    protected void handleAltPost(URI uri, HTTPRequest request, ToadletContext ctx, boolean logMINOR) throws ToadletContextClosedException, IOException, RedirectException {
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("send_n2ntm")) {
            PageNode page = ctx.getPageMaker().getPageNode(DarknetConnectionsToadlet.l10n("sendMessageTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            HashMap<String, String> peers = new HashMap<String, String>();
            for (DarknetPeerNode pn : peerNodes) {
                if (!request.isPartSet("node_" + pn.hashCode())) continue;
                String peer_name = pn.getName();
                String peer_hash = "" + pn.hashCode();
                if (peers.containsKey(peer_hash)) continue;
                peers.put(peer_hash, peer_name);
            }
            N2NTMToadlet.createN2NTMSendForm(pageNode, contentNode, ctx, peers);
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("update_notes")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("peerPrivateNote_" + peerNodes[i].hashCode()) || request.getPartAsString("peerPrivateNote_" + peerNodes[i].hashCode(), 250).equals(peerNodes[i].getPrivateDarknetCommentNote())) continue;
                peerNodes[i].setPrivateDarknetCommentNote(request.getPartAsString("peerPrivateNote_" + peerNodes[i].hashCode(), 250));
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("enable")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].enablePeer();
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("disable")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].disablePeer();
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("set_burst_only")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setBurstOnly(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("clear_burst_only")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setBurstOnly(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("set_ignore_source_port")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setIgnoreSourcePort(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("clear_ignore_source_port")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setIgnoreSourcePort(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("clear_dont_route")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setRoutingStatus(true, true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("set_dont_route")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setRoutingStatus(false, true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("set_listen_only")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setListenOnly(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("clear_listen_only")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setListenOnly(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("set_allow_local")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setAllowLocalAddresses(true);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("clear_allow_local")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                peerNodes[i].setAllowLocalAddresses(false);
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("remove") || request.isPartSet("doAction") && request.getPartAsString("action", 25).equals("remove")) {
            if (logMINOR) {
                Logger.minor(this, "Remove node");
            }
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (request.isPartSet("node_" + peerNodes[i].hashCode())) {
                    if (peerNodes[i].timeLastConnectionCompleted() < System.currentTimeMillis() - 604800000L || peerNodes[i].peerNodeStatus == 6 || request.isPartSet("forceit")) {
                        this.node.removePeerConnection(peerNodes[i]);
                        if (!logMINOR) continue;
                        Logger.minor(this, "Removed node: node_" + peerNodes[i].hashCode());
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Refusing to remove : node_" + peerNodes[i].hashCode() + " (trying to prevent network churn) : let's display the warning message.");
                    }
                    PageNode page = ctx.getPageMaker().getPageNode(DarknetConnectionsToadlet.l10n("confirmRemoveNodeTitle"), ctx);
                    HTMLNode pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    HTMLNode content = ctx.getPageMaker().getInfobox("infobox-warning", DarknetConnectionsToadlet.l10n("confirmRemoveNodeWarningTitle"), contentNode);
                    content.addChild("p").addChild("#", L10n.getString("DarknetConnectionsToadlet.confirmRemoveNode", new String[]{"name"}, new String[]{peerNodes[i].getName()}));
                    HTMLNode removeForm = ctx.addFormChild(content, "/friends/", "removeConfirmForm");
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "node_" + peerNodes[i].hashCode(), "remove"});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove", DarknetConnectionsToadlet.l10n("remove")});
                    removeForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "forceit", DarknetConnectionsToadlet.l10n("forceRemove")});
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                    return;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Part not set: node_" + peerNodes[i].hashCode());
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("acceptTransfer")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                long id = Long.parseLong(request.getPartAsString("id", 32));
                peerNodes[i].acceptTransfer(id);
                break;
            }
            this.redirectHere(ctx);
            return;
        }
        if (request.isPartSet("rejectTransfer")) {
            DarknetPeerNode[] peerNodes = this.node.getDarknetConnections();
            for (int i = 0; i < peerNodes.length; ++i) {
                if (!request.isPartSet("node_" + peerNodes[i].hashCode())) continue;
                long id = Long.parseLong(request.getPartAsString("id", 32));
                peerNodes[i].rejectTransfer(id);
                break;
            }
            this.redirectHere(ctx);
            return;
        }
        this.handleGet(uri, new HTTPRequestImpl(uri, "GET"), ctx);
    }

    private void redirectHere(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", "/friends/");
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    @Override
    protected boolean isOpennet() {
        return false;
    }

    @Override
    ConnectionsToadlet.SimpleColumn[] endColumnHeaders(boolean advancedMode) {
        return null;
    }

    @Override
    public String path() {
        return "/friends/";
    }

    protected class DarknetComparator
    extends ConnectionsToadlet.ComparatorByStatus {
        DarknetComparator(String sortBy, boolean reversed) {
            super(sortBy, reversed);
        }

        protected int customCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode, String sortBy) {
            if (sortBy.equals("name")) {
                return ((DarknetPeerNodeStatus)firstNode).getName().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getName());
            }
            if (sortBy.equals("privnote")) {
                return ((DarknetPeerNodeStatus)firstNode).getPrivateDarknetCommentNote().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getPrivateDarknetCommentNote());
            }
            return super.customCompare(firstNode, secondNode, sortBy);
        }

        protected int lastResortCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            return ((DarknetPeerNodeStatus)firstNode).getName().compareToIgnoreCase(((DarknetPeerNodeStatus)secondNode).getName());
        }
    }
}

