/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.StatisticsToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.PacketThrottle;
import freenet.l10n.L10n;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStats;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.Version;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionsToadlet
extends Toadlet {
    protected final Node node;
    protected final NodeClientCore core;
    protected final NodeStats stats;
    protected final PeerManager peers;
    protected boolean isReversed = false;
    protected final DecimalFormat fix1 = new DecimalFormat("##0.0%");

    @Override
    public String supportedMethods() {
        if (this.acceptRefPosts()) {
            return "GET, POST";
        }
        return "GET";
    }

    protected ConnectionsToadlet(Node n, NodeClientCore core, HighLevelSimpleClient client) {
        super(client);
        this.node = n;
        this.core = core;
        this.stats = n.nodeStats;
        this.peers = n.peers;
    }

    abstract SimpleColumn[] endColumnHeaders(boolean var1);

    @Override
    public void handleGet(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String path = uri.getPath();
        if (path.endsWith("myref.fref")) {
            SimpleFieldSet fs = this.getNoderef();
            StringWriter sw = new StringWriter();
            fs.writeTo(sw);
            MultiValueTable<String, String> extraHeaders = new MultiValueTable<String, String>();
            extraHeaders.put("Content-Disposition", "attachment; filename=myref.fref");
            this.writeReply(ctx, 200, "application/x-freenet-reference", "OK", extraHeaders, sw.toString());
            return;
        }
        if (path.endsWith("myref.txt")) {
            SimpleFieldSet fs = this.getNoderef();
            StringWriter sw = new StringWriter();
            fs.writeTo(sw);
            this.writeTextReply(ctx, 200, "OK", sw.toString());
            return;
        }
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        boolean fProxyJavascriptEnabled = this.node.isFProxyJavascriptEnabled();
        boolean drawMessageTypes = path.endsWith("displaymessagetypes.html");
        PeerNodeStatus[] peerNodeStatuses = this.getPeerNodeStatuses(!drawMessageTypes);
        Arrays.sort(peerNodeStatuses, this.comparator(request.getParam("sortBy", null), request.isParameterSet("reversed")));
        int numberOfConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 1);
        int numberOfRoutingBackedOff = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 2);
        int numberOfTooNew = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 3);
        int numberOfTooOld = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 4);
        int numberOfDisconnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 5);
        int numberOfNeverConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 6);
        int numberOfDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 7);
        int numberOfBursting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 8);
        int numberOfListening = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 9);
        int numberOfListenOnly = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 10);
        int numberOfClockProblem = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 11);
        int numberOfConnError = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 12);
        int numberOfDisconnecting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 13);
        int numberOfRoutingDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 14);
        int numberOfSimpleConnected = numberOfConnected + numberOfRoutingBackedOff;
        int numberOfNotConnected = numberOfTooNew + numberOfTooOld + numberOfDisconnected + numberOfNeverConnected + numberOfDisabled + numberOfBursting + numberOfListening + numberOfListenOnly + numberOfClockProblem + numberOfConnError;
        String titleCountString = null;
        titleCountString = this.node.isAdvancedModeEnabled() ? "(" + numberOfConnected + '/' + numberOfRoutingBackedOff + '/' + numberOfTooNew + '/' + numberOfTooOld + '/' + numberOfRoutingDisabled + '/' + numberOfNotConnected + ')' : (numberOfNotConnected + numberOfSimpleConnected > 0 ? String.valueOf(numberOfSimpleConnected) : "");
        PageNode page = ctx.getPageMaker().getPageNode(this.getPageTitle(titleCountString, this.node.getMyName()), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        long now = System.currentTimeMillis();
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(this.core.alerts.createSummary());
        }
        int mode = ctx.getPageMaker().drawModeSelectionArray(this.core, request, contentNode);
        if (peerNodeStatuses.length > 0) {
            if (mode >= 2) {
                long nodeUptimeSeconds = (now - this.node.startupTime) / 1000L;
                int bwlimitDelayTime = (int)this.stats.getBwlimitDelayTime();
                int nodeAveragePingTime = (int)this.stats.getNodeAveragePingTime();
                int networkSizeEstimateSession = this.stats.getDarknetSizeEstimate(-1L);
                int networkSizeEstimateRecent = 0;
                if (nodeUptimeSeconds > 172800L) {
                    networkSizeEstimateRecent = this.stats.getDarknetSizeEstimate(now - 172800000L);
                }
                DecimalFormat fix4 = new DecimalFormat("0.0000");
                double routingMissDistance = this.stats.routingMissDistance.currentValue();
                double backedOffPercent = this.stats.backedOffPercent.currentValue();
                String nodeUptimeString = TimeUtil.formatTime(nodeUptimeSeconds * 1000L);
                HTMLNode overviewTable = contentNode.addChild("table", "class", "column");
                HTMLNode overviewTableRow = overviewTable.addChild("tr");
                HTMLNode nextTableCell = overviewTableRow.addChild("td", "class", "first");
                HTMLNode overviewInfobox = nextTableCell.addChild("div", "class", "infobox");
                overviewInfobox.addChild("div", "class", "infobox-header", "Node status overview");
                HTMLNode overviewInfoboxContent = overviewInfobox.addChild("div", "class", "infobox-content");
                HTMLNode overviewList = overviewInfoboxContent.addChild("ul");
                overviewList.addChild("li", "bwlimitDelayTime:\u00a0" + bwlimitDelayTime + "ms");
                overviewList.addChild("li", "nodeAveragePingTime:\u00a0" + nodeAveragePingTime + "ms");
                overviewList.addChild("li", "darknetSizeEstimateSession:\u00a0" + networkSizeEstimateSession + "\u00a0nodes");
                if (nodeUptimeSeconds > 172800L) {
                    overviewList.addChild("li", "darknetSizeEstimateRecent:\u00a0" + networkSizeEstimateRecent + "\u00a0nodes");
                }
                overviewList.addChild("li", "nodeUptime:\u00a0" + nodeUptimeString);
                overviewList.addChild("li", "routingMissDistance:\u00a0" + fix4.format(routingMissDistance));
                overviewList.addChild("li", "backedOffPercent:\u00a0" + this.fix1.format(backedOffPercent));
                overviewList.addChild("li", "pInstantReject:\u00a0" + this.fix1.format(this.stats.pRejectIncomingInstantly()));
                nextTableCell = overviewTableRow.addChild("td");
                int numARKFetchers = this.node.getNumARKFetchers();
                HTMLNode activityInfobox = nextTableCell.addChild("div", "class", "infobox");
                activityInfobox.addChild("div", "class", "infobox-header", ConnectionsToadlet.l10n("activityTitle"));
                HTMLNode activityInfoboxContent = activityInfobox.addChild("div", "class", "infobox-content");
                HTMLNode activityList = StatisticsToadlet.drawActivity(activityInfoboxContent, this.node);
                if (mode >= 2 && activityList != null) {
                    if (numARKFetchers > 0) {
                        activityList.addChild("li", "ARK\u00a0Fetch\u00a0Requests:\u00a0" + numARKFetchers);
                    }
                    StatisticsToadlet.drawBandwidth(activityList, this.node, nodeUptimeSeconds, mode >= 2);
                }
                nextTableCell = mode >= 2 ? overviewTableRow.addChild("td") : overviewTableRow.addChild("td", "class", "last");
                HTMLNode peerStatsInfobox = nextTableCell.addChild("div", "class", "infobox");
                StatisticsToadlet.drawPeerStatsBox(peerStatsInfobox, mode >= 2, numberOfConnected, numberOfRoutingBackedOff, numberOfTooNew, numberOfTooOld, numberOfDisconnected, numberOfNeverConnected, numberOfDisabled, numberOfBursting, numberOfListening, numberOfListenOnly, 0, 0, numberOfRoutingDisabled, numberOfClockProblem, numberOfConnError, numberOfDisconnecting);
                if (mode >= 2) {
                    nextTableCell = overviewTableRow.addChild("td", "class", "last");
                    HTMLNode backoffReasonInfobox = nextTableCell.addChild("div", "class", "infobox");
                    backoffReasonInfobox.addChild("div", "class", "infobox-header", "Peer backoff reasons");
                    HTMLNode backoffReasonContent = backoffReasonInfobox.addChild("div", "class", "infobox-content");
                    String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons();
                    if (routingBackoffReasons.length == 0) {
                        backoffReasonContent.addChild("#", "Good, your node is not backed off from any peers!");
                    } else {
                        HTMLNode reasonList = backoffReasonContent.addChild("ul");
                        for (int i = 0; i < routingBackoffReasons.length; ++i) {
                            int reasonCount = this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReasons[i]);
                            if (reasonCount <= 0) continue;
                            reasonList.addChild("li", routingBackoffReasons[i] + '\u00a0' + reasonCount);
                        }
                    }
                }
            }
            boolean enablePeerActions = this.showPeerActionsBox();
            if (fProxyJavascriptEnabled) {
                StringBuilder jsBuf = new StringBuilder();
                jsBuf.append("  function peerNoteChange() {\n");
                jsBuf.append("    var theobj = document.getElementById( \"action\" );\n");
                jsBuf.append("    var length = theobj.options.length;\n");
                jsBuf.append("    for (var i = 0; i < length; i++) {\n");
                jsBuf.append("      if(theobj.options[i] == \"update_notes\") {\n");
                jsBuf.append("        theobj.options[i].select = true;\n");
                jsBuf.append("      } else {\n");
                jsBuf.append("        theobj.options[i].select = false;\n");
                jsBuf.append("      }\n");
                jsBuf.append("    }\n");
                jsBuf.append("    theobj.value=\"update_notes\";\n");
                jsBuf.append("    document.getElementById( \"peersForm\" ).doAction.click();\n");
                jsBuf.append("  }\n");
                jsBuf.append("  function peerNoteBlur() {\n");
                jsBuf.append("    var theobj = document.getElementById( \"action\" );\n");
                jsBuf.append("    var length = theobj.options.length;\n");
                jsBuf.append("    for (var i = 0; i < length; i++) {\n");
                jsBuf.append("      if(theobj.options[i] == \"update_notes\") {\n");
                jsBuf.append("        theobj.options[i].select = true;\n");
                jsBuf.append("      } else {\n");
                jsBuf.append("        theobj.options[i].select = false;\n");
                jsBuf.append("      }\n");
                jsBuf.append("    }\n");
                jsBuf.append("    theobj.value=\"update_notes\";\n");
                jsBuf.append("  }\n");
                contentNode.addChild("script", "type", "text/javascript").addChild("%", jsBuf.toString());
            }
            HTMLNode peerTableInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
            HTMLNode peerTableInfoboxHeader = peerTableInfobox.addChild("div", "class", "infobox-header");
            peerTableInfoboxHeader.addChild("#", this.getPeerListTitle());
            if (mode >= 2 && !path.endsWith("displaymessagetypes.html")) {
                peerTableInfoboxHeader.addChild("#", " ");
                peerTableInfoboxHeader.addChild("a", "href", "displaymessagetypes.html", "(more detailed)");
            }
            HTMLNode peerTableInfoboxContent = peerTableInfobox.addChild("div", "class", "infobox-content");
            if (peerNodeStatuses.length == 0) {
                L10n.addL10nSubstitution(peerTableInfoboxContent, "DarknetConnectionsToadlet.noPeersWithHomepageLink", new String[]{"link", "/link"}, new String[]{"<a href=\"/\">", "</a>"});
            } else {
                SimpleColumn[] endCols;
                HTMLNode peerTable;
                HTMLNode peerForm = null;
                if (enablePeerActions) {
                    peerForm = ctx.addFormChild(peerTableInfoboxContent, ".", "peersForm");
                    peerTable = peerForm.addChild("table", "class", "darknet_connections");
                } else {
                    peerTable = peerTableInfoboxContent.addChild("table", "class", "darknet_connections");
                }
                HTMLNode peerTableHeaderRow = peerTable.addChild("tr");
                if (enablePeerActions) {
                    peerTableHeaderRow.addChild("th");
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "status")).addChild("#", ConnectionsToadlet.l10n("statusTitle"));
                if (this.hasNameColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "name")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("nameClickToMessage"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("nameTitle"));
                }
                if (mode >= 2) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "address")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("ipAddress"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("ipAddressTitle"));
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "version")).addChild("#", ConnectionsToadlet.l10n("versionTitle"));
                if (mode >= 2) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "location")).addChild("#", "Location");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "backoff")).addChild("span", new String[]{"title", "style"}, new String[]{"Other node busy? Display: Percentage of time the node is overloaded, Current wait time remaining (0=not overloaded)/total/last overload reason", "border-bottom: 1px dotted; cursor: help;"}, "Backoff");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "overload_p")).addChild("span", new String[]{"title", "style"}, new String[]{"Probability of the node rejecting a request due to overload or causing a timeout.", "border-bottom: 1px dotted; cursor: help;"}, "Overload Probability");
                }
                peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "idle")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("idleTime"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("idleTimeTitle"));
                if (this.hasPrivateNoteColumn()) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "privnote")).addChild("span", new String[]{"title", "style"}, new String[]{ConnectionsToadlet.l10n("privateNote"), "border-bottom: 1px dotted; cursor: help;"}, ConnectionsToadlet.l10n("privateNoteTitle"));
                }
                if (mode >= 2) {
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "time_routable")).addChild("#", "%\u00a0Time Routable");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "selection_percentage")).addChild("#", "%\u00a0Selection");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "total_traffic")).addChild("#", "Total\u00a0Traffic\u00a0(in/out/resent)");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "total_traffic_since_startup")).addChild("#", "Total\u00a0Traffic\u00a0(in/out) since startup");
                    peerTableHeaderRow.addChild("th", "Congestion\u00a0Control");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "time_delta")).addChild("#", "Time\u00a0Delta");
                    peerTableHeaderRow.addChild("th").addChild("a", "href", this.sortString(this.isReversed, "uptime")).addChild("#", "Reported\u00a0Uptime");
                }
                if ((endCols = this.endColumnHeaders(mode >= 2)) != null) {
                    for (int i = 0; i < endCols.length; ++i) {
                        SimpleColumn col = endCols[i];
                        HTMLNode header = peerTableHeaderRow.addChild("th");
                        String sortString = col.getSortString();
                        if (sortString != null) {
                            header = header.addChild("a", "href", this.sortString(this.isReversed, sortString));
                        }
                        header.addChild("span", new String[]{"title", "style"}, new String[]{L10n.getString(col.getExplanationKey()), "border-bottom: 1px dotted; cursor: help;"}, L10n.getString(col.getTitleKey()));
                    }
                }
                double totalSelectionRate = 0.0;
                for (PeerNodeStatus status : peerNodeStatuses) {
                    totalSelectionRate += status.getSelectionRate();
                }
                for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
                    this.drawRow(peerTable, peerNodeStatus, mode >= 2, fProxyJavascriptEnabled, now, path, enablePeerActions, endCols, drawMessageTypes, totalSelectionRate);
                }
                if (peerForm != null) {
                    this.drawPeerActionSelectBox(peerForm, mode >= 2);
                }
            }
        } else if (!this.isOpennet()) {
            try {
                throw new RedirectException("/addfriend/");
            }
            catch (URISyntaxException e) {
                Logger.error(this, "Impossible: " + e + " for /addfriend/", e);
            }
        }
        if (this.shouldDrawNoderefBox(mode >= 2)) {
            this.drawAddPeerBox(contentNode, ctx);
            this.drawNoderefBox(contentNode, ctx);
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    protected abstract boolean acceptRefPosts();

    protected abstract String defaultRedirectLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        int idx;
        StringBuilder ref;
        String privateComment;
        block20: {
            boolean logMINOR = Logger.shouldLog(4, this);
            if (!this.acceptRefPosts()) {
                super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
                return;
            }
            if (!ctx.isAllowedFullAccess()) {
                super.sendErrorPage(ctx, 403, "Unauthorized", L10n.getString("Toadlet.unauthorized"));
                return;
            }
            String pass = request.getPartAsString("formPassword", 32);
            if (pass == null || !pass.equals(this.core.formPassword)) {
                MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                headers.put("Location", this.defaultRedirectLocation());
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                if (!logMINOR) return;
                Logger.minor(this, "No password (" + pass + " should be " + this.core.formPassword + ')');
                return;
            }
            if (!request.isPartSet("add")) {
                this.handleAltPost(uri, request, ctx, logMINOR);
                return;
            }
            String urltext = request.getPartAsString("url", 200);
            urltext = urltext.trim();
            String reftext = request.getPartAsString("ref", Integer.MAX_VALUE);
            if ((reftext = reftext.trim()).length() < 200) {
                reftext = request.getPartAsString("reffile", Integer.MAX_VALUE);
                reftext = reftext.trim();
            }
            privateComment = null;
            if (!this.isOpennet()) {
                privateComment = request.getPartAsString("peerPrivateNote", 250).trim();
            }
            ref = new StringBuilder(1024);
            if (urltext.length() > 0) {
                BufferedReader in = null;
                try {
                    try {
                        String line;
                        URL url = new URL(urltext);
                        URLConnection uc = url.openConnection();
                        in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                        while ((line = in.readLine()) != null) {
                            ref.append(line).append('\n');
                        }
                        Object var15_19 = null;
                        if (in == null) break block20;
                    }
                    catch (IOException e) {
                        this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("failedToAddNodeTitle"), L10n.getString("DarknetConnectionsToadlet.cantFetchNoderefURL", new String[]{"url"}, new String[]{urltext}));
                        Object var15_20 = null;
                        if (in == null) return;
                        in.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            } else {
                if (reftext.length() <= 0) {
                    this.sendErrorPage(ctx, 200, ConnectionsToadlet.l10n("failedToAddNodeTitle"), ConnectionsToadlet.l10n("noRefOrURL"));
                    request.freeParts();
                    return;
                }
                ref = new StringBuilder(reftext.replaceAll(".*?((?:[\\w,\\.]+\\=[^\r\n]+?)|(?:End))[ \\t]*(?:\\r?\\n)+", "$1\n"));
            }
        }
        ref = new StringBuilder(ref.toString().trim());
        request.freeParts();
        while ((idx = ref.indexOf("\r\n")) > -1) {
            ref.deleteCharAt(idx);
        }
        while ((idx = ref.indexOf("\r")) > -1) {
            ref.setCharAt(idx, '\n');
        }
        String[] nodesToAdd = ref.toString().split("\nEnd\n");
        HashMap<PeerAdditionReturnCodes, Integer> results = new HashMap<PeerAdditionReturnCodes, Integer>();
        for (int i = 0; i < nodesToAdd.length; ++i) {
            PeerAdditionReturnCodes result = this.addNewNode(nodesToAdd[i].trim().concat("\nEnd"), privateComment);
            if (!results.containsKey((Object)result)) {
                results.put(result, 0);
            }
            results.put(result, (Integer)results.get((Object)result) + 1);
        }
        PageNode page = ctx.getPageMaker().getPageNode(ConnectionsToadlet.l10n("reportOfNodeAddition"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode detailedStatusBox = new HTMLNode("table");
        detailedStatusBox.addChild(new HTMLNode("tr")).addChildren(new HTMLNode[]{new HTMLNode("th", ConnectionsToadlet.l10n("resultName")), new HTMLNode("th", ConnectionsToadlet.l10n("numOfResults"))});
        HTMLNode statusBoxTable = detailedStatusBox.addChild(new HTMLNode("tbody"));
        for (PeerAdditionReturnCodes returnCode : PeerAdditionReturnCodes.values()) {
            if (!results.containsKey((Object)returnCode)) continue;
            statusBoxTable.addChild(new HTMLNode("tr", "style", "color:" + (returnCode == PeerAdditionReturnCodes.OK ? "green" : "red"))).addChildren(new HTMLNode[]{new HTMLNode("td", ConnectionsToadlet.l10n("peerAdditionCode." + returnCode.toString())), new HTMLNode("td", ((Integer)results.get((Object)returnCode)).toString())});
        }
        HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox", ConnectionsToadlet.l10n("reportOfNodeAddition"), contentNode);
        infoboxContent.addChild(detailedStatusBox);
        if (!this.isOpennet()) {
            infoboxContent.addChild("p").addChild("a", "href", "/addfriend/", ConnectionsToadlet.l10n("addAnotherFriend"));
        }
        infoboxContent.addChild("p").addChild("a", "href", this.path(), ConnectionsToadlet.l10n("goFriendConnectionStatus"));
        ConnectionsToadlet.addHomepageLink(infoboxContent.addChild("p"));
        this.writeHTMLReply(ctx, 500, ConnectionsToadlet.l10n("reportOfNodeAddition"), pageNode.generate());
    }

    private PeerAdditionReturnCodes addNewNode(String nodeReference, String privateComment) {
        PeerNode pn;
        SimpleFieldSet fs;
        try {
            nodeReference = Fields.trimLines(nodeReference);
            fs = new SimpleFieldSet(nodeReference, false, true);
            if (!fs.getEndMarker().endsWith("End")) {
                return PeerAdditionReturnCodes.WRONG_ENCODING;
            }
            fs.setEndMarker("End");
        }
        catch (IOException e) {
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (Throwable t) {
            return PeerAdditionReturnCodes.INTERNAL_ERROR;
        }
        try {
            if (this.isOpennet()) {
                pn = this.node.createNewOpennetNode(fs);
            } else {
                pn = this.node.createNewDarknetNode(fs);
                ((DarknetPeerNode)pn).setPrivateDarknetCommentNote(privateComment);
            }
        }
        catch (FSParseException e1) {
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (PeerParseException e1) {
            return PeerAdditionReturnCodes.CANT_PARSE;
        }
        catch (ReferenceSignatureVerificationException e1) {
            return PeerAdditionReturnCodes.INVALID_SIGNATURE;
        }
        catch (Throwable t) {
            return PeerAdditionReturnCodes.INTERNAL_ERROR;
        }
        if (Arrays.equals(pn.getIdentity(), this.node.getDarknetIdentity())) {
            return PeerAdditionReturnCodes.TRY_TO_ADD_SELF;
        }
        if (!this.node.addPeerConnection(pn)) {
            return PeerAdditionReturnCodes.ALREADY_IN_REFERENCE;
        }
        return PeerAdditionReturnCodes.OK;
    }

    protected abstract boolean isOpennet();

    protected void handleAltPost(URI uri, HTTPRequest request, ToadletContext ctx, boolean logMINOR) throws ToadletContextClosedException, IOException, RedirectException {
        this.handleGet(uri, new HTTPRequestImpl(uri, "GET"), ctx);
    }

    protected abstract String getPeerListTitle();

    protected abstract boolean showPeerActionsBox();

    protected abstract void drawPeerActionSelectBox(HTMLNode var1, boolean var2);

    protected abstract boolean shouldDrawNoderefBox(boolean var1);

    private void drawNoderefBox(HTMLNode contentNode, ToadletContext ctx) {
        ConnectionsToadlet.drawNoderefBox(contentNode, ctx, this.getNoderef());
    }

    static void drawNoderefBox(HTMLNode contentNode, ToadletContext ctx, SimpleFieldSet fs) {
        HTMLNode referenceInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        HTMLNode headerReferenceInfobox = referenceInfobox.addChild("div", "class", "infobox-header");
        L10n.addL10nSubstitution(headerReferenceInfobox, "DarknetConnectionsToadlet.myReferenceHeader", new String[]{"linkref", "/linkref", "linktext", "/linktext"}, new String[]{"<a href=\"myref.fref\">", "</a>", "<a href=\"myref.txt\">", "</a>"});
        HTMLNode referenceInfoboxContent = referenceInfobox.addChild("div", "class", "infobox-content");
        HTMLNode warningSentence = referenceInfoboxContent.addChild("p");
        L10n.addL10nSubstitution(warningSentence, "DarknetConnectionsToadlet.referenceCopyWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
        referenceInfoboxContent.addChild("pre", "id", "reference", fs.toString() + '\n');
    }

    protected abstract String getPageTitle(String var1, String var2);

    protected void drawAddPeerBox(HTMLNode contentNode, ToadletContext ctx) {
        ConnectionsToadlet.drawAddPeerBox(contentNode, ctx, this.isOpennet(), this.path());
    }

    protected static void drawAddPeerBox(HTMLNode contentNode, ToadletContext ctx, boolean isOpennet, String formTarget) {
        HTMLNode peerAdditionInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        peerAdditionInfobox.addChild("div", "class", "infobox-header", ConnectionsToadlet.l10n("addPeerTitle"));
        HTMLNode peerAdditionContent = peerAdditionInfobox.addChild("div", "class", "infobox-content");
        HTMLNode peerAdditionForm = ctx.addFormChild(peerAdditionContent, formTarget, "addPeerForm");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("pasteReference"));
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("textarea", new String[]{"id", "name", "rows", "cols"}, new String[]{"reftext", "ref", "8", "74"});
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("urlReference") + ' ');
        peerAdditionForm.addChild("input", new String[]{"id", "type", "name"}, new String[]{"refurl", "text", "url"});
        peerAdditionForm.addChild("br");
        peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("fileReference") + ' ');
        peerAdditionForm.addChild("input", new String[]{"id", "type", "name"}, new String[]{"reffile", "file", "reffile"});
        peerAdditionForm.addChild("br");
        if (!isOpennet) {
            peerAdditionForm.addChild("#", ConnectionsToadlet.l10n("enterDescription") + ' ');
            peerAdditionForm.addChild("input", new String[]{"id", "type", "name", "size", "maxlength", "value"}, new String[]{"peerPrivateNote", "text", "peerPrivateNote", "16", "250", ""});
            peerAdditionForm.addChild("br");
        }
        peerAdditionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "add", ConnectionsToadlet.l10n("add")});
    }

    protected Comparator<PeerNodeStatus> comparator(String sortBy, boolean reversed) {
        return new ComparatorByStatus(sortBy, reversed);
    }

    protected abstract PeerNodeStatus[] getPeerNodeStatuses(boolean var1);

    protected abstract SimpleFieldSet getNoderef();

    private void drawRow(HTMLNode peerTable, PeerNodeStatus peerNodeStatus, boolean advancedModeEnabled, boolean fProxyJavascriptEnabled, long now, String path, boolean enablePeerActions, SimpleColumn[] endCols, boolean drawMessageTypes, double totalSelectionRate) {
        double selectionRate = peerNodeStatus.getSelectionRate();
        int peerSelectionPercentage = 0;
        if (totalSelectionRate > 0.0) {
            peerSelectionPercentage = (int)(selectionRate * 100.0 / totalSelectionRate);
        }
        HTMLNode peerRow = peerTable.addChild("tr", "class", "darknet_connections_" + (peerSelectionPercentage > 30 ? "warning" : "normal"));
        if (enablePeerActions) {
            peerRow.addChild("td", "class", "peer-marker").addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "node_" + peerNodeStatus.hashCode()});
        }
        String statusString = peerNodeStatus.getStatusName();
        if (!advancedModeEnabled && peerNodeStatus.getStatusValue() == 2) {
            statusString = "BUSY";
        }
        peerRow.addChild("td", "class", "peer-status").addChild("span", "class", peerNodeStatus.getStatusCSSName(), L10n.getString("ConnectionsToadlet.nodeStatus." + statusString) + (peerNodeStatus.isFetchingARK() ? "*" : ""));
        this.drawNameColumn(peerRow, peerNodeStatus);
        if (advancedModeEnabled) {
            String pingTime = "";
            if (peerNodeStatus.isConnected()) {
                pingTime = " (" + (int)peerNodeStatus.getAveragePingTime() + "ms)";
            }
            peerRow.addChild("td", "class", "peer-address").addChild("#", (peerNodeStatus.getPeerAddress() != null ? peerNodeStatus.getPeerAddress() + ':' + peerNodeStatus.getPeerPort() : ConnectionsToadlet.l10n("unknownAddress")) + pingTime);
        }
        if (peerNodeStatus.getStatusValue() != 6 && (peerNodeStatus.isPublicInvalidVersion() || peerNodeStatus.isPublicReverseInvalidVersion())) {
            peerRow.addChild("td", "class", "peer-version").addChild("span", "class", "peer_version_problem", Integer.toString(peerNodeStatus.getSimpleVersion()));
        } else {
            peerRow.addChild("td", "class", "peer-version").addChild("#", Integer.toString(peerNodeStatus.getSimpleVersion()));
        }
        if (advancedModeEnabled) {
            HTMLNode locationNode = peerRow.addChild("td", "class", "peer-location");
            locationNode.addChild("b", String.valueOf(peerNodeStatus.getLocation()));
            locationNode.addChild("br");
            double[] peersLoc = peerNodeStatus.getPeersLocation();
            if (peersLoc != null) {
                for (double loc : peersLoc) {
                    locationNode.addChild("i", String.valueOf(loc)).addChild("br");
                }
            }
        }
        if (advancedModeEnabled) {
            HTMLNode backoffCell = peerRow.addChild("td", "class", "peer-backoff");
            backoffCell.addChild("#", this.fix1.format(peerNodeStatus.getBackedOffPercent()));
            int backoff = (int)Math.max(peerNodeStatus.getRoutingBackedOffUntil() - now, 0L);
            if (backoff > 0 && backoff < 1000) {
                backoff = 1000;
            }
            backoffCell.addChild("#", ' ' + String.valueOf(backoff / 1000) + '/' + String.valueOf(peerNodeStatus.getRoutingBackoffLength() / 1000));
            backoffCell.addChild("#", peerNodeStatus.getLastBackoffReason() == null ? "" : '/' + peerNodeStatus.getLastBackoffReason());
            HTMLNode pRejectCell = peerRow.addChild("td", "class", "peer-backoff");
            pRejectCell.addChild("#", this.fix1.format(peerNodeStatus.getPReject()));
        }
        long idle = peerNodeStatus.getTimeLastRoutable();
        if (peerNodeStatus.isRoutable()) {
            idle = peerNodeStatus.getTimeLastConnectionCompleted();
        } else if (peerNodeStatus.getStatusValue() == 6) {
            idle = peerNodeStatus.getPeerAddedTime();
        }
        if (!peerNodeStatus.isConnected() && now - idle > 1209600000L) {
            peerRow.addChild("td", "class", "peer-idle").addChild("span", "class", "peer_idle_old", this.idleToString(now, idle));
        } else {
            peerRow.addChild("td", "class", "peer-idle", this.idleToString(now, idle));
        }
        if (this.hasPrivateNoteColumn()) {
            this.drawPrivateNoteColumn(peerRow, peerNodeStatus, fProxyJavascriptEnabled);
        }
        if (advancedModeEnabled) {
            peerRow.addChild("td", "class", "peer-idle").addChild("#", this.fix1.format(peerNodeStatus.getPercentTimeRoutableConnection()));
            peerRow.addChild("td", "class", "peer-idle").addChild("#", totalSelectionRate > 0.0 ? peerSelectionPercentage + "%" : "N/A");
            peerRow.addChild("td", "class", "peer-idle").addChild("#", SizeUtil.formatSize(peerNodeStatus.getTotalInputBytes()) + " / " + SizeUtil.formatSize(peerNodeStatus.getTotalOutputBytes()) + "/" + SizeUtil.formatSize(peerNodeStatus.getResendBytesSent()));
            peerRow.addChild("td", "class", "peer-idle").addChild("#", SizeUtil.formatSize(peerNodeStatus.getTotalInputSinceStartup()) + " / " + SizeUtil.formatSize(peerNodeStatus.getTotalOutputSinceStartup()));
            PacketThrottle t = peerNodeStatus.getThrottle();
            String val = t == null ? "none" : (int)(1000.0 / (double)t.getDelay() * 1024.0) + "B/sec delay " + t.getDelay() + "ms (RTT " + t.getRoundTripTime() + "ms window " + t.getWindowSize() + ')';
            peerRow.addChild("td", "class", "peer-idle").addChild("#", val);
            peerRow.addChild("td", "class", "peer-idle").addChild("#", TimeUtil.formatTime(peerNodeStatus.getClockDelta()));
            peerRow.addChild("td", "class", "peer-idle").addChild("#", peerNodeStatus.getReportedUptimePercentage() + "%");
        }
        if (endCols != null) {
            for (int i = 0; i < endCols.length; ++i) {
                endCols[i].drawColumn(peerRow, peerNodeStatus);
            }
        }
        if (drawMessageTypes) {
            this.drawMessageTypes(peerTable, peerNodeStatus);
        }
    }

    protected abstract boolean hasNameColumn();

    protected abstract void drawNameColumn(HTMLNode var1, PeerNodeStatus var2);

    protected abstract boolean hasPrivateNoteColumn();

    protected abstract void drawPrivateNoteColumn(HTMLNode var1, PeerNodeStatus var2, boolean var3);

    private void drawMessageTypes(HTMLNode peerTable, PeerNodeStatus peerNodeStatus) {
        Long messageCount;
        String messageName;
        HTMLNode messageCountRow = peerTable.addChild("tr", "class", "message-status");
        messageCountRow.addChild("td", "colspan", "2");
        HTMLNode messageCountCell = messageCountRow.addChild("td", "colspan", "9");
        HTMLNode messageCountTable = messageCountCell.addChild("table", "class", "message-count");
        HTMLNode countHeaderRow = messageCountTable.addChild("tr");
        countHeaderRow.addChild("th", "Message");
        countHeaderRow.addChild("th", "Incoming");
        countHeaderRow.addChild("th", "Outgoing");
        ArrayList<String> messageNames = new ArrayList<String>();
        HashMap<String, Long[]> messageCounts = new HashMap<String, Long[]>();
        for (Map.Entry<String, Long> entry : peerNodeStatus.getLocalMessagesReceived().entrySet()) {
            messageName = entry.getKey();
            messageCount = entry.getValue();
            messageNames.add(messageName);
            messageCounts.put(messageName, new Long[]{messageCount, 0L});
        }
        for (Map.Entry<String, Long> entry : peerNodeStatus.getLocalMessagesSent().entrySet()) {
            Long[] existingCounts;
            messageName = entry.getKey();
            messageCount = entry.getValue();
            if (!messageNames.contains(messageName)) {
                messageNames.add(messageName);
            }
            if ((existingCounts = (Long[])messageCounts.get(messageName)) == null) {
                messageCounts.put(messageName, new Long[]{0L, messageCount});
                continue;
            }
            existingCounts[1] = messageCount;
        }
        Collections.sort(messageNames, new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return first.compareToIgnoreCase(second);
            }
        });
        for (String messageName2 : messageNames) {
            Long[] messageCount2 = (Long[])messageCounts.get(messageName2);
            HTMLNode messageRow = messageCountTable.addChild("tr");
            messageRow.addChild("td", messageName2);
            messageRow.addChild("td", "class", "right-align", String.valueOf(messageCount2[0]));
            messageRow.addChild("td", "class", "right-align", String.valueOf(messageCount2[1]));
        }
    }

    private String idleToString(long now, long idle) {
        if (idle <= 0L) {
            return " ";
        }
        long idleMilliseconds = now - idle;
        return TimeUtil.formatTime(idleMilliseconds);
    }

    private static String l10n(String string) {
        return L10n.getString("DarknetConnectionsToadlet." + string);
    }

    private String sortString(boolean isReversed, String type) {
        return isReversed ? "?sortBy=" + type : "?sortBy=" + type + "&reversed";
    }

    abstract class SimpleColumn {
        SimpleColumn() {
        }

        protected abstract void drawColumn(HTMLNode var1, PeerNodeStatus var2);

        public abstract String getSortString();

        public abstract String getTitleKey();

        public abstract String getExplanationKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PeerAdditionReturnCodes {
        OK,
        WRONG_ENCODING,
        CANT_PARSE,
        INTERNAL_ERROR,
        INVALID_SIGNATURE,
        TRY_TO_ADD_SELF,
        ALREADY_IN_REFERENCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ComparatorByStatus
    implements Comparator<PeerNodeStatus> {
        protected final String sortBy;
        protected final boolean reversed;

        ComparatorByStatus(String sortBy, boolean reversed) {
            this.sortBy = sortBy;
            this.reversed = reversed;
        }

        @Override
        public int compare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            int result = 0;
            boolean isSet = true;
            isSet = this.sortBy != null ? (result = this.customCompare(firstNode, secondNode, this.sortBy)) != 0 : false;
            if (!isSet) {
                int statusDifference = firstNode.getStatusValue() - secondNode.getStatusValue();
                result = statusDifference != 0 ? (statusDifference < 0 ? -1 : 1) : this.lastResortCompare(firstNode, secondNode);
            }
            if (result == 0) {
                return 0;
            }
            if (this.reversed) {
                ConnectionsToadlet.this.isReversed = true;
                return result > 0 ? -1 : 1;
            }
            ConnectionsToadlet.this.isReversed = false;
            return result < 0 ? -1 : 1;
        }

        private int compareLongs(long long1, long long2) {
            int diff = Long.valueOf(long1).compareTo(long2);
            if (diff == 0) {
                return 0;
            }
            return diff > 0 ? 1 : -1;
        }

        private int compareInts(int int1, int int2) {
            int diff = Integer.valueOf(int1).compareTo(int2);
            if (diff == 0) {
                return 0;
            }
            return diff > 0 ? 1 : -1;
        }

        protected int customCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode, String sortBy2) {
            if (this.sortBy.equals("address")) {
                return firstNode.getPeerAddress().compareToIgnoreCase(secondNode.getPeerAddress());
            }
            if (this.sortBy.equals("location")) {
                return this.compareLocations(firstNode, secondNode);
            }
            if (this.sortBy.equals("version")) {
                return Version.getArbitraryBuildNumber(firstNode.getVersion(), -1) - Version.getArbitraryBuildNumber(secondNode.getVersion(), -1);
            }
            if (this.sortBy.equals("backoff")) {
                return Double.compare(firstNode.getBackedOffPercent(), secondNode.getBackedOffPercent());
            }
            if (this.sortBy.equals("overload_p")) {
                return Double.compare(firstNode.getPReject(), secondNode.getPReject());
            }
            if (this.sortBy.equals("idle")) {
                return this.compareLongs(firstNode.getTimeLastConnectionCompleted(), secondNode.getTimeLastConnectionCompleted());
            }
            if (this.sortBy.equals("time_routable")) {
                return Double.compare(firstNode.getPercentTimeRoutableConnection(), secondNode.getPercentTimeRoutableConnection());
            }
            if (this.sortBy.equals("total_traffic")) {
                long total1 = firstNode.getTotalInputBytes() + firstNode.getTotalOutputBytes();
                long total2 = secondNode.getTotalInputBytes() + secondNode.getTotalOutputBytes();
                return this.compareLongs(total1, total2);
            }
            if (this.sortBy.equals("total_traffic_since_startup")) {
                long total1 = firstNode.getTotalInputSinceStartup() + firstNode.getTotalOutputSinceStartup();
                long total2 = secondNode.getTotalInputSinceStartup() + secondNode.getTotalOutputSinceStartup();
                return this.compareLongs(total1, total2);
            }
            if (this.sortBy.equals("selection_percentage")) {
                return Double.compare(firstNode.getSelectionRate(), secondNode.getSelectionRate());
            }
            if (this.sortBy.equals("time_delta")) {
                return this.compareLongs(firstNode.getClockDelta(), secondNode.getClockDelta());
            }
            if (this.sortBy.equals("uptime")) {
                return this.compareInts(firstNode.getReportedUptimePercentage(), secondNode.getReportedUptimePercentage());
            }
            return 0;
        }

        private int compareLocations(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            double diff = firstNode.getLocation() - secondNode.getLocation();
            if (9.9E-324 > Math.abs(diff)) {
                return 0;
            }
            return diff > 0.0 ? 1 : -1;
        }

        protected int lastResortCompare(PeerNodeStatus firstNode, PeerNodeStatus secondNode) {
            return this.compareLocations(firstNode, secondNode);
        }
    }
}

