/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.config.BooleanOption;
import freenet.config.Config;
import freenet.config.ConfigCallback;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.config.WrapperConfig;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.BooleanCallback;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class ConfigToadlet
extends Toadlet
implements LinkEnabledCallback {
    private static final int MAX_PARAM_VALUE_SIZE = 0x100000;
    private final SubConfig subConfig;
    private final Config config;
    private final NodeClientCore core;
    private final Node node;
    private boolean needRestart = false;
    private NeedRestartUserAlert needRestartUserAlert;

    ConfigToadlet(HighLevelSimpleClient client, Config conf, SubConfig subConfig, Node node, NodeClientCore core) {
        super(client);
        this.config = conf;
        this.core = core;
        this.node = node;
        this.subConfig = subConfig;
    }

    public void handlePost(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        HTMLNode content;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        String pass = request.getPartAsString("formPassword", 32);
        if (pass == null || !pass.equals(this.core.formPassword)) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", this.path());
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        SubConfig[] sc = this.config.getConfigs();
        StringBuilder errbuf = new StringBuilder();
        boolean logMINOR = Logger.shouldLog(4, this);
        for (int i = 0; i < sc.length; ++i) {
            String value;
            Option<?>[] o = sc[i].getOptions();
            String prefix = sc[i].getPrefix();
            for (int j = 0; j < o.length; ++j) {
                String configName = o[j].getName();
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName);
                }
                if (!request.isPartSet(prefix + '.' + configName)) continue;
                value = request.getPartAsString(prefix + '.' + configName, 0x100000);
                if (o[j].getValueString().equals(value)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName + " to " + value);
                }
                try {
                    o[j].setValue(value);
                    continue;
                }
                catch (InvalidConfigValueException e) {
                    errbuf.append(o[j].getName()).append(' ').append(e.getMessage()).append('\n');
                    continue;
                }
                catch (NodeNeedRestartException e) {
                    this.needRestart = true;
                    continue;
                }
                catch (Exception e) {
                    errbuf.append(o[j].getName()).append(' ').append(e).append('\n');
                    Logger.error(this, "Caught " + e, e);
                }
            }
            String wrapperConfigName = "wrapper.java.maxmemory";
            if (!request.isPartSet(wrapperConfigName)) continue;
            value = request.getPartAsString(wrapperConfigName, 0x100000);
            if (WrapperConfig.getWrapperProperty(wrapperConfigName).equals(value)) continue;
            if (logMINOR) {
                Logger.minor(this, "Setting " + wrapperConfigName + " to " + value);
            }
            WrapperConfig.setWrapperProperty(wrapperConfigName, value);
        }
        this.core.storeConfig();
        PageNode page = ctx.getPageMaker().getPageNode(ConfigToadlet.l10n("appliedTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (errbuf.length() == 0) {
            content = ctx.getPageMaker().getInfobox("infobox-success", ConfigToadlet.l10n("appliedTitle"), contentNode);
            content.addChild("#", ConfigToadlet.l10n("appliedSuccess"));
            if (this.needRestart) {
                content.addChild("br");
                content.addChild("#", ConfigToadlet.l10n("needRestart"));
                if (this.node.isUsingWrapper()) {
                    content.addChild("br");
                    HTMLNode restartForm = ctx.addFormChild(content, "/", "restartForm");
                    restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                    restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", ConfigToadlet.l10n("restartNode")});
                }
                if (this.needRestartUserAlert == null) {
                    this.needRestartUserAlert = new NeedRestartUserAlert();
                    this.node.clientCore.alerts.register(this.needRestartUserAlert);
                }
            }
        } else {
            content = ctx.getPageMaker().getInfobox("infobox-error", ConfigToadlet.l10n("appliedFailureTitle"), contentNode).addChild("div", "class", "infobox-content");
            content.addChild("#", ConfigToadlet.l10n("appliedFailureExceptions"));
            content.addChild("br");
            content.addChild("#", errbuf.toString());
        }
        content = ctx.getPageMaker().getInfobox("infobox-normal", ConfigToadlet.l10n("possibilitiesTitle"), contentNode);
        content.addChild("a", new String[]{"href", "title"}, new String[]{this.path(), ConfigToadlet.l10n("shortTitle")}, ConfigToadlet.l10n("returnToNodeConfig"));
        content.addChild("br");
        ConfigToadlet.addHomepageLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private static final String l10n(String string) {
        return L10n.getString("ConfigToadlet." + string);
    }

    public void handleGet(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String configName;
        String curValue;
        if (!ctx.isAllowedFullAccess()) {
            super.sendErrorPage(ctx, 403, L10n.getString("Toadlet.unauthorizedTitle"), L10n.getString("Toadlet.unauthorized"));
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(L10n.getString("ConfigToadlet.fullTitle", new String[]{"name"}, new String[]{this.node.getMyName()}), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(this.core.alerts.createSummary());
        int mode = ctx.getPageMaker().drawModeSelectionArray(this.core, req, contentNode);
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", ConfigToadlet.l10n("title"));
        HTMLNode configNode = infobox.addChild("div", "class", "infobox-content");
        HTMLNode formNode = ctx.addFormChild(configNode, this.path(), "configForm");
        if (this.subConfig.getPrefix().equals("node") && WrapperConfig.canChangeProperties() && (curValue = WrapperConfig.getWrapperProperty(configName = "wrapper.java.maxmemory")) != null) {
            formNode.addChild("div", "class", "configprefix", ConfigToadlet.l10n("wrapper"));
            HTMLNode list = formNode.addChild("ul", "class", "config");
            HTMLNode item = list.addChild("li");
            String defaultValue = "128";
            item.addChild("span", new String[]{"class", "title", "style"}, new String[]{"configshortdesc", L10n.getString("ConfigToadlet.defaultIs", new String[]{"default"}, new String[]{defaultValue}), "cursor: help;"}).addChild(L10n.getHTMLNode("WrapperConfig." + configName + ".short"));
            item.addChild("span", "class", "config").addChild("input", new String[]{"type", "class", "name", "value"}, new String[]{"text", "config", configName, curValue});
            item.addChild("span", "class", "configlongdesc").addChild(L10n.getHTMLNode("WrapperConfig." + configName + ".long"));
        }
        int displayedConfigElements = 0;
        Option<?>[] o = this.subConfig.getOptions();
        HTMLNode configGroupUlNode = new HTMLNode("ul", "class", "config");
        for (int j = 0; j < o.length; ++j) {
            if (mode == 1 && o[j].isExpert()) continue;
            displayedConfigElements = (short)(displayedConfigElements + 1);
            String configName2 = o[j].getName();
            HTMLNode configItemNode = configGroupUlNode.addChild("li");
            configItemNode.addChild("span", new String[]{"class", "title", "style"}, new String[]{"configshortdesc", L10n.getString("ConfigToadlet.defaultIs", new String[]{"default"}, new String[]{o[j].getDefault()}) + (mode >= 2 ? " [" + this.subConfig.getPrefix() + '.' + o[j].getName() + ']' : ""), "cursor: help;"}).addChild(L10n.getHTMLNode(o[j].getShortDesc()));
            HTMLNode configItemValueNode = configItemNode.addChild("span", "class", "config");
            if (o[j].getValueString() == null) {
                Logger.error(this, this.subConfig.getPrefix() + configName2 + "has returned null from config!);");
                continue;
            }
            ConfigCallback<?> callback = o[j].getCallback();
            if (callback instanceof EnumerableOptionCallback) {
                configItemValueNode.addChild(this.addComboBox((EnumerableOptionCallback)((Object)callback), this.subConfig, configName2, callback.isReadOnly()));
            } else if (callback instanceof BooleanCallback) {
                configItemValueNode.addChild(this.addBooleanComboBox((Boolean)((BooleanOption)o[j]).getValue(), this.subConfig, configName2, callback.isReadOnly()));
            } else if (callback.isReadOnly()) {
                configItemValueNode.addChild("input", new String[]{"type", "class", "disabled", "alt", "name", "value"}, new String[]{"text", "config", "disabled", o[j].getShortDesc(), this.subConfig.getPrefix() + '.' + configName2, o[j].getValueString()});
            } else {
                configItemValueNode.addChild("input", new String[]{"type", "class", "alt", "name", "value"}, new String[]{"text", "config", o[j].getShortDesc(), this.subConfig.getPrefix() + '.' + configName2, o[j].getValueString()});
            }
            configItemNode.addChild("span", "class", "configlongdesc").addChild(L10n.getHTMLNode(o[j].getLongDesc()));
        }
        if (displayedConfigElements > 0) {
            formNode.addChild("div", "class", "configprefix", ConfigToadlet.l10n(this.subConfig.getPrefix()));
            formNode.addChild("a", "id", this.subConfig.getPrefix());
            formNode.addChild(configGroupUlNode);
        }
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", ConfigToadlet.l10n("apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", ConfigToadlet.l10n("reset")});
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    private HTMLNode addComboBox(EnumerableOptionCallback o, SubConfig sc, String name, boolean disabled) {
        HTMLNode result = disabled ? new HTMLNode("select", new String[]{"name", "disabled"}, new String[]{sc.getPrefix() + '.' + name, "disabled"}) : new HTMLNode("select", "name", sc.getPrefix() + '.' + name);
        String[] possibleValues = o.getPossibleValues();
        for (int i = 0; i < possibleValues.length; ++i) {
            if (possibleValues[i].equals(o.get())) {
                result.addChild("option", new String[]{"value", "selected"}, new String[]{possibleValues[i], "selected"}, possibleValues[i]);
                continue;
            }
            result.addChild("option", "value", possibleValues[i], possibleValues[i]);
        }
        return result;
    }

    private HTMLNode addBooleanComboBox(boolean value, SubConfig sc, String name, boolean disabled) {
        HTMLNode result = disabled ? new HTMLNode("select", new String[]{"name", "disabled"}, new String[]{sc.getPrefix() + '.' + name, "disabled"}) : new HTMLNode("select", "name", sc.getPrefix() + '.' + name);
        if (value) {
            result.addChild("option", new String[]{"value", "selected"}, new String[]{"true", "selected"}, ConfigToadlet.l10n("true"));
            result.addChild("option", "value", "false", ConfigToadlet.l10n("false"));
        } else {
            result.addChild("option", "value", "true", ConfigToadlet.l10n("true"));
            result.addChild("option", new String[]{"value", "selected"}, new String[]{"false", "selected"}, ConfigToadlet.l10n("false"));
        }
        return result;
    }

    public String path() {
        return "/config/" + this.subConfig.getPrefix();
    }

    public boolean isEnabled(ToadletContext ctx) {
        Option<?>[] o = this.subConfig.getOptions();
        if (this.core.isAdvancedModeEnabled()) {
            return true;
        }
        for (Option<?> option : o) {
            if (option.isExpert()) continue;
            return true;
        }
        return false;
    }

    private class NeedRestartUserAlert
    extends AbstractUserAlert {
        private NeedRestartUserAlert() {
        }

        public String getTitle() {
            return ConfigToadlet.l10n("needRestartTitle");
        }

        public String getText() {
            return this.getHTMLText().toString();
        }

        public String getShortText() {
            return ConfigToadlet.l10n("needRestartShort");
        }

        public HTMLNode getHTMLText() {
            HTMLNode alertNode = new HTMLNode("div");
            alertNode.addChild("#", ConfigToadlet.l10n("needRestart"));
            if (ConfigToadlet.this.node.isUsingWrapper()) {
                alertNode.addChild("br");
                HTMLNode restartForm = alertNode.addChild("form", new String[]{"action", "method", "enctype", "id", "accept-charset"}, new String[]{"/", "post", "multipart/form-data", "restartForm", "utf-8"}).addChild("div");
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", ((ConfigToadlet)ConfigToadlet.this).node.clientCore.formPassword});
                restartForm.addChild("div");
                restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", ConfigToadlet.l10n("restartNode")});
            }
            return alertNode;
        }

        public short getPriorityClass() {
            return 2;
        }

        public boolean isValid() {
            return ConfigToadlet.this.needRestart;
        }

        public boolean userCanDismiss() {
            return false;
        }
    }
}

