/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.bookmark.Bookmark;
import freenet.clients.http.bookmark.BookmarkCategory;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.URLEncoder;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;

public class BookmarkEditorToadlet
extends Toadlet {
    private static final int MAX_ACTION_LENGTH = 20;
    private static final int MAX_NAME_LENGTH = 500;
    private static final int MAX_BOOKMARK_PATH_LENGTH = 5000;
    private final NodeClientCore core;
    private final BookmarkManager bookmarkManager;
    private String cutedPath;

    BookmarkEditorToadlet(HighLevelSimpleClient client, NodeClientCore core, BookmarkManager bookmarks) {
        super(client);
        this.core = core;
        this.bookmarkManager = bookmarks;
        this.cutedPath = null;
    }

    private void addCategoryToList(BookmarkCategory cat, String path, HTMLNode list) {
        List<BookmarkItem> items = cat.getItems();
        String edit = L10n.getString("BookmarkEditorToadlet.edit");
        String delete = L10n.getString("BookmarkEditorToadlet.delete");
        String cut = L10n.getString("BookmarkEditorToadlet.cut");
        String moveUp = L10n.getString("BookmarkEditorToadlet.moveUp");
        String moveDown = L10n.getString("BookmarkEditorToadlet.moveDown");
        String paste = L10n.getString("BookmarkEditorToadlet.paste");
        String addBookmark = L10n.getString("BookmarkEditorToadlet.addBookmark");
        String addCategory = L10n.getString("BookmarkEditorToadlet.addCategory");
        for (int i = 0; i < items.size(); ++i) {
            BookmarkItem item = items.get(i);
            String itemPath = URLEncoder.encode(path + item.getName(), false);
            HTMLNode li = new HTMLNode("li", "class", "item", item.getName());
            HTMLNode actions = new HTMLNode("span", "class", "actions");
            actions.addChild("a", "href", "?action=edit&bookmark=" + itemPath).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/edit.png", edit, edit});
            actions.addChild("a", "href", "?action=del&bookmark=" + itemPath).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/delete.png", delete, delete});
            if (this.cutedPath == null) {
                actions.addChild("a", "href", "?action=cut&bookmark=" + itemPath).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/cut.png", cut, cut});
            }
            if (i != 0) {
                actions.addChild("a", "href", "?action=up&bookmark=" + itemPath).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/go-up.png", moveUp, moveUp});
            }
            if (i != items.size() - 1) {
                actions.addChild("a", "href", "?action=down&bookmark=" + itemPath).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/go-down.png", moveDown, moveDown});
            }
            li.addChild(actions);
            list.addChild(li);
        }
        List<BookmarkCategory> cats = cat.getSubCategories();
        for (int i = 0; i < cats.size(); ++i) {
            String catPath = path + cats.get(i).getName() + '/';
            String catPathEncoded = URLEncoder.encode(catPath, false);
            HTMLNode subCat = list.addChild("li", "class", "cat", cats.get(i).getName());
            HTMLNode actions = new HTMLNode("span", "class", "actions");
            actions.addChild("a", "href", "?action=edit&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/edit.png", edit, edit});
            actions.addChild("a", "href", "?action=del&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/delete.png", delete, delete});
            actions.addChild("a", "href", "?action=addItem&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/bookmark-new.png", addBookmark, addBookmark});
            actions.addChild("a", "href", "?action=addCat&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/folder-new.png", addCategory, addCategory});
            if (this.cutedPath == null) {
                actions.addChild("a", "href", "?action=cut&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/cut.png", cut, cut});
            }
            if (i != 0) {
                actions.addChild("a", "href", "?action=up&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/go-up.png", moveUp, moveUp});
            }
            if (i != cats.size() - 1) {
                actions.addChild("a", "href", "?action=down&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/go-down.png", moveDown, moveDown});
            }
            if (this.cutedPath != null && !catPathEncoded.startsWith(this.cutedPath) && !catPathEncoded.equals(this.bookmarkManager.parentPath(this.cutedPath))) {
                actions.addChild("a", "href", "?action=paste&bookmark=" + catPathEncoded).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/paste.png", paste, paste});
            }
            subCat.addChild(actions);
            if (cats.get(i).size() == 0) continue;
            this.addCategoryToList(cats.get(i), catPath, list.addChild("li").addChild("ul"));
        }
    }

    public HTMLNode getBookmarksList() {
        HTMLNode bookmarks = new HTMLNode("ul", "id", "bookmarks");
        HTMLNode root = bookmarks.addChild("li", "class", "cat root", "/");
        HTMLNode actions = new HTMLNode("span", "class", "actions");
        String addBookmark = L10n.getString("BookmarkEditorToadlet.addBookmark");
        String addCategory = L10n.getString("BookmarkEditorToadlet.addCategory");
        String paste = L10n.getString("BookmarkEditorToadlet.paste");
        actions.addChild("a", "href", "?action=addItem&bookmark=/").addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/bookmark-new.png", addBookmark, addBookmark});
        actions.addChild("a", "href", "?action=addCat&bookmark=/").addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/folder-new.png", addCategory, addCategory});
        if (this.cutedPath != null && !"/".equals(this.bookmarkManager.parentPath(this.cutedPath))) {
            actions.addChild("a", "href", "?action=paste&bookmark=/").addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/paste.png", paste, paste});
        }
        root.addChild(actions);
        this.addCategoryToList(BookmarkManager.MAIN_CATEGORY, "/", root.addChild("ul"));
        return bookmarks;
    }

    public void handleGet(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageMaker pageMaker = ctx.getPageMaker();
        String editorTitle = L10n.getString("BookmarkEditorToadlet.title");
        String error = L10n.getString("BookmarkEditorToadlet.error");
        PageNode page = pageMaker.getPageNode(editorTitle, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode content = page.content;
        String originalBookmark = req.getParam("bookmark");
        if (req.getParam("action").length() > 0 && originalBookmark.length() > 0) {
            String bookmarkPath;
            String action = req.getParam("action");
            try {
                bookmarkPath = URLDecoder.decode(originalBookmark, false);
            }
            catch (URLEncodedFormatException e) {
                pageMaker.getInfobox("infobox-error", error, content).addChild("#", L10n.getString("BookmarkEditorToadlet.urlDecodeError"));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            Bookmark bookmark = bookmarkPath.endsWith("/") ? this.bookmarkManager.getCategoryByPath(bookmarkPath) : this.bookmarkManager.getItemByPath(bookmarkPath);
            if (bookmark == null) {
                pageMaker.getInfobox("infobox-error", error, content).addChild("#", L10n.getString("BookmarkEditorToadlet.bookmarkDoesNotExist", new String[]{"bookmark"}, new String[]{bookmarkPath}));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if ("del".equals(action)) {
                String[] bm = new String[]{"bookmark"};
                String[] path = new String[]{bookmarkPath};
                String queryTitle = L10n.getString("BookmarkEditorToadlet." + (bookmark instanceof BookmarkItem ? "deleteBookmark" : "deleteCategory"));
                HTMLNode infoBoxContent = pageMaker.getInfobox("infobox-query", queryTitle, content);
                String query = L10n.getString("BookmarkEditorToadlet." + (bookmark instanceof BookmarkItem ? "deleteBookmarkConfirm" : "deleteCategoryConfirm"), bm, path);
                infoBoxContent.addChild("p").addChild("#", query);
                HTMLNode confirmForm = ctx.addFormChild(infoBoxContent, "", "confirmDeleteForm");
                confirmForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "bookmark", bookmarkPath});
                confirmForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", L10n.getString("Toadlet.cancel")});
                confirmForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirmdelete", L10n.getString("BookmarkEditorToadlet.confirmDelete")});
            } else if ("cut".equals(action)) {
                this.cutedPath = bookmarkPath;
            } else if ("paste".equals(action) && this.cutedPath != null) {
                this.bookmarkManager.moveBookmark(this.cutedPath, bookmarkPath);
                this.bookmarkManager.storeBookmarks();
                this.cutedPath = null;
            } else if ("edit".equals(action) || "addItem".equals(action) || "addCat".equals(action)) {
                String header = "edit".equals(action) ? L10n.getString("BookmarkEditorToadlet.edit" + (bookmark instanceof BookmarkItem ? "Bookmark" : "Category") + "Title") : ("addItem".equals(action) ? L10n.getString("BookmarkEditorToadlet.addNewBookmark") : L10n.getString("BookmarkEditorToadlet.addNewCategory"));
                HTMLNode actionBoxContent = pageMaker.getInfobox("infobox-query", header, content);
                HTMLNode form = ctx.addFormChild(actionBoxContent, "", "editBookmarkForm");
                form.addChild("label", "for", "name", L10n.getString("BookmarkEditorToadlet.nameLabel") + ' ');
                form.addChild("input", new String[]{"type", "id", "name", "size", "value"}, new String[]{"text", "name", "name", "20", "edit".equals(action) ? bookmark.getName() : ""});
                form.addChild("br");
                boolean isNew = false;
                if ("edit".equals(action) && bookmark instanceof BookmarkItem || (isNew = "addItem".equals(action))) {
                    BookmarkItem item = isNew ? null : (BookmarkItem)bookmark;
                    String key = action.equals("edit") ? item.getKey() : "";
                    form.addChild("label", "for", "key", L10n.getString("BookmarkEditorToadlet.keyLabel") + ' ');
                    form.addChild("input", new String[]{"type", "id", "name", "size", "value"}, new String[]{"text", "key", "key", "50", key});
                    form.addChild("br");
                    form.addChild("label", "for", "descB", L10n.getString("BookmarkEditorToadlet.descLabel") + ' ');
                    form.addChild("br");
                    form.addChild("textarea", new String[]{"id", "name", "row", "cols"}, new String[]{"descB", "descB", "3", "70"}, item == null ? "" : item.getDescription());
                    form.addChild("br");
                    form.addChild("label", "for", "hasAnActivelink", L10n.getString("BookmarkEditorToadlet.hasAnActivelinkLabel") + ' ');
                    if (item != null && item.hasAnActivelink()) {
                        form.addChild("input", new String[]{"type", "id", "name", "checked"}, new String[]{"checkbox", "hasAnActivelink", "hasAnActivelink", String.valueOf(item.hasAnActivelink())});
                    } else {
                        form.addChild("input", new String[]{"type", "id", "name"}, new String[]{"checkbox", "hasAnActivelink", "hasAnActivelink"});
                    }
                }
                form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "bookmark", bookmarkPath});
                form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "action", req.getParam("action")});
                form.addChild("br");
                form.addChild("input", new String[]{"type", "value"}, new String[]{"submit", L10n.getString("BookmarkEditorToadlet.save")});
            } else if ("up".equals(action)) {
                this.bookmarkManager.moveBookmarkUp(bookmarkPath, true);
            } else if ("down".equals(action)) {
                this.bookmarkManager.moveBookmarkDown(bookmarkPath, true);
            }
        }
        if (this.cutedPath != null) {
            HTMLNode infoBoxContent = pageMaker.getInfobox("infobox-normal", L10n.getString("BookmarkEditorToadlet.pasteTitle"), content);
            infoBoxContent.addChild("#", L10n.getString("BookmarkEditorToadlet.pasteOrCancel"));
            HTMLNode cancelForm = ctx.addFormChild(infoBoxContent, "/bookmarkEditor/", "cancelCutForm");
            cancelForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancelCut", L10n.getString("BookmarkEditorToadlet.cancelCut")});
            cancelForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "action", "cancelCut"});
        }
        pageMaker.getInfobox("infobox-normal", L10n.getString("BookmarkEditorToadlet.myBookmarksTitle"), content).addChild(this.getBookmarksList());
        HTMLNode addDefaultBookmarksForm = ctx.addFormChild(content, "", "AddDefaultBookmarks");
        addDefaultBookmarksForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "AddDefaultBookmarks", L10n.getString("BookmarkEditorToadlet.addDefaultBookmarks")});
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "Returning:\n" + pageNode.generate());
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public void handlePost(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        boolean noPassword;
        PageMaker pageMaker = ctx.getPageMaker();
        PageNode page = pageMaker.getPageNode(L10n.getString("BookmarkEditorToadlet.title"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode content = page.content;
        String passwd = req.getPartAsString("formPassword", 32);
        boolean bl = noPassword = passwd == null || !passwd.equals(this.core.formPassword);
        if (noPassword) {
            BookmarkEditorToadlet.writePermanentRedirect(ctx, "Invalid", "");
            return;
        }
        if (req.isPartSet("AddDefaultBookmarks")) {
            this.bookmarkManager.reAddDefaultBookmarks();
            this.writeTemporaryRedirect(ctx, "Ok", "/");
            return;
        }
        String bookmarkPath = req.getPartAsString("bookmark", 5000);
        try {
            Bookmark bookmark = bookmarkPath.endsWith("/") ? this.bookmarkManager.getCategoryByPath(bookmarkPath) : this.bookmarkManager.getItemByPath(bookmarkPath);
            if (bookmark == null && !req.isPartSet("cancelCut")) {
                pageMaker.getInfobox("infobox-error", L10n.getString("BookmarkEditorToadlet.error"), content).addChild("#", L10n.getString("BookmarkEditorToadlet.bookmarkDoesNotExist", new String[]{"bookmark"}, new String[]{bookmarkPath}));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            String action = req.getPartAsString("action", 20);
            if (req.isPartSet("confirmdelete")) {
                this.bookmarkManager.removeBookmark(bookmarkPath);
                this.bookmarkManager.storeBookmarks();
                pageMaker.getInfobox("infobox-success", L10n.getString("BookmarkEditorToadlet.deleteSucceededTitle"), content).addChild("p", L10n.getString("BookmarkEditorToadlet.deleteSucceeded"));
            } else if (req.isPartSet("cancelCut")) {
                this.cutedPath = null;
            } else if ("edit".equals(action) || "addItem".equals(action) || "addCat".equals(action)) {
                String name = "unnamed";
                if (req.isPartSet("name")) {
                    name = req.getPartAsString("name", 500);
                }
                if ("edit".equals(action)) {
                    this.bookmarkManager.renameBookmark(bookmarkPath, name);
                    boolean hasAnActivelink = req.isPartSet("hasAnActivelink");
                    if (bookmark instanceof BookmarkItem) {
                        ((BookmarkItem)bookmark).update(new FreenetURI(req.getPartAsString("key", 0x100000)), hasAnActivelink, req.getPartAsString("descB", 0x100000));
                    }
                    this.bookmarkManager.storeBookmarks();
                    pageMaker.getInfobox("infobox-success", L10n.getString("BookmarkEditorToadlet.changesSavedTitle"), content).addChild("p", L10n.getString("BookmarkEditorToadlet.changesSaved"));
                } else if ("addItem".equals(action) || "addCat".equals(action)) {
                    Bookmark newBookmark = null;
                    if ("addItem".equals(action)) {
                        FreenetURI key = new FreenetURI(req.getPartAsString("key", 0x100000));
                        boolean hasAnActivelink = req.isPartSet("hasAnActivelink");
                        if (name.contains("/")) {
                            pageMaker.getInfobox("infobox-error", L10n.getString("BookmarkEditorToadlet.invalidNameTitle"), content).addChild("#", L10n.getString("BookmarkEditorToadlet.invalidName"));
                        } else {
                            newBookmark = new BookmarkItem(key, name, req.getPartAsString("descB", 0x100000), hasAnActivelink, this.core.alerts);
                        }
                    } else if (name.contains("/")) {
                        pageMaker.getInfobox("infobox-error", L10n.getString("BookmarkEditorToadlet.invalidNameTitle"), content).addChild("#", L10n.getString("BookmarkEditorToadlet.invalidName"));
                    } else {
                        newBookmark = new BookmarkCategory(name);
                    }
                    if (newBookmark != null) {
                        this.bookmarkManager.addBookmark(bookmarkPath, newBookmark);
                        this.bookmarkManager.storeBookmarks();
                        pageMaker.getInfobox("infobox-success", L10n.getString("BookmarkEditorToadlet.addedNewBookmarkTitle"), content).addChild("p", L10n.getString("BookmarkEditorToadlet.addedNewBookmark"));
                    }
                }
            }
        }
        catch (MalformedURLException mue) {
            pageMaker.getInfobox("infobox-error", L10n.getString("BookmarkEditorToadlet.invalidKeyTitle"), content).addChild("#", L10n.getString("BookmarkEditorToadlet.invalidKey"));
        }
        pageMaker.getInfobox("infobox-normal", L10n.getString("BookmarkEditorToadlet.myBookmarksTitle"), content).addChild(this.getBookmarksList());
        HTMLNode addDefaultBookmarksForm = ctx.addFormChild(content, "", "AddDefaultBookmarks");
        addDefaultBookmarksForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "AddDefaultBookmarks", L10n.getString("BookmarkEditorToadlet.addDefaultBookmarks")});
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public String supportedMethods() {
        return "GET, POST";
    }

    public String path() {
        return "/bookmarkEditor/";
    }
}

