/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.events;

import com.db4o.ObjectContainer;
import freenet.client.events.ClientEvent;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class SplitfileProgressEvent
implements ClientEvent {
    private static volatile boolean logMINOR;
    public static final int CODE = 7;
    public final int totalBlocks;
    public final int succeedBlocks;
    public final int failedBlocks;
    public final int fatallyFailedBlocks;
    public int minSuccessfulBlocks;
    public final boolean finalizedTotal;

    public SplitfileProgressEvent(int totalBlocks, int succeedBlocks, int failedBlocks, int fatallyFailedBlocks, int minSuccessfulBlocks, boolean finalizedTotal) {
        this.totalBlocks = totalBlocks;
        this.succeedBlocks = succeedBlocks;
        this.failedBlocks = failedBlocks;
        this.fatallyFailedBlocks = fatallyFailedBlocks;
        this.minSuccessfulBlocks = minSuccessfulBlocks;
        this.finalizedTotal = finalizedTotal;
        if (logMINOR) {
            Logger.minor(this, "Created SplitfileProgressEvent: total=" + totalBlocks + " succeed=" + succeedBlocks + " failed=" + failedBlocks + " fatally=" + fatallyFailedBlocks + " min success=" + minSuccessfulBlocks + " finalized=" + finalizedTotal);
        }
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Completed ");
        if (this.minSuccessfulBlocks == 0 && this.succeedBlocks == 0) {
            this.minSuccessfulBlocks = 1;
        }
        if (this.minSuccessfulBlocks == 0) {
            if (Logger.globalGetThreshold() > 4) {
                Logger.error(this, "minSuccessfulBlocks=0, succeedBlocks=" + this.succeedBlocks + ", totalBlocks=" + this.totalBlocks + ", failedBlocks=" + this.failedBlocks + ", fatallyFailedBlocks=" + this.fatallyFailedBlocks + ", finalizedTotal=" + this.finalizedTotal);
            } else {
                Logger.error(this, "minSuccessfulBlocks=0, succeedBlocks=" + this.succeedBlocks + ", totalBlocks=" + this.totalBlocks + ", failedBlocks=" + this.failedBlocks + ", fatallyFailedBlocks=" + this.fatallyFailedBlocks + ", finalizedTotal=" + this.finalizedTotal, new Exception("debug"));
            }
        } else {
            sb.append(100 * this.succeedBlocks / this.minSuccessfulBlocks);
            sb.append('%');
        }
        sb.append(' ');
        sb.append(this.succeedBlocks);
        sb.append('/');
        sb.append(this.minSuccessfulBlocks);
        sb.append(" (failed ");
        sb.append(this.failedBlocks);
        sb.append(", fatally ");
        sb.append(this.fatallyFailedBlocks);
        sb.append(", total ");
        sb.append(this.totalBlocks);
        sb.append(") ");
        sb.append(this.finalizedTotal ? " (finalized total)" : "");
        return sb.toString();
    }

    public int getCode() {
        return 7;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

