/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.events;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ClientEventProducer;
import freenet.support.Logger;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SimpleEventProducer
implements ClientEventProducer {
    private Vector<ClientEventListener> listeners = new Vector();

    public SimpleEventProducer() {
    }

    public SimpleEventProducer(ClientEventListener[] cela) {
        this();
        for (int i = 0; i < cela.length; ++i) {
            this.addEventListener(cela[i]);
        }
    }

    public void addEventListener(ClientEventListener cel) {
        if (cel == null) {
            throw new IllegalArgumentException("Adding a null listener!");
        }
        this.listeners.addElement(cel);
    }

    public boolean removeEventListener(ClientEventListener cel) {
        boolean b = this.listeners.removeElement(cel);
        this.listeners.trimToSize();
        return b;
    }

    public void produceEvent(ClientEvent ce, ObjectContainer container, ClientContext context) {
        if (container != null) {
            container.activate(this.listeners, 1);
        }
        Enumeration<ClientEventListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            try {
                ClientEventListener cel = e.nextElement();
                if (container != null) {
                    container.activate((Object)cel, 1);
                }
                cel.receive(ce, container, context);
            }
            catch (NoSuchElementException ne) {
                Logger.normal(this, "Concurrent modification in produceEvent!: " + this);
            }
            catch (Exception ue) {
                System.err.println("---Unexpected Exception------------------");
                ue.printStackTrace();
                System.err.println("-----------------------------------------");
            }
        }
    }

    public ClientEventListener[] getEventListeners() {
        Object[] ret = new ClientEventListener[this.listeners.size()];
        this.listeners.copyInto(ret);
        return ret;
    }

    public void addEventListeners(ClientEventListener[] cela) {
        for (int i = 0; i < cela.length; ++i) {
            this.addEventListener(cela[i]);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (container != null) {
            container.activate(this.listeners, 1);
        }
        ClientEventListener[] list = this.listeners.toArray(new ClientEventListener[this.listeners.size()]);
        this.listeners.clear();
        container.delete(this.listeners);
        for (int i = 0; i < list.length; ++i) {
            list[i].onRemoveEventProducer(container);
        }
        container.delete((Object)this);
    }
}

