/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.USKCallback;
import freenet.client.async.USKRetrieverCallback;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.RequestClient;
import freenet.support.Logger;
import java.net.MalformedURLException;

public class USKRetriever
extends BaseClientGetter
implements USKCallback {
    final FetchContext ctx;
    final USKRetrieverCallback cb;
    final USK origUSK;

    public USKRetriever(FetchContext fctx, short prio, RequestClient client, USKRetrieverCallback cb, USK origUSK) {
        super(prio, client);
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKRetriever cannot be persistent");
        }
        this.ctx = fctx;
        this.cb = cb;
        this.origUSK = origUSK;
    }

    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (l < 0L) {
            Logger.error(this, "Found negative edition: " + l + " for " + key + " !!!");
            return;
        }
        FreenetURI uri = key.getSSK(l).getURI();
        try {
            SingleFileFetcher getter = (SingleFileFetcher)SingleFileFetcher.create(this, this, uri, this.ctx, new ArchiveContext(this.ctx.maxTempLength, this.ctx.maxArchiveLevels), this.ctx.maxNonSplitfileRetries, 0, true, l, true, null, false, null, context);
            getter.schedule(null, context);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Impossible: " + e, e);
        }
        catch (FetchException e) {
            Logger.error(this, "Could not start fetcher for " + uri + " : " + e, e);
        }
    }

    public void onSuccess(FetchResult result, ClientGetState state, ObjectContainer container, ClientContext context) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Success on " + this + " from " + state + " : length " + result.size() + " mime type " + result.getMimeType());
        }
        this.cb.onFound(this.origUSK, state.getToken(), result);
        context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
    }

    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        switch (e.mode) {
            case 24: 
            case 27: {
                context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
                return;
            }
        }
        Logger.error(this, "Found edition " + state.getToken() + " but failed to fetch edition: " + e, e);
    }

    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    public boolean isFinished() {
        return false;
    }

    public void notifyClients(ObjectContainer container, ClientContext context) {
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    public void onExpectedMIME(String mime, ObjectContainer container, ClientContext context) {
    }

    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
    }

    public void onFinalizedMetadata(ObjectContainer container) {
    }

    public short getPollingPriorityNormal() {
        return this.cb.getPollingPriorityNormal();
    }

    public short getPollingPriorityProgress() {
        return this.cb.getPollingPriorityProgress();
    }

    public void cancel(ObjectContainer container, ClientContext context) {
        super.cancel();
    }

    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }
}

