/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.GetCompletionCallback;
import freenet.keys.FreenetURI;
import freenet.keys.USK;

public class USKProxyCompletionCallback
implements GetCompletionCallback {
    final USK usk;
    final GetCompletionCallback cb;
    final boolean persistent;

    public USKProxyCompletionCallback(USK usk, GetCompletionCallback cb, boolean persistent) {
        this.usk = usk;
        this.cb = cb;
        this.persistent = persistent;
    }

    public void onSuccess(FetchResult result, ClientGetState state, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
            container.activate((Object)this.usk, 5);
        }
        context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
        this.cb.onSuccess(result, state, container, context);
        if (this.persistent) {
            this.removeFrom(container);
        }
    }

    private void removeFrom(ObjectContainer container) {
        container.activate((Object)this.usk, 5);
        this.usk.removeFrom(container);
        container.delete((Object)this);
    }

    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        FreenetURI uri;
        switch (e.mode) {
            case 24: 
            case 27: {
                context.uskManager.updateKnownGood(this.usk, this.usk.suggestedEdition, context);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.activate((Object)this.usk, 5);
        }
        if ((uri = e.newURI) != null) {
            uri = this.usk.turnMySSKIntoUSK(uri);
            e = new FetchException(e, uri);
        }
        this.cb.onFailure(e, state, container, context);
        if (this.persistent) {
            this.removeFrom(container);
        }
    }

    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onBlockSetFinished(state, container, context);
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    public void onExpectedMIME(String mime, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedMIME(mime, container, context);
    }

    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedSize(size, container, context);
    }

    public void onFinalizedMetadata(ObjectContainer container) {
        if (container != null && this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFinalizedMetadata(container);
    }
}

