/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.NullClientCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.USKCallback;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.client.async.USKFetcherWrapper;
import freenet.client.async.USKManagerPersistent;
import freenet.client.async.USKRetriever;
import freenet.client.async.USKRetrieverCallback;
import freenet.clients.http.FProxyToadlet;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.support.Executor;
import freenet.support.LRUHashtable;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.NullBucket;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Vector;

public class USKManager
implements RequestClient {
    private static volatile boolean logMINOR;
    final HashMap<USK, Long> latestKnownGoodByClearUSK;
    final HashMap<USK, Long> latestSlotByClearUSK;
    final HashMap<USK, USKCallback[]> subscribersByClearUSK;
    final HashMap<USK, USKFetcher> fetchersByUSK;
    final HashMap<USK, USKFetcher> backgroundFetchersByClearUSK;
    final LRUHashtable<USK, USKFetcher> temporaryBackgroundFetchersLRU;
    final FetchContext backgroundFetchContext;
    final FetchContext realFetchContext;
    final Executor executor;
    private ClientContext context;

    public USKManager(NodeClientCore core) {
        HighLevelSimpleClient client = core.makeClient((short)3);
        client.setMaxIntermediateLength(FProxyToadlet.MAX_LENGTH);
        client.setMaxLength(FProxyToadlet.MAX_LENGTH);
        this.backgroundFetchContext = client.getFetchContext();
        this.backgroundFetchContext.followRedirects = false;
        this.realFetchContext = client.getFetchContext();
        this.latestKnownGoodByClearUSK = new HashMap();
        this.latestSlotByClearUSK = new HashMap();
        this.subscribersByClearUSK = new HashMap();
        this.fetchersByUSK = new HashMap();
        this.backgroundFetchersByClearUSK = new HashMap();
        this.temporaryBackgroundFetchersLRU = new LRUHashtable();
        this.executor = core.getExecutor();
    }

    public void init(ObjectContainer container, ClientContext context) {
        this.context = context;
        if (container != null) {
            USKManagerPersistent.init(this, container, context);
        }
    }

    public synchronized long lookupKnownGood(USK usk) {
        Long l = this.latestKnownGoodByClearUSK.get(usk.clearCopy());
        if (l != null) {
            return l;
        }
        return -1L;
    }

    public synchronized long lookupLatestSlot(USK usk) {
        Long l = this.latestSlotByClearUSK.get(usk.clearCopy());
        if (l != null) {
            return l;
        }
        return -1L;
    }

    public USKFetcherTag getFetcher(USK usk, FetchContext ctx, boolean keepLast, boolean persistent, USKFetcherCallback callback, boolean ownFetchContext, ObjectContainer container, ClientContext context) {
        return USKFetcherTag.create(usk, callback, context.nodeDBHandle, persistent, container, ctx, keepLast, 0, ownFetchContext);
    }

    synchronized USKFetcher getFetcher(USK usk, FetchContext ctx, ClientRequester requester, boolean keepLastData) {
        USKFetcher f = this.fetchersByUSK.get(usk);
        if (f != null && f.parent.priorityClass == requester.priorityClass && f.ctx.equals(ctx) && f.keepLastData == keepLastData) {
            return f;
        }
        f = new USKFetcher(usk, this, ctx, requester, 3, false, keepLastData);
        this.fetchersByUSK.put(usk, f);
        return f;
    }

    public USKFetcherTag getFetcherForInsertDontSchedule(USK usk, short prioClass, USKFetcherCallback cb, RequestClient client, ObjectContainer container, ClientContext context, boolean persistent) {
        return this.getFetcher(usk, persistent ? new FetchContext(this.backgroundFetchContext, 0, false, null) : this.backgroundFetchContext, true, client.persistent(), cb, true, container, context);
    }

    public void hintUpdate(USK usk, long edition, ClientContext context) {
        if (edition < this.lookupLatestSlot(usk)) {
            return;
        }
        FreenetURI uri = usk.copy(edition).getURI();
        ClientGetter get = new ClientGetter(new NullClientCallback(), uri, new FetchContext(this.backgroundFetchContext, 0, false, null), 3, (RequestClient)this, (Bucket)new NullBucket(), null);
        try {
            get.start(null, context);
        }
        catch (FetchException e) {
            // empty catch block
        }
    }

    public void hintUpdate(FreenetURI uri, ClientContext context) throws MalformedURLException {
        if (uri.getSuggestedEdition() < this.lookupLatestSlot(USK.create(uri))) {
            return;
        }
        ClientGetter get = new ClientGetter(new NullClientCallback(), uri, new FetchContext(this.backgroundFetchContext, 0, false, null), 3, (RequestClient)this, (Bucket)new NullBucket(), null);
        try {
            get.start(null, context);
        }
        catch (FetchException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTemporaryBackgroundFetcher(USK usk, ClientContext context, final FetchContext fctx, boolean prefetchContent) {
        USK clear = usk.clearCopy();
        USKFetcher sched = null;
        Vector<USKFetcher> toCancel = null;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USKFetcher f = this.temporaryBackgroundFetchersLRU.get(clear);
            if (f == null) {
                sched = f = new USKFetcher(usk, this, this.backgroundFetchContext, new USKFetcherWrapper(usk, 3, this), 3, false, false);
                this.temporaryBackgroundFetchersLRU.push(clear, f);
            }
            if (prefetchContent) {
                final long min = this.lookupKnownGood(usk);
                f.addCallback(new USKFetcherCallback(){

                    public void onCancelled(ObjectContainer container, ClientContext context) {
                    }

                    public void onFailure(ObjectContainer container, ClientContext context) {
                    }

                    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
                        if (l <= min) {
                            return;
                        }
                        FreenetURI uri = key.copy(l).getURI();
                        ClientGetter get = new ClientGetter(new NullClientCallback(), uri, new FetchContext(fctx, 0, false, null), 3, (RequestClient)USKManager.this, (Bucket)new NullBucket(), null);
                        try {
                            get.start(null, context);
                        }
                        catch (FetchException e) {
                            // empty catch block
                        }
                    }

                    public short getPollingPriorityNormal() {
                        return 3;
                    }

                    public short getPollingPriorityProgress() {
                        return 3;
                    }
                });
            }
            this.temporaryBackgroundFetchersLRU.push(clear, f);
            while (this.temporaryBackgroundFetchersLRU.size() > NodeClientCore.maxBackgroundUSKFetchers) {
                USKFetcher fetcher = this.temporaryBackgroundFetchersLRU.popValue();
                if (!fetcher.hasSubscribers()) {
                    if (toCancel == null) {
                        toCancel = new Vector<USKFetcher>(2);
                    }
                    toCancel.add(fetcher);
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Allowing temporary background fetcher to continue as it has subscribers... " + fetcher);
                }
                fetcher.killOnLoseSubscribers();
            }
        }
        if (toCancel != null) {
            for (int i = 0; i < toCancel.size(); ++i) {
                USKFetcher fetcher = (USKFetcher)toCancel.get(i);
                fetcher.cancel(null, context);
            }
        }
        if (sched != null) {
            sched.schedule(null, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKnownGood(USK origUSK, final long number, final ClientContext context) {
        USKCallback[] callbacks;
        if (logMINOR) {
            Logger.minor(this, "Updating " + origUSK.getURI() + " : " + number);
        }
        USK clear = origUSK.clearCopy();
        boolean newSlot = false;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            Long l = this.latestKnownGoodByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old known good: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestKnownGoodByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
            } else {
                return;
            }
            l = this.latestSlotByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old slot: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestSlotByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
                newSlot = true;
            }
            callbacks = this.subscribersByClearUSK.get(clear);
        }
        if (callbacks != null) {
            final USK usk = origUSK.copy(number);
            final boolean newSlotToo = newSlot;
            for (final USKCallback callback : callbacks) {
                context.mainExecutor.execute(new Runnable(){

                    public void run() {
                        callback.onFoundEdition(number, usk, null, context, false, (short)-1, null, true, newSlotToo);
                    }
                }, "USKManager callback executor for " + callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSlot(USK origUSK, final long number, final ClientContext context) {
        USKCallback[] callbacks;
        if (logMINOR) {
            Logger.minor(this, "Updating " + origUSK.getURI() + " : " + number);
        }
        USK clear = origUSK.clearCopy();
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            Long l = this.latestSlotByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old slot: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestSlotByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
            } else {
                return;
            }
            callbacks = this.subscribersByClearUSK.get(clear);
        }
        if (callbacks != null) {
            final USK usk = origUSK.copy(number);
            for (final USKCallback callback : callbacks) {
                context.mainExecutor.execute(new Runnable(){

                    public void run() {
                        callback.onFoundEdition(number, usk, null, context, false, (short)-1, null, false, false);
                    }
                }, "USKManager callback executor for " + callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(USK origUSK, USKCallback cb, boolean runBackgroundFetch, RequestClient client) {
        if (logMINOR) {
            Logger.minor(this, "Subscribing to " + origUSK + " for " + cb);
        }
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKManager subscriptions cannot be persistent");
        }
        USKFetcher sched = null;
        long ed = origUSK.suggestedEdition;
        if (ed < 0L) {
            Logger.error(this, "Subscribing to USK with negative edition number: " + ed);
            ed = -ed;
        }
        long curEd = this.lookupLatestSlot(origUSK);
        long goodEd = this.lookupKnownGood(origUSK);
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USK clear = origUSK.clearCopy();
            USKCallback[] callbacks = this.subscribersByClearUSK.get(clear);
            if (callbacks == null) {
                callbacks = new USKCallback[1];
            } else {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] != cb) continue;
                    return;
                }
                USKCallback[] newCallbacks = new USKCallback[callbacks.length + 1];
                System.arraycopy(callbacks, 0, newCallbacks, 0, callbacks.length);
                callbacks = newCallbacks;
            }
            callbacks[callbacks.length - 1] = cb;
            this.subscribersByClearUSK.put(clear, callbacks);
            if (runBackgroundFetch) {
                USKFetcher f = this.backgroundFetchersByClearUSK.get(clear);
                if (f == null) {
                    sched = f = new USKFetcher(origUSK, this, this.backgroundFetchContext, new USKFetcherWrapper(origUSK, 3, client), 10, true, false);
                    this.backgroundFetchersByClearUSK.put(clear, f);
                }
                f.addSubscriber(cb);
            }
        }
        if (goodEd > ed) {
            cb.onFoundEdition(goodEd, origUSK.copy(curEd), null, this.context, false, (short)-1, null, true, curEd > ed);
        } else if (curEd > ed) {
            cb.onFoundEdition(curEd, origUSK.copy(curEd), null, this.context, false, (short)-1, null, false, false);
        }
        final USKFetcher fetcher = sched;
        if (fetcher != null) {
            this.executor.execute(new Runnable(){

                public void run() {
                    fetcher.schedule(null, USKManager.this.context);
                }
            }, "USKManager.schedule for " + fetcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(USK origUSK, USKCallback cb) {
        USKFetcher toCancel = null;
        USKFetcher toCancelAlt = null;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USK clear = origUSK.clearCopy();
            USKCallback[] callbacks = this.subscribersByClearUSK.get(clear);
            if (callbacks == null) {
                Logger.error(this, "The callback is null! it has been already unsubscribed, hasn't it?", new Exception("debug"));
                return;
            }
            int j = 0;
            for (int i = 0; i < callbacks.length; ++i) {
                USKCallback c = callbacks[i];
                if (c == null || c == cb) continue;
                callbacks[j++] = c;
            }
            USKCallback[] newCallbacks = new USKCallback[j];
            System.arraycopy(callbacks, 0, newCallbacks, 0, j);
            if (newCallbacks.length > 0) {
                this.subscribersByClearUSK.put(clear, callbacks);
            } else {
                this.subscribersByClearUSK.remove(clear);
                this.fetchersByUSK.remove(origUSK);
            }
            USKFetcher f = this.backgroundFetchersByClearUSK.get(clear);
            if (f != null) {
                f.removeSubscriber(cb, this.context);
                if (!f.hasSubscribers()) {
                    toCancel = f;
                    this.backgroundFetchersByClearUSK.remove(clear);
                }
            }
            if ((f = this.temporaryBackgroundFetchersLRU.get(clear)) != null) {
                f.removeCallback(cb);
                if (!f.hasCallbacks()) {
                    if (toCancel != null) {
                        toCancelAlt = f;
                        Logger.error(this, "Subscribed in both backgroundFetchers and temporaryBackgroundFetchers???: " + cb + " for " + origUSK);
                    } else {
                        toCancel = f;
                    }
                    this.temporaryBackgroundFetchersLRU.removeKey(clear);
                }
            }
        }
        if (toCancel != null) {
            toCancel.cancel(null, this.context);
        }
        if (toCancelAlt != null) {
            toCancelAlt.cancel(null, this.context);
        }
    }

    public USKRetriever subscribeContent(USK origUSK, USKRetrieverCallback cb, boolean runBackgroundFetch, FetchContext fctx, short prio, RequestClient client) {
        USKRetriever ret = new USKRetriever(fctx, prio, client, cb, origUSK);
        this.subscribe(origUSK, ret, runBackgroundFetch, client);
        return ret;
    }

    public void unsubscribeContent(USK origUSK, USKRetriever ret, boolean runBackgroundFetch) {
        this.unsubscribe(origUSK, ret);
    }

    public int getFetcherByUSKSize() {
        return this.fetchersByUSK.size();
    }

    public int getBackgroundFetcherByUSKSize() {
        return this.backgroundFetchersByClearUSK.size();
    }

    public int getTemporaryBackgroundFetchersLRU() {
        return this.temporaryBackgroundFetchersLRU.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinished(USKFetcher fetcher) {
        USK orig = fetcher.getOriginalUSK();
        USK clear = orig.clearCopy();
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            if (this.backgroundFetchersByClearUSK.get(clear) == fetcher) {
                this.backgroundFetchersByClearUSK.remove(clear);
                Logger.error(this, "onCancelled for " + fetcher + " - was still registered, how did this happen??", new Exception("debug"));
            }
            if (this.temporaryBackgroundFetchersLRU.get(clear) == fetcher) {
                this.temporaryBackgroundFetchersLRU.removeKey(clear);
            }
            if (this.fetchersByUSK.get(orig) == fetcher) {
                this.fetchersByUSK.remove(clear);
            }
        }
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

