/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableUSK;
import freenet.keys.USK;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;

public class USKInserter
implements ClientPutState,
USKFetcherCallback,
PutCompletionCallback {
    final BaseClientPutter parent;
    Bucket data;
    final short compressionCodec;
    final InsertContext ctx;
    final PutCompletionCallback cb;
    final boolean isMetadata;
    final int sourceLength;
    final int token;
    final boolean getCHKOnly;
    public final Object tokenObject;
    final boolean persistent;
    final InsertableUSK privUSK;
    final USK pubUSK;
    private USKFetcherTag fetcher;
    private SingleBlockInserter sbi;
    private long edition;
    private int consecutiveCollisions;
    private boolean finished;
    private static final long MAX_TRIED_SLOTS = 10L;
    private boolean freeData;
    final int hashCode = super.hashCode();

    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.scheduleFetcher(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFetcher(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.pubUSK, 5);
        }
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "scheduling fetcher for " + this.pubUSK.getURI());
            }
            if (this.finished) {
                return;
            }
            this.fetcher = context.uskManager.getFetcherForInsertDontSchedule(this.persistent ? this.pubUSK.clone() : this.pubUSK, this.parent.priorityClass, this, this.parent.getClient(), container, context, this.persistent);
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "scheduled: " + this.fetcher);
            }
        }
        if (this.persistent) {
            container.store((Object)this.fetcher);
            container.store((Object)this);
        }
        this.fetcher.schedule(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean lastContentWasMetadata, short codec, byte[] hisData, boolean newKnownGood, boolean newSlotToo) {
        boolean alreadyInserted = false;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            this.edition = Math.max(l, this.edition);
            this.consecutiveCollisions = 0;
            if (lastContentWasMetadata == this.isMetadata && hisData != null && codec == this.compressionCodec) {
                try {
                    byte[] myData;
                    if (this.persistent) {
                        container.activate((Object)this.data, 1);
                    }
                    if (Arrays.equals(myData = BucketTools.toByteArray(this.data), hisData)) {
                        alreadyInserted = true;
                        this.finished = true;
                        this.sbi = null;
                    }
                }
                catch (IOException e) {
                    Logger.error(this, "Could not decode: " + e, e);
                }
            }
            if (this.persistent) {
                container.activate((Object)this.fetcher, 1);
                container.activate((Object)this.fetcher.ctx, 1);
                this.fetcher.removeFrom(container, context);
                this.fetcher.ctx.removeFrom(container);
                this.fetcher = null;
                container.store((Object)this);
            }
        }
        if (alreadyInserted) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.addMustSucceedBlocks(1, container);
            this.parent.completedBlock(true, container, context);
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
                container.activate((Object)this.pubUSK, 5);
            }
            this.cb.onEncode(this.pubUSK.copy(this.edition), this, container, context);
            this.cb.onSuccess(this, container, context);
            if (this.freeData) {
                this.data.free();
                if (this.persistent) {
                    this.data.removeFrom(container);
                }
            }
        } else {
            this.scheduleInsert(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInsert(ObjectContainer container, ClientContext context) {
        long edNo = Math.max(this.edition, context.uskManager.lookupLatestSlot(this.pubUSK) + 1L);
        if (this.persistent) {
            container.activate((Object)this.privUSK, 5);
            container.activate((Object)this.pubUSK, 5);
        }
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.edition = edNo;
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "scheduling insert for " + this.pubUSK.getURI() + ' ' + this.edition);
            }
            this.sbi = new SingleBlockInserter(this.parent, this.data, this.compressionCodec, this.privUSK.getInsertableSSK(this.edition).getInsertURI(), this.ctx, this, this.isMetadata, this.sourceLength, this.token, this.getCHKOnly, false, true, this.tokenObject, container, context, this.persistent, false);
        }
        try {
            this.sbi.schedule(container, context);
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            USKInserter uSKInserter2 = this;
            synchronized (uSKInserter2) {
                this.finished = true;
            }
            if (this.freeData) {
                if (this.persistent) {
                    container.activate((Object)this.data, 1);
                }
                this.data.free();
                this.data.removeFrom(container);
                uSKInserter2 = this;
                synchronized (uSKInserter2) {
                    this.data = null;
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            this.cb.onFailure(e, this, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        FreenetURI realURI;
        if (this.persistent) {
            container.activate((Object)this.pubUSK, 5);
        }
        USK newEdition = this.pubUSK.copy(this.edition);
        this.finished = true;
        this.sbi = null;
        FreenetURI targetURI = this.pubUSK.getSSK(this.edition).getURI();
        if (!targetURI.equals(realURI = ((SingleBlockInserter)state).getURI(container, context))) {
            Logger.error(this, "URI should be " + targetURI + " actually is " + realURI);
        } else {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "URI should be " + targetURI + " actually is " + realURI);
            }
            context.uskManager.updateKnownGood(this.pubUSK, this.edition, context);
        }
        if (this.persistent) {
            state.removeFrom(container, context);
        }
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.data, 1);
            }
            this.data.free();
            if (this.persistent) {
                this.data.removeFrom(container);
            }
            USKInserter uSKInserter = this;
            synchronized (uSKInserter) {
                this.data = null;
            }
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.store((Object)this);
        }
        this.cb.onEncode(newEdition, this, container, context);
        this.cb.onSuccess(this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        SingleBlockInserter oldSBI;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            oldSBI = this.sbi;
            this.sbi = null;
            if (e.getMode() == 9) {
                ++this.edition;
                ++this.consecutiveCollisions;
                if (this.persistent) {
                    container.store((Object)this);
                }
                if ((long)this.consecutiveCollisions > 10L) {
                    this.scheduleFetcher(container, context);
                } else {
                    this.scheduleInsert(container, context);
                }
            } else {
                if (this.freeData) {
                    if (this.persistent) {
                        container.activate((Object)this.data, 1);
                    }
                    this.data.free();
                    this.data.removeFrom(container);
                    USKInserter uSKInserter2 = this;
                    synchronized (uSKInserter2) {
                        this.data = null;
                    }
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                }
                if (this.persistent) {
                    container.activate((Object)this.cb, 1);
                }
                this.cb.onFailure(e, state, container, context);
            }
        }
        if (state != null && this.persistent) {
            state.removeFrom(container, context);
        }
        if (oldSBI != null && oldSBI != state) {
            container.activate((Object)oldSBI, 1);
            oldSBI.removeFrom(container, context);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public USKInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean getCHKOnly, boolean addToParent, Object tokenObject, ObjectContainer container, ClientContext context, boolean freeData, boolean persistent) throws MalformedURLException {
        this.tokenObject = tokenObject;
        this.persistent = persistent;
        this.parent = parent;
        this.data = data;
        this.compressionCodec = compressionCodec;
        this.ctx = ctx;
        this.cb = cb;
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.token = token;
        this.getCHKOnly = getCHKOnly;
        if (addToParent) {
            parent.addBlock(container);
            parent.addMustSucceedBlocks(1, container);
            parent.notifyClients(container, context);
        }
        this.privUSK = InsertableUSK.createInsertable(uri, persistent);
        this.pubUSK = this.privUSK.getUSK();
        this.edition = this.pubUSK.suggestedEdition;
        this.freeData = freeData;
    }

    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        USKFetcherTag tag;
        boolean persist = this.persistent;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            tag = this.fetcher;
            this.fetcher = null;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (tag != null) {
            tag.cancel(container, context);
            if (persist) {
                container.activate((Object)this, 1);
            }
        }
        if (this.sbi != null) {
            this.sbi.cancel(container, context);
            if (persist) {
                container.activate((Object)this, 1);
            }
        }
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.data, 1);
            }
            this.data.free();
            if (this.persistent) {
                this.data.removeFrom(container);
            }
            uSKInserter = this;
            synchronized (uSKInserter) {
                this.data = null;
            }
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    public void onFailure(ObjectContainer container, ClientContext context) {
        Logger.error(this, "Fetcher failed", new Exception("debug"));
        this.scheduleInsert(container, context);
    }

    public synchronized void onCancelled(ObjectContainer container, ClientContext context) {
        if (this.fetcher != null) {
            if (this.persistent) {
                container.activate((Object)this.fetcher, 1);
                container.activate((Object)this.fetcher.ctx, 1);
                this.fetcher.ctx.removeFrom(container);
                this.fetcher.removeFrom(container, context);
            }
            this.fetcher = null;
        }
        if (this.finished) {
            return;
        }
        Logger.error(this, "Unexpected onCancelled()", new Exception("error"));
        this.cancel(container, context);
    }

    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Logger.error(this, "Got onTransition(" + oldState + ',' + newState + ')');
    }

    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got onMetadata(" + m + ',' + state + ')');
    }

    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    public Object getToken() {
        return this.tokenObject;
    }

    public void onFetchable(ClientPutState state, ObjectContainer container) {
    }

    public short getPollingPriorityNormal() {
        return this.parent.getPriorityClass();
    }

    public short getPollingPriorityProgress() {
        return this.parent.getPriorityClass();
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Removing from database: " + this, (Throwable)new Exception("debug"));
        }
        if (this.freeData && this.data != null && container.ext().isStored((Object)this.data)) {
            try {
                this.data.free();
            }
            catch (Throwable t) {
                Logger.error(this, "Already freed? Caught in removeFrom on " + this + " : " + this.data + " : " + t, t);
            }
            this.data.removeFrom(container);
        }
        container.activate((Object)this.privUSK, 5);
        this.privUSK.removeFrom(container);
        container.activate((Object)this.pubUSK, 5);
        this.pubUSK.removeFrom(container);
        if (this.fetcher != null) {
            Logger.error(this, "Fetcher tag still present: " + this.fetcher + " in removeFrom() for " + this, new Exception("debug"));
            container.activate((Object)this.fetcher, 1);
            container.activate((Object)this.fetcher.ctx, 1);
            this.fetcher.ctx.removeFrom(container);
            this.fetcher.removeFrom(container, context);
        }
        if (this.sbi != null) {
            Logger.error(this, "sbi still present: " + this.sbi + " in removeFrom() for " + this);
            container.activate((Object)this.sbi, 1);
            this.sbi.removeFrom(container, context);
        }
        container.delete((Object)this);
    }
}

