/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherWrapper;
import freenet.client.async.USKManager;
import freenet.keys.USK;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

class USKFetcherTag
implements ClientGetState,
USKFetcherCallback {
    public final long nodeDBHandle;
    public final USKFetcherCallback callback;
    public final USK origUSK;
    protected long edition;
    public final boolean persistent;
    public final FetchContext ctx;
    public final boolean keepLastData;
    private short priority;
    private long token;
    private transient USKFetcher fetcher;
    private short pollingPriorityNormal;
    private short pollingPriorityProgress;
    private boolean finished;
    private final boolean ownFetchContext;
    private static final RequestClient client = new RequestClient(){

        public boolean persistent() {
            return false;
        }

        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }
    };
    private static volatile boolean logMINOR;

    private USKFetcherTag(USK origUSK, USKFetcherCallback callback, long nodeDBHandle, boolean persistent, ObjectContainer container, FetchContext ctx, boolean keepLastData, long token, boolean hasOwnFetchContext) {
        this.nodeDBHandle = nodeDBHandle;
        this.callback = callback;
        this.origUSK = origUSK;
        this.edition = origUSK.suggestedEdition;
        this.persistent = persistent;
        this.ctx = ctx;
        this.keepLastData = keepLastData;
        this.token = token;
        this.ownFetchContext = hasOwnFetchContext;
        this.pollingPriorityNormal = callback.getPollingPriorityNormal();
        this.pollingPriorityProgress = callback.getPollingPriorityProgress();
        this.priority = this.pollingPriorityNormal;
    }

    public static USKFetcherTag create(USK usk, USKFetcherCallback callback, long nodeDBHandle, boolean persistent, ObjectContainer container, FetchContext ctx, boolean keepLast, int token, boolean hasOwnFetchContext) {
        USKFetcherTag tag = new USKFetcherTag(usk, callback, nodeDBHandle, persistent, container, ctx, keepLast, token, hasOwnFetchContext);
        if (persistent) {
            container.store((Object)tag);
        }
        return tag;
    }

    synchronized void updatedEdition(long ed, ObjectContainer container) {
        if (this.edition < ed) {
            this.edition = ed;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public void start(USKManager manager, ClientContext context, ObjectContainer container) {
        USK usk = this.origUSK;
        if (this.persistent) {
            container.activate((Object)this.origUSK, 5);
        }
        if (usk.suggestedEdition < this.edition) {
            usk = usk.copy(this.edition);
        } else if (this.persistent) {
            usk = usk.clone();
        }
        this.fetcher = manager.getFetcher(usk, this.ctx, new USKFetcherWrapper(usk, this.priority, client), this.keepLastData);
        this.fetcher.addCallback(this);
        this.fetcher.schedule(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        if (this.fetcher != null) {
            this.fetcher.cancel(null, context);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            this.finished = true;
        }
    }

    public long getToken() {
        return this.token;
    }

    public void schedule(ObjectContainer container, ClientContext context) {
        this.start(context.uskManager, context, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancelled(ObjectContainer container, ClientContext context) {
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            this.finished = true;
        }
        if (this.persistent) {
            try {
                context.jobRunner.runBlocking(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        container.activate((Object)USKFetcherTag.this.callback, 1);
                        USKFetcherTag.this.callback.onCancelled(container, context);
                        USKFetcherTag.this.removeFrom(container, context);
                        container.deactivate((Object)USKFetcherTag.this.callback, 1);
                        return false;
                    }
                }, 7);
            }
            catch (DatabaseDisabledException databaseDisabledException) {}
        } else {
            this.callback.onCancelled(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(ObjectContainer container, ClientContext context) {
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            this.finished = true;
        }
        if (this.persistent) {
            if (container != null) {
                container.activate((Object)this.callback, 1);
                this.callback.onFailure(container, context);
                container.deactivate((Object)this.callback, 1);
                this.removeFrom(container, context);
            } else {
                try {
                    context.jobRunner.queue(new DBJob(){

                        public boolean run(ObjectContainer container, ClientContext context) {
                            container.activate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.callback.onFailure(container, context);
                            container.deactivate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.removeFrom(container, context);
                            return true;
                        }
                    }, 7, false);
                }
                catch (DatabaseDisabledException databaseDisabledException) {}
            }
        } else {
            this.callback.onFailure(container, context);
        }
    }

    public short getPollingPriorityNormal() {
        return this.pollingPriorityNormal;
    }

    public short getPollingPriorityProgress() {
        return this.pollingPriorityProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFoundEdition(final long l, final USK key, ObjectContainer container, ClientContext context, final boolean metadata, final short codec, final byte[] data, final boolean newKnownGood, final boolean newSlotToo) {
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.fetcher == null) {
                Logger.error(this, "onFoundEdition but fetcher is null - isn't onFoundEdition() terminal for USKFetcherCallback's??", new Exception("debug"));
            }
            this.finished = true;
            this.fetcher = null;
        }
        if (this.persistent) {
            if (container != null) {
                container.activate((Object)this.callback, 1);
                this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
                container.deactivate((Object)this.callback, 1);
                this.removeFrom(container, context);
            } else {
                try {
                    context.jobRunner.queue(new DBJob(){

                        public boolean run(ObjectContainer container, ClientContext context) {
                            container.activate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
                            container.deactivate((Object)USKFetcherTag.this.callback, 1);
                            USKFetcherTag.this.removeFrom(container, context);
                            return false;
                        }
                    }, 7, false);
                }
                catch (DatabaseDisabledException e) {}
            }
        } else {
            this.callback.onFoundEdition(l, key, container, context, metadata, codec, data, newKnownGood, newSlotToo);
        }
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + this);
        }
        container.activate((Object)this.origUSK, 5);
        this.origUSK.removeFrom(container);
        if (this.ownFetchContext) {
            container.activate((Object)this.ctx, 1);
            this.ctx.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

