/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.USKCallback;
import freenet.client.async.USKChecker;
import freenet.client.async.USKCheckerCallback;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKManager;
import freenet.keys.ClientKey;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.SSKBlock;
import freenet.keys.USK;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class USKFetcher
implements ClientGetState,
USKCallback,
HasKeyListener,
KeyListener {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final USKManager uskManager;
    private final USK origUSK;
    private final LinkedList<USKFetcherCallback> callbacks;
    final FetchContext ctx;
    private boolean completed;
    private boolean cancelled;
    private boolean killOnLoseSubscribers;
    final ClientRequester parent;
    private Bucket lastRequestData;
    private short lastCompressionCodec;
    private boolean lastWasMetadata;
    private long firstKeyWatching = -1L;
    private final ArrayList<ClientSSK> keysWatching;
    private long checkedDatastoreUpTo = -1L;
    private final ArrayList<USKAttempt> attemptsToStart;
    private static final int WATCH_KEYS = 50;
    private final Vector<USKAttempt> runningAttempts;
    private long lastFetchedEdition;
    private long lastAddedEdition;
    long minFailures;
    final long origMinFailures;
    static final int origSleepTime = 1800000;
    static final int maxSleepTime = 86400000;
    int sleepTime = 1800000;
    private final long maxMinFailures;
    private static final long DEFAULT_MAX_MIN_FAILURES = 100L;
    private long valueAtSchedule;
    private final boolean backgroundPoll;
    final boolean keepLastData;
    private boolean started;
    private static short DEFAULT_NORMAL_POLL_PRIORITY;
    private short normalPollPriority = DEFAULT_NORMAL_POLL_PRIORITY;
    private static short DEFAULT_PROGRESS_POLL_PRIORITY;
    private short progressPollPriority = DEFAULT_PROGRESS_POLL_PRIORITY;
    final HashSet<USKCallback> subscribers;
    private boolean runningStoreChecker = false;

    public synchronized boolean addCallback(USKFetcherCallback cb) {
        if (this.completed) {
            return false;
        }
        this.callbacks.add(cb);
        return true;
    }

    USKFetcher(USK origUSK, USKManager manager, FetchContext ctx, ClientRequester requester, int minFailures, boolean pollForever, boolean keepLastData) {
        this(origUSK, manager, ctx, requester, minFailures, pollForever, 100L, keepLastData);
    }

    USKFetcher(USK origUSK, USKManager manager, FetchContext ctx, ClientRequester requester, int minFailures, boolean pollForever, long maxProbeEditions, boolean keepLastData) {
        this.parent = requester;
        this.maxMinFailures = maxProbeEditions;
        this.origUSK = origUSK;
        this.uskManager = manager;
        this.minFailures = this.origMinFailures = (long)minFailures;
        this.runningAttempts = new Vector();
        this.callbacks = new LinkedList();
        this.subscribers = new HashSet();
        this.lastFetchedEdition = -1L;
        this.lastAddedEdition = -1L;
        this.ctx = ctx;
        this.backgroundPoll = pollForever;
        this.keepLastData = keepLastData;
        this.keysWatching = new ArrayList();
        this.attemptsToStart = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDNF(USKAttempt att, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "DNF: " + att);
        }
        boolean finished = false;
        long curLatest = this.uskManager.lookupLatestSlot(this.origUSK);
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.completed || this.cancelled) {
                return;
            }
            this.lastFetchedEdition = Math.max(this.lastFetchedEdition, att.number);
            this.runningAttempts.remove(att);
            if (this.runningAttempts.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "latest: " + curLatest + ", last fetched: " + this.lastFetchedEdition + ", curLatest+MIN_FAILURES: " + (curLatest + this.minFailures));
                }
                if (this.started) {
                    finished = true;
                }
            } else if (logMINOR) {
                Logger.minor(this, "Remaining: " + this.runningAttempts.size());
            }
        }
        if (finished) {
            this.finishSuccess(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSuccess(ClientContext context) {
        if (this.backgroundPoll) {
            long end;
            long valAtEnd = this.uskManager.lookupLatestSlot(this.origUSK);
            long now = System.currentTimeMillis();
            USKFetcher uSKFetcher = this;
            synchronized (uSKFetcher) {
                this.started = false;
                int newSleepTime = this.sleepTime * 2;
                if (newSleepTime > 86400000) {
                    newSleepTime = 86400000;
                }
                this.sleepTime = newSleepTime;
                end = now + (long)context.random.nextInt(this.sleepTime);
                if (valAtEnd > this.valueAtSchedule && valAtEnd > this.origUSK.suggestedEdition) {
                    this.minFailures = this.origMinFailures;
                    this.sleepTime = 1800000;
                    end = now;
                    if (logMINOR) {
                        Logger.minor(this, "We have advanced: at start, " + this.valueAtSchedule + " at end, " + valAtEnd);
                    }
                } else {
                    long newMinFailures = Math.max((long)((int)((double)this.minFailures * 1.25)), this.minFailures + 1L);
                    if (newMinFailures > this.maxMinFailures) {
                        newMinFailures = this.maxMinFailures;
                    }
                    this.minFailures = newMinFailures;
                }
            }
            this.schedule(end - now, null, context);
        } else {
            byte[] data;
            USKFetcherCallback[] cb;
            this.uskManager.unsubscribe(this.origUSK, this);
            this.uskManager.onFinished(this);
            context.getSskFetchScheduler().schedTransient.removePendingKeys(this);
            long ed = this.uskManager.lookupLatestSlot(this.origUSK);
            USKFetcher uSKFetcher = this;
            synchronized (uSKFetcher) {
                this.completed = true;
                cb = this.callbacks.toArray(new USKFetcherCallback[this.callbacks.size()]);
            }
            if (this.lastRequestData == null) {
                data = null;
            } else {
                try {
                    data = BucketTools.toByteArray(this.lastRequestData);
                }
                catch (IOException e) {
                    Logger.error(this, "Unable to turn lastRequestData into byte[]: caught I/O exception: " + e, e);
                    data = null;
                }
            }
            for (int i = 0; i < cb.length; ++i) {
                try {
                    cb[i].onFoundEdition(ed, this.origUSK.copy(ed), null, context, this.lastWasMetadata, this.lastCompressionCodec, data, false, false);
                    continue;
                }
                catch (Exception e) {
                    Logger.error(this, "An exception occured while dealing with a callback:" + cb[i].toString() + "\n" + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSuccess(USKAttempt att, boolean dontUpdate, ClientSSKBlock block, ClientContext context) {
        Vector<USKAttempt> killAttempts;
        long curLatest;
        long lastEd = this.uskManager.lookupLatestSlot(this.origUSK);
        boolean decode = false;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.runningAttempts.remove(att);
            curLatest = att.number;
            if (this.completed || this.cancelled) {
                return;
            }
            decode = curLatest >= lastEd && (!dontUpdate || block != null);
            curLatest = Math.max(lastEd, curLatest);
            if (logMINOR) {
                Logger.minor(this, "Latest: " + curLatest);
            }
            long addTo = curLatest + this.minFailures;
            long addFrom = Math.max(this.lastAddedEdition + 1L, curLatest + 1L);
            if (logMINOR) {
                Logger.minor(this, "Adding from " + addFrom + " to " + addTo + " for " + this.origUSK);
            }
            if (addTo >= addFrom) {
                for (long i = addFrom; i <= addTo; ++i) {
                    if (logMINOR) {
                        Logger.minor(this, "Adding checker for edition " + i + " for " + this.origUSK);
                    }
                    this.attemptsToStart.add(this.add(i));
                }
            }
            killAttempts = this.cancelBefore(curLatest, context);
            this.fillKeysWatching(curLatest + 1L, context);
        }
        this.finishCancelBefore(killAttempts, context);
        Bucket data = null;
        if (decode) {
            try {
                data = block.decode(context.getBucketFactory(this.parent.persistent()), 1025, true);
            }
            catch (KeyDecodeException e) {
                data = null;
            }
            catch (IOException e) {
                data = null;
                Logger.error(this, "An IOE occured while decoding: " + e.getMessage(), e);
            }
        }
        USKFetcher uSKFetcher2 = this;
        synchronized (uSKFetcher2) {
            if (decode) {
                this.lastCompressionCodec = block.getCompressionCodec();
                this.lastWasMetadata = block.isMetadata();
                if (this.keepLastData) {
                    if (this.lastRequestData != null) {
                        this.lastRequestData.free();
                    }
                    this.lastRequestData = data;
                } else {
                    data.free();
                }
            }
        }
        if (!dontUpdate) {
            this.uskManager.updateSlot(this.origUSK, curLatest, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled(USKAttempt att, ClientContext context) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.runningAttempts.remove(att);
            if (!this.runningAttempts.isEmpty()) {
                return;
            }
            if (this.cancelled) {
                this.finishCancelled(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCancelled(ClientContext context) {
        USKFetcherCallback[] cb;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.completed = true;
            cb = this.callbacks.toArray(new USKFetcherCallback[this.callbacks.size()]);
        }
        for (int i = 0; i < cb.length; ++i) {
            cb[i].onCancelled(null, context);
        }
    }

    public void onFail(USKAttempt attempt, ClientContext context) {
        this.onDNF(attempt, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<USKAttempt> cancelBefore(long curLatest, ClientContext context) {
        Vector<USKAttempt> v = null;
        int count = 0;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            Iterator<USKAttempt> i = this.runningAttempts.iterator();
            while (i.hasNext()) {
                USKAttempt att = i.next();
                if (att.number < curLatest) {
                    if (v == null) {
                        v = new Vector<USKAttempt>(this.runningAttempts.size() - count);
                    }
                    v.add(att);
                    i.remove();
                }
                ++count;
            }
        }
        return v;
    }

    private void finishCancelBefore(Vector<USKAttempt> v, ClientContext context) {
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                USKAttempt att = v.get(i);
                att.cancel(null, context);
            }
        }
    }

    private synchronized USKAttempt add(long i) {
        if (this.cancelled) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Adding USKAttempt for " + i + " for " + this.origUSK.getURI());
        }
        if (!this.runningAttempts.isEmpty()) {
            USKAttempt last = this.runningAttempts.lastElement();
            if (last.number >= i) {
                if (logMINOR) {
                    Logger.minor(this, "Returning because last.number=" + i + " for " + this.origUSK.getURI());
                }
                return null;
            }
        }
        USKAttempt a = new USKAttempt(i);
        this.runningAttempts.add(a);
        this.lastAddedEdition = i;
        if (logMINOR) {
            Logger.minor(this, "Added " + a + " for " + this.origUSK);
        }
        return a;
    }

    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            return this.completed || this.cancelled;
        }
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    public void schedule(long delay, ObjectContainer container, final ClientContext context) {
        assert (container == null);
        if (delay <= 0L) {
            this.schedule(container, context);
        } else {
            context.ticker.queueTimedJob(new Runnable(){

                public void run() {
                    USKFetcher.this.schedule(null, context);
                }
            }, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ObjectContainer container, ClientContext context) {
        context.getSskFetchScheduler().schedTransient.addPendingKeys(this);
        this.updatePriorities();
        this.uskManager.subscribe(this.origUSK, this, false, this.parent.getClient());
        long lookedUp = this.uskManager.lookupLatestSlot(this.origUSK);
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            long startPoint;
            this.valueAtSchedule = Math.max(lookedUp, this.valueAtSchedule);
            if (this.cancelled) {
                return;
            }
            for (long i = startPoint = Math.max(this.origUSK.suggestedEdition, this.valueAtSchedule); i < startPoint + this.minFailures; ++i) {
                this.attemptsToStart.add(this.add(i));
            }
            this.started = true;
            this.fillKeysWatching(this.valueAtSchedule, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        USKAttempt[] attempts;
        this.uskManager.unsubscribe(this.origUSK, this);
        context.getSskFetchScheduler().schedTransient.removePendingKeys(this);
        assert (container == null);
        this.uskManager.onFinished(this);
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.cancelled = true;
            attempts = this.runningAttempts.toArray(new USKAttempt[this.runningAttempts.size()]);
        }
        for (int i = 0; i < attempts.length; ++i) {
            attempts[i].cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(USKCallback cb) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.add(cb);
        }
        this.updatePriorities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePriorities() {
        USKCallback[] localCallbacks;
        short normalPrio = 6;
        short progressPrio = 6;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            localCallbacks = this.subscribers.toArray(new USKCallback[this.subscribers.size()]);
        }
        if (localCallbacks.length == 0) {
            this.normalPollPriority = DEFAULT_NORMAL_POLL_PRIORITY;
            this.progressPollPriority = DEFAULT_PROGRESS_POLL_PRIORITY;
            return;
        }
        for (int i = 0; i < localCallbacks.length; ++i) {
            USKCallback cb = localCallbacks[i];
            short prio = cb.getPollingPriorityNormal();
            if (logDEBUG) {
                Logger.debug(this, "Normal priority for " + cb + " : " + prio);
            }
            if (prio < normalPrio) {
                normalPrio = prio;
            }
            if (logDEBUG) {
                Logger.debug(this, "Progress priority for " + cb + " : " + prio);
            }
            if ((prio = cb.getPollingPriorityProgress()) >= progressPrio) continue;
            progressPrio = prio;
        }
        if (logMINOR) {
            Logger.minor(this, "Updating priorities: normal=" + normalPrio + " progress=" + progressPrio + " for " + this + " for " + this.origUSK);
        }
        USKFetcher uSKFetcher2 = this;
        synchronized (uSKFetcher2) {
            this.normalPollPriority = normalPrio;
            this.progressPollPriority = progressPrio;
        }
    }

    public synchronized boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public synchronized boolean hasCallbacks() {
        return !this.callbacks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(USKCallback cb, ClientContext context) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.remove(cb);
        }
        this.updatePriorities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(USKCallback cb) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.remove(cb);
        }
    }

    public synchronized boolean hasLastData() {
        return this.lastRequestData != null;
    }

    public synchronized boolean lastContentWasMetadata() {
        return this.lastWasMetadata;
    }

    public synchronized short lastCompressionCodec() {
        return this.lastCompressionCodec;
    }

    public synchronized Bucket getLastData() {
        return this.lastRequestData;
    }

    public synchronized void freeLastData() {
        if (this.lastRequestData == null) {
            return;
        }
        this.lastRequestData.free();
        this.lastRequestData = null;
    }

    public synchronized void killOnLoseSubscribers() {
        this.killOnLoseSubscribers = true;
    }

    @Override
    public long getToken() {
        return -1L;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing USKFetcher in database", new Exception("error"));
        return false;
    }

    @Override
    public short getPollingPriorityNormal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getPollingPriorityProgress() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long ed, USK key, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        Vector<USKAttempt> killAttempts;
        if (newKnownGood && !newSlotToo) {
            return;
        }
        long lastEd = this.uskManager.lookupLatestSlot(this.origUSK);
        boolean decode = false;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.completed || this.cancelled) {
                return;
            }
            decode = lastEd == ed && data != null;
            ed = Math.max(lastEd, ed);
            if (logMINOR) {
                Logger.minor(this, "Latest: " + ed);
            }
            long addTo = ed + this.minFailures;
            long addFrom = Math.max(this.lastAddedEdition + 1L, ed + 1L);
            if (logMINOR) {
                Logger.minor(this, "Adding from " + addFrom + " to " + addTo + " for " + this.origUSK);
            }
            if (addTo >= addFrom) {
                for (long i = addFrom; i <= addTo; ++i) {
                    if (logMINOR) {
                        Logger.minor(this, "Adding checker for edition " + i + " for " + this.origUSK);
                    }
                    this.attemptsToStart.add(this.add(i));
                }
            }
            killAttempts = this.cancelBefore(ed, context);
            this.fillKeysWatching(ed + 1L, context);
        }
        this.finishCancelBefore(killAttempts, context);
        uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (decode) {
                this.lastCompressionCodec = codec;
                this.lastWasMetadata = metadata;
                if (this.keepLastData) {
                    if (this.lastRequestData != null) {
                        this.lastRequestData.free();
                    }
                    try {
                        this.lastRequestData = BucketTools.makeImmutableBucket(context.tempBucketFactory, data);
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught " + e, e);
                    }
                }
            }
        }
    }

    private synchronized void fillKeysWatching(long ed, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "fillKeysWatching from " + ed + " for " + this + " : " + this.origUSK, (Throwable)new Exception("debug"));
        }
        this.keysWatching.clear();
        for (int i = 0; i < 50; ++i) {
            this.keysWatching.add(this.origUSK.getSSK(ed + (long)i));
        }
        this.firstKeyWatching = ed;
        if (this.runningStoreChecker) {
            return;
        }
        long firstCheck = Math.max(this.firstKeyWatching, this.checkedDatastoreUpTo + 1L);
        final long lastCheck = this.firstKeyWatching + (long)this.keysWatching.size() - 1L;
        if (logMINOR) {
            Logger.minor(this, "firstCheck=" + firstCheck + " lastCheck=" + lastCheck);
        }
        if (lastCheck < firstCheck) {
            return;
        }
        int checkCount = (int)(lastCheck - firstCheck + 1L);
        int offset = (int)(firstCheck - this.firstKeyWatching);
        final Key[] checkStore = new Key[checkCount];
        for (int i = 0; i < checkStore.length; ++i) {
            checkStore[i] = this.keysWatching.get(i + offset).getNodeKey();
        }
        assert (offset + checkStore.length == this.keysWatching.size());
        assert (this.keysWatching.get(this.keysWatching.size() - 1).getURI().uskForSSK().getSuggestedEdition() == lastCheck);
        if (logMINOR) {
            Logger.minor(this, "Checking from " + firstCheck + " to " + lastCheck + " for " + this + " : " + this.origUSK);
        }
        SendableGet storeChecker = new SendableGet(this.parent){
            boolean done;
            {
                super(x0);
                this.done = false;
            }

            @Override
            public boolean dontCache(ObjectContainer container) {
                return false;
            }

            @Override
            public FetchContext getContext() {
                return USKFetcher.this.ctx;
            }

            @Override
            public long getCooldownWakeup(Object token, ObjectContainer container) {
                return -1L;
            }

            @Override
            public long getCooldownWakeupByKey(Key key, ObjectContainer container) {
                return -1L;
            }

            @Override
            public ClientKey getKey(Object token, ObjectContainer container) {
                return null;
            }

            @Override
            public boolean ignoreStore() {
                return false;
            }

            @Override
            public Key[] listKeys(ObjectContainer container) {
                return checkStore;
            }

            @Override
            public void onFailure(LowLevelGetException e, Object token, ObjectContainer container, ClientContext context) {
            }

            @Override
            public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
            }

            @Override
            public void resetCooldownTimes(ObjectContainer container) {
            }

            @Override
            public boolean hasValidKeys(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
                USKAttempt[] attempts;
                this.unregister(container, context);
                USKFetcher uSKFetcher = USKFetcher.this;
                synchronized (uSKFetcher) {
                    if (USKFetcher.this.cancelled) {
                        return;
                    }
                    USKFetcher.this.runningStoreChecker = false;
                    attempts = USKFetcher.this.attemptsToStart.toArray(new USKAttempt[USKFetcher.this.attemptsToStart.size()]);
                    USKFetcher.this.attemptsToStart.clear();
                    this.done = true;
                    USKFetcher.this.checkedDatastoreUpTo = lastCheck;
                }
                if (logMINOR) {
                    Logger.minor(this, "Checked datastore, finishing registration for " + attempts.length + " checkers for " + USKFetcher.this + " for " + USKFetcher.this.origUSK);
                }
                if (attempts.length > 0) {
                    this.parent.toNetwork(container, context);
                }
                for (int i = 0; i < attempts.length; ++i) {
                    long lastEd = USKFetcher.this.uskManager.lookupLatestSlot(USKFetcher.this.origUSK);
                    if (USKFetcher.this.keepLastData && USKFetcher.this.lastRequestData == null && lastEd == ((USKFetcher)USKFetcher.this).origUSK.suggestedEdition) {
                        --lastEd;
                    }
                    if (attempts[i] == null) continue;
                    if (attempts[i].number > lastEd) {
                        attempts[i].schedule(container, context);
                        continue;
                    }
                    3 var8_10 = this;
                    synchronized (var8_10) {
                        USKFetcher.this.runningAttempts.remove(attempts[i]);
                        continue;
                    }
                }
                long lastEd = USKFetcher.this.uskManager.lookupLatestSlot(USKFetcher.this.origUSK);
                USKFetcher.this.fillKeysWatching(lastEd, context);
            }

            @Override
            public SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
                return null;
            }

            @Override
            public long countAllKeys(ObjectContainer container, ClientContext context) {
                return USKFetcher.this.keysWatching.size();
            }

            @Override
            public long countSendableKeys(ObjectContainer container, ClientContext context) {
                return 0L;
            }

            @Override
            public RequestClient getClient(ObjectContainer container) {
                return USKFetcher.this.uskManager;
            }

            @Override
            public ClientRequester getClientRequest() {
                return this.parent;
            }

            @Override
            public short getPriorityClass(ObjectContainer container) {
                return USKFetcher.this.progressPollPriority;
            }

            @Override
            public int getRetryCount() {
                return 0;
            }

            @Override
            public boolean isCancelled(ObjectContainer container) {
                return this.done;
            }

            @Override
            public boolean isSSK() {
                return true;
            }

            @Override
            public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
                return null;
            }

            @Override
            public boolean isEmpty(ObjectContainer container) {
                return this.done;
            }
        };
        this.runningStoreChecker = true;
        try {
            context.getSskFetchScheduler().register(null, new SendableGet[]{storeChecker}, false, null, null, false);
        }
        catch (KeyListenerConstructionException e1) {
            this.runningStoreChecker = false;
        }
        catch (Throwable t) {
            this.runningStoreChecker = false;
            Logger.error(this, "Unable to start: " + t, t);
        }
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.completed || this.cancelled;
    }

    @Override
    public KeyListener makeKeyListener(ObjectContainer container, ClientContext context) throws KeyListenerConstructionException {
        return this;
    }

    @Override
    public void onFailed(KeyListenerConstructionException e, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Failed to construct KeyListener on USKFetcher: " + e, e);
    }

    @Override
    public synchronized long countKeys() {
        return this.keysWatching.size();
    }

    @Override
    public synchronized short definitelyWantKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        for (ClientSSK ssk : this.keysWatching) {
            if (!ssk.getNodeKey().equals(key)) continue;
            return this.progressPollPriority;
        }
        return -1;
    }

    @Override
    public boolean dontCache() {
        return !this.ctx.cacheLocalRequests;
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        return this.progressPollPriority;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        return new SendableGet[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock found, ObjectContainer container, ClientContext context) {
        if (!(found instanceof SSKBlock)) {
            return false;
        }
        ClientSSK realKey = null;
        long edition = -1L;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            for (int i = 0; i < this.keysWatching.size(); ++i) {
                ClientSSK ssk = this.keysWatching.get(i);
                if (!ssk.getNodeKey().equals(key)) continue;
                realKey = ssk;
                edition = this.firstKeyWatching + (long)i;
                break;
            }
            if (realKey == null) {
                return false;
            }
        }
        assert (edition == realKey.getURI().uskForSSK().getSuggestedEdition());
        this.onFoundEdition(edition, this.origUSK, container, context, false, (short)-1, null, false, false);
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cancelled || this.completed;
    }

    @Override
    public boolean isSSK() {
        return true;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public synchronized boolean probablyWantKey(Key key, byte[] saltedKey) {
        for (ClientSSK ssk : this.keysWatching) {
            if (!ssk.getNodeKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
        DEFAULT_NORMAL_POLL_PRIORITY = (short)5;
        DEFAULT_PROGRESS_POLL_PRIORITY = (short)3;
    }

    class USKAttempt
    implements USKCheckerCallback {
        long number;
        USKChecker checker;
        boolean succeeded;
        boolean dnf;
        boolean cancelled;

        public USKAttempt(long i) {
            this.number = i;
            this.succeeded = false;
            this.dnf = false;
            this.checker = new USKChecker(this, USKFetcher.this.origUSK.getSSK(i), USKFetcher.this.ctx.maxUSKRetries, USKFetcher.this.ctx, USKFetcher.this.parent);
        }

        public void onDNF(ClientContext context) {
            this.checker = null;
            this.dnf = true;
            USKFetcher.this.onDNF(this, context);
        }

        public void onSuccess(ClientSSKBlock block, ClientContext context) {
            this.checker = null;
            this.succeeded = true;
            USKFetcher.this.onSuccess(this, false, block, context);
        }

        public void onFatalAuthorError(ClientContext context) {
            this.checker = null;
            USKFetcher.this.onSuccess(this, true, null, context);
        }

        public void onNetworkError(ClientContext context) {
            this.checker = null;
            USKFetcher.this.onFail(this, context);
        }

        public void onCancelled(ClientContext context) {
            this.checker = null;
            USKFetcher.this.onCancelled(this, context);
        }

        public void cancel(ObjectContainer container, ClientContext context) {
            assert (container == null);
            this.cancelled = true;
            if (this.checker != null) {
                this.checker.cancel(container, context);
            }
            this.onCancelled(context);
        }

        public void schedule(ObjectContainer container, ClientContext context) {
            assert (container == null);
            if (this.checker == null) {
                if (logMINOR) {
                    Logger.minor(this, "Checker == null in schedule() for " + this, (Throwable)new Exception("debug"));
                }
            } else {
                assert (!this.checker.persistent());
                this.checker.schedule(container, context);
            }
        }

        public String toString() {
            return "USKAttempt for " + this.number + " for " + USKFetcher.this.origUSK.getURI() + " for " + USKFetcher.this;
        }

        public short getPriority() {
            if (USKFetcher.this.backgroundPoll) {
                if (USKFetcher.this.minFailures == USKFetcher.this.origMinFailures && USKFetcher.this.minFailures != USKFetcher.this.maxMinFailures) {
                    return USKFetcher.this.progressPollPriority;
                }
                return USKFetcher.this.normalPollPriority;
            }
            return USKFetcher.this.parent.getPriorityClass();
        }
    }
}

