/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.USKCheckerCallback;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSKBlock;
import freenet.node.LowLevelGetException;
import freenet.support.Logger;

class USKChecker
extends BaseSingleFileFetcher {
    final USKCheckerCallback cb;
    private int dnfs;

    USKChecker(USKCheckerCallback cb, ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent) {
        super(key, maxRetries, ctx, parent, false);
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Created USKChecker for " + key);
        }
        this.cb = cb;
    }

    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onSuccess((ClientSSKBlock)block, context);
    }

    public void onFailure(LowLevelGetException e, Object token, ObjectContainer container, ClientContext context) {
        boolean canRetry;
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.cb, 1);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "onFailure: " + e + " for " + this);
        }
        switch (e.code) {
            case 1: 
            case 9: {
                canRetry = false;
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                ++this.dnfs;
                canRetry = true;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                canRetry = true;
                break;
            }
            default: {
                Logger.error(this, "Unknown low-level fetch error code: " + e.code, new Exception("error"));
                canRetry = true;
            }
        }
        if (canRetry && this.retry(container, context)) {
            return;
        }
        this.unregisterAll(container, context);
        if (e.code == 9) {
            this.cb.onCancelled(context);
            return;
        }
        if (e.code == 1) {
            this.cb.onFatalAuthorError(context);
            return;
        }
        if (this.dnfs > 0) {
            this.cb.onDNF(context);
        } else {
            this.cb.onNetworkError(context);
        }
    }

    public String toString() {
        return "USKChecker for " + this.key.getURI() + " for " + this.cb;
    }

    public void onFailed(KeyListenerConstructionException e, ObjectContainer container, ClientContext context) {
        this.onFailure(new LowLevelGetException(3, "IMPOSSIBLE: Failed to create Bloom filters (we don't have any!)", e), null, container, context);
    }

    public short getPriorityClass(ObjectContainer container) {
        return this.cb.getPriority();
    }
}

