/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.SplitfileBlock;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.Encodeable;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.ResumeException;
import freenet.client.async.SplitFileInserter;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.FreenetURI;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFileInserterSegment
extends SendableInsert
implements FECCallback,
Encodeable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final SplitFileInserter parent;
    final BaseClientPutter putter;
    final short splitfileAlgo;
    final Bucket[] dataBlocks;
    final Bucket[] checkBlocks;
    final ClientCHK[] dataURIs;
    final ClientCHK[] checkURIs;
    final int[] dataRetries;
    final int[] checkRetries;
    final int[] dataConsecutiveRNFs;
    final int[] checkConsecutiveRNFs;
    final ArrayList<Integer> blocks;
    final boolean[] dataFinished;
    final boolean[] checkFinished;
    final boolean[] dataFailed;
    final boolean[] checkFailed;
    final int maxRetries;
    final InsertContext blockInsertContext;
    final int segNo;
    private volatile boolean encoded;
    private volatile boolean started;
    private volatile boolean finished;
    private volatile boolean hasURIs;
    private final boolean getCHKOnly;
    private InsertException toThrow;
    private final FailureCodeTracker errors;
    private int blocksGotURI;
    private int blocksSucceeded;
    private int blocksCompleted;
    private final boolean persistent;
    private FECJob encodeJob;
    private boolean removeOnEncode;

    public SplitFileInserterSegment(SplitFileInserter parent, boolean persistent, BaseClientPutter putter, short splitfileAlgo, int checkBlockCount, Bucket[] origDataBlocks, InsertContext blockInsertContext, boolean getCHKOnly, int segNo, ObjectContainer container) {
        super(persistent);
        this.parent = parent;
        this.getCHKOnly = getCHKOnly;
        this.persistent = persistent;
        this.errors = new FailureCodeTracker(true);
        this.blockInsertContext = blockInsertContext;
        this.splitfileAlgo = splitfileAlgo;
        this.dataBlocks = origDataBlocks;
        this.checkBlocks = new Bucket[checkBlockCount];
        this.checkURIs = new ClientCHK[checkBlockCount];
        this.dataURIs = new ClientCHK[origDataBlocks.length];
        this.dataRetries = new int[origDataBlocks.length];
        this.checkRetries = new int[checkBlockCount];
        this.dataFinished = new boolean[origDataBlocks.length];
        this.checkFinished = new boolean[checkBlockCount];
        this.dataFailed = new boolean[origDataBlocks.length];
        this.checkFailed = new boolean[checkBlockCount];
        this.dataConsecutiveRNFs = new int[origDataBlocks.length];
        this.checkConsecutiveRNFs = new int[checkBlockCount];
        this.blocks = new ArrayList();
        putter.addBlocks(this.dataURIs.length + this.checkURIs.length, container);
        putter.addMustSucceedBlocks(this.dataURIs.length + this.checkURIs.length, container);
        this.segNo = segNo;
        if (persistent) {
            container.activate((Object)blockInsertContext, 1);
        }
        this.maxRetries = blockInsertContext.maxInsertRetries;
        this.putter = putter;
    }

    public SplitFileInserterSegment(SplitFileInserter parent, boolean persistent, BaseClientPutter putter, SimpleFieldSet fs, short splitfileAlgorithm, InsertContext ctx, boolean getCHKOnly, int segNo, ClientContext context, ObjectContainer container) throws ResumeException {
        super(persistent);
        int i;
        int dataBlockCount;
        this.parent = parent;
        this.splitfileAlgo = splitfileAlgorithm;
        this.getCHKOnly = getCHKOnly;
        this.persistent = persistent;
        this.blockInsertContext = ctx;
        this.maxRetries = ctx.maxInsertRetries;
        this.segNo = segNo;
        if (!"SplitFileInserterSegment".equals(fs.get("Type"))) {
            throw new ResumeException("Wrong Type: " + fs.get("Type"));
        }
        this.finished = Fields.stringToBool(fs.get("Finished"), false);
        this.encoded = true;
        this.started = Fields.stringToBool(fs.get("Started"), false);
        SimpleFieldSet errorsFS = fs.subset("Errors");
        this.errors = errorsFS != null ? new FailureCodeTracker(true, errorsFS) : new FailureCodeTracker(true);
        if (this.finished && !this.errors.isEmpty()) {
            this.toThrow = InsertException.construct(this.errors);
        }
        this.blocksGotURI = 0;
        this.blocksCompleted = 0;
        SimpleFieldSet dataFS = fs.subset("DataBlocks");
        if (dataFS == null) {
            throw new ResumeException("No data blocks");
        }
        String tmp = dataFS.get("Count");
        if (tmp == null) {
            throw new ResumeException("No data block count");
        }
        try {
            dataBlockCount = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt data blocks count: " + e + " : " + tmp);
        }
        this.hasURIs = true;
        this.dataBlocks = new Bucket[dataBlockCount];
        this.dataURIs = new ClientCHK[dataBlockCount];
        this.dataRetries = new int[dataBlockCount];
        this.dataConsecutiveRNFs = new int[dataBlockCount];
        this.dataFinished = new boolean[dataBlockCount];
        this.dataFailed = new boolean[dataBlockCount];
        this.blocks = new ArrayList();
        this.putter = putter;
        SimpleFieldSet checkFS = fs.subset("CheckBlocks");
        if (checkFS != null) {
            int checkBlockCount;
            tmp = checkFS.get("Count");
            if (tmp == null) {
                throw new ResumeException("Check blocks but no check block count");
            }
            try {
                checkBlockCount = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new ResumeException("Corrupt check blocks count: " + e + " : " + tmp);
            }
            this.checkBlocks = new Bucket[checkBlockCount];
            this.checkURIs = new ClientCHK[checkBlockCount];
            this.checkRetries = new int[checkBlockCount];
            this.checkConsecutiveRNFs = new int[checkBlockCount];
            this.checkFinished = new boolean[checkBlockCount];
            this.checkFailed = new boolean[checkBlockCount];
            for (int i2 = 0; i2 < checkBlockCount; ++i2) {
                boolean blockFinished;
                String index = Integer.toString(i2);
                SimpleFieldSet blockFS = checkFS.subset(index);
                if (blockFS == null) {
                    this.hasURIs = false;
                    this.encoded = false;
                    Logger.normal(this, "Clearing encoded because block " + i2 + " of " + segNo + " missing");
                    continue;
                }
                tmp = blockFS.get("URI");
                if (tmp != null) {
                    try {
                        this.checkURIs[i2] = (ClientCHK)ClientKey.getBaseKey(new FreenetURI(tmp));
                        ++this.blocksGotURI;
                    }
                    catch (MalformedURLException e) {
                        throw new ResumeException("Corrupt URI: " + e + " : " + tmp);
                    }
                } else {
                    this.hasURIs = false;
                }
                boolean bl = blockFinished = Fields.stringToBool(blockFS.get("Finished"), false) && this.checkURIs[i2] != null;
                if (blockFinished && this.checkURIs[i2] == null) {
                    Logger.error(this, "No URI for check block " + i2 + " of " + segNo + " yet apparently finished?");
                    this.encoded = false;
                }
                if (!blockFinished) {
                    SimpleFieldSet bucketFS = blockFS.subset("Data");
                    if (bucketFS != null) {
                        try {
                            this.checkBlocks[i2] = SerializableToFieldSetBucketUtil.create(bucketFS, context.random, ctx.persistentFileTracker);
                            if (logMINOR) {
                                Logger.minor(this, "Check block " + i2 + " : " + this.checkBlocks[i2]);
                            }
                        }
                        catch (CannotCreateFromFieldSetException e) {
                            Logger.error(this, "Failed to deserialize check block " + i2 + " of " + segNo + " : " + e, e);
                            this.checkBlocks[i2] = null;
                            this.encoded = false;
                        }
                        if (this.checkBlocks[i2] == null) {
                            throw new ResumeException("Check block " + i2 + " of " + segNo + " not finished but no data (create returned null)");
                        }
                    }
                } else {
                    ++this.blocksCompleted;
                }
                if (this.checkBlocks[i2] == null && this.checkURIs[i2] == null) {
                    Logger.normal(this, "Clearing encoded because block " + i2 + " of " + segNo + " missing");
                    this.encoded = false;
                }
                checkFS.removeSubset(index);
            }
            if (this.checkBlocks.length > this.dataBlocks.length) {
                throw new ResumeException("Detected 1135 insert bug, you must restart the insert");
            }
        } else {
            Logger.normal(this, "Not encoded because no check blocks");
            this.encoded = false;
            FECCodec splitfileAlgo = FECCodec.getCodec(splitfileAlgorithm, dataBlockCount);
            int checkBlocksCount = splitfileAlgo.countCheckBlocks();
            this.checkURIs = new ClientCHK[checkBlocksCount];
            this.checkBlocks = new Bucket[checkBlocksCount];
            this.checkRetries = new int[checkBlocksCount];
            this.checkConsecutiveRNFs = new int[checkBlocksCount];
            this.checkFinished = new boolean[checkBlocksCount];
            this.checkFailed = new boolean[checkBlocksCount];
            this.hasURIs = false;
        }
        for (i = 0; i < dataBlockCount; ++i) {
            String index = Integer.toString(i);
            SimpleFieldSet blockFS = dataFS.subset(index);
            if (blockFS == null) {
                throw new ResumeException("No data block " + i + " on segment " + segNo);
            }
            tmp = blockFS.get("URI");
            if (tmp != null) {
                try {
                    this.dataURIs[i] = (ClientCHK)ClientKey.getBaseKey(new FreenetURI(tmp));
                    ++this.blocksGotURI;
                }
                catch (MalformedURLException e) {
                    throw new ResumeException("Corrupt URI: " + e + " : " + tmp);
                }
            } else {
                this.hasURIs = false;
            }
            boolean blockFinished = Fields.stringToBool(blockFS.get("Finished"), false);
            if (blockFinished && this.dataURIs[i] == null) {
                throw new ResumeException("Block " + i + " of " + segNo + " finished but no URI");
            }
            if (!blockFinished) {
                this.finished = false;
            } else {
                ++this.blocksCompleted;
            }
            SimpleFieldSet bucketFS = blockFS.subset("Data");
            if (bucketFS == null) {
                if (!blockFinished) {
                    throw new ResumeException("Block " + i + " of " + segNo + " not finished but no data");
                }
                if (splitfileAlgorithm > 0 && !this.encoded) {
                    throw new ResumeException("Block " + i + " of " + segNo + " data not available even though not encoded");
                }
            } else {
                try {
                    this.dataBlocks[i] = SerializableToFieldSetBucketUtil.create(bucketFS, context.random, ctx.persistentFileTracker);
                    if (logMINOR) {
                        Logger.minor(this, "Data block " + i + " : " + this.dataBlocks[i]);
                    }
                }
                catch (CannotCreateFromFieldSetException e) {
                    throw new ResumeException("Failed to deserialize block " + i + " of " + segNo + " : " + e, e);
                }
                if (this.dataBlocks[i] == null) {
                    throw new ResumeException("Block " + i + " of " + segNo + " could not serialize data (create returned null) from " + bucketFS);
                }
            }
            dataFS.removeSubset(index);
        }
        if (!this.encoded) {
            this.finished = false;
            this.hasURIs = false;
            for (i = 0; i < this.dataBlocks.length; ++i) {
                if (this.dataBlocks[i] != null) continue;
                throw new ResumeException("Missing data block " + i + " and need to reconstruct check blocks");
            }
        }
        putter.addBlocks(this.dataURIs.length + this.checkURIs.length, container);
        putter.addMustSucceedBlocks(this.dataURIs.length + this.checkURIs.length, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        boolean fetchable;
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.parent.parent, 1);
            container.activate(this.blocks, 2);
        }
        if (logMINOR) {
            if (this.parent == null) {
                throw new NullPointerException();
            }
            Logger.minor(this, "Starting segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + "): " + this + " ( finished=" + this.finished + " encoded=" + this.encoded + " hasURIs=" + this.hasURIs + " persistent=" + this.persistent + ')');
        }
        boolean fin = true;
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            if (this.dataBlocks[i] != null) {
                fin = false;
                SplitFileInserterSegment splitFileInserterSegment = this;
                synchronized (splitFileInserterSegment) {
                    this.blocks.add(i);
                    continue;
                }
            }
            this.parent.parent.completedBlock(true, container, context);
        }
        this.started = true;
        FECJob job = null;
        FECCodec splitfileAlgo = null;
        if (!this.encoded) {
            if (logMINOR) {
                Logger.minor(this, "Segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + ") is not encoded");
            }
            splitfileAlgo = FECCodec.getCodec(this.splitfileAlgo, this.dataBlocks.length, this.checkBlocks.length);
            if (logMINOR) {
                Logger.minor(this, "Encoding segment " + this.segNo + " of " + this.parent + " (" + this.parent.dataLength + ") persistent=" + this.persistent);
            }
            SplitFileInserterSegment splitFileInserterSegment = this;
            synchronized (splitFileInserterSegment) {
                if (!this.encoded) {
                    if (this.persistent) {
                        for (int i = 0; i < this.dataBlocks.length; ++i) {
                            container.activate((Object)this.dataBlocks[i], 5);
                        }
                    }
                    job = this.encodeJob = new FECJob(splitfileAlgo, context.fecQueue, this.dataBlocks, this.checkBlocks, 32768, this.persistent ? this.blockInsertContext.persistentBucketFactory : context.tempBucketFactory, (FECCallback)this, false, this.parent.parent.getPriorityClass(), this.persistent);
                }
            }
            fin = false;
        } else {
            for (int i = 0; i < this.checkBlocks.length; ++i) {
                if (this.checkBlocks[i] != null) {
                    SplitFileInserterSegment splitFileInserterSegment = this;
                    synchronized (splitFileInserterSegment) {
                        this.blocks.add(i + this.dataBlocks.length);
                    }
                    fin = false;
                    continue;
                }
                this.parent.parent.completedBlock(true, container, context);
            }
            this.onEncodedSegment(container, context, null, this.dataBlocks, this.checkBlocks, null, null);
        }
        if (this.hasURIs) {
            this.parent.segmentHasURIs(this, container, context);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            fetchable = this.blocksCompleted > this.dataBlocks.length;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.store(this.blocks);
        }
        if (fetchable) {
            this.parent.segmentFetchable(this, container);
        }
        if (fin) {
            this.finish(container, context, this.parent);
        } else {
            this.schedule(container, context);
        }
        if (this.finished) {
            this.finish(container, context, this.parent);
        }
        if (job != null) {
            splitfileAlgo.addToQueue(job, context.fecQueue, container);
        }
    }

    private void schedule(ObjectContainer container, ClientContext context) {
        if (!this.getCHKOnly) {
            this.getScheduler(context).registerInsert(this, this.persistent, false, container);
        } else {
            this.tryEncode(container, context);
        }
    }

    @Override
    public void tryEncode(ObjectContainer container, ClientContext context) {
        ClientCHK key;
        int i;
        for (i = 0; i < this.dataBlocks.length; ++i) {
            if (this.dataURIs[i] == null && this.dataBlocks[i] != null) {
                try {
                    boolean deactivate = false;
                    if (this.persistent) {
                        boolean bl = deactivate = !container.ext().isActive((Object)this.dataBlocks[i]);
                        if (deactivate) {
                            container.activate((Object)this.dataBlocks[i], 1);
                        }
                    }
                    key = this.encodeBucket(this.dataBlocks[i]).getClientKey();
                    if (deactivate) {
                        container.deactivate((Object)this.dataBlocks[i], 1);
                    }
                    this.onEncode(i, key, container, context);
                }
                catch (CHKEncodeException e) {
                    this.fail(new InsertException(3, e, null), container, context);
                }
                catch (IOException e) {
                    this.fail(new InsertException(2, e, null), container, context);
                }
                continue;
            }
            if (this.dataURIs[i] != null || this.dataBlocks[i] != null) continue;
            this.fail(new InsertException(3, "Data block " + i + " cannot be encoded: no data", null), container, context);
        }
        if (this.encoded) {
            for (i = 0; i < this.checkBlocks.length; ++i) {
                if (this.checkURIs[i] == null && this.checkBlocks[i] != null) {
                    try {
                        boolean deactivate = false;
                        if (this.persistent) {
                            boolean bl = deactivate = !container.ext().isActive((Object)this.checkBlocks[i]);
                            if (deactivate) {
                                container.activate((Object)this.checkBlocks[i], 1);
                            }
                        }
                        key = this.encodeBucket(this.checkBlocks[i]).getClientKey();
                        if (deactivate) {
                            container.deactivate((Object)this.checkBlocks[i], 1);
                        }
                        this.onEncode(i + this.dataBlocks.length, key, container, context);
                    }
                    catch (CHKEncodeException e) {
                        this.fail(new InsertException(3, e, null), container, context);
                    }
                    catch (IOException e) {
                        this.fail(new InsertException(2, e, null), container, context);
                    }
                    continue;
                }
                if (this.checkURIs[i] != null || this.checkBlocks[i] != null) continue;
                this.fail(new InsertException(3, "Data block " + i + " cannot be encoded: no data", null), container, context);
            }
        }
    }

    @Override
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets, Bucket[] checkBuckets, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        boolean fin;
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.parent.parent, 1);
            container.activate(this.blocks, 2);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            fin = this.finished;
            this.encodeJob = null;
        }
        if (this.removeOnEncode) {
            if (logMINOR) {
                Logger.minor(this, "Removing on encode: " + this);
            }
            this.freeBucketsArray(container, dataBuckets);
            this.freeBucketsArray(container, checkBuckets);
            this.removeFrom(container, context);
            return;
        }
        if (fin) {
            Logger.error(this, "Encoded segment even though segment finished! Freeing buckets...");
            this.freeBucketsArray(container, dataBuckets);
            this.freeBucketsArray(container, checkBuckets);
            return;
        }
        try {
            if (logMINOR) {
                Logger.minor(this, "Scheduling " + this.checkBlocks.length + " check blocks...");
            }
            for (int i = 0; i < this.checkBlocks.length; ++i) {
                this.checkBlocks[i] = checkBuckets[i];
                if (this.checkBlocks[i] == null) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Skipping check block " + i + " - is null");
                    continue;
                }
                if (this.persistent) {
                    this.checkBlocks[i].storeTo(container);
                }
                if (!this.persistent) continue;
                container.deactivate((Object)this.checkBlocks[i], 1);
            }
            SplitFileInserterSegment i = this;
            synchronized (i) {
                for (int i2 = 0; i2 < this.checkBlocks.length; ++i2) {
                    this.blocks.add(this.dataBlocks.length + i2);
                }
            }
            if (this.persistent) {
                container.store(this.blocks);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " while encoding " + this, t);
            InsertException ex = new InsertException(3, t, null);
            this.finish(ex, container, context, this.parent);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
            return;
        }
        SplitFileInserterSegment splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            this.encoded = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.encodedSegment(this, container, context);
        splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            this.freeFinishedDataBlocks(container);
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.parent, 1);
        }
        this.schedule(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(InsertException ex, ObjectContainer container, ClientContext context, SplitFileInserter parent) {
        if (logMINOR) {
            Logger.minor(this, "Finishing " + this + " with " + ex, (Throwable)ex);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.toThrow = ex;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context, SplitFileInserter parent) {
        if (logMINOR) {
            Logger.minor(this, "Finishing " + this);
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 5);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (this.blocksSucceeded < this.blocksCompleted) {
                this.toThrow = InsertException.construct(this.errors);
            }
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.errors, 5);
        }
        this.unregister(container, context);
        parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEncode(int x, ClientCHK key, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Encoded block " + x + " on " + this);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            int i;
            if (this.finished) {
                return false;
            }
            if (x >= this.dataBlocks.length) {
                if (this.checkURIs[x - this.dataBlocks.length] != null) {
                    return false;
                }
                this.checkURIs[x - this.dataBlocks.length] = key;
            } else {
                if (this.dataURIs[x] != null) {
                    return false;
                }
                this.dataURIs[x] = key;
            }
            ++this.blocksGotURI;
            if (this.persistent) {
                container.store((Object)this);
            }
            if (logMINOR) {
                Logger.minor(this, "Blocks got URI: " + this.blocksGotURI + " of " + (this.dataBlocks.length + this.checkBlocks.length));
            }
            if (this.blocksGotURI != this.dataBlocks.length + this.checkBlocks.length) {
                return false;
            }
            for (i = 0; i < this.checkURIs.length; ++i) {
                if (this.checkURIs[i] != null) continue;
                Logger.error(this, "Check URI " + i + " is null");
                return false;
            }
            for (i = 0; i < this.dataURIs.length; ++i) {
                if (this.dataURIs[i] != null) continue;
                Logger.error(this, "Data URI " + i + " is null");
                return false;
            }
            this.hasURIs = true;
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.store((Object)this);
        }
        this.parent.segmentHasURIs(this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.parent, 1);
        }
        return true;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public int countCheckBlocks() {
        return this.checkBlocks.length;
    }

    public int countDataBlocks() {
        return this.dataBlocks.length;
    }

    public ClientCHK[] getCheckCHKs() {
        return this.checkURIs;
    }

    public ClientCHK[] getDataCHKs() {
        return this.dataURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InsertException getException(ObjectContainer container) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.persistent) {
                container.activate((Object)this.toThrow, 5);
            }
            return this.toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (this.toThrow != null) {
                this.toThrow = new InsertException(10);
            }
        }
        this.cancelInner(container, context);
    }

    private void cancelInner(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        super.unregister(container, context);
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.segmentFinished(this, container, context);
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
    }

    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Logger.error(this, "Illegal transition in SplitFileInserterSegment: " + oldState + " -> " + newState);
    }

    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got onMetadata from " + state);
    }

    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Should not happen: onBlockSetFinished(" + state + ") on " + this);
    }

    public synchronized boolean hasURIs() {
        return this.hasURIs;
    }

    public synchronized boolean isFetchable() {
        return this.blocksCompleted >= this.dataBlocks.length;
    }

    public void onFetchable(ClientPutState state, ObjectContainer container) {
    }

    public void forceEncode(ObjectContainer container, ClientContext context) {
        context.backgroundBlockEncoder.queue(this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(InsertException e, ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                Logger.error(this, "Failing but already finished on " + this);
                return;
            }
            this.finished = true;
            Logger.error(this, "Insert segment failed: " + e + " for " + this, e);
            this.toThrow = e;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        this.cancelInner(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                Logger.error(this, "FEC decode or encode failed but already finished: " + t, t);
                return;
            }
            this.finished = true;
            Logger.error(this, "Insert segment failed: " + t + " for " + this, t);
            this.toThrow = new InsertException(3, "FEC failure: " + t, null);
        }
        this.cancelInner(container, context);
    }

    Bucket getBucket(int blockNum) {
        if (blockNum >= this.dataBlocks.length) {
            return this.checkBlocks[blockNum - this.dataBlocks.length];
        }
        return this.dataBlocks[blockNum];
    }

    private BlockItem getBlockItem(ObjectContainer container, ClientContext context, int blockNum) throws IOException {
        Bucket data;
        Bucket sourceData = this.getBucket(blockNum);
        if (sourceData == null) {
            Logger.error(this, "Selected block " + blockNum + " but is null - already finished?? on " + this);
            return null;
        }
        boolean deactivateBucket = false;
        if (this.persistent) {
            boolean bl = deactivateBucket = !container.ext().isActive((Object)sourceData);
            if (deactivateBucket) {
                container.activate((Object)sourceData, 1);
            }
        }
        if ((data = sourceData.createShadow()) == null) {
            data = context.tempBucketFactory.makeBucket(sourceData.size());
            BucketTools.copy(sourceData, data);
        }
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " : bucket " + sourceData + " shadow " + data);
        }
        if (this.persistent && deactivateBucket) {
            container.deactivate((Object)sourceData, 1);
        }
        return new BlockItem(this, blockNum, data, this.persistent);
    }

    private int hashCodeForBlock(int blockNum) {
        return this.hashCode() * (blockNum + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, Object keyNum, ObjectContainer container, ClientContext context) {
        int succeeded;
        int completed;
        BlockItem block = (BlockItem)keyNum;
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 5);
        }
        switch (e.code) {
            case 5: {
                Logger.error(this, "Collision on a CHK?!?!?");
                this.fail(new InsertException(3, "Collision on a CHK", null), container, context);
                return;
            }
            case 1: {
                Logger.error(this, "Internal error: " + e, e);
                this.fail(new InsertException(3, e.toString(), null), container, context);
                return;
            }
            case 3: {
                this.errors.inc(4);
                break;
            }
            case 2: {
                this.errors.inc(5);
                break;
            }
            case 4: {
                this.errors.inc(8);
                break;
            }
            default: {
                Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                this.fail(new InsertException(3, e.toString(), null), container, context);
                return;
            }
        }
        if (this.persistent) {
            container.store((Object)this.errors);
        }
        boolean isRNF = e.code == 2 || e.code == 4;
        int blockNum = block.blockNum;
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " failed on " + this + " : " + e);
        }
        boolean treatAsSuccess = false;
        boolean failedBlock = false;
        SplitFileInserterSegment splitFileInserterSegment2 = this;
        synchronized (splitFileInserterSegment2) {
            if (blockNum >= this.dataBlocks.length) {
                int checkNum = blockNum - this.dataBlocks.length;
                if (this.checkFinished[checkNum]) {
                    if (this.checkFailed[checkNum]) {
                        Logger.error(this, "Got onFailure() but block has already failed! Check block " + checkNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onFailure() but block has already succeeded: Check block " + checkNum + " on " + this);
                    }
                    return;
                }
                if (isRNF) {
                    int n = checkNum;
                    this.checkConsecutiveRNFs[n] = this.checkConsecutiveRNFs[n] + 1;
                    if (this.persistent) {
                        container.activate((Object)this.blockInsertContext, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Consecutive RNFs: " + this.checkConsecutiveRNFs[checkNum] + " / " + this.blockInsertContext.consecutiveRNFsCountAsSuccess);
                    }
                    if (this.checkConsecutiveRNFs[checkNum] == this.blockInsertContext.consecutiveRNFsCountAsSuccess) {
                        treatAsSuccess = true;
                    }
                } else {
                    this.checkConsecutiveRNFs[checkNum] = 0;
                }
                if (!treatAsSuccess) {
                    int n = checkNum;
                    this.checkRetries[n] = this.checkRetries[n] + 1;
                    if (this.checkRetries[checkNum] > this.maxRetries && this.maxRetries != -1) {
                        failedBlock = true;
                        this.checkFinished[checkNum] = true;
                        this.checkFailed[checkNum] = true;
                        ++this.blocksCompleted;
                        if (this.persistent) {
                            container.activate(this.blocks, 2);
                        }
                        this.blocks.remove((Object)blockNum);
                        if (this.persistent) {
                            container.store(this.blocks);
                        }
                        if (this.checkBlocks[checkNum] != null) {
                            if (this.persistent) {
                                container.activate((Object)this.checkBlocks[checkNum], 1);
                            }
                            this.checkBlocks[checkNum].free();
                            if (this.persistent) {
                                this.checkBlocks[checkNum].removeFrom(container);
                            }
                            this.checkBlocks[checkNum] = null;
                            if (logMINOR) {
                                Logger.minor(this, "Failed to insert check block " + checkNum + " on " + this);
                            }
                        } else {
                            Logger.error(this, "Check block " + checkNum + " failed on " + this + " but bucket is already nulled out!");
                        }
                    }
                } else {
                    this.checkFinished[checkNum] = true;
                    this.checkFailed[checkNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                    if (this.checkBlocks[checkNum] != null) {
                        if (this.persistent) {
                            container.activate((Object)this.checkBlocks[checkNum], 1);
                        }
                        this.checkBlocks[checkNum].free();
                        if (this.persistent) {
                            this.checkBlocks[checkNum].removeFrom(container);
                        }
                        this.checkBlocks[checkNum] = null;
                        if (logMINOR) {
                            Logger.minor(this, "Repeated RNF, treating as success for check block " + checkNum + " on " + this);
                        }
                    } else {
                        Logger.error(this, "Check block " + checkNum + " succeeded (sort of) on " + this + " but bucket is already nulled out!");
                    }
                }
            } else {
                if (this.dataFinished[blockNum]) {
                    if (this.dataFailed[blockNum]) {
                        Logger.error(this, "Got onFailure() but block has already failed! Data block " + blockNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onFailure() but block has already succeeded: Data block " + blockNum + " on " + this);
                    }
                    return;
                }
                if (isRNF) {
                    int n = blockNum;
                    this.dataConsecutiveRNFs[n] = this.dataConsecutiveRNFs[n] + 1;
                    if (this.persistent) {
                        container.activate((Object)this.blockInsertContext, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Consecutive RNFs: " + this.dataConsecutiveRNFs[blockNum] + " / " + this.blockInsertContext.consecutiveRNFsCountAsSuccess);
                    }
                    if (this.dataConsecutiveRNFs[blockNum] == this.blockInsertContext.consecutiveRNFsCountAsSuccess) {
                        treatAsSuccess = true;
                    }
                } else {
                    this.dataConsecutiveRNFs[blockNum] = 0;
                }
                if (!treatAsSuccess) {
                    int n = blockNum;
                    this.dataRetries[n] = this.dataRetries[n] + 1;
                    if (this.dataRetries[blockNum] > this.maxRetries && this.maxRetries != -1) {
                        failedBlock = true;
                        this.dataFinished[blockNum] = true;
                        this.dataFailed[blockNum] = true;
                        ++this.blocksCompleted;
                        if (this.persistent) {
                            container.activate(this.blocks, 2);
                        }
                        this.blocks.remove((Object)blockNum);
                        if (this.persistent) {
                            container.store(this.blocks);
                        }
                        if (this.dataBlocks[blockNum] != null) {
                            if (this.persistent) {
                                container.activate((Object)this.dataBlocks[blockNum], 1);
                            }
                            this.dataBlocks[blockNum].free();
                            if (this.persistent) {
                                this.dataBlocks[blockNum].removeFrom(container);
                            }
                            this.dataBlocks[blockNum] = null;
                            if (logMINOR) {
                                Logger.minor(this, "Failed to insert data block " + blockNum + " on " + this);
                            }
                        } else {
                            Logger.error(this, "Data block " + blockNum + " failed on " + this + " but bucket is already nulled out!");
                        }
                    }
                } else {
                    this.dataFinished[blockNum] = true;
                    this.dataFailed[blockNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                    if (this.dataBlocks[blockNum] != null && this.encoded) {
                        if (this.persistent) {
                            container.activate((Object)this.dataBlocks[blockNum], 1);
                        }
                        this.dataBlocks[blockNum].free();
                        if (this.persistent) {
                            this.dataBlocks[blockNum].removeFrom(container);
                        }
                        this.dataBlocks[blockNum] = null;
                        if (logMINOR) {
                            Logger.minor(this, "Repeated RNF, treating as success for data block " + blockNum + " on " + this);
                        }
                    } else {
                        Logger.error(this, "Data block " + blockNum + " succeeded (sort of) on " + this + " but bucket is already nulled out!");
                    }
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            completed = this.blocksCompleted;
            succeeded = this.blocksSucceeded;
        }
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        if (failedBlock) {
            this.putter.failedBlock(container, context);
        } else if (treatAsSuccess) {
            this.putter.completedBlock(false, container, context);
        }
        if (this.persistent) {
            container.deactivate((Object)this.putter, 1);
        }
        if (treatAsSuccess && succeeded == this.dataBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.segmentFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else if (completed == this.dataBlocks.length + this.checkBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.finish(container, context, this.parent);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object keyNum, ObjectContainer container, ClientContext context) {
        int succeeded;
        int completed;
        BlockItem block = (BlockItem)keyNum;
        int blockNum = block.blockNum;
        if (logMINOR) {
            Logger.minor(this, "Block " + blockNum + " succeeded on " + this);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return;
            }
            if (blockNum >= this.dataBlocks.length) {
                int checkNum = blockNum - this.dataBlocks.length;
                if (!this.checkFinished[checkNum]) {
                    this.checkFinished[checkNum] = true;
                    this.checkFailed[checkNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                } else {
                    if (this.checkFailed[checkNum]) {
                        Logger.error(this, "Got onSuccess() but block has already failed! Check block " + checkNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onSuccess() but block has already succeeded: Check block " + checkNum + " on " + this);
                    }
                    return;
                }
                if (this.checkBlocks[checkNum] != null) {
                    if (this.persistent) {
                        container.activate((Object)this.checkBlocks[checkNum], 1);
                    }
                    this.checkBlocks[checkNum].free();
                    if (this.persistent) {
                        this.checkBlocks[checkNum].removeFrom(container);
                    }
                    this.checkBlocks[checkNum] = null;
                } else {
                    Logger.error(this, "Check block " + checkNum + " succeeded on " + this + " but bucket is already nulled out!");
                }
            } else {
                if (!this.dataFinished[blockNum]) {
                    this.dataFinished[blockNum] = true;
                    this.dataFailed[blockNum] = false;
                    ++this.blocksCompleted;
                    ++this.blocksSucceeded;
                    if (this.persistent) {
                        container.activate(this.blocks, 2);
                    }
                    this.blocks.remove((Object)blockNum);
                    if (this.persistent) {
                        container.store(this.blocks);
                    }
                } else {
                    if (this.dataFailed[blockNum]) {
                        Logger.error(this, "Got onSuccess() but block has already failed! Data block " + blockNum + " on " + this);
                    } else {
                        Logger.error(this, "Got onSuccess() but block has already succeeded: Data block " + blockNum + " on " + this);
                    }
                    return;
                }
                if (this.encoded && this.dataBlocks[blockNum] != null) {
                    if (this.persistent) {
                        container.activate((Object)this.dataBlocks[blockNum], 1);
                    }
                    this.dataBlocks[blockNum].free();
                    if (this.persistent) {
                        this.dataBlocks[blockNum].removeFrom(container);
                    }
                    this.dataBlocks[blockNum] = null;
                } else if (this.dataBlocks[blockNum] == null) {
                    Logger.error(this, "Data block " + blockNum + " succeeded on " + this + " but bucket is already nulled out!");
                    if (this.persistent) {
                        Logger.minor(this, "Activation state: " + container.ext().isActive((Object)this));
                    }
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            completed = this.blocksCompleted;
            succeeded = this.blocksSucceeded;
        }
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        this.putter.completedBlock(false, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.putter, 1);
        }
        if (succeeded == this.dataBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.segmentFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else if (completed == this.dataBlocks.length + this.checkBlocks.length) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.finish(container, context, this.parent);
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        return this.countSendableKeys(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blocks, 1);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            if (this.finished) {
                return null;
            }
            if (this.blocks.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "No blocks to remove");
                }
                return null;
            }
            int i = 0;
            if (i < 10) {
                if (this.blocks.size() == 0) {
                    return null;
                }
                int x = context.random.nextInt(this.blocks.size());
                Integer ret = this.blocks.get(x);
                int num = ret;
                if (!this.persistent && keys.hasTransientInsert(this, new FakeBlockItem(num))) {
                    return null;
                }
                try {
                    return this.getBlockItem(container, context, num);
                }
                catch (IOException e) {
                    this.fail(new InsertException(2, e, null), container, context);
                    return null;
                }
            }
            return null;
        }
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        return this.putter.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.putter, 1);
        }
        return this.putter.getPriorityClass();
    }

    @Override
    public int getRetryCount() {
        return 0;
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        return new SendableRequestSender(){

            public boolean send(NodeClientCore core, RequestScheduler sched, final ClientContext context, ChosenBlock req) {
                try {
                    ClientCHKBlock b;
                    BlockItem block = (BlockItem)req.token;
                    if (logMINOR) {
                        Logger.minor(this, "Starting request: " + SplitFileInserterSegment.this + " block number " + block.blockNum);
                    }
                    try {
                        try {
                            b = SplitFileInserterSegment.this.encodeBucket(block.copyBucket);
                        }
                        catch (CHKEncodeException e) {
                            throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                        }
                        catch (MalformedURLException e) {
                            throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                        }
                        catch (IOException e) {
                            throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage() + " for " + block.copyBucket, e);
                        }
                        Object var9_9 = null;
                        block.copyBucket.free();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        block.copyBucket.free();
                        throw throwable;
                    }
                    if (b == null) {
                        Logger.error(this, "Asked to send empty block on " + SplitFileInserterSegment.this, new Exception("error"));
                        return false;
                    }
                    final ClientCHK key = b.getClientKey();
                    final int num = block.blockNum;
                    if (block.persistent) {
                        context.jobRunner.queue(new DBJob(){

                            public boolean run(ObjectContainer container, ClientContext context) {
                                if (!container.ext().isStored((Object)SplitFileInserterSegment.this)) {
                                    return false;
                                }
                                container.activate((Object)SplitFileInserterSegment.this, 1);
                                boolean retval = SplitFileInserterSegment.this.onEncode(num, key, container, context);
                                container.deactivate((Object)SplitFileInserterSegment.this, 1);
                                return retval;
                            }
                        }, 6, false);
                    } else {
                        context.mainExecutor.execute(new Runnable(){

                            public void run() {
                                SplitFileInserterSegment.this.onEncode(num, key, null, context);
                            }
                        }, "Got URI");
                    }
                    core.realPut(b, req.cacheLocalRequests);
                }
                catch (LowLevelPutException e) {
                    req.onFailure(e, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed: " + SplitFileInserterSegment.this + " for " + e);
                    }
                    return true;
                }
                catch (DatabaseDisabledException e) {
                    Logger.error(this, "Running persistent insert but database is disabled!");
                }
                if (logMINOR) {
                    Logger.minor(this, "Request succeeded: " + SplitFileInserterSegment.this);
                }
                req.onInsertSuccess(context);
                return true;
            }
        };
    }

    protected ClientCHKBlock encodeBucket(Bucket copyBucket) throws CHKEncodeException, IOException {
        return ClientCHKBlock.encode(copyBucket, false, true, (short)-1, 32768L);
    }

    @Override
    public boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
        Object[] blockNumbers;
        if (this.persistent) {
            container.activate(this.blocks, 1);
        }
        SplitFileInserterSegment splitFileInserterSegment = this;
        synchronized (splitFileInserterSegment) {
            blockNumbers = this.blocks.toArray(new Integer[this.blocks.size()]);
        }
        ArrayList<PersistentChosenBlock> ret = new ArrayList<PersistentChosenBlock>();
        Arrays.sort(blockNumbers);
        int prevBlockNumber = -1;
        for (int i = 0; i < blockNumbers.length; ++i) {
            BlockItem item;
            int blockNumber = (Integer)blockNumbers[i];
            if (blockNumber == prevBlockNumber) {
                Logger.error(this, "Duplicate block number in makeBlocks() in " + this + ": two copies of " + blockNumber);
                continue;
            }
            prevBlockNumber = blockNumber;
            try {
                item = this.getBlockItem(container, context, blockNumber);
                if (item == null) {
                    continue;
                }
            }
            catch (IOException e) {
                this.fail(new InsertException(2, e, null), container, context);
                return null;
            }
            PersistentChosenBlock block = new PersistentChosenBlock(true, request, item, null, null, sched);
            if (logMINOR) {
                Logger.minor(this, "Created block " + block + " for block number " + blockNumber + " on " + this);
            }
            ret.add(block);
        }
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Returning " + ret.size() + " blocks");
        }
        return ret;
    }

    @Override
    public synchronized long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate(this.blocks, 1);
        }
        int sz = this.blocks.size();
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        return sz;
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        boolean ret;
        if (this.persistent) {
            container.activate(this.blocks, 2);
        }
        boolean bl = ret = this.finished || this.blocks.isEmpty();
        if (this.persistent) {
            container.deactivate(this.blocks, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.encodeJob, 1);
        if (this.encodeJob != null) {
            if (!this.encodeJob.cancel(container, context)) {
                SplitFileInserterSegment splitFileInserterSegment = this;
                synchronized (splitFileInserterSegment) {
                    this.removeOnEncode = true;
                    if (logMINOR) {
                        Logger.minor(this, "Will remove after encode finished: " + this);
                    }
                    container.store((Object)this);
                    return;
                }
            }
            this.encodeJob = null;
        }
        this.freeBucketsArray(container, this.dataBlocks);
        this.freeBucketsArray(container, this.checkBlocks);
        for (ClientCHK chk : this.dataURIs) {
            if (chk == null) continue;
            if (logMINOR) {
                Logger.minor(this, "dataURI is null on " + this);
            }
            container.activate((Object)chk, 5);
            chk.removeFrom(container);
        }
        for (ClientCHK chk : this.checkURIs) {
            if (chk == null) continue;
            if (logMINOR) {
                Logger.minor(this, "checkURI is null on " + this);
            }
            container.activate((Object)chk, 5);
            chk.removeFrom(container);
        }
        container.activate(this.blocks, 5);
        for (Integer i : this.blocks) {
            container.activate((Object)i, 1);
            container.delete((Object)i);
        }
        container.delete(this.blocks);
        if (this.toThrow != null) {
            container.activate((Object)this.toThrow, 5);
            this.toThrow.removeFrom(container);
        }
        if (this.errors != null) {
            container.activate((Object)this.errors, 1);
            this.errors.removeFrom(container);
        }
        container.delete((Object)this);
    }

    @Override
    public boolean cacheInserts(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.blockInsertContext);
            if (deactivate) {
                container.activate((Object)this.blockInsertContext, 1);
            }
        }
        boolean retval = this.blockInsertContext.cacheLocalRequests;
        if (deactivate) {
            container.deactivate((Object)this.blockInsertContext, 1);
        }
        return retval;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "Storing " + this + " when already finished!", new Exception("error"));
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("debug"));
        }
        return true;
    }

    private void freeBucketsArray(ObjectContainer container, Bucket[] buckets) {
        for (int i = 0; i < buckets.length; ++i) {
            if (buckets[i] == null) continue;
            if (this.persistent) {
                container.activate((Object)buckets[i], 1);
            }
            buckets[i].free();
            if (this.persistent) {
                buckets[i].removeFrom(container);
            }
            buckets[i] = null;
        }
    }

    private void freeFinishedDataBlocks(ObjectContainer container) {
        for (int i = 0; i < this.dataBlocks.length; ++i) {
            if (!this.dataFinished[i] || this.dataBlocks[i] == null) continue;
            if (logMINOR) {
                Logger.minor(this, "Freeing data block " + i + " delayed for encode");
            }
            if (this.persistent) {
                container.activate((Object)this.dataBlocks[i], 1);
            }
            this.dataBlocks[i].free();
            if (this.persistent) {
                this.dataBlocks[i].removeFrom(container);
            }
            this.dataBlocks[i] = null;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    private class FakeBlockItem
    implements SendableRequestItem {
        private final int blockNum;
        private final int hashCode;

        FakeBlockItem(int blockNum) {
            this.blockNum = blockNum;
            this.hashCode = SplitFileInserterSegment.this.hashCodeForBlock(blockNum);
        }

        public void dump() {
        }

        public SplitFileInserterSegment getParent() {
            return SplitFileInserterSegment.this;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof BlockItem ? ((BlockItem)o).parent == SplitFileInserterSegment.this && ((BlockItem)o).blockNum == this.blockNum : o instanceof FakeBlockItem && ((FakeBlockItem)o).getParent() == SplitFileInserterSegment.this && ((FakeBlockItem)o).blockNum == this.blockNum;
        }
    }

    private static class BlockItem
    implements SendableRequestItem {
        private final boolean persistent;
        private final Bucket copyBucket;
        private final int hashCode;
        private final SplitFileInserterSegment parent;
        private final int blockNum;

        BlockItem(SplitFileInserterSegment parent, int blockNum, Bucket bucket, boolean persistent) throws IOException {
            this.parent = parent;
            this.blockNum = blockNum;
            this.copyBucket = bucket;
            this.hashCode = parent.hashCodeForBlock(blockNum);
            this.persistent = persistent;
        }

        public void dump() {
            this.copyBucket.free();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof BlockItem ? ((BlockItem)o).parent == this.parent && ((BlockItem)o).blockNum == this.blockNum : o instanceof FakeBlockItem && ((FakeBlockItem)o).getParent() == this.parent && ((FakeBlockItem)o).blockNum == this.blockNum;
        }
    }
}

