/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.FECCodec;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.ResumeException;
import freenet.client.async.SplitFileInserterSegment;
import freenet.keys.ClientCHK;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.util.Vector;

public class SplitFileInserter
implements ClientPutState {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final BaseClientPutter parent;
    final InsertContext ctx;
    final PutCompletionCallback cb;
    final long dataLength;
    final Compressor.COMPRESSOR_TYPE compressionCodec;
    final short splitfileAlgorithm;
    final int segmentSize;
    final int checkSegmentSize;
    final SplitFileInserterSegment[] segments;
    final boolean getCHKOnly;
    final int countCheckBlocks;
    final int countDataBlocks;
    private boolean haveSentMetadata;
    final ClientMetadata cm;
    final boolean isMetadata;
    private volatile boolean finished;
    private boolean fetchable;
    public final Object token;
    final ArchiveManager.ARCHIVE_TYPE archiveType;
    private boolean forceEncode;
    private final long decompressedLength;
    final boolean persistent;
    private final int hashCode = super.hashCode();

    public int hashCode() {
        return this.hashCode;
    }

    public SplitFileInserter(BaseClientPutter put, PutCompletionCallback cb, Bucket data, Compressor.COMPRESSOR_TYPE bestCodec, long decompressedLength, ClientMetadata clientMetadata, InsertContext ctx, boolean getCHKOnly, boolean isMetadata, Object token, ArchiveManager.ARCHIVE_TYPE archiveType, boolean freeData, boolean persistent, ObjectContainer container, ClientContext context) throws InsertException {
        int i;
        Bucket[] dataBuckets;
        if (put == null) {
            throw new NullPointerException();
        }
        this.parent = put;
        this.archiveType = archiveType;
        this.compressionCodec = bestCodec;
        this.token = token;
        this.finished = false;
        this.isMetadata = isMetadata;
        this.cm = clientMetadata;
        this.getCHKOnly = getCHKOnly;
        this.cb = cb;
        this.ctx = ctx;
        this.decompressedLength = decompressedLength;
        this.dataLength = data.size();
        context.jobRunner.setCommitThisTransaction();
        try {
            dataBuckets = BucketTools.split(data, 32768, persistent ? ctx.persistentBucketFactory : context.tempBucketFactory, freeData, persistent, container);
            if (dataBuckets[dataBuckets.length - 1].size() < 32768L) {
                Bucket oldData = dataBuckets[dataBuckets.length - 1];
                dataBuckets[dataBuckets.length - 1] = BucketTools.pad(oldData, 32768, context.getBucketFactory(persistent), (int)oldData.size());
                if (persistent) {
                    dataBuckets[dataBuckets.length - 1].storeTo(container);
                }
                oldData.free();
                if (persistent) {
                    oldData.removeFrom(container);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Data size " + data.size() + " buckets " + dataBuckets.length);
            }
        }
        catch (IOException e) {
            throw new InsertException(2, e, null);
        }
        this.countDataBlocks = dataBuckets.length;
        this.splitfileAlgorithm = ctx.splitfileAlgorithm;
        this.segmentSize = ctx.splitfileSegmentDataBlocks;
        this.checkSegmentSize = this.splitfileAlgorithm == 0 ? 0 : ctx.splitfileSegmentCheckBlocks;
        this.persistent = persistent;
        if (persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.segments = this.splitIntoSegments(this.segmentSize, dataBuckets, context.mainExecutor, container, context, persistent, put);
        if (persistent) {
            for (int i2 = 0; i2 < dataBuckets.length; ++i2) {
                dataBuckets[i2].storeTo(container);
                container.deactivate((Object)dataBuckets[i2], 1);
                if (dataBuckets.length <= this.segmentSize) continue;
                dataBuckets[i2] = null;
            }
        }
        dataBuckets = null;
        int count = 0;
        for (i = 0; i < this.segments.length; ++i) {
            count += this.segments[i].countCheckBlocks();
        }
        this.countCheckBlocks = count;
        this.parent.onMajorProgress(container);
        if (persistent) {
            for (i = 0; i < this.segments.length; ++i) {
                container.store((Object)this.segments[i]);
                container.deactivate((Object)this.segments[i], 1);
            }
        }
    }

    public SplitFileInserter(BaseClientPutter parent, PutCompletionCallback cb, ClientMetadata clientMetadata, InsertContext ctx, boolean getCHKOnly, boolean metadata, Object token, ArchiveManager.ARCHIVE_TYPE archiveType, SimpleFieldSet fs, ObjectContainer container, ClientContext context) throws ResumeException {
        int segmentCount;
        this.parent = parent;
        this.archiveType = archiveType;
        this.token = token;
        this.finished = false;
        this.isMetadata = metadata;
        this.cm = clientMetadata;
        this.getCHKOnly = getCHKOnly;
        this.cb = cb;
        this.ctx = ctx;
        this.persistent = parent.persistent();
        context.jobRunner.setCommitThisTransaction();
        String length = fs.get("DataLength");
        if (length == null) {
            throw new ResumeException("No DataLength");
        }
        try {
            this.dataLength = Long.parseLong(length);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt DataLength: " + e + " : " + length);
        }
        length = fs.get("DecompressedLength");
        long dl = 0L;
        if (length != null) {
            try {
                dl = Long.parseLong(length);
            }
            catch (NumberFormatException e) {
                dl = -1L;
            }
        }
        this.decompressedLength = dl;
        String tmp = fs.get("SegmentSize");
        if (length == null) {
            throw new ResumeException("No SegmentSize");
        }
        try {
            this.segmentSize = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt SegmentSize: " + e + " : " + length);
        }
        tmp = fs.get("CheckSegmentSize");
        if (length == null) {
            throw new ResumeException("No CheckSegmentSize");
        }
        try {
            this.checkSegmentSize = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt CheckSegmentSize: " + e + " : " + length);
        }
        String ccodec = fs.get("CompressionCodec");
        Compressor.COMPRESSOR_TYPE compressor = null;
        if (ccodec != null) {
            try {
                compressor = Compressor.COMPRESSOR_TYPE.valueOf(ccodec);
            }
            catch (Throwable t) {
                try {
                    short codecNo = Short.parseShort(ccodec);
                    compressor = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(codecNo);
                }
                catch (NumberFormatException nfe) {
                    throw new ResumeException("Invalid compression codec: " + ccodec);
                }
            }
        }
        this.compressionCodec = compressor;
        String scodec = fs.get("SplitfileCodec");
        if (scodec == null) {
            throw new ResumeException("No splitfile codec");
        }
        try {
            this.splitfileAlgorithm = Short.parseShort(scodec);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt SplitfileCodec: " + e + " : " + scodec);
        }
        SimpleFieldSet segFS = fs.subset("Segments");
        if (segFS == null) {
            throw new ResumeException("No segments");
        }
        String segc = segFS.get("Count");
        if (segc == null) {
            throw new ResumeException("No segment count");
        }
        try {
            segmentCount = Integer.parseInt(segc);
        }
        catch (NumberFormatException e) {
            throw new ResumeException("Corrupt segment count: " + e + " : " + segc);
        }
        this.segments = new SplitFileInserterSegment[segmentCount];
        int dataBlocks = 0;
        int checkBlocks = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            String index = Integer.toString(i);
            SimpleFieldSet segment = segFS.subset(index);
            segFS.removeSubset(index);
            if (segment == null) {
                throw new ResumeException("No segment " + i);
            }
            this.segments[i] = new SplitFileInserterSegment(this, this.persistent, parent, segment, this.splitfileAlgorithm, ctx, getCHKOnly, i, context, container);
            dataBlocks += this.segments[i].countDataBlocks();
            checkBlocks += this.segments[i].countCheckBlocks();
        }
        this.countDataBlocks = dataBlocks;
        this.countCheckBlocks = checkBlocks;
    }

    private SplitFileInserterSegment[] splitIntoSegments(int segmentSize, Bucket[] origDataBlocks, Executor executor, ObjectContainer container, ClientContext context, boolean persistent, BaseClientPutter putter) {
        int dataBlocks = origDataBlocks.length;
        Vector<SplitFileInserterSegment> segs = new Vector<SplitFileInserterSegment>();
        if (dataBlocks < segmentSize || segmentSize == -1) {
            SplitFileInserterSegment onlySeg = new SplitFileInserterSegment(this, persistent, putter, this.splitfileAlgorithm, FECCodec.getCheckBlocks(this.splitfileAlgorithm, origDataBlocks.length), origDataBlocks, this.ctx, this.getCHKOnly, 0, container);
            segs.add(onlySeg);
        } else {
            int j = 0;
            int segNo = 0;
            int i = segmentSize;
            while (true) {
                if (i > dataBlocks) {
                    i = dataBlocks;
                }
                Bucket[] seg = new Bucket[i - j];
                System.arraycopy(origDataBlocks, j, seg, 0, i - j);
                j = i;
                for (int x = 0; x < seg.length; ++x) {
                    if (seg[x] != null) continue;
                    throw new NullPointerException("In splitIntoSegs: " + x + " is null of " + seg.length + " of " + segNo);
                }
                SplitFileInserterSegment s = new SplitFileInserterSegment(this, persistent, putter, this.splitfileAlgorithm, FECCodec.getCheckBlocks(this.splitfileAlgorithm, seg.length), seg, this.ctx, this.getCHKOnly, segNo, container);
                segs.add(s);
                if (i == dataBlocks) break;
                ++segNo;
                i += segmentSize;
            }
        }
        if (persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.parent.notifyClients(container, context);
        return segs.toArray(new SplitFileInserterSegment[segs.size()]);
    }

    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].start(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        if (this.countDataBlocks > 32) {
            this.parent.onMajorProgress(container);
        }
        this.parent.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodedSegment(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        boolean encode;
        if (logMINOR) {
            Logger.minor(this, "Encoded segment " + segment.segNo + " of " + this);
        }
        boolean ret = false;
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            encode = this.forceEncode;
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.segments[i] != segment && this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (this.segments[i] == null || !this.segments[i].isEncoded()) {
                    ret = true;
                    if (this.segments[i] == segment || !this.persistent) break;
                    container.deactivate((Object)this.segments[i], 1);
                    break;
                }
                if (this.segments[i] == segment || !this.persistent) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
        }
        if (encode) {
            segment.forceEncode(container, context);
        }
        if (ret) {
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onBlockSetFinished(this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
        if (this.countDataBlocks > 32) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.onMajorProgress(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean segmentHasURIs(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Segment has URIs: " + segment);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.haveSentMetadata) {
                return false;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                boolean hasURIs = this.segments[i].hasURIs();
                if (this.persistent && this.segments[i] != segment) {
                    container.deactivate((Object)this.segments[i], 1);
                }
                if (hasURIs) continue;
                if (logMINOR) {
                    Logger.minor(this, "Segment does not have URIs: " + this.segments[i]);
                }
                return false;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Have URIs from all segments");
        }
        this.encodeMetadata(container, context, segment);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeMetadata(ObjectContainer container, ClientContext context, SplitFileInserterSegment dontDeactivateSegment) {
        boolean missingURIs;
        context.jobRunner.setCommitThisTransaction();
        Metadata m = null;
        Object[] dataURIs = new ClientCHK[this.countDataBlocks];
        Object[] checkURIs = new ClientCHK[this.countCheckBlocks];
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            int i;
            int dpos = 0;
            int cpos = 0;
            for (i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                ClientCHK[] data = this.segments[i].getDataCHKs();
                System.arraycopy(data, 0, dataURIs, dpos, data.length);
                dpos += data.length;
                ClientCHK[] check = this.segments[i].getCheckCHKs();
                System.arraycopy(check, 0, checkURIs, cpos, check.length);
                cpos += check.length;
                if (!this.persistent || this.segments[i] == dontDeactivateSegment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Data URIs: " + dataURIs.length + ", check URIs: " + checkURIs.length);
            }
            boolean bl = missingURIs = SplitFileInserter.anyNulls(dataURIs) || SplitFileInserter.anyNulls(checkURIs);
            if (this.persistent) {
                for (i = 0; i < dataURIs.length; ++i) {
                    container.activate(dataURIs[i], 5);
                    dataURIs[i] = ((ClientCHK)dataURIs[i]).cloneKey();
                }
                for (i = 0; i < checkURIs.length; ++i) {
                    container.activate(checkURIs[i], 5);
                    checkURIs[i] = ((ClientCHK)checkURIs[i]).cloneKey();
                }
            }
            if (!missingURIs) {
                if (this.persistent) {
                    container.activate((Object)this.cm, 5);
                }
                ClientMetadata meta = this.cm;
                if (this.persistent) {
                    meta = meta == null ? null : meta.clone();
                }
                m = new Metadata(this.splitfileAlgorithm, (ClientCHK[])dataURIs, (ClientCHK[])checkURIs, this.segmentSize, this.checkSegmentSize, meta, this.dataLength, this.archiveType, this.compressionCodec, this.decompressedLength, this.isMetadata);
            }
            this.haveSentMetadata = true;
        }
        if (missingURIs) {
            if (logMINOR) {
                Logger.minor(this, "Missing URIs");
            }
            this.fail(new InsertException(3, "Missing URIs after encoding", null), container, context);
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onMetadata(m, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    private static boolean anyNulls(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return true;
        }
        return false;
    }

    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFinished(SplitFileInserterSegment segment, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Segment finished: " + segment, (Throwable)new Exception("debug"));
        }
        boolean allGone = true;
        if (this.countDataBlocks > 32) {
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            this.parent.onMajorProgress(container);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            InsertException e;
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already");
                }
                return;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent && this.segments[i] != segment) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (!this.segments[i].isFinished()) {
                    if (logMINOR) {
                        Logger.minor(this, "Segment not finished: " + i + ": " + this.segments[i]);
                    }
                    allGone = false;
                    if (!this.persistent || this.segments[i] == segment) break;
                    container.deactivate((Object)this.segments[i], 1);
                    break;
                }
                if (!this.persistent || this.segments[i] == segment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            if ((e = segment.getException(container)) != null && e.isFatal()) {
                this.cancel(container, context);
            } else if (!allGone) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        this.onAllFinished(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFetchable(SplitFileInserterSegment segment, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Segment fetchable: " + segment);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            if (this.fetchable) {
                return;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.persistent && this.segments[i] != segment) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (!this.segments[i].isFetchable()) {
                    if (logMINOR) {
                        Logger.minor(this, "Segment not fetchable: " + i + ": " + this.segments[i]);
                    }
                    if (this.persistent && this.segments[i] != segment) {
                        container.deactivate((Object)this.segments[i], 1);
                    }
                    return;
                }
                if (!this.persistent || this.segments[i] == segment) continue;
                container.deactivate((Object)this.segments[i], 1);
            }
            this.fetchable = true;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
            container.store((Object)this);
        }
        this.cb.onFetchable(this, container);
    }

    private void onAllFinished(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "All finished");
        }
        try {
            FailureCodeTracker tracker = new FailureCodeTracker(true);
            boolean allSucceeded = true;
            for (int i = 0; i < this.segments.length; ++i) {
                InsertException e;
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if ((e = this.segments[i].getException(container)) == null) continue;
                if (logMINOR) {
                    Logger.minor(this, "Failure on segment " + i + " : " + this.segments[i] + " : " + e, (Throwable)e);
                }
                allSucceeded = false;
                if (e.errorCodes != null) {
                    tracker.merge(e.errorCodes);
                }
                tracker.inc(e.getMode());
            }
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            if (allSucceeded) {
                this.cb.onSuccess(this, container, context);
            } else {
                this.cb.onFailure(InsertException.construct(tracker), this, container, context);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new InsertException(3), this, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].cancel(container, context);
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.start(container, context);
    }

    public Object getToken() {
        return this.token;
    }

    public long getLength() {
        return this.dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceEncode(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        Logger.minor(this, "Forcing encode on " + this);
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            this.forceEncode = true;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].forceEncode(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        for (SplitFileInserterSegment segment : this.segments) {
            container.activate((Object)segment, 1);
            segment.removeFrom(container, context);
        }
        container.delete((Object)this);
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (logDEBUG) {
            Logger.debug(this, "objectCanUpdate() on " + this, new Exception("debug"));
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "objectCanNew but finished on " + this, new Exception("error"));
        } else if (logDEBUG) {
            Logger.debug(this, "objectCanNew() on " + this, new Exception("debug"));
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

