/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.NodeCHK;
import freenet.keys.TooBigException;
import freenet.node.BulkCallFailureItem;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SupportsBulkCallFailure;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFileFetcherSubSegment
extends SendableGet
implements SupportsBulkCallFailure {
    final int retryCount;
    final SplitFileFetcherSegment segment;
    final Vector<Integer> blockNums;
    final FetchContext ctx;
    private static boolean logMINOR;
    private boolean cancelled;

    SplitFileFetcherSubSegment(SplitFileFetcherSegment segment, ClientRequester parent, int retryCount) {
        super(parent);
        this.segment = segment;
        this.retryCount = retryCount;
        if (parent == null) {
            throw new NullPointerException();
        }
        this.ctx = segment.blockFetchContext;
        this.blockNums = new Vector();
        logMINOR = Logger.shouldLog(4, this);
    }

    @Override
    public boolean dontCache(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        if (this.ctx == null) {
            if (this.segment != null) {
                Logger.error(this, "CTX=NULL BUT SEGMENT != NULL!");
            } else {
                Logger.error(this, "CTX=NULL AND SEGMENT = NULL on " + this);
            }
        }
        return !this.ctx.cacheLocalRequests;
    }

    @Override
    public FetchContext getContext() {
        return this.ctx;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (this.cancelled) {
            return null;
        }
        return this.getRandomBlockNum(keys, context, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientKey getKey(Object token, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Segment is finishing when getting key " + token + " on " + this);
                }
                return null;
            }
            ClientCHK key = this.segment.getBlockKey(((MySendableRequestItem)token).x, container);
            if (key == null) {
                if (this.segment.isFinished(container)) {
                    Logger.error(this, "Segment finished but didn't tell us! " + this);
                } else if (this.segment.isFinishing(container)) {
                    Logger.error(this, "Segment finishing but didn't tell us! " + this);
                } else {
                    Logger.error(this, "Segment not finishing yet still returns null for getKey()!: " + token + " for " + this, new Exception("debug"));
                }
            }
            return key;
        }
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
        }
        return this.segment.getKeyNumbersAtRetryLevel(this.retryCount).length;
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
        }
        this.cleanBlockNums(container);
        return this.blockNums.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBlockNums(ObjectContainer container) {
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            int initSize = this.blockNums.size();
            Integer prev = null;
            for (int i = 0; i < this.blockNums.size(); ++i) {
                Integer x = this.blockNums.get(i);
                if (x == prev || x.equals(prev)) {
                    this.blockNums.remove(i);
                    --i;
                    if (!this.persistent) continue;
                    container.delete((Object)x);
                    continue;
                }
                prev = x;
            }
            if (this.blockNums.size() < initSize) {
                Logger.error(this, "Cleaned block number list duplicates: was " + initSize + " now " + this.blockNums.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendableRequestItem getRandomBlockNum(KeysFetchingLocally keys, ClientContext context, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
            container.activate((Object)this.segment, 1);
        }
        logMINOR = Logger.shouldLog(4, this);
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (this.blockNums.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "No blocks to remove");
                }
                return null;
            }
            for (int i = 0; i < 10; ++i) {
                if (this.blockNums.size() == 0) {
                    return null;
                }
                int x = context.random.nextInt(this.blockNums.size());
                Integer ret = this.blockNums.get(x);
                int num = ret;
                NodeCHK key = this.segment.getBlockNodeKey(num, container);
                if (key == null) {
                    if (this.segment.isFinishing(container) || this.segment.isFinished(container)) {
                        return null;
                    }
                    if (this.segment.haveBlock(num, container)) {
                        Logger.error(this, "Already have block " + ret + " but was in blockNums on " + this);
                        continue;
                    }
                    Logger.error(this, "Key is null for block " + ret + " for " + this);
                    continue;
                }
                if (keys.hasKey(key)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Removing block " + x + " of " + (this.blockNums.size() + 1) + " : " + ret + " on " + this);
                }
                return new MySendableRequestItem(num);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValidKeys(KeysFetchingLocally keys, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
            container.activate((Object)this.segment, 1);
        }
        boolean hasSet = false;
        boolean retval = false;
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            for (int i = 0; i < 10 && !this.blockNums.isEmpty(); ++i) {
                int x = context.random.nextInt(this.blockNums.size());
                Integer ret = this.blockNums.get(x);
                int block = ret;
                NodeCHK key = this.segment.getBlockNodeKey(block, container);
                if (key == null) {
                    if (this.segment.isFinishing(container) || this.segment.isFinished(container)) {
                        return false;
                    }
                    if (this.segment.haveBlock(block, container)) {
                        Logger.error(this, "Already have block " + ret + " but was in blockNums on " + this + " in hasValidKeys");
                    } else {
                        Logger.error(this, "Key is null for block " + ret + " for " + this + " in hasValidKeys");
                    }
                    this.blockNums.remove(x);
                    if (!this.persistent) continue;
                    container.delete((Object)ret);
                    if (hasSet) continue;
                    hasSet = true;
                    container.store(this.blockNums);
                    continue;
                }
                if (keys.hasKey(key)) continue;
                retval = true;
                break;
            }
        }
        if (this.persistent) {
            container.deactivate(this.blockNums, 5);
            container.deactivate((Object)this.segment, 1);
        }
        return retval;
    }

    @Override
    public boolean ignoreStore() {
        return this.ctx.ignoreStore;
    }

    @Override
    public void onFailure(BulkCallFailureItem[] items, ObjectContainer container, ClientContext context) {
        int i;
        FetchException[] fetchExceptions = new FetchException[items.length];
        int countFatal = 0;
        if (this.persistent) {
            container.activate(this.blockNums, 2);
        }
        for (i = 0; i < items.length; ++i) {
            fetchExceptions[i] = this.translateException(items[i].e);
            if (fetchExceptions[i].isFatal()) {
                ++countFatal;
            }
            this.removeBlockNum(((MySendableRequestItem)items[i].token).x, container, true);
        }
        if (this.persistent) {
            container.store(this.blockNums);
            container.deactivate(this.blockNums, 2);
            container.activate((Object)this.segment, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment.errors, 1);
        }
        if (this.parent.isCancelled()) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Failing: cancelled");
            }
            this.segment.fail(new FetchException(25), container, context, false);
            return;
        }
        for (i = 0; i < fetchExceptions.length; ++i) {
            this.segment.errors.inc(fetchExceptions[i].getMode());
        }
        int nonFatalExceptions = items.length - countFatal;
        int[] blockNumbers = new int[nonFatalExceptions];
        if (countFatal > 0) {
            FetchException[] newFetchExceptions = new FetchException[items.length - countFatal];
            int x = 0;
            for (int i2 = 0; i2 < items.length; ++i2) {
                int blockNum = ((MySendableRequestItem)items[i2].token).x;
                if (fetchExceptions[i2].isFatal()) {
                    this.segment.onFatalFailure(fetchExceptions[i2], blockNum, this, container, context);
                    continue;
                }
                blockNumbers[x] = blockNum;
                newFetchExceptions[x] = fetchExceptions[i2];
                ++x;
            }
            fetchExceptions = newFetchExceptions;
        } else {
            for (int i3 = 0; i3 < blockNumbers.length; ++i3) {
                blockNumbers[i3] = ((MySendableRequestItem)items[i3].token).x;
            }
        }
        this.segment.onNonFatalFailure(fetchExceptions, blockNumbers, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.segment.errors, 1);
        }
    }

    private FetchException translateException(LowLevelGetException e) {
        switch (e.code) {
            case 2: 
            case 4: {
                return new FetchException(13);
            }
            case 10: {
                return new FetchException(30);
            }
            case 1: {
                return new FetchException(6);
            }
            case 3: {
                return new FetchException(17);
            }
            case 6: {
                return new FetchException(15);
            }
            case 5: {
                return new FetchException(14);
            }
            case 7: {
                return new FetchException(18);
            }
            case 8: {
                return new FetchException(6);
            }
            case 9: {
                return new FetchException(25);
            }
        }
        Logger.error(this, "Unknown LowLevelGetException code: " + e.code);
        return new FetchException(17, "Unknown error code: " + e.code);
    }

    @Override
    public void onFailure(LowLevelGetException e, Object token, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + " , " + token + " on " + this);
        }
        this.onFailure(this.translateException(e), token, container, context);
    }

    protected void onFailure(FetchException e, Object token, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment.errors, 1);
        }
        boolean forceFatal = false;
        if (this.parent.isCancelled()) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Failing: cancelled");
            }
            e = new FetchException(25);
            forceFatal = true;
        }
        this.segment.errors.inc(e.getMode());
        if (e.isFatal() && token == null) {
            this.segment.fail(e, container, context, false);
        } else if (e.isFatal() || forceFatal) {
            this.segment.onFatalFailure(e, ((MySendableRequestItem)token).x, this, container, context);
        } else {
            this.segment.onNonFatalFailure(e, ((MySendableRequestItem)token).x, this, container, context);
        }
        this.removeBlockNum(((MySendableRequestItem)token).x, container, false);
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.segment.errors, 1);
        }
    }

    protected void onSuccess(Bucket data, boolean fromStore, Integer token, int blockNo, ClientKeyBlock block, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
            container.activate((Object)this.parent, 1);
        }
        if (this.parent.isCancelled()) {
            data.free();
            if (this.persistent) {
                data.removeFrom(container);
            }
            this.onFailure(new FetchException(25), (Object)token, container, context);
            return;
        }
        this.segment.onSuccess(data, blockNo, block, container, context, this);
    }

    protected Bucket extract(ClientKeyBlock block, Object token, ObjectContainer container, ClientContext context) {
        Bucket data;
        try {
            data = block.decode(context.getBucketFactory(this.persistent), (int)Math.min(this.ctx.maxOutputLength, Integer.MAX_VALUE), false);
        }
        catch (KeyDecodeException e1) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Decode failure: " + e1, (Throwable)e1);
            }
            this.onFailure(new FetchException(6, e1.getMessage()), token, container, context);
            return null;
        }
        catch (TooBigException e) {
            this.onFailure(new FetchException(21, e.getMessage()), token, container, context);
            return null;
        }
        catch (IOException e) {
            Logger.error(this, "Could not capture data - disk full?: " + e, e);
            this.onFailure(new FetchException(12, (Throwable)e), token, container, context);
            return null;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, data == null ? "Could not decode: null" : "Decoded " + data.size() + " bytes");
        }
        return data;
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.priorityClass;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.segment, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            return this.parent.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate(this.blockNums, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            return this.cancelled || this.blockNums.isEmpty();
        }
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    public void addAll(int blocks, ObjectContainer container, ClientContext context, boolean dontComplainOnDupes) {
        int[] list = new int[blocks];
        for (int i = 0; i < blocks; ++i) {
            list[i] = i;
        }
        this.addAll(list, container, context, dontComplainOnDupes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(int[] blocks, ObjectContainer container, ClientContext context, boolean dontComplainOnDupes) {
        boolean logMINOR;
        if (this.persistent) {
            container.activate(this.blockNums, 1);
        }
        if (logMINOR = Logger.shouldLog(4, this)) {
            Logger.minor(this, "Adding " + blocks + " blocks to " + this);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (this.cancelled) {
                throw new IllegalStateException("Adding blocks to already cancelled " + this);
            }
            for (int x = 0; x < blocks.length; ++x) {
                int i = blocks[x];
                Integer ii = i;
                if (this.blockNums.contains(ii)) {
                    if (!dontComplainOnDupes) {
                        Logger.error(this, "Block numbers already contain block " + i);
                        continue;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Block numbers already contain block " + i);
                    continue;
                }
                this.blockNums.add(ii);
            }
        }
        if (this.persistent) {
            container.store(this.blockNums);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int blockNo, ObjectContainer container, ClientContext context, boolean dontComplainOnDupes) {
        boolean logMINOR;
        if (this.persistent) {
            container.activate(this.blockNums, 1);
        }
        if (logMINOR = Logger.shouldLog(4, this)) {
            Logger.minor(this, "Adding block " + blockNo + " to " + this);
        }
        if (blockNo < 0) {
            throw new IllegalArgumentException();
        }
        Integer i = blockNo;
        boolean schedule = true;
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (this.cancelled) {
                throw new IllegalStateException("Adding block " + blockNo + " to already cancelled " + this);
            }
            if (this.blockNums.contains(i)) {
                if (!dontComplainOnDupes) {
                    Logger.error(this, "Block numbers already contain block " + blockNo);
                } else if (logMINOR) {
                    Logger.minor(this, "Block numbers already contain block " + blockNo);
                }
            } else {
                this.blockNums.add(i);
            }
            if (schedule && this.getParentGrabArray() != null) {
                if (logMINOR) {
                    Logger.minor(this, "Already registered, not scheduling: " + this.blockNums.size() + " : " + this.blockNums);
                }
                schedule = false;
            }
        }
        if (this.persistent) {
            container.store(this.blockNums);
        }
        return schedule;
    }

    public String toString() {
        return super.toString() + ":" + this.retryCount + "/" + this.segment + '(' + (this.blockNums == null ? "null" : String.valueOf(this.blockNums.size())) + "),tempid=" + this.objectHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean possiblyRemoveFromParent(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
            container.activate(this.blockNums, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Possibly removing from parent: " + this);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (!this.blockNums.isEmpty()) {
                if (this.persistent) {
                    container.deactivate(this.blockNums, 1);
                }
                return false;
            }
            if (logMINOR) {
                Logger.minor(this, "Definitely removing from parent: " + this);
            }
            if (!this.segment.maybeRemoveSeg(this, container)) {
                if (this.persistent) {
                    container.deactivate(this.blockNums, 1);
                }
                return false;
            }
            this.cancelled = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        ClientCHKBlock cb;
        int blockNo;
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
            container.activate(this.blockNums, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "onGotKey(" + key + ")");
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            for (int i = 0; i < this.blockNums.size(); ++i) {
                Integer token = this.blockNums.get(i);
                int num = token;
                NodeCHK k = this.segment.getBlockNodeKey(num, container);
                if (k == null || !((Key)k).equals(key)) continue;
                this.blockNums.remove(i);
                if (!this.persistent) break;
                container.delete((Object)token);
                break;
            }
            blockNo = this.segment.getBlockNumber(key, container);
        }
        if (blockNo == -1) {
            Logger.minor(this, "No block found for key " + key + " on " + this);
            return;
        }
        Integer token = blockNo;
        ClientCHK ckey = this.segment.getBlockKey(blockNo, container);
        try {
            cb = new ClientCHKBlock((CHKBlock)block, ckey);
        }
        catch (CHKVerifyException e) {
            this.onFailure(new FetchException(6, (Throwable)e), (Object)token, container, context);
            return;
        }
        Bucket data = this.extract(cb, token, container, context);
        if (data == null) {
            return;
        }
        if (!cb.isMetadata()) {
            this.onSuccess(data, false, token, token, cb, container, context);
        } else {
            this.onFailure(new FetchException(4, "Metadata where expected data"), (Object)token, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(ObjectContainer container, ClientContext context, boolean dontDeactivateSeg, boolean cancelledAlready) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate(this.blockNums, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Killing " + this);
        }
        this.unregister(container, context);
        Integer[] oldNums = null;
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (cancelledAlready) {
                if (!this.cancelled) {
                    Logger.error(this, "Should be cancelled already! " + this, new Exception("error"));
                    this.cancelled = true;
                }
                if (!this.blockNums.isEmpty()) {
                    Logger.error(this, "Block nums not empty! on " + this + " : " + this.blockNums, new Exception("error"));
                }
            } else {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
            }
            if (this.persistent) {
                oldNums = this.blockNums.toArray(new Integer[this.blockNums.size()]);
            }
            this.blockNums.clear();
        }
        if (this.persistent && oldNums != null && oldNums.length > 0) {
            for (Integer i : oldNums) {
                container.delete((Object)i);
            }
        }
        if (this.persistent) {
            this.removeFrom(container, context, dontDeactivateSeg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container, ClientContext context, boolean dontDeactivateSeg) {
        container.activate((Object)this.segment, 1);
        container.activate(this.blockNums, 1);
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            if (!this.cancelled) {
                Logger.error(this, "Removing when not cancelled! on " + this, new Exception("error"));
                this.cancelled = true;
            }
            if (!this.blockNums.isEmpty()) {
                Logger.error(this, "Removing when blockNums not empty! on " + this, new Exception("error"));
                for (Integer i : this.blockNums) {
                    container.delete((Object)i);
                }
                this.blockNums.clear();
            }
        }
        container.delete(this.blockNums);
        container.delete((Object)this);
        if (!dontDeactivateSeg) {
            container.deactivate((Object)this.segment, 1);
        }
    }

    @Override
    public long getCooldownWakeup(Object token, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
        }
        long ret = this.segment.getCooldownWakeup(((MySendableRequestItem)token).x);
        return ret;
    }

    @Override
    public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Requeueing after cooldown " + key + " for " + this);
        }
        if (!this.segment.requeueAfterCooldown(key, time, container, context, this)) {
            Logger.error(this, "Key was not wanted after cooldown: " + key + " for " + this + " in requeueAfterCooldown");
        }
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
        }
    }

    @Override
    public long getCooldownWakeupByKey(Key key, ObjectContainer container) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        long ret = this.segment.getCooldownWakeupByKey(key, container);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCooldownTimes(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)this.segment, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            this.segment.resetCooldownTimes(this.blockNums.toArray(new Integer[this.blockNums.size()]));
        }
    }

    public void reschedule(ObjectContainer container, ClientContext context) {
        try {
            if (this.persistent) {
                container.activate((Object)this.segment, 1);
                container.activate((Object)this.segment.blockFetchContext, 1);
            }
            this.getScheduler(context).register(null, new SendableGet[]{this}, this.persistent, container, this.segment.blockFetchContext.blocks, true);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBlockNum(int blockNum, ObjectContainer container, boolean callerActivatesAndSets) {
        if (logMINOR) {
            Logger.minor(this, "Removing block " + blockNum + " from " + this);
        }
        if (this.persistent && !callerActivatesAndSets) {
            container.activate(this.blockNums, 2);
        }
        boolean found = false;
        SplitFileFetcherSegment splitFileFetcherSegment = this.segment;
        synchronized (splitFileFetcherSegment) {
            for (int i = 0; i < this.blockNums.size(); ++i) {
                Integer token = this.blockNums.get(i);
                int num = token;
                if (num != blockNum) continue;
                this.blockNums.remove(i);
                if (this.persistent) {
                    container.delete((Object)token);
                }
                if (logMINOR) {
                    Logger.minor(this, "Removed block " + blockNum + " from " + this);
                }
                found = true;
                break;
            }
        }
        if (this.persistent && !callerActivatesAndSets) {
            container.store(this.blockNums);
            container.deactivate(this.blockNums, 2);
        }
        return found;
    }

    public void removeBlockNums(int[] blockNos, ObjectContainer container) {
        if (this.persistent) {
            container.activate(this.blockNums, 2);
        }
        boolean store = false;
        for (int i = 0; i < blockNos.length; ++i) {
            store |= this.removeBlockNum(blockNos[i], container, true);
        }
        if (this.persistent) {
            if (store) {
                container.store(this.blockNums);
            }
            container.deactivate(this.blockNums, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
        Object[] blockNumbers;
        if (this.persistent) {
            container.activate((Object)this.segment, 1);
            container.activate(this.blockNums, 1);
        }
        SplitFileFetcherSubSegment splitFileFetcherSubSegment = this;
        synchronized (splitFileFetcherSubSegment) {
            blockNumbers = this.blockNums.toArray(new Integer[this.blockNums.size()]);
        }
        ArrayList<PersistentChosenBlock> blocks = new ArrayList<PersistentChosenBlock>();
        Arrays.sort(blockNumbers);
        int prevBlockNumber = -1;
        for (int i = 0; i < blockNumbers.length; ++i) {
            int blockNumber = (Integer)blockNumbers[i];
            if (blockNumber == prevBlockNumber) {
                Logger.error(this, "Duplicate block number in makeBlocks() in " + this + ": two copies of " + blockNumber);
                continue;
            }
            prevBlockNumber = blockNumber;
            ClientKey key = this.segment.getBlockKey(blockNumber, container);
            if (key == null) {
                if (!logMINOR) continue;
                Logger.minor(this, "Block " + blockNumber + " is null, maybe race condition");
                continue;
            }
            key = key.cloneKey();
            Key k = key.getNodeKey();
            PersistentChosenBlock block = new PersistentChosenBlock(false, request, new MySendableRequestItem(blockNumber), k, key, sched);
            if (logMINOR) {
                Logger.minor(this, "Created block " + block + " for block number " + blockNumber + " on " + this);
            }
            blocks.add(block);
        }
        blocks.trimToSize();
        if (this.persistent) {
            container.deactivate((Object)this.segment, 1);
            container.deactivate(this.blockNums, 1);
        }
        return blocks;
    }

    @Override
    public Key[] listKeys(ObjectContainer container) {
        boolean activated = false;
        if (this.persistent && !(activated = container.ext().isActive((Object)this.segment))) {
            container.activate((Object)this.segment, 1);
        }
        Key[] keys = this.segment.listKeys(container);
        if (this.persistent && !activated) {
            container.deactivate((Object)this.segment, 1);
        }
        return keys;
    }

    public int objectHash() {
        return super.hashCode();
    }

    public boolean objectCanStore(ObjectContainer container) {
        if (this.blockNums == null) {
            throw new NullPointerException("Storing " + this + " but blockNums == null!");
        }
        return true;
    }

    @Override
    public void preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return;
        }
        boolean deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.parent);
            container.activate((Object)this.parent, 1);
        }
        this.parent.toNetwork(container, context);
        if (deactivate) {
            container.deactivate((Object)this.parent, 1);
        }
    }

    private static class MySendableRequestItem
    implements SendableRequestItem {
        final int x;

        MySendableRequestItem(int x) {
            this.x = x;
        }

        public void dump() {
        }
    }
}

