/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.FailureCodeTracker;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.MetadataParseException;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.MinimalSplitfileBlock;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherSubSegment;
import freenet.keys.CHKBlock;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.NodeCHK;
import freenet.keys.TooBigException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Vector;

public class SplitFileFetcherSegment
implements FECCallback {
    private static volatile boolean logMINOR;
    final short splitfileType;
    final ClientCHK[] dataKeys;
    final ClientCHK[] checkKeys;
    final MinimalSplitfileBlock[] dataBuckets;
    final MinimalSplitfileBlock[] checkBuckets;
    final long[] dataCooldownTimes;
    final long[] checkCooldownTimes;
    final int[] dataRetries;
    final int[] checkRetries;
    final Vector<SplitFileFetcherSubSegment> subSegments;
    final int minFetched;
    final SplitFileFetcher parentFetcher;
    final ClientRequester parent;
    final ArchiveContext archiveContext;
    final long maxBlockLength;
    private volatile boolean finished;
    private boolean startedDecode;
    private Bucket decodedData;
    final FetchContext blockFetchContext;
    final int recursionLevel;
    private FetchException failureException;
    private final boolean ignoreLastDataBlock;
    private int fatallyFailedBlocks;
    private int failedBlocks;
    private int fetchedBlocks;
    private int fetchedDataBlocks;
    final FailureCodeTracker errors;
    private boolean finishing;
    private boolean scheduled;
    private final boolean persistent;
    final int segNum;
    private final int hashCode;
    private boolean fetcherFinished = false;
    private boolean encoderFinished = false;
    private transient FECCodec codec;
    private static final short ON_SUCCESS_DONT_NOTIFY = 1;
    private static final short ON_SUCCESS_ALL_FAILED = 2;
    private static final short ON_SUCCESS_DECODE_NOW = 4;

    public int hashCode() {
        return this.hashCode;
    }

    public SplitFileFetcherSegment(short splitfileType, ClientCHK[] splitfileDataKeys, ClientCHK[] splitfileCheckKeys, SplitFileFetcher fetcher, ArchiveContext archiveContext, FetchContext blockFetchContext, long maxTempLength, int recursionLevel, ClientRequester requester, int segNum, boolean ignoreLastDataBlock) throws MetadataParseException, FetchException {
        int i;
        this.segNum = segNum;
        this.hashCode = super.hashCode();
        this.persistent = fetcher.persistent;
        this.parentFetcher = fetcher;
        this.ignoreLastDataBlock = ignoreLastDataBlock;
        this.errors = new FailureCodeTracker(false);
        this.archiveContext = archiveContext;
        this.splitfileType = splitfileType;
        this.parent = requester;
        this.dataKeys = splitfileDataKeys;
        this.checkKeys = splitfileCheckKeys;
        if (splitfileType == 0) {
            this.minFetched = this.dataKeys.length;
        } else if (splitfileType == 1) {
            this.minFetched = this.dataKeys.length;
        } else {
            throw new MetadataParseException("Unknown splitfile type" + splitfileType);
        }
        this.finished = false;
        this.decodedData = null;
        this.dataBuckets = new MinimalSplitfileBlock[this.dataKeys.length];
        this.checkBuckets = new MinimalSplitfileBlock[this.checkKeys.length];
        for (i = 0; i < this.dataBuckets.length; ++i) {
            this.dataBuckets[i] = new MinimalSplitfileBlock(i);
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            this.checkBuckets[i] = new MinimalSplitfileBlock(i + this.dataBuckets.length);
        }
        this.dataRetries = new int[this.dataKeys.length];
        this.checkRetries = new int[this.checkKeys.length];
        this.dataCooldownTimes = new long[this.dataKeys.length];
        this.checkCooldownTimes = new long[this.checkKeys.length];
        this.subSegments = new Vector();
        this.maxBlockLength = maxTempLength;
        this.blockFetchContext = blockFetchContext;
        this.recursionLevel = 0;
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " for " + this.parentFetcher + " : " + this.dataRetries.length + " data blocks " + this.checkRetries.length + " check blocks");
        }
        for (i = 0; i < this.dataKeys.length; ++i) {
            if (this.dataKeys[i] != null) continue;
            throw new NullPointerException("Null: data block " + i);
        }
        for (i = 0; i < this.checkKeys.length; ++i) {
            if (this.checkKeys[i] != null) continue;
            throw new NullPointerException("Null: check block " + i);
        }
    }

    public synchronized boolean isFinished(ObjectContainer container) {
        if (this.finished) {
            return true;
        }
        boolean deactivateParent = false;
        if (this.persistent) {
            boolean bl = deactivateParent = !container.ext().isActive((Object)this.parent);
            if (deactivateParent) {
                container.activate((Object)this.parent, 1);
            }
        }
        boolean ret = this.parent.isCancelled();
        if (deactivateParent) {
            container.deactivate((Object)this.parent, 1);
        }
        return ret;
    }

    public synchronized boolean succeeded() {
        return this.finished;
    }

    public synchronized boolean isFinishing(ObjectContainer container) {
        return this.isFinished(container) || this.finishing;
    }

    public synchronized void throwError(ObjectContainer container) throws FetchException {
        if (this.failureException != null) {
            if (this.persistent) {
                container.activate((Object)this.failureException, 5);
            }
            if (this.persistent) {
                throw this.failureException.clone();
            }
            throw this.failureException;
        }
    }

    public long decodedLength(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.decodedData, 1);
        }
        return this.decodedData.size();
    }

    public long writeDecodedDataTo(OutputStream os, long truncateLength) throws IOException {
        long len = this.decodedData.size();
        if (truncateLength >= 0L && truncateLength < len) {
            len = truncateLength;
        }
        BucketTools.copyTo(this.decodedData, os, Math.min(truncateLength, this.decodedData.size()));
        return len;
    }

    public synchronized int failedBlocks() {
        return this.failedBlocks;
    }

    public synchronized int fetchedBlocks() {
        return this.fetchedBlocks;
    }

    public synchronized int fatallyFailedBlocks() {
        return this.fatallyFailedBlocks;
    }

    private synchronized short onSuccessInner(Bucket data, int blockNo, ClientKeyBlock block, ObjectContainer container, ClientContext context, SplitFileFetcherSubSegment sub) {
        boolean tooSmall;
        boolean allFailed = false;
        boolean decodeNow = false;
        boolean wasDataBlock = false;
        if (this.finished) {
            if (logMINOR) {
                Logger.minor(this, "onSuccess() when already finished for " + this);
            }
            data.free();
            return -1;
        }
        if (this.startedDecode) {
            if (logMINOR) {
                Logger.minor(this, "onSuccess() when started decode for " + this);
            }
            data.free();
            return -1;
        }
        if (blockNo < this.dataKeys.length) {
            wasDataBlock = true;
            if (this.dataKeys[blockNo] == null) {
                if (!this.startedDecode && logMINOR) {
                    Logger.minor(this, "Block already finished: " + blockNo);
                }
                data.free();
                return -1;
            }
            this.dataRetries[blockNo] = 0;
            if (this.persistent) {
                container.activate((Object)this.dataKeys[blockNo], 5);
                this.dataKeys[blockNo].removeFrom(container);
            }
            this.dataKeys[blockNo] = null;
            if (this.persistent) {
                container.activate((Object)this.dataBuckets[blockNo], 1);
            }
            this.dataBuckets[blockNo].setData(data);
            if (this.persistent) {
                data.storeTo(container);
                container.store((Object)this.dataBuckets[blockNo]);
                container.store((Object)this);
            }
        } else if (blockNo < this.checkKeys.length + this.dataKeys.length) {
            int checkNo = blockNo - this.dataKeys.length;
            if (this.checkKeys[checkNo] == null) {
                if (!this.startedDecode && logMINOR) {
                    Logger.minor(this, "Check block already finished: " + checkNo);
                }
                data.free();
                return -1;
            }
            this.checkRetries[checkNo] = 0;
            if (this.persistent) {
                container.activate((Object)this.checkKeys[checkNo], 5);
                this.checkKeys[checkNo].removeFrom(container);
            }
            this.checkKeys[checkNo] = null;
            if (this.persistent) {
                container.activate((Object)this.checkBuckets[checkNo], 1);
            }
            this.checkBuckets[checkNo].setData(data);
            if (this.persistent) {
                data.storeTo(container);
                container.store((Object)this.checkBuckets[checkNo]);
                container.store((Object)this);
            }
        } else {
            Logger.error(this, "Unrecognized block number: " + blockNo, new Exception("error"));
        }
        if (this.startedDecode) {
            return -1;
        }
        boolean bl = tooSmall = data.size() < 32768L;
        if (tooSmall && (!this.ignoreLastDataBlock || blockNo != this.dataKeys.length - 1)) {
            this.fail(new FetchException(4, "Block too small in splitfile: block " + blockNo + " of " + this.dataKeys.length + " data keys, " + this.checkKeys.length + " check keys"), container, context, true);
            return -1;
        }
        if (!this.ignoreLastDataBlock || blockNo != this.dataKeys.length - 1 || !tooSmall) {
            ++this.fetchedBlocks;
        } else {
            ++this.fatallyFailedBlocks;
        }
        if (wasDataBlock) {
            ++this.fetchedDataBlocks;
        }
        if (logMINOR) {
            Logger.minor(this, "Fetched " + this.fetchedBlocks + " blocks in onSuccess(" + blockNo + ")");
        }
        boolean haveDataBlocks = this.fetchedDataBlocks == this.dataKeys.length;
        boolean bl2 = decodeNow = !this.startedDecode && (this.fetchedBlocks >= this.minFetched || haveDataBlocks);
        if (decodeNow) {
            this.startedDecode = true;
            this.finishing = true;
        } else {
            allFailed = this.failedBlocks + this.fatallyFailedBlocks > this.dataKeys.length + this.checkKeys.length - this.minFetched;
        }
        boolean dontNotify = !this.scheduled;
        short res = 0;
        if (dontNotify) {
            res = (short)(res | 1);
        }
        if (allFailed) {
            res = (short)(res | 2);
        }
        if (decodeNow) {
            res = (short)(res | 4);
        }
        return res;
    }

    public void onSuccess(Bucket data, int blockNo, ClientKeyBlock block, ObjectContainer container, ClientContext context, SplitFileFetcherSubSegment sub) {
        short result;
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (logMINOR) {
            Logger.minor(this, "Fetched block " + blockNo + " in " + this + " data=" + this.dataBuckets.length + " check=" + this.checkBuckets.length);
        }
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, container, context);
        }
        if ((result = this.onSuccessInner(data, blockNo, block, container, context, sub)) == -1) {
            return;
        }
        this.finishOnSuccess(result, container, context);
    }

    private void finishOnSuccess(short result, ObjectContainer container, ClientContext context) {
        boolean decodeNow;
        boolean dontNotify = (result & 1) == 1;
        boolean allFailed = (result & 2) == 2;
        boolean bl = decodeNow = (result & 4) == 4;
        if (logMINOR) {
            Logger.minor(this, "finishOnSuccess: result = " + result + " dontNotify=" + dontNotify + " allFailed=" + allFailed + " decodeNow=" + decodeNow);
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parent, 1);
        }
        this.parent.completedBlock(dontNotify, container, context);
        if (decodeNow) {
            if (this.persistent) {
                container.activate((Object)this.parentFetcher, 1);
            }
            this.parentFetcher.removeMyPendingKeys(this, container, context);
            if (this.persistent) {
                container.deactivate((Object)this.parentFetcher, 1);
            }
            this.removeSubSegments(container, context, false);
            this.decode(container, context);
        } else if (allFailed) {
            this.fail(new FetchException(19, this.errors), container, context, true);
        }
        if (this.persistent) {
            container.deactivate((Object)this.parent, 1);
        }
    }

    public void decode(ObjectContainer container, ClientContext context) {
        int i;
        int i2;
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Decoding " + this);
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent) {
            for (i2 = 0; i2 < this.dataBuckets.length; ++i2) {
                container.activate((Object)this.dataBuckets[i2], 1);
            }
        }
        if (this.persistent) {
            for (i2 = 0; i2 < this.checkBuckets.length; ++i2) {
                container.activate((Object)this.checkBuckets[i2], 1);
            }
        }
        int data = 0;
        for (i = 0; i < this.dataBuckets.length; ++i) {
            if (this.dataBuckets[i].getData() == null) continue;
            ++data;
        }
        if (data == this.dataBuckets.length) {
            if (logMINOR) {
                Logger.minor(this, "Already decoded");
            }
            if (this.persistent) {
                for (i = 0; i < this.dataBuckets.length; ++i) {
                    container.activate((Object)this.dataBuckets[i].getData(), 1);
                }
            }
            this.onDecodedSegment(container, context, null, null, null, this.dataBuckets, this.checkBuckets);
            return;
        }
        if (this.splitfileType != 0) {
            Bucket lastBlock;
            int i3;
            FECQueue queue = context.fecQueue;
            int count = 0;
            for (i3 = 0; i3 < this.dataBuckets.length; ++i3) {
                if (this.dataBuckets[i3].getData() == null) continue;
                ++count;
            }
            for (i3 = 0; i3 < this.checkBuckets.length; ++i3) {
                if (this.checkBuckets[i3].getData() == null) continue;
                ++count;
            }
            if (count < this.dataBuckets.length) {
                Logger.error(this, "Attempting to decode but only " + count + " of " + this.dataBuckets.length + " blocks available!", new Exception("error"));
            }
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if ((lastBlock = this.dataBuckets[this.dataBuckets.length - 1].data) != null) {
                if (this.persistent) {
                    container.activate((Object)lastBlock, 1);
                }
                if (this.ignoreLastDataBlock && lastBlock.size() < 32768L) {
                    lastBlock.free();
                    if (this.persistent) {
                        lastBlock.removeFrom(container);
                    }
                    this.dataBuckets[this.dataBuckets.length - 1].data = null;
                    if (this.persistent) {
                        container.store((Object)this.dataBuckets[this.dataBuckets.length - 1]);
                    }
                } else if (lastBlock.size() != 32768L) {
                    this.fail(new FetchException(4, "Last data block is not the standard size"), container, context, true);
                }
            }
            if (this.codec == null) {
                this.codec = FECCodec.getCodec(this.splitfileType, this.dataKeys.length, this.checkKeys.length);
            }
            FECJob job = new FECJob(this.codec, queue, this.dataBuckets, this.checkBuckets, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, true, this.parent.getPriorityClass(), this.persistent);
            this.codec.addToQueue(job, queue, container);
            if (logMINOR) {
                Logger.minor(this, "Queued FEC job: " + job);
            }
            if (this.persistent) {
                container.deactivate((Object)this.parent, 1);
            }
        } else {
            Logger.error(this, "SPLITFILE_NONREDUNDANT !!");
            this.onDecodedSegment(container, context, null, null, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDecodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets2, Bucket[] checkBuckets2, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        block53: {
            if (this.persistent) {
                container.activate((Object)this.parentFetcher, 1);
                container.activate((Object)this.parent, 1);
                container.activate((Object)context, 1);
            }
            if (this.codec == null) {
                this.codec = FECCodec.getCodec(this.splitfileType, this.dataKeys.length, this.checkKeys.length);
            }
            try {
                int i;
                if (this.persistent) {
                    for (i = 0; i < this.dataBuckets.length; ++i) {
                        long ourID;
                        long theirID;
                        if (dataBlockStatus[i] != this.dataBuckets[i] && (theirID = container.ext().getID((Object)dataBlockStatus[i])) == (ourID = container.ext().getID((Object)this.dataBuckets[i]))) {
                            Logger.error(this, "DB4O BUG DETECTED IN DECODED SEGMENT!: our block: " + this.dataBuckets[i] + " block from decode " + dataBlockStatus[i] + " both have ID " + ourID + " = " + theirID);
                            this.dataBuckets[i] = (MinimalSplitfileBlock)dataBlockStatus[i];
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Data block " + i + " is " + this.dataBuckets[i]);
                        }
                        if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                            Logger.error(this, "Data block " + i + " is not stored!");
                        } else if (!container.ext().isActive((Object)this.dataBuckets[i])) {
                            Logger.error(this, "Data block " + i + " is inactive! : " + this.dataBuckets[i]);
                        }
                        if (this.dataBuckets[i] == null) {
                            Logger.error(this, "Data block " + i + " is null!");
                        } else if (this.dataBuckets[i].data == null) {
                            Logger.error(this, "Data block " + i + " has null data!");
                        } else {
                            this.dataBuckets[i].data.storeTo(container);
                        }
                        container.store((Object)this.dataBuckets[i]);
                    }
                }
                if (this.isCollectingBinaryBlob()) {
                    for (i = 0; i < this.dataBuckets.length; ++i) {
                        Bucket data = dataBlockStatus[i].getData();
                        if (data == null) {
                            throw new NullPointerException("Data bucket " + i + " of " + this.dataBuckets.length + " is null");
                        }
                        try {
                            this.maybeAddToBinaryBlob(data, i, false, container, context);
                            continue;
                        }
                        catch (FetchException e) {
                            this.fail(e, container, context, false);
                            return;
                        }
                    }
                }
                this.decodedData = context.getBucketFactory(this.persistent).makeBucket(this.maxBlockLength * (long)this.dataBuckets.length);
                if (logMINOR) {
                    Logger.minor(this, "Copying data from " + this.dataBuckets.length + " data blocks");
                }
                OutputStream os = this.decodedData.getOutputStream();
                long osSize = 0L;
                for (int i2 = 0; i2 < this.dataBuckets.length; ++i2) {
                    MinimalSplitfileBlock status;
                    if (logMINOR) {
                        Logger.minor(this, "Copying data from block " + i2);
                    }
                    if ((status = this.dataBuckets[i2]) == null) {
                        throw new NullPointerException();
                    }
                    Bucket data = status.getData();
                    if (data == null) {
                        throw new NullPointerException("Data bucket " + i2 + " of " + this.dataBuckets.length + " is null");
                    }
                    if (this.persistent) {
                        container.activate((Object)data, 1);
                    }
                    long copied = BucketTools.copyTo(data, os, Long.MAX_VALUE);
                    osSize += copied;
                    if (i2 != this.dataBuckets.length - 1 && copied != 32768L) {
                        Logger.error(this, "Copied only " + copied + " bytes from " + data + " (bucket " + i2 + ")");
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Copied " + copied + " bytes from bucket " + i2);
                }
                if (logMINOR) {
                    Logger.minor(this, "Copied data (" + osSize + ")");
                }
                os.close();
                this.finished = true;
                if (this.persistent) {
                    container.store((Object)this);
                }
                if (this.persistent) {
                    boolean fin;
                    SplitFileFetcherSegment splitFileFetcherSegment = this;
                    synchronized (splitFileFetcherSegment) {
                        fin = this.fetcherFinished;
                    }
                    if (fin) {
                        this.encoderFinished(container, context);
                        return;
                    }
                }
                if (this.splitfileType == 0 || !this.isCollectingBinaryBlob()) {
                    this.parentFetcher.segmentFinished(this, container, context);
                }
            }
            catch (IOException e) {
                boolean fin;
                Logger.normal(this, "Caught bucket error?: " + e, e);
                SplitFileFetcherSegment splitFileFetcherSegment = this;
                synchronized (splitFileFetcherSegment) {
                    this.finished = true;
                    this.failureException = new FetchException(12);
                    fin = this.fetcherFinished;
                }
                if (this.persistent && fin) {
                    this.encoderFinished(container, context);
                    return;
                }
                if (this.persistent) {
                    container.store((Object)this);
                }
                this.parentFetcher.segmentFinished(this, container, context);
                if (this.persistent) {
                    this.encoderFinished(container, context);
                }
                return;
            }
            if (this.splitfileType == 0) {
                if (this.persistent) {
                    container.deactivate((Object)this.parentFetcher, 1);
                    container.deactivate((Object)this.parent, 1);
                    container.deactivate((Object)context, 1);
                }
                if (this.persistent) {
                    this.encoderFinished(container, context);
                }
                return;
            }
            Bucket lastBlock = this.dataBuckets[this.dataBuckets.length - 1].data;
            if (lastBlock != null) {
                if (this.persistent) {
                    container.activate((Object)lastBlock, 1);
                }
                if (lastBlock.size() != 32768L) {
                    try {
                        this.dataBuckets[this.dataBuckets.length - 1].data = BucketTools.pad(lastBlock, 32768, context.getBucketFactory(this.persistent), (int)lastBlock.size());
                        lastBlock.free();
                        if (this.persistent) {
                            lastBlock.removeFrom(container);
                            this.dataBuckets[this.dataBuckets.length - 1].storeTo(container);
                        }
                    }
                    catch (IOException e) {
                        this.fail(new FetchException(12, (Throwable)e), container, context, true);
                    }
                }
            }
            try {
                this.codec.addToQueue(new FECJob(this.codec, context.fecQueue, this.dataBuckets, this.checkBuckets, 32768, context.getBucketFactory(this.persistent), (FECCallback)this, false, this.parent.getPriorityClass(), this.persistent), context.fecQueue, container);
                if (this.persistent) {
                    container.deactivate((Object)this.parentFetcher, 1);
                    container.deactivate((Object)this.parent, 1);
                    container.deactivate((Object)context, 1);
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                if (!this.persistent) break block53;
                this.encoderFinished(container, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onEncodedSegment(ObjectContainer container, ClientContext context, FECJob job, Bucket[] dataBuckets2, Bucket[] checkBuckets2, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus) {
        try {
            Bucket data;
            boolean heal;
            int i;
            if (this.persistent) {
                container.activate((Object)this.parent, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Encoded " + this);
            }
            SplitFileFetcherSegment splitFileFetcherSegment = this;
            // MONITORENTER : splitFileFetcherSegment
            for (i = 0; i < this.dataBuckets.length; ++i) {
                heal = false;
                if (this.dataBuckets[i] == null) {
                    Logger.error(this, "Data bucket " + i + " is null in onEncodedSegment on " + this);
                    continue;
                }
                if (this.dataBuckets[i] != dataBlockStatus[i]) {
                    Logger.error(this, "Data block " + i + " : ours is " + this.dataBuckets[i] + " codec's is " + dataBlockStatus[i]);
                    if (this.persistent) {
                        if (container.ext().getID((Object)this.dataBuckets[i]) == container.ext().getID((Object)dataBlockStatus[i])) {
                            Logger.error(this, "DB4O BUG DETECTED: SAME UID FOR TWO OBJECTS: " + this.dataBuckets[i] + "=" + container.ext().getID((Object)this.dataBuckets[i]) + " and " + dataBlockStatus[i] + "=" + container.ext().getID((Object)dataBlockStatus[i]) + " ... attempting workaround ...");
                        }
                        Logger.error(this, "Ours is " + (container.ext().isStored((Object)this.dataBuckets[i]) ? "stored " : "") + (container.ext().isActive((Object)this.dataBuckets[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)this.dataBuckets[i]));
                        Logger.error(this, "Theirs is " + (container.ext().isStored((Object)dataBlockStatus[i]) ? "stored " : "") + (container.ext().isActive((Object)dataBlockStatus[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)dataBlockStatus[i]));
                    }
                    this.dataBuckets[i] = (MinimalSplitfileBlock)dataBlockStatus[i];
                }
                if ((data = this.dataBuckets[i].getData()) == null) {
                    Logger.error(this, "Data bucket " + i + " has null contents in onEncodedSegment on " + this + " for block " + this.dataBuckets[i]);
                    if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                        Logger.error(this, "Splitfile block appears not to be stored");
                        continue;
                    }
                    if (container.ext().isActive((Object)this.dataBuckets[i])) continue;
                    Logger.error(this, "Splitfile block appears not to be active");
                    continue;
                }
                if (this.dataRetries[i] > 0) {
                    heal = true;
                }
                if (heal) {
                    this.queueHeal(data, container, context);
                    this.dataBuckets[i].data = null;
                } else {
                    this.dataBuckets[i].data.free();
                }
                if (this.persistent) {
                    this.dataBuckets[i].removeFrom(container);
                }
                this.dataBuckets[i] = null;
                if (this.persistent && this.dataKeys[i] != null) {
                    this.dataKeys[i].removeFrom(container);
                }
                this.dataKeys[i] = null;
            }
            for (i = 0; i < this.checkBuckets.length; ++i) {
                heal = false;
                if (this.checkBuckets[i] == null) {
                    Logger.error(this, "Check bucket " + i + " is null in onEncodedSegment on " + this);
                    continue;
                }
                if (this.checkBuckets[i] != checkBlockStatus[i]) {
                    Logger.error(this, "Check block " + i + " : ours is " + this.checkBuckets[i] + " codec's is " + checkBlockStatus[i]);
                    if (this.persistent) {
                        if (container.ext().getID((Object)this.checkBuckets[i]) == container.ext().getID((Object)checkBlockStatus[i])) {
                            Logger.error(this, "DB4O BUG DETECTED: SAME UID FOR TWO OBJECTS: " + this.checkBuckets[i] + "=" + container.ext().getID((Object)this.checkBuckets[i]) + " and " + checkBlockStatus[i] + "=" + container.ext().getID((Object)checkBlockStatus[i]) + " ... attempting workaround ...");
                        }
                        Logger.error(this, "Ours is " + (container.ext().isStored((Object)this.checkBuckets[i]) ? "stored " : "") + (container.ext().isActive((Object)this.checkBuckets[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)this.checkBuckets[i]));
                        Logger.error(this, "Theirs is " + (container.ext().isStored((Object)checkBlockStatus[i]) ? "stored " : "") + (container.ext().isActive((Object)checkBlockStatus[i]) ? "active " : "") + " UUID " + container.ext().getID((Object)checkBlockStatus[i]));
                    }
                    this.checkBuckets[i] = (MinimalSplitfileBlock)checkBlockStatus[i];
                }
                if ((data = this.checkBuckets[i].getData()) == null) {
                    Logger.error(this, "Check bucket " + i + " has null contents in onEncodedSegment on " + this + " for block " + this.checkBuckets[i]);
                    if (!container.ext().isStored((Object)this.dataBuckets[i])) {
                        Logger.error(this, "Splitfile block appears not to be stored");
                        continue;
                    }
                    if (container.ext().isActive((Object)this.dataBuckets[i])) continue;
                    Logger.error(this, "Splitfile block appears not to be active");
                    continue;
                }
                try {
                    this.maybeAddToBinaryBlob(data, i, true, container, context);
                }
                catch (FetchException e) {
                    this.fail(e, container, context, false);
                    // MONITOREXIT : splitFileFetcherSegment
                    Object var15_13 = null;
                    if (!this.persistent) return;
                    this.encoderFinished(container, context);
                    return;
                }
                if (this.checkRetries[i] > 0) {
                    heal = true;
                }
                if (heal) {
                    this.queueHeal(data, container, context);
                    this.checkBuckets[i].data = null;
                } else {
                    data.free();
                }
                if (this.persistent) {
                    this.checkBuckets[i].removeFrom(container);
                }
                this.checkBuckets[i] = null;
                if (this.persistent && this.checkKeys[i] != null) {
                    this.checkKeys[i].removeFrom(container);
                }
                this.checkKeys[i] = null;
            }
            if (this.persistent && !this.fetcherFinished) {
                container.store((Object)this);
            }
            // MONITOREXIT : splitFileFetcherSegment
            if (this.isCollectingBinaryBlob()) {
                if (this.persistent) {
                    container.activate((Object)this.parentFetcher, 1);
                }
                this.parentFetcher.segmentFinished(this, container, context);
                if (this.persistent) {
                    container.deactivate((Object)this.parentFetcher, 1);
                }
            }
            Object var15_14 = null;
            if (!this.persistent) return;
            this.encoderFinished(container, context);
            return;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (!this.persistent) throw throwable;
            this.encoderFinished(container, context);
            throw throwable;
        }
    }

    boolean isCollectingBinaryBlob() {
        if (this.parent instanceof ClientGetter) {
            ClientGetter getter = (ClientGetter)this.parent;
            return getter.collectingBinaryBlob();
        }
        return false;
    }

    private void maybeAddToBinaryBlob(Bucket data, int i, boolean check, ObjectContainer container, ClientContext context) throws FetchException {
        ClientGetter getter;
        if (this.parent instanceof ClientGetter && (getter = (ClientGetter)this.parent).collectingBinaryBlob()) {
            try {
                ClientCHKBlock block = ClientCHKBlock.encode(data, false, true, (short)-1, data.size());
                getter.addKeyToBinaryBlob(block, container, context);
            }
            catch (CHKEncodeException e) {
                Logger.error(this, "Failed to encode (collecting binary blob) " + (check ? "check" : "data") + " block " + i + ": " + e, e);
                throw new FetchException(17, "Failed to encode for binary blob: " + e);
            }
            catch (IOException e) {
                throw new FetchException(12, "Failed to encode for binary blob: " + e);
            }
        }
    }

    private void queueHeal(Bucket data, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            try {
                Bucket copy = context.tempBucketFactory.makeBucket(data.size());
                BucketTools.copy(data, copy);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                data = copy;
            }
            catch (IOException e) {
                Logger.normal(this, "Failed to copy data for healing: " + e, e);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Queueing healing insert for " + data + " on " + this);
        }
        context.healingQueue.queue(data, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFatalFailure(FetchException e, int blockNo, SplitFileFetcherSubSegment seg, ObjectContainer container, ClientContext context) {
        boolean allFailed;
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Permanently failed block: " + blockNo + " on " + this + " : " + e, (Throwable)e);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.isFinishing(container)) {
                return;
            }
            if (blockNo < this.dataKeys.length) {
                if (this.dataKeys[blockNo] == null) {
                    Logger.error(this, "Block already finished: " + blockNo);
                    return;
                }
                if (this.persistent) {
                    container.activate((Object)this.dataKeys[blockNo], 1);
                    this.dataKeys[blockNo].removeFrom(container);
                }
                this.dataKeys[blockNo] = null;
            } else if (blockNo < this.checkKeys.length + this.dataKeys.length) {
                if (this.checkKeys[blockNo - this.dataKeys.length] == null) {
                    Logger.error(this, "Check block already finished: " + blockNo);
                    return;
                }
                if (this.persistent) {
                    container.activate((Object)this.checkKeys[blockNo - this.dataKeys.length], 1);
                    this.checkKeys[blockNo - this.dataKeys.length].removeFrom(container);
                }
                this.checkKeys[blockNo - this.dataKeys.length] = null;
            } else {
                Logger.error(this, "Unrecognized block number: " + blockNo, new Exception("error"));
            }
            boolean deactivateParent = false;
            if (this.persistent) {
                boolean bl = deactivateParent = !container.ext().isActive((Object)this.parent);
                if (deactivateParent) {
                    container.activate((Object)this.parent, 1);
                }
            }
            if (e.isFatal()) {
                ++this.fatallyFailedBlocks;
                this.parent.fatallyFailedBlock(container, context);
            } else {
                ++this.failedBlocks;
                this.parent.failedBlock(container, context);
            }
            if (deactivateParent) {
                container.deactivate((Object)this.parent, 1);
            }
            allFailed = this.failedBlocks + this.fatallyFailedBlocks > this.dataKeys.length + this.checkKeys.length - this.minFetched;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (allFailed) {
            this.fail(new FetchException(19, this.errors), container, context, false);
        } else if (seg != null && seg.possiblyRemoveFromParent(container, context)) {
            seg.kill(container, context, true, true);
        }
    }

    public void onNonFatalFailure(FetchException e, int blockNo, SplitFileFetcherSubSegment seg, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.blockFetchContext, 1);
        }
        int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
        RequestScheduler sched = context.getFetchScheduler(false);
        seg.removeBlockNum(blockNo, container, false);
        SplitFileFetcherSubSegment sub = this.onNonFatalFailure(e, blockNo, seg, container, context, sched, maxTries);
        if (sub != null) {
            sub.reschedule(container, context);
            if (this.persistent && sub != seg) {
                container.deactivate((Object)sub, 1);
            }
        }
    }

    public void onNonFatalFailure(FetchException[] failures, int[] blockNos, SplitFileFetcherSubSegment seg, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.blockFetchContext, 1);
        }
        int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
        RequestScheduler sched = context.getFetchScheduler(false);
        HashSet<SplitFileFetcherSubSegment> toSchedule = null;
        seg.removeBlockNums(blockNos, container);
        for (int i = 0; i < failures.length; ++i) {
            SplitFileFetcherSubSegment sub = this.onNonFatalFailure(failures[i], blockNos[i], seg, container, context, sched, maxTries);
            if (sub == null) continue;
            if (toSchedule == null) {
                toSchedule = new HashSet<SplitFileFetcherSubSegment>();
            }
            toSchedule.add(sub);
        }
        if (toSchedule != null && !toSchedule.isEmpty()) {
            for (SplitFileFetcherSubSegment sub : toSchedule) {
                sub.reschedule(container, context);
                if (!this.persistent || sub == seg) continue;
                container.deactivate((Object)sub, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplitFileFetcherSubSegment onNonFatalFailure(FetchException e, int blockNo, SplitFileFetcherSubSegment seg, ObjectContainer container, ClientContext context, RequestScheduler sched, int maxTries) {
        int tries;
        ClientCHK key;
        if (logMINOR) {
            Logger.minor(this, "Calling onNonFatalFailure for block " + blockNo + " on " + this + " from " + seg);
        }
        boolean failed = false;
        boolean cooldown = false;
        SplitFileFetcherSubSegment sub = null;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.isFinished(container)) {
                return null;
            }
            if (blockNo < this.dataKeys.length) {
                key = this.dataKeys[blockNo];
                if (this.persistent) {
                    container.activate((Object)key, 5);
                }
                int n = blockNo;
                this.dataRetries[n] = this.dataRetries[n] + 1;
                tries = this.dataRetries[n];
                if (tries > maxTries && maxTries >= 0) {
                    failed = true;
                } else {
                    sub = this.getSubSegment(tries, container, false, seg);
                    if (tries % 3 == 0) {
                        long now = System.currentTimeMillis();
                        if (this.dataCooldownTimes[blockNo] > now) {
                            Logger.error(this, "Already on the cooldown queue! for " + this + " data block no " + blockNo, new Exception("error"));
                        } else {
                            this.dataCooldownTimes[blockNo] = sched.queueCooldown(key, sub, container);
                        }
                        cooldown = true;
                    }
                }
            } else {
                int checkNo = blockNo - this.dataKeys.length;
                key = this.checkKeys[checkNo];
                if (this.persistent) {
                    container.activate((Object)key, 5);
                }
                int n = checkNo;
                this.checkRetries[n] = this.checkRetries[n] + 1;
                tries = this.checkRetries[n];
                if (tries > maxTries && maxTries >= 0) {
                    failed = true;
                } else {
                    sub = this.getSubSegment(tries, container, false, seg);
                    if (tries % 3 == 0) {
                        long now = System.currentTimeMillis();
                        if (this.checkCooldownTimes[checkNo] > now) {
                            Logger.error(this, "Already on the cooldown queue! for " + this + " check block no " + blockNo, new Exception("error"));
                        } else {
                            this.checkCooldownTimes[checkNo] = sched.queueCooldown(key, sub, container);
                        }
                        cooldown = true;
                    }
                }
            }
        }
        if (tries != seg.retryCount + 1) {
            Logger.error(this, "Failed on segment " + seg + " but tries for block " + blockNo + " (after increment) is " + tries);
        }
        if (failed) {
            this.onFatalFailure(e, blockNo, seg, container, context);
            if (logMINOR) {
                Logger.minor(this, "Not retrying block " + blockNo + " on " + this + " : tries=" + tries + "/" + maxTries);
            }
            return null;
        }
        boolean mustSchedule = false;
        if (cooldown) {
            if (logMINOR) {
                Logger.minor(this, "Added to cooldown queue: " + key + " for " + this + " was on segment " + seg + " now registered to " + sub);
            }
        } else {
            mustSchedule = sub.add(blockNo, container, context, false);
            if (logMINOR) {
                Logger.minor(this, "Retrying block " + blockNo + " on " + this + " : tries=" + tries + "/" + maxTries + " : " + sub);
            }
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)key, 5);
        }
        if (mustSchedule) {
            return sub;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplitFileFetcherSubSegment getSubSegment(int retryCount, ObjectContainer container, boolean noCreate, SplitFileFetcherSubSegment dontDeactivate) {
        SplitFileFetcherSubSegment sub;
        if (this.persistent) {
            container.activate(this.subSegments, 1);
        }
        SplitFileFetcherSubSegment ret = null;
        int dupes = 0;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            for (int i = 0; i < this.subSegments.size(); ++i) {
                sub = this.subSegments.get(i);
                if (this.persistent) {
                    container.activate((Object)sub, 1);
                }
                if (sub.retryCount == retryCount) {
                    if (ret != null) {
                        Logger.error(this, "Duplicate subsegment (count=" + dupes + "): " + ret + " and " + sub + " for retry count " + retryCount + " on " + this);
                        ++dupes;
                    } else {
                        ret = sub;
                    }
                }
                if (!this.persistent || sub == ret || sub == dontDeactivate) continue;
                container.deactivate((Object)sub, 1);
            }
            if (ret != null) {
                return ret;
            }
            if (noCreate) {
                return null;
            }
            boolean deactivateParent = false;
            if (this.persistent) {
                boolean bl = deactivateParent = !container.ext().isActive((Object)this.parent);
                if (deactivateParent) {
                    container.activate((Object)this.parent, 1);
                }
            }
            sub = new SplitFileFetcherSubSegment(this, this.parent, retryCount);
            if (deactivateParent) {
                container.deactivate((Object)this.parent, 1);
            }
            this.subSegments.add(sub);
        }
        if (this.persistent) {
            container.ext().store(this.subSegments, 1);
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(FetchException e, ObjectContainer container, ClientContext context, boolean dontDeactivateParent) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            Bucket d;
            MinimalSplitfileBlock b;
            int i;
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.failureException = e;
            if (this.startedDecode) {
                Logger.error(this, "Failing with " + e + " but already started decode", e);
                return;
            }
            for (i = 0; i < this.dataBuckets.length; ++i) {
                b = this.dataBuckets[i];
                if (this.persistent) {
                    container.activate((Object)b, 2);
                }
                if (b != null && (d = b.getData()) != null) {
                    d.free();
                }
                if (this.persistent) {
                    b.removeFrom(container);
                }
                this.dataBuckets[i] = null;
                if (this.persistent && this.dataKeys[i] != null) {
                    this.dataKeys[i].removeFrom(container);
                }
                this.dataKeys[i] = null;
            }
            for (i = 0; i < this.checkBuckets.length; ++i) {
                b = this.checkBuckets[i];
                if (this.persistent) {
                    container.activate((Object)b, 2);
                }
                if (b != null && (d = b.getData()) != null) {
                    d.free();
                }
                if (this.persistent) {
                    b.removeFrom(container);
                }
                this.checkBuckets[i] = null;
                if (this.persistent && this.checkKeys[i] != null) {
                    this.checkKeys[i].removeFrom(container);
                }
                this.checkKeys[i] = null;
            }
        }
        this.removeSubSegments(container, context, false);
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.parentFetcher, 1);
        }
        this.parentFetcher.removeMyPendingKeys(this, container, context);
        this.parentFetcher.segmentFinished(this, container, context);
        if (this.persistent && !dontDeactivateParent) {
            container.deactivate((Object)this.parentFetcher, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileFetcherSubSegment schedule(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        try {
            SplitFileFetcherSubSegment seg = this.getSubSegment(0, container, false, null);
            if (this.persistent) {
                container.activate((Object)seg, 1);
            }
            seg.addAll(this.dataRetries.length + this.checkRetries.length, container, context, false);
            if (logMINOR) {
                Logger.minor(this, "scheduling " + seg + " : " + seg.blockNums);
            }
            SplitFileFetcherSegment splitFileFetcherSegment = this;
            synchronized (splitFileFetcherSegment) {
                this.scheduled = true;
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.persistent) {
                container.deactivate((Object)seg, 1);
            }
            return seg;
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " scheduling " + this, t);
            this.fail(new FetchException(17, t), container, context, true);
            return null;
        }
    }

    public void cancel(ObjectContainer container, ClientContext context) {
        this.fail(new FetchException(25), container, context, true);
    }

    public void onBlockSetFinished(ClientGetState state) {
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState) {
    }

    public synchronized ClientCHK getBlockKey(int blockNum, ObjectContainer container) {
        ClientCHK ret;
        if (blockNum < 0) {
            return null;
        }
        if (blockNum < this.dataKeys.length) {
            ret = this.dataKeys[blockNum];
        } else if (blockNum < this.dataKeys.length + this.checkKeys.length) {
            ret = this.checkKeys[blockNum - this.dataKeys.length];
        } else {
            return null;
        }
        if (this.persistent) {
            container.activate((Object)ret, 5);
        }
        return ret;
    }

    public NodeCHK getBlockNodeKey(int blockNum, ObjectContainer container) {
        ClientCHK key = this.getBlockKey(blockNum, container);
        if (key != null) {
            return key.getNodeCHK();
        }
        return null;
    }

    public synchronized boolean maybeRemoveSeg(SplitFileFetcherSubSegment segment, ObjectContainer container) {
        int i;
        int retryCount = segment.retryCount;
        boolean dontRemove = true;
        for (i = 0; i < this.dataRetries.length; ++i) {
            if (this.dataRetries[i] != retryCount) continue;
            dontRemove = false;
            break;
        }
        for (i = 0; i < this.checkRetries.length; ++i) {
            if (this.checkRetries[i] != retryCount) continue;
            dontRemove = false;
            break;
        }
        if (this.isFinishing(container)) {
            dontRemove = false;
        }
        if (dontRemove) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Removing sub segment: " + segment + " for retry count " + retryCount);
        }
        if (this.persistent) {
            container.activate(this.subSegments, 1);
        }
        for (i = 0; i < this.subSegments.size(); ++i) {
            if (!segment.equals(this.subSegments.get(i))) continue;
            this.subSegments.remove(i);
            --i;
        }
        if (this.persistent) {
            container.store(this.subSegments);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubSegments(ObjectContainer container, ClientContext context, boolean finishing) {
        SplitFileFetcherSubSegment[] deadSegs;
        if (this.persistent) {
            container.activate(this.subSegments, 1);
        }
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            deadSegs = this.subSegments.toArray(new SplitFileFetcherSubSegment[this.subSegments.size()]);
            this.subSegments.clear();
        }
        if (this.persistent && deadSegs.length > 0) {
            container.store((Object)this);
        }
        for (int i = 0; i < deadSegs.length; ++i) {
            if (this.persistent) {
                container.activate((Object)deadSegs[i], 1);
            }
            deadSegs[i].kill(container, context, true, false);
            context.getChkFetchScheduler().removeFromStarterQueue(deadSegs[i], container, true);
            if (!this.persistent) continue;
            container.deactivate((Object)deadSegs[i], 1);
        }
        if (this.persistent && !finishing) {
            container.store((Object)this);
            container.store(this.subSegments);
        }
    }

    public synchronized long getCooldownWakeup(int blockNum) {
        if (blockNum < this.dataKeys.length) {
            return this.dataCooldownTimes[blockNum];
        }
        return this.checkCooldownTimes[blockNum - this.dataKeys.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context, SplitFileFetcherSubSegment dontDeactivate) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        Vector<SplitFileFetcherSubSegment> v = null;
        boolean notFound = true;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            SplitFileFetcherSubSegment sub;
            int tries;
            ClientCHK k;
            int i;
            if (this.isFinishing(container)) {
                return false;
            }
            int maxTries = this.blockFetchContext.maxNonSplitfileRetries;
            for (i = 0; i < this.dataKeys.length; ++i) {
                if (this.dataKeys[i] == null) continue;
                k = this.dataKeys[i];
                if (this.persistent) {
                    container.activate((Object)k, 5);
                }
                if (((ClientKey)k).getNodeKey().equals(key)) {
                    if (this.dataCooldownTimes[i] > time) {
                        if (logMINOR) {
                            Logger.minor(this, "Not retrying after cooldown for data block " + i + " as deadline has not passed yet on " + this + " remaining time: " + (this.dataCooldownTimes[i] - time) + "ms");
                        }
                        return false;
                    }
                    tries = this.dataRetries[i];
                    sub = this.getSubSegment(tries, container, false, dontDeactivate);
                    if (logMINOR) {
                        Logger.minor(this, "Retrying after cooldown on " + this + ": data block " + i + " on " + this + " : tries=" + tries + "/" + maxTries + " : " + sub);
                    }
                    if (v == null) {
                        v = new Vector<SplitFileFetcherSubSegment>();
                    }
                    sub.add(i, container, context, true);
                    if (!v.contains(sub)) {
                        v.add(sub);
                    }
                    notFound = false;
                    continue;
                }
                if (!this.persistent) continue;
                container.deactivate((Object)k, 5);
            }
            for (i = 0; i < this.checkKeys.length; ++i) {
                if (this.checkKeys[i] == null) continue;
                k = this.checkKeys[i];
                if (this.persistent) {
                    container.activate((Object)k, 5);
                }
                if (((ClientKey)k).getNodeKey().equals(key)) {
                    if (this.checkCooldownTimes[i] > time) {
                        if (logMINOR) {
                            Logger.minor(this, "Not retrying after cooldown for check block " + i + " as deadline has not passed yet on " + this + " remaining time: " + (this.checkCooldownTimes[i] - time) + "ms");
                        }
                        return false;
                    }
                    tries = this.checkRetries[i];
                    sub = this.getSubSegment(tries, container, false, dontDeactivate);
                    if (logMINOR) {
                        Logger.minor(this, "Retrying after cooldown on " + this + ": check block " + i + " on " + this + " : tries=" + tries + "/" + maxTries + " : " + sub);
                    }
                    if (v == null) {
                        v = new Vector();
                    }
                    sub.add(i + this.dataKeys.length, container, context, true);
                    if (!v.contains(sub)) {
                        v.add(sub);
                    }
                    notFound = false;
                    continue;
                }
                if (!this.persistent) continue;
                container.deactivate((Object)k, 5);
            }
        }
        if (notFound) {
            Logger.error(this, "requeueAfterCooldown: Key not found!: " + key + " on " + this);
        }
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                RandomGrabArray rga;
                SplitFileFetcherSubSegment sub = (SplitFileFetcherSubSegment)v.get(i);
                if (this.persistent && sub != dontDeactivate) {
                    container.activate((Object)sub, 1);
                }
                if ((rga = sub.getParentGrabArray()) == null) {
                    sub.reschedule(container, context);
                } else {
                    if (this.persistent) {
                        container.activate((Object)rga, 1);
                    }
                    if (!rga.contains(sub, container)) {
                        Logger.error(this, "Sub-segment has RGA but isn't registered to it!!: " + sub + " for " + rga);
                        sub.reschedule(container, context);
                    }
                    if (this.persistent) {
                        container.deactivate((Object)rga, 1);
                    }
                }
                if (!this.persistent || sub == dontDeactivate) continue;
                container.deactivate((Object)sub, 1);
            }
        }
        return true;
    }

    public synchronized long getCooldownWakeupByKey(Key key, ObjectContainer container) {
        ClientCHK k;
        int i;
        for (i = 0; i < this.dataKeys.length; ++i) {
            if (this.dataKeys[i] == null) continue;
            k = this.dataKeys[i];
            if (this.persistent) {
                container.activate((Object)k, 5);
            }
            if (((ClientKey)k).getNodeKey().equals(key)) {
                return this.dataCooldownTimes[i];
            }
            if (!this.persistent) continue;
            container.deactivate((Object)k, 5);
        }
        for (i = 0; i < this.checkKeys.length; ++i) {
            if (this.checkKeys[i] == null) continue;
            k = this.checkKeys[i];
            if (this.persistent) {
                container.activate((Object)k, 5);
            }
            if (this.checkKeys[i].getNodeKey().equals(key)) {
                return this.checkCooldownTimes[i];
            }
            if (!this.persistent) continue;
            container.deactivate((Object)k, 5);
        }
        return -1L;
    }

    public synchronized int getBlockNumber(Key key, ObjectContainer container) {
        ClientCHK k;
        int i;
        for (i = 0; i < this.dataKeys.length; ++i) {
            k = this.dataKeys[i];
            if (k == null) continue;
            if (this.persistent) {
                container.activate((Object)k, 5);
            }
            if (k.getRoutingKey() == null) {
                throw new NullPointerException("Routing key is null yet key exists for data block " + i + " of " + this + (this.persistent ? " stored=" + container.ext().isStored((Object)k) + " active=" + container.ext().isActive((Object)k) : ""));
            }
            if (k.getNodeKey().equals(key)) {
                return i;
            }
            if (!this.persistent) continue;
            container.deactivate((Object)k, 5);
        }
        for (i = 0; i < this.checkKeys.length; ++i) {
            k = this.checkKeys[i];
            if (k == null) continue;
            if (this.persistent) {
                container.activate((Object)k, 5);
            }
            if (k.getRoutingKey() == null) {
                throw new NullPointerException("Routing key is null yet key exists for check block " + i + " of " + this);
            }
            if (k.getNodeKey().equals(key)) {
                return this.dataKeys.length + i;
            }
            if (!this.persistent) continue;
            container.deactivate((Object)k, 5);
        }
        return -1;
    }

    public synchronized Integer[] getKeyNumbersAtRetryLevel(int retryCount) {
        int i;
        Vector<Integer> v = new Vector<Integer>();
        for (i = 0; i < this.dataRetries.length; ++i) {
            if (this.dataKeys[i] == null || this.dataRetries[i] != retryCount) continue;
            v.add(i);
        }
        for (i = 0; i < this.checkRetries.length; ++i) {
            if (this.checkKeys[i] == null || this.checkRetries[i] != retryCount) continue;
            v.add(i + this.dataKeys.length);
        }
        return v.toArray(new Integer[v.size()]);
    }

    public synchronized void resetCooldownTimes(Integer[] blockNums) {
        for (int i = 0; i < blockNums.length; ++i) {
            int blockNo = blockNums[i];
            if (blockNo < this.dataCooldownTimes.length) {
                this.dataCooldownTimes[blockNo] = -1L;
                continue;
            }
            this.checkCooldownTimes[blockNo - this.dataCooldownTimes.length] = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(Throwable t, ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished) {
                Logger.error(this, "FEC decode or encode failed but already finished: " + t, t);
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        this.fail(new FetchException(17, "FEC failure: " + t, t), container, context, false);
    }

    public boolean haveBlock(int blockNo, ObjectContainer container) {
        if (blockNo < this.dataBuckets.length) {
            boolean wasActive = false;
            if (this.dataBuckets[blockNo] == null) {
                return false;
            }
            if (this.persistent && !(wasActive = container.ext().isActive((Object)this.dataBuckets[blockNo]))) {
                container.activate((Object)this.dataBuckets[blockNo], 1);
            }
            boolean retval = this.dataBuckets[blockNo].hasData();
            if (this.persistent && !wasActive) {
                container.deactivate((Object)this.dataBuckets[blockNo], 1);
            }
            return retval;
        }
        boolean wasActive = false;
        if (this.checkBuckets[blockNo -= this.dataBuckets.length] == null) {
            return false;
        }
        if (this.persistent && !(wasActive = container.ext().isActive((Object)this.checkBuckets[blockNo]))) {
            container.activate((Object)this.checkBuckets[blockNo], 1);
        }
        boolean retval = this.checkBuckets[blockNo].hasData();
        if (this.persistent && !wasActive) {
            container.deactivate((Object)this.checkBuckets[blockNo], 1);
        }
        return retval;
    }

    public boolean dontCache(ObjectContainer container) {
        return !this.blockFetchContext.cacheLocalRequests;
    }

    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.priorityClass;
    }

    public SendableGet getRequest(Key key, ObjectContainer container) {
        int blockNum = this.getBlockNumber(key, container);
        if (blockNum < 0) {
            return null;
        }
        int retryCount = this.getBlockRetryCount(blockNum);
        return this.getSubSegment(retryCount, container, false, null);
    }

    public boolean isCancelled(ObjectContainer container) {
        return this.isFinishing(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key[] listKeys(ObjectContainer container) {
        Vector<Key> v = new Vector<Key>();
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            int i;
            for (i = 0; i < this.dataKeys.length; ++i) {
                if (this.dataKeys[i] == null) continue;
                if (this.persistent) {
                    container.activate((Object)this.dataKeys[i], 5);
                }
                v.add(this.dataKeys[i].getNodeKey());
            }
            for (i = 0; i < this.checkKeys.length; ++i) {
                if (this.checkKeys[i] == null) continue;
                if (this.persistent) {
                    container.activate((Object)this.checkKeys[i], 5);
                }
                v.add(this.checkKeys[i].getNodeKey());
            }
        }
        return v.toArray(new Key[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        SplitFileFetcherSubSegment seg;
        int blockNum;
        ClientCHKBlock cb = null;
        Bucket data = null;
        short onSuccessResult = -1;
        boolean killSeg = false;
        FetchException fatal = null;
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            if (this.finished || this.startedDecode || this.fetcherFinished) {
                return false;
            }
            blockNum = this.getBlockNumber(key, container);
            if (blockNum < 0) {
                return false;
            }
            if (logMINOR) {
                Logger.minor(this, "Found key for block " + blockNum + " on " + this + " in onGotKey() for " + key);
            }
            ClientCHK ckey = this.getBlockKey(blockNum, container);
            int retryCount = this.getBlockRetryCount(blockNum);
            seg = this.getSubSegment(retryCount, container, true, null);
            if (this.persistent) {
                container.activate((Object)seg, 1);
            }
            if (seg != null) {
                seg.removeBlockNum(blockNum, container, false);
                killSeg = seg.possiblyRemoveFromParent(container, context);
            }
            for (int i = 0; i < this.subSegments.size(); ++i) {
                SplitFileFetcherSubSegment checkSeg = this.subSegments.get(i);
                if (checkSeg == seg) continue;
                if (this.persistent) {
                    container.activate((Object)checkSeg, 1);
                }
                if (checkSeg.removeBlockNum(blockNum, container, false)) {
                    Logger.error(this, "Block number " + blockNum + " was registered to wrong subsegment " + checkSeg + " should be " + seg);
                }
                if (!this.persistent) continue;
                container.deactivate((Object)checkSeg, 1);
            }
            try {
                cb = new ClientCHKBlock((CHKBlock)block, ckey);
            }
            catch (CHKVerifyException e) {
                fatal = new FetchException(6, (Throwable)e);
            }
            if (cb != null) {
                data = this.extract(cb, blockNum, container, context);
                if (data == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Extract failed");
                    }
                    return false;
                }
                if (this.parent instanceof ClientGetter) {
                    ((ClientGetter)this.parent).addKeyToBinaryBlob(cb, container, context);
                }
                if (!cb.isMetadata()) {
                    onSuccessResult = this.onSuccessInner(data, blockNum, cb, container, context, seg);
                }
            }
        }
        if (killSeg) {
            seg.kill(container, context, true, true);
        }
        if (this.persistent) {
            container.deactivate((Object)seg, 1);
        }
        if (fatal != null) {
            this.onFatalFailure(fatal, blockNum, null, container, context);
            return false;
        }
        if (data == null) {
            return false;
        }
        if (!cb.isMetadata()) {
            if (onSuccessResult != -1) {
                this.finishOnSuccess(onSuccessResult, container, context);
            }
            return true;
        }
        this.onFatalFailure(new FetchException(4, "Metadata where expected data"), blockNum, null, container, context);
        return true;
    }

    private int getBlockRetryCount(int blockNum) {
        if (blockNum < this.dataRetries.length) {
            return this.dataRetries[blockNum];
        }
        return this.checkRetries[blockNum -= this.dataRetries.length];
    }

    protected Bucket extract(ClientKeyBlock block, int blockNum, ObjectContainer container, ClientContext context) {
        Bucket data;
        try {
            data = block.decode(context.getBucketFactory(this.persistent), (int)Math.min(this.blockFetchContext.maxOutputLength, Integer.MAX_VALUE), false);
        }
        catch (KeyDecodeException e1) {
            if (logMINOR) {
                Logger.minor(this, "Decode failure: " + e1, (Throwable)e1);
            }
            this.onFatalFailure(new FetchException(6, e1.getMessage()), blockNum, null, container, context);
            return null;
        }
        catch (TooBigException e) {
            this.onFatalFailure(new FetchException(21, e.getMessage()), blockNum, null, container, context);
            return null;
        }
        catch (IOException e) {
            Logger.error(this, "Could not capture data - disk full?: " + e, e);
            this.onFatalFailure(new FetchException(12, (Throwable)e), blockNum, null, container, context);
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, data == null ? "Could not decode: null" : "Decoded " + data.size() + " bytes");
        }
        return data;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public void deactivateKeys(ObjectContainer container) {
        int i;
        for (i = 0; i < this.dataKeys.length; ++i) {
            container.deactivate((Object)this.dataKeys[i], 1);
        }
        for (i = 0; i < this.checkKeys.length; ++i) {
            container.deactivate((Object)this.checkKeys[i], 1);
        }
    }

    public SplitFileFetcherSubSegment getSubSegmentFor(int blockNum, ObjectContainer container) {
        return this.getSubSegment(this.getBlockRetryCount(blockNum), container, false, null);
    }

    public void freeDecodedData(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.decodedData, 1);
        }
        this.decodedData.free();
        if (this.persistent) {
            this.decodedData.removeFrom(container);
        }
        this.decodedData = null;
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        MinimalSplitfileBlock block;
        int i;
        if (logMINOR) {
            Logger.minor(this, "removing " + this);
        }
        if (this.decodedData != null) {
            this.freeDecodedData(container);
        }
        this.removeSubSegments(container, context, true);
        container.delete(this.subSegments);
        for (i = 0; i < this.dataKeys.length; ++i) {
            if (this.dataKeys[i] != null) {
                this.dataKeys[i].removeFrom(container);
            }
            this.dataKeys[i] = null;
        }
        for (i = 0; i < this.checkKeys.length; ++i) {
            if (this.checkKeys[i] != null) {
                this.checkKeys[i].removeFrom(container);
            }
            this.checkKeys[i] = null;
        }
        for (i = 0; i < this.dataBuckets.length; ++i) {
            block = this.dataBuckets[i];
            if (block == null) continue;
            if (block.data != null) {
                Logger.error(this, "Data block " + i + " still present in removeFrom()! on " + this);
                block.data.free();
            }
            block.removeFrom(container);
        }
        for (i = 0; i < this.checkBuckets.length; ++i) {
            block = this.checkBuckets[i];
            if (block == null) continue;
            if (block.data != null) {
                Logger.error(this, "Check block " + i + " still present in removeFrom()! on " + this);
                block.data.free();
            }
            block.removeFrom(container);
        }
        container.activate((Object)this.errors, 1);
        this.errors.removeFrom(container);
        if (this.failureException != null) {
            container.activate((Object)this.failureException, 5);
            this.failureException.removeFrom(container);
        }
        container.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetcherFinished(ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            this.fetcherFinished = true;
            if (!this.encoderFinished) {
                if (!this.startedDecode) {
                    this.encoderFinished = true;
                    container.store((Object)this);
                } else {
                    container.store((Object)this);
                    if (logMINOR) {
                        Logger.minor(this, "Fetcher finished but encoder not finished on " + this);
                    }
                    return;
                }
            }
        }
        this.removeFrom(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encoderFinished(ObjectContainer container, ClientContext context) {
        SplitFileFetcherSegment splitFileFetcherSegment = this;
        synchronized (splitFileFetcherSegment) {
            this.encoderFinished = true;
            if (!this.fetcherFinished) {
                container.store((Object)this);
                if (logMINOR) {
                    Logger.minor(this, "Encoder finished but fetcher not finished on " + this);
                }
                return;
            }
        }
        this.removeFrom(container, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

