/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.client.async.SplitFileFetcherSubSegment;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.node.PrioRunnable;
import freenet.node.SendableGet;
import freenet.support.BinaryBloomFilter;
import freenet.support.CountingBloomFilter;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;

public class SplitFileFetcherKeyListener
implements KeyListener {
    private final SplitFileFetcher fetcher;
    private final boolean persistent;
    private int keyCount;
    private final byte[] filterBuffer;
    private final CountingBloomFilter filter;
    private final byte[] segmentsFilterBuffer;
    private final BinaryBloomFilter[] segmentFilters;
    private final File mainBloomFile;
    private final File altBloomFile;
    private static final int WRITE_DELAY = 60000;
    private final boolean dontCache;
    private short prio;
    private final byte[] localSalt;
    private boolean killed;
    private boolean writingBloomFilter;

    public SplitFileFetcherKeyListener(SplitFileFetcher parent, int keyCount, File bloomFile, File altBloomFile, int mainBloomSizeBytes, int mainBloomK, boolean dontCache, byte[] localSalt, int segments, int segmentFilterSizeBytes, int segmentBloomK, boolean persistent, boolean newFilter) throws IOException {
        this.fetcher = parent;
        this.persistent = persistent;
        this.keyCount = keyCount;
        this.mainBloomFile = bloomFile;
        this.altBloomFile = altBloomFile;
        this.dontCache = dontCache;
        assert (localSalt.length == 32);
        if (persistent) {
            this.localSalt = new byte[32];
            System.arraycopy(localSalt, 0, this.localSalt, 0, 32);
        } else {
            this.localSalt = localSalt;
        }
        this.segmentsFilterBuffer = new byte[segmentFilterSizeBytes * segments];
        ByteBuffer baseBuffer = ByteBuffer.wrap(this.segmentsFilterBuffer);
        this.segmentFilters = new BinaryBloomFilter[segments];
        int start = 0;
        int end = segmentFilterSizeBytes;
        for (int i = 0; i < segments; ++i) {
            baseBuffer.position(start);
            baseBuffer.limit(end);
            ByteBuffer slice = baseBuffer.slice();
            this.segmentFilters[i] = new BinaryBloomFilter(slice, segmentFilterSizeBytes * 8, segmentBloomK);
            start += segmentFilterSizeBytes;
            end += segmentFilterSizeBytes;
        }
        this.filterBuffer = new byte[mainBloomSizeBytes];
        if (newFilter) {
            this.filter = new CountingBloomFilter(mainBloomSizeBytes * 8 / 2, mainBloomK, this.filterBuffer);
            this.filter.setWarnOnRemoveFromEmpty();
        } else {
            FileInputStream fis = new FileInputStream(bloomFile);
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(this.filterBuffer);
            dis.close();
            this.filter = new CountingBloomFilter(mainBloomSizeBytes * 8 / 2, mainBloomK, this.filterBuffer);
            this.filter.setWarnOnRemoveFromEmpty();
            fis = new FileInputStream(altBloomFile);
            dis = new DataInputStream(fis);
            dis.readFully(this.segmentsFilterBuffer);
            dis.close();
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Created " + this + " for " + this.fetcher);
        }
    }

    public long countKeys() {
        return this.keyCount;
    }

    void addKey(Key key, int segNo, ClientContext context) {
        byte[] saltedKey = context.getChkFetchScheduler().saltKey(key);
        this.filter.addKey(saltedKey);
        byte[] localSalted = this.localSaltKey(key);
        this.segmentFilters[segNo].addKey(localSalted);
    }

    private byte[] localSaltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.localSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.filter == null) {
            Logger.error(this, "Probably want key: filter = null for " + this + " fetcher = " + this.fetcher);
        }
        return this.filter.checkFilter(saltedKey);
    }

    public short definitelyWantKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        byte[] salted = this.localSaltKey(key);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            boolean found;
            if (!this.segmentFilters[i].checkFilter(salted)) continue;
            if (this.persistent) {
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.error(this, "ALREADY ACTIVE in definitelyWantKey(): " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                container.deactivate((Object)this.fetcher, 1);
            }
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.error(this, "ALREADY ACTIVE in definitelyWantKey(): " + segment);
                }
                container.activate((Object)segment, 1);
            }
            boolean bl = found = segment.getBlockNumber(key, container) >= 0;
            if (!found) {
                Logger.error(this, "Found block in primary and segment bloom filters but segment doesn't want it: " + segment + " on " + this);
            }
            if (this.persistent) {
                container.deactivate((Object)segment, 1);
            }
            if (!found) continue;
            return this.prio;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock block, ObjectContainer container, ClientContext context) {
        boolean found = false;
        byte[] salted = this.localSaltKey(key);
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "handleBlock(" + key + ") on " + this + " for " + this.fetcher);
        }
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            boolean match;
            SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
            synchronized (splitFileFetcherKeyListener) {
                match = this.segmentFilters[i].checkFilter(salted);
            }
            if (!match) continue;
            if (this.persistent) {
                if (!container.ext().isStored((Object)this.fetcher)) {
                    Logger.error(this, "Fetcher not in database! for " + this);
                    return false;
                }
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.error(this, "ALREADY ACTIVATED: " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.error(this, "ALREADY ACTIVATED: " + segment);
                }
                container.activate((Object)segment, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Key " + key + " may be in segment " + segment);
            }
            if (segment.onGotKey(key, block, container, context)) {
                SplitFileFetcherKeyListener splitFileFetcherKeyListener2 = this;
                synchronized (splitFileFetcherKeyListener2) {
                    if (this.filter.checkFilter(saltedKey)) {
                        this.filter.removeKey(saltedKey);
                        --this.keyCount;
                    } else {
                        Logger.error(this, "Not removing key from splitfile filter because already removed!: " + key + " for " + this, new Exception("debug"));
                    }
                }
                this.fetcher.setKeyCount(this.keyCount, container);
                found = true;
            }
            if (this.persistent) {
                container.deactivate((Object)segment, 1);
            }
            if (!this.persistent) continue;
            container.deactivate((Object)this.fetcher, 1);
        }
        return found;
    }

    public boolean dontCache() {
        return this.dontCache;
    }

    public HasKeyListener getHasKeyListener() {
        return this.fetcher;
    }

    public short getPriorityClass(ObjectContainer container) {
        return this.prio;
    }

    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        ArrayList<SplitFileFetcherSubSegment> ret = new ArrayList<SplitFileFetcherSubSegment>();
        byte[] salted = this.localSaltKey(key);
        for (int i = 0; i < this.segmentFilters.length; ++i) {
            int blockNum;
            if (!this.segmentFilters[i].checkFilter(salted)) continue;
            if (this.persistent) {
                if (container.ext().isActive((Object)this.fetcher)) {
                    Logger.error(this, "ALREADY ACTIVATED in getRequestsForKey: " + this.fetcher);
                }
                container.activate((Object)this.fetcher, 1);
            }
            SplitFileFetcherSegment segment = this.fetcher.getSegment(i);
            if (this.persistent) {
                container.deactivate((Object)this.fetcher, 1);
            }
            if (this.persistent) {
                if (container.ext().isActive((Object)segment)) {
                    Logger.error(this, "ALREADY ACTIVATED in getRequestsForKey: " + segment);
                }
                container.activate((Object)segment, 1);
            }
            if ((blockNum = segment.getBlockNumber(key, container)) >= 0) {
                ret.add(segment.getSubSegmentFor(blockNum, container));
            }
            if (!this.persistent) continue;
            container.deactivate((Object)segment, 1);
        }
        return ret.toArray(new SendableGet[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove() {
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            this.killed = true;
        }
        if (this.persistent) {
            this.mainBloomFile.delete();
            this.altBloomFile.delete();
        }
    }

    public boolean persistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFilters() throws IOException {
        if (!this.persistent) {
            return;
        }
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            if (this.killed) {
                return;
            }
        }
        RandomAccessFile raf = new RandomAccessFile(this.mainBloomFile, "rw");
        raf.write(this.filterBuffer);
        raf.close();
        raf = new RandomAccessFile(this.altBloomFile, "rw");
        raf.write(this.segmentsFilterBuffer);
        raf.close();
    }

    public synchronized int killSegment(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        int segNo = segment.segNum;
        this.segmentFilters[segNo].unsetAll();
        Key[] removeKeys = segment.listKeys(container);
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Removing segment from bloom filter: " + segment + " keys: " + removeKeys.length);
        }
        for (int i = 0; i < removeKeys.length; ++i) {
            byte[] salted;
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Removing key from bloom filter: " + removeKeys[i]);
            }
            if (this.filter.checkFilter(salted = context.getChkFetchScheduler().saltKey(removeKeys[i]))) {
                this.filter.removeKey(salted);
                continue;
            }
            Logger.error(this, "Removing key " + removeKeys[i] + " for " + this + " from " + segment + " : NOT IN BLOOM FILTER!", new Exception("debug"));
        }
        this.scheduleWriteFilters(context);
        return this.keyCount -= removeKeys.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleWriteFilters(ClientContext context) {
        SplitFileFetcherKeyListener splitFileFetcherKeyListener = this;
        synchronized (splitFileFetcherKeyListener) {
            if (this.writingBloomFilter) {
                return;
            }
            this.writingBloomFilter = true;
            try {
                context.ticker.queueTimedJob(new PrioRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        SplitFileFetcherKeyListener splitFileFetcherKeyListener = SplitFileFetcherKeyListener.this;
                        synchronized (splitFileFetcherKeyListener) {
                            block6: {
                                try {
                                    try {
                                        SplitFileFetcherKeyListener.this.writeFilters();
                                    }
                                    catch (IOException e) {
                                        Logger.error(this, "Failed to write bloom filters, we will have more false positives on already-found blocks which aren't in the store: " + e, e);
                                        Object var4_3 = null;
                                        SplitFileFetcherKeyListener.this.writingBloomFilter = true;
                                        break block6;
                                    }
                                    Object var4_2 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    SplitFileFetcherKeyListener.this.writingBloomFilter = true;
                                    throw throwable;
                                }
                                SplitFileFetcherKeyListener.this.writingBloomFilter = true;
                            }
                            return;
                        }
                    }

                    public int getPriority() {
                        return 7;
                    }
                }, 60000L);
            }
            catch (Throwable t) {
                this.writingBloomFilter = false;
            }
        }
    }

    public boolean isEmpty() {
        return this.killed;
    }

    public boolean isSSK() {
        return false;
    }

    public void objectOnDeactivate(ObjectContainer container) {
        Logger.error(this, "Deactivating a SplitFileFetcherKeyListener: " + this, new Exception("error"));
    }
}

