/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SplitFileFetcherKeyListener;
import freenet.client.async.SplitFileFetcherSegment;
import freenet.keys.ClientCHK;
import freenet.node.SendableGet;
import freenet.support.BloomFilter;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.api.Bucket;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SplitFileFetcher
implements ClientGetState,
HasKeyListener {
    private static volatile boolean logMINOR;
    final FetchContext fetchContext;
    final FetchContext blockFetchContext;
    final boolean deleteFetchContext;
    final ArchiveContext archiveContext;
    final List decompressors;
    final ClientMetadata clientMetadata;
    final ClientRequester parent;
    final GetCompletionCallback cb;
    final int recursionLevel;
    final short splitfileType;
    final int blocksPerSegment;
    final int checkBlocksPerSegment;
    final int segmentCount;
    final SplitFileFetcherSegment[] segments;
    final long maxTempLength;
    private boolean allSegmentsFinished;
    private final long overrideLength;
    private final Bucket returnBucket;
    private boolean finished;
    private long token;
    final boolean persistent;
    private FetchException otherFailure;
    private final int hashCode;
    File mainBloomFile;
    File altBloomFile;
    final int mainBloomFilterSizeBytes;
    static final int DEFAULT_MAIN_BLOOM_ELEMENTS_PER_KEY = 19;
    final int mainBloomK;
    static final double ACCEPTABLE_BLOOM_FALSE_POSITIVES_ALL_SEGMENTS = 0.01;
    final int perSegmentBloomFilterSizeBytes;
    final int perSegmentK;
    private int keyCount;
    private final byte[] localSalt;
    private transient SplitFileFetcherKeyListener tempListener;

    public int hashCode() {
        return this.hashCode;
    }

    public SplitFileFetcher(Metadata metadata, GetCompletionCallback rcb, ClientRequester parent2, FetchContext newCtx, boolean deleteFetchContext, List decompressors2, ClientMetadata clientMetadata, ArchiveContext actx, int recursionLevel, Bucket returnBucket, long token2, ObjectContainer container, ClientContext context) throws FetchException, MetadataParseException {
        int perSegmentSize;
        int i;
        int hash;
        this.persistent = parent2.persistent();
        this.deleteFetchContext = deleteFetchContext;
        if (logMINOR) {
            Logger.minor(this, "Persistence = " + this.persistent + " from " + parent2, (Throwable)new Exception("debug"));
        }
        if ((hash = super.hashCode()) == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.finished = false;
        this.returnBucket = returnBucket;
        this.fetchContext = newCtx;
        if (newCtx == null) {
            throw new NullPointerException();
        }
        this.archiveContext = actx;
        List list = this.decompressors = this.persistent ? new ArrayList(decompressors2) : decompressors2;
        if (this.decompressors.size() > 1) {
            Logger.error(this, "Multiple decompressors: " + this.decompressors.size() + " - this is almost certainly a bug", new Exception("debug"));
        }
        this.clientMetadata = clientMetadata == null ? new ClientMetadata() : clientMetadata.clone();
        this.cb = rcb;
        this.recursionLevel = recursionLevel + 1;
        this.parent = parent2;
        this.localSalt = new byte[32];
        context.random.nextBytes(this.localSalt);
        if (parent2.isCancelled()) {
            throw new FetchException(25);
        }
        this.overrideLength = metadata.dataLength();
        this.splitfileType = metadata.getSplitfileType();
        ClientCHK[] splitfileDataBlocks = metadata.getSplitfileDataKeys();
        ClientCHK[] splitfileCheckBlocks = metadata.getSplitfileCheckKeys();
        if (this.persistent) {
            metadata.clearSplitfileKeys();
            container.store((Object)metadata);
        }
        for (i = 0; i < splitfileDataBlocks.length; ++i) {
            if (splitfileDataBlocks[i] != null) continue;
            throw new MetadataParseException("Null: data block " + i + " of " + splitfileDataBlocks.length);
        }
        for (i = 0; i < splitfileCheckBlocks.length; ++i) {
            if (splitfileCheckBlocks[i] != null) continue;
            throw new MetadataParseException("Null: check block " + i + " of " + splitfileCheckBlocks.length);
        }
        long finalLength = 1L * (long)splitfileDataBlocks.length * 32768L;
        if (finalLength > this.overrideLength) {
            if (finalLength - this.overrideLength > 32768L) {
                throw new FetchException(4, "Splitfile is " + finalLength + " but length is " + finalLength);
            }
            finalLength = this.overrideLength;
        }
        long eventualLength = Math.max(this.overrideLength, metadata.uncompressedDataLength());
        boolean wasActive = true;
        if (this.persistent && !(wasActive = container.ext().isActive((Object)this.cb))) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onExpectedSize(eventualLength, container, context);
        String mimeType = metadata.getMIMEType();
        if (mimeType != null) {
            this.cb.onExpectedMIME(mimeType, container, context);
        }
        if (metadata.uncompressedDataLength() > 0L) {
            this.cb.onFinalizedMetadata(container);
        }
        if (!wasActive) {
            container.deactivate((Object)this.cb, 1);
        }
        if (eventualLength > 0L && newCtx.maxOutputLength > 0L && eventualLength > newCtx.maxOutputLength) {
            throw new FetchException(21, eventualLength, true, clientMetadata.getMIMEType());
        }
        this.token = token2;
        if (this.splitfileType == 0) {
            this.blocksPerSegment = -1;
            this.checkBlocksPerSegment = -1;
            this.segmentCount = 1;
            if (splitfileCheckBlocks.length > 0) {
                Logger.error(this, "Splitfile type is SPLITFILE_NONREDUNDANT yet " + splitfileCheckBlocks.length + " check blocks found!! : " + this);
                throw new FetchException(4, "Splitfile type is non-redundant yet have " + splitfileCheckBlocks.length + " check blocks");
            }
        } else if (this.splitfileType == 1) {
            byte[] params = metadata.splitfileParams();
            if (params == null || params.length < 8) {
                throw new MetadataParseException("No splitfile params");
            }
            this.blocksPerSegment = Fields.bytesToInt(params, 0);
            int checkBlocks = Fields.bytesToInt(params, 4);
            if (checkBlocks == 64 && this.blocksPerSegment == 128 && splitfileCheckBlocks.length == splitfileDataBlocks.length - splitfileDataBlocks.length / 128) {
                Logger.normal(this, "Activating 1135 wrong check blocks per segment workaround for " + this);
                checkBlocks = 127;
            }
            this.checkBlocksPerSegment = checkBlocks;
            if (this.blocksPerSegment > this.fetchContext.maxDataBlocksPerSegment || this.checkBlocksPerSegment > this.fetchContext.maxCheckBlocksPerSegment) {
                throw new FetchException(23, "Too many blocks per segment: " + this.blocksPerSegment + " data, " + this.checkBlocksPerSegment + " check");
            }
            this.segmentCount = splitfileDataBlocks.length / this.blocksPerSegment + (splitfileDataBlocks.length % this.blocksPerSegment == 0 ? 0 : 1);
        } else {
            throw new MetadataParseException("Unknown splitfile format: " + this.splitfileType);
        }
        this.maxTempLength = this.fetchContext.maxTempLength;
        if (logMINOR) {
            Logger.minor(this, "Algorithm: " + this.splitfileType + ", blocks per segment: " + this.blocksPerSegment + ", check blocks per segment: " + this.checkBlocksPerSegment + ", segments: " + this.segmentCount + ", data blocks: " + splitfileDataBlocks.length + ", check blocks: " + splitfileCheckBlocks.length);
        }
        this.segments = new SplitFileFetcherSegment[this.segmentCount];
        if (this.persistent) {
            try {
                this.mainBloomFile = context.persistentFG.makeRandomFile();
                this.altBloomFile = context.persistentFG.makeRandomFile();
            }
            catch (IOException e) {
                throw new FetchException(12, "Unable to create Bloom filter files", e);
            }
        } else {
            this.mainBloomFile = null;
            this.altBloomFile = null;
        }
        int mainElementsPerKey = 19;
        int origSize = splitfileDataBlocks.length + splitfileCheckBlocks.length;
        this.mainBloomK = (int)((double)mainElementsPerKey * 0.7);
        long elementsLong = origSize * mainElementsPerKey;
        if (elementsLong > Integer.MAX_VALUE) {
            throw new FetchException(21, "Cannot fetch splitfiles with more than " + Integer.MAX_VALUE / mainElementsPerKey + " keys! (approx 3.3TB)");
        }
        int mainSizeBits = (int)elementsLong;
        if ((mainSizeBits & 7) != 0) {
            mainSizeBits += 8 - (mainSizeBits & 7);
        }
        this.mainBloomFilterSizeBytes = mainSizeBits / 8 * 2;
        double acceptableFalsePositives = 0.01 / (double)this.segments.length;
        int perSegmentBitsPerKey = (int)Math.ceil(Math.log(acceptableFalsePositives) / Math.log(0.6185));
        int segBlocks = this.blocksPerSegment + this.checkBlocksPerSegment;
        if (segBlocks > origSize) {
            segBlocks = origSize;
        }
        if (((perSegmentSize = perSegmentBitsPerKey * segBlocks) & 7) != 0) {
            perSegmentSize += 8 - (perSegmentSize & 7);
        }
        this.perSegmentBloomFilterSizeBytes = perSegmentSize / 8;
        this.perSegmentK = BloomFilter.optimialK(perSegmentSize, segBlocks);
        this.keyCount = origSize;
        if (logMINOR) {
            Logger.minor(this, "Creating block filter for " + this + ": keys=" + (splitfileDataBlocks.length + splitfileCheckBlocks.length) + " main bloom size " + this.mainBloomFilterSizeBytes + " bytes, K=" + this.mainBloomK + ", filename=" + this.mainBloomFile + " alt bloom filter: filename=" + this.altBloomFile + " segments: " + this.segments.length + " each is " + this.perSegmentBloomFilterSizeBytes + " bytes k=" + this.perSegmentK);
        }
        try {
            this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, this.mainBloomFile, this.altBloomFile, this.mainBloomFilterSizeBytes, this.mainBloomK, !this.fetchContext.cacheLocalRequests, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, true);
        }
        catch (IOException e) {
            throw new FetchException(12, "Unable to write Bloom filters for splitfile");
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        this.blockFetchContext = new FetchContext(this.fetchContext, 1, true, null);
        if (this.segmentCount == 1) {
            int i2;
            ClientCHK[] newSplitfileDataBlocks = new ClientCHK[splitfileDataBlocks.length];
            ClientCHK[] newSplitfileCheckBlocks = new ClientCHK[splitfileCheckBlocks.length];
            System.arraycopy(splitfileDataBlocks, 0, newSplitfileDataBlocks, 0, splitfileDataBlocks.length);
            if (splitfileCheckBlocks.length > 0) {
                System.arraycopy(splitfileCheckBlocks, 0, newSplitfileCheckBlocks, 0, splitfileCheckBlocks.length);
            }
            this.segments[0] = new SplitFileFetcherSegment(this.splitfileType, newSplitfileDataBlocks, newSplitfileCheckBlocks, this, this.archiveContext, this.blockFetchContext, this.maxTempLength, recursionLevel, this.parent, 0, true);
            for (i2 = 0; i2 < newSplitfileDataBlocks.length; ++i2) {
                if (logMINOR) {
                    Logger.minor(this, "Added data block " + i2 + " : " + newSplitfileDataBlocks[i2].getNodeKey());
                }
                this.tempListener.addKey(newSplitfileDataBlocks[i2].getNodeKey(), 0, context);
            }
            for (i2 = 0; i2 < newSplitfileCheckBlocks.length; ++i2) {
                if (logMINOR) {
                    Logger.minor(this, "Added check block " + i2 + " : " + newSplitfileCheckBlocks[i2].getNodeKey());
                }
                this.tempListener.addKey(newSplitfileCheckBlocks[i2].getNodeKey(), 0, context);
            }
            if (this.persistent) {
                container.store((Object)this.segments[0]);
                this.segments[0].deactivateKeys(container);
                container.deactivate((Object)this.segments[0], 1);
            }
        } else {
            int dataBlocksPtr = 0;
            int checkBlocksPtr = 0;
            for (int i3 = 0; i3 < this.segments.length; ++i3) {
                int j;
                int copyDataBlocks = Math.min(splitfileDataBlocks.length - dataBlocksPtr, this.blocksPerSegment);
                int copyCheckBlocks = Math.min(splitfileCheckBlocks.length - checkBlocksPtr, this.checkBlocksPerSegment);
                ClientCHK[] dataBlocks = new ClientCHK[copyDataBlocks];
                ClientCHK[] checkBlocks = new ClientCHK[copyCheckBlocks];
                if (copyDataBlocks > 0) {
                    System.arraycopy(splitfileDataBlocks, dataBlocksPtr, dataBlocks, 0, copyDataBlocks);
                }
                if (copyCheckBlocks > 0) {
                    System.arraycopy(splitfileCheckBlocks, checkBlocksPtr, checkBlocks, 0, copyCheckBlocks);
                }
                this.segments[i3] = new SplitFileFetcherSegment(this.splitfileType, dataBlocks, checkBlocks, this, this.archiveContext, this.blockFetchContext, this.maxTempLength, recursionLevel + 1, this.parent, i3, i3 == this.segments.length - 1);
                for (j = 0; j < dataBlocks.length; ++j) {
                    this.tempListener.addKey(dataBlocks[j].getNodeKey(), i3, context);
                }
                for (j = 0; j < checkBlocks.length; ++j) {
                    this.tempListener.addKey(checkBlocks[j].getNodeKey(), i3, context);
                }
                if (this.persistent) {
                    int x;
                    container.store((Object)this.segments[i3]);
                    this.segments[i3].deactivateKeys(container);
                    container.deactivate((Object)this.segments[i3], 1);
                    for (x = dataBlocksPtr; x < dataBlocksPtr + copyDataBlocks; ++x) {
                        splitfileDataBlocks[x] = null;
                    }
                    for (x = checkBlocksPtr; x < checkBlocksPtr + copyCheckBlocks; ++x) {
                        splitfileCheckBlocks[x] = null;
                    }
                }
                dataBlocksPtr += copyDataBlocks;
                checkBlocksPtr += copyCheckBlocks;
            }
            if (dataBlocksPtr != splitfileDataBlocks.length) {
                throw new FetchException(4, "Unable to allocate all data blocks to segments - buggy or malicious inserter");
            }
            if (checkBlocksPtr != splitfileCheckBlocks.length) {
                throw new FetchException(4, "Unable to allocate all check blocks to segments - buggy or malicious inserter");
            }
        }
        this.parent.addBlocks(splitfileDataBlocks.length + splitfileCheckBlocks.length, container);
        this.parent.addMustSucceedBlocks(splitfileDataBlocks.length, container);
        this.parent.notifyClients(container, context);
        try {
            this.tempListener.writeFilters();
        }
        catch (IOException e) {
            throw new FetchException(12, "Unable to write Bloom filters for splitfile");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bucket finalStatus(ObjectContainer container, ClientContext context) throws FetchException {
        Bucket output;
        long finalLength;
        block15: {
            finalLength = 0L;
            for (int i = 0; i < this.segments.length; ++i) {
                SplitFileFetcherSegment s = this.segments[i];
                if (this.persistent) {
                    container.activate((Object)s, 1);
                }
                if (!s.succeeded()) {
                    throw new IllegalStateException("Not all finished");
                }
                s.throwError(container);
                long sz = s.decodedLength(container);
                finalLength += sz;
                if (!logMINOR) continue;
                Logger.minor(this, "Segment " + i + " decoded length " + sz + " total length now " + finalLength + " for " + s.dataBuckets.length + " blocks which should be " + s.dataBuckets.length * 32768);
            }
            if (finalLength > this.overrideLength) {
                if (finalLength - this.overrideLength > 32768L) {
                    throw new FetchException(4, "Splitfile is " + finalLength + " but length is " + finalLength);
                }
                finalLength = this.overrideLength;
            }
            long bytesWritten = 0L;
            OutputStream os = null;
            if (this.persistent) {
                container.activate((Object)this.decompressors, 5);
                if (this.returnBucket != null) {
                    container.activate((Object)this.returnBucket, 5);
                }
            }
            try {
                try {
                    long max;
                    SplitFileFetcherSegment s;
                    output = this.returnBucket != null && this.decompressors.isEmpty() ? this.returnBucket : context.getBucketFactory(this.parent.persistent()).makeBucket(finalLength);
                    os = output.getOutputStream();
                    for (int i = 0; i < this.segments.length; bytesWritten += s.writeDecodedDataTo(os, max), ++i) {
                        s = this.segments[i];
                        max = finalLength < 0L ? 0L : finalLength - bytesWritten;
                        s.freeDecodedData(container);
                    }
                    Object var14_14 = null;
                    if (os == null) break block15;
                }
                catch (IOException e) {
                    throw new FetchException(12, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FetchException(12, (Throwable)e);
                }
            }
            try {}
            catch (IOException e) {
                throw new FetchException(12, (Throwable)e);
            }
            os.close();
        }
        if (finalLength == output.size()) return output;
        Logger.error(this, "Final length is supposed to be " + finalLength + " but only written " + output.size());
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentFinished(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Finished segment: " + segment);
        }
        boolean finish = false;
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            int i;
            boolean allDone = true;
            for (i = 0; i < this.segments.length; ++i) {
                if (this.persistent) {
                    container.activate((Object)this.segments[i], 1);
                }
                if (this.segments[i].succeeded()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Segment " + this.segments[i] + " is not finished");
                }
                allDone = false;
            }
            if (allDone) {
                if (this.allSegmentsFinished) {
                    Logger.error(this, "Was already finished! (segmentFinished(" + segment + ')', new Exception("debug"));
                } else {
                    this.allSegmentsFinished = true;
                    finish = true;
                }
            } else {
                for (i = 0; i < this.segments.length; ++i) {
                    if (this.segments[i] == segment || !this.persistent) continue;
                    container.deactivate((Object)this.segments[i], 1);
                }
            }
            this.notifyAll();
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (finish) {
            this.finish(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        context.getChkFetchScheduler().removePendingKeys(this, true);
        boolean cbWasActive = true;
        try {
            SplitFileFetcher splitFileFetcher = this;
            synchronized (splitFileFetcher) {
                if (this.otherFailure != null) {
                    throw this.otherFailure;
                }
                if (this.finished) {
                    Logger.error(this, "Was already finished");
                    return;
                }
                this.finished = true;
            }
            context.jobRunner.setCommitThisTransaction();
            if (this.persistent) {
                container.store((Object)this);
            }
            Bucket data = this.finalStatus(container, context);
            if (this.persistent) {
                container.activate((Object)this.decompressors, 5);
                container.activate((Object)this.returnBucket, 5);
                cbWasActive = container.ext().isActive((Object)this.cb);
                if (!cbWasActive) {
                    container.activate((Object)this.cb, 1);
                }
                container.activate((Object)this.fetchContext, 1);
                if (this.fetchContext == null) {
                    Logger.error(this, "Fetch context is null");
                    if (!container.ext().isActive((Object)this.fetchContext)) {
                        Logger.error(this, "Fetch context is null and splitfile is not activated", new Exception("error"));
                        container.activate((Object)this, 1);
                        container.activate((Object)this.decompressors, 5);
                        container.activate((Object)this.returnBucket, 5);
                        container.activate((Object)this.fetchContext, 1);
                    } else {
                        Logger.error(this, "Fetch context is null and splitfile IS activated", new Exception("error"));
                    }
                }
                container.activate((Object)this.fetchContext, 1);
            }
            int count = 0;
            while (!this.decompressors.isEmpty()) {
                Object var12_16;
                Compressor c = (Compressor)this.decompressors.remove(this.decompressors.size() - 1);
                if (logMINOR) {
                    Logger.minor(this, "Decompressing with " + c);
                }
                long maxLen = Math.max(this.fetchContext.maxTempLength, this.fetchContext.maxOutputLength);
                Bucket orig = data;
                try {
                    try {
                        Bucket out = this.returnBucket;
                        if (!this.decompressors.isEmpty()) {
                            out = null;
                        }
                        data = c.decompress(data, context.getBucketFactory(this.parent.persistent()), maxLen, maxLen * 4L, out);
                    }
                    catch (IOException e) {
                        if (e.getMessage().equals("Not in GZIP format") && count == 1) {
                            Logger.error(this, "Attempting to decompress twice, failed, returning first round data: " + this);
                            var12_16 = null;
                            if (orig == data) break;
                            orig.free();
                            if (!this.persistent) break;
                            orig.removeFrom(container);
                            break;
                        }
                        this.cb.onFailure(new FetchException(12, (Throwable)e), this, container, context);
                        var12_16 = null;
                        if (orig != data) {
                            orig.free();
                            if (this.persistent) {
                                orig.removeFrom(container);
                            }
                        }
                        return;
                    }
                    catch (CompressionOutputSizeException e) {
                        if (logMINOR) {
                            Logger.minor(this, "Too big: maxSize = " + this.fetchContext.maxOutputLength + " maxTempSize = " + this.fetchContext.maxTempLength);
                        }
                        this.cb.onFailure(new FetchException(21, e.estimatedSize, false, this.clientMetadata.getMIMEType()), this, container, context);
                        var12_16 = null;
                        if (orig != data) {
                            orig.free();
                            if (this.persistent) {
                                orig.removeFrom(container);
                            }
                        }
                        return;
                    }
                    var12_16 = null;
                    if (orig != data) {
                        orig.free();
                        if (this.persistent) {
                            orig.removeFrom(container);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var12_16 = null;
                    if (orig != data) {
                        orig.free();
                        if (this.persistent) {
                            orig.removeFrom(container);
                        }
                    }
                    throw throwable;
                }
                ++count;
            }
            this.cb.onSuccess(new FetchResult(this.clientMetadata, data), this, container, context);
        }
        catch (FetchException e) {
            this.cb.onFailure(e, this, container, context);
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
            System.err.println("Failing above attempted fetch...");
            this.cb.onFailure(new FetchException(17, (Throwable)e), this, container, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new FetchException(17, t), this, container, context);
        }
        if (!cbWasActive) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    public void schedule(ObjectContainer container, ClientContext context) throws KeyListenerConstructionException {
        if (this.persistent) {
            container.activate((Object)this, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Scheduling " + this);
        }
        SendableGet[] getters = new SendableGet[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            if (logMINOR) {
                Logger.minor(this, "Scheduling segment " + i + " : " + this.segments[i]);
            }
            if (this.persistent) {
                container.activate((Object)this.segments[i], 1);
            }
            getters[i] = this.segments[i].schedule(container, context);
            if (!this.persistent) continue;
            container.deactivate((Object)this.segments[i], 1);
        }
        BlockSet blocks = this.fetchContext.blocks;
        context.getChkFetchScheduler().register(this, getters, this.persistent, container, blocks, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        boolean persist = this.persistent;
        if (persist) {
            container.activate((Object)this, 1);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling segment " + i);
            }
            if (this.segments == null && persist && !container.ext().isActive((Object)this)) {
                Logger.error(this, "Deactivated mid-cancel on " + this, new Exception("error"));
                container.activate((Object)this, 1);
            }
            if (this.segments[i] == null) {
                SplitFileFetcher splitFileFetcher = this;
                synchronized (splitFileFetcher) {
                    if (this.finished) {
                        if (logMINOR) {
                            Logger.minor(this, "Finished mid-cancel on " + this);
                        }
                        return;
                    }
                }
            }
            if (persist) {
                container.activate((Object)this.segments[i], 1);
            }
            this.segments[i].cancel(container, context);
        }
    }

    public long getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyListener makeKeyListener(ObjectContainer container, ClientContext context) throws KeyListenerConstructionException {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            boolean cacheLocalRequests;
            File alt;
            File main;
            if (this.finished) {
                return null;
            }
            if (this.tempListener != null) {
                return this.tempListener;
            }
            if (this.fetchContext == null) {
                Logger.error(this, "fetchContext deleted without splitfile being deleted!");
                return null;
            }
            if (this.persistent) {
                container.activate((Object)this.mainBloomFile, 5);
                container.activate((Object)this.altBloomFile, 5);
                main = new File(this.mainBloomFile.getPath());
                alt = new File(this.altBloomFile.getPath());
                container.deactivate((Object)this.mainBloomFile, 1);
                container.deactivate((Object)this.altBloomFile, 1);
                container.activate((Object)this.fetchContext, 1);
                cacheLocalRequests = this.fetchContext.cacheLocalRequests;
                container.deactivate((Object)this.fetchContext, 1);
            } else {
                main = null;
                alt = null;
                cacheLocalRequests = this.fetchContext.cacheLocalRequests;
            }
            try {
                if (logMINOR) {
                    Logger.minor(this, "Attempting to read Bloom filter for " + this + " main file=" + main + " alt file=" + alt);
                }
                this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, main, alt, this.mainBloomFilterSizeBytes, this.mainBloomK, !cacheLocalRequests, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, false);
            }
            catch (IOException e) {
                Logger.error(this, "Unable to read Bloom filter for " + this + " attempting to reconstruct...", e);
                main.delete();
                alt.delete();
                try {
                    this.mainBloomFile = context.fg.makeRandomFile();
                    this.altBloomFile = context.fg.makeRandomFile();
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                }
                catch (IOException e1) {
                    throw new KeyListenerConstructionException(new FetchException(12, "Unable to create Bloom filter files in reconstruction", e1));
                }
                try {
                    this.tempListener = new SplitFileFetcherKeyListener(this, this.keyCount, this.mainBloomFile, this.altBloomFile, this.mainBloomFilterSizeBytes, this.mainBloomK, !this.fetchContext.cacheLocalRequests, this.localSalt, this.segments.length, this.perSegmentBloomFilterSizeBytes, this.perSegmentK, this.persistent, true);
                }
                catch (IOException e1) {
                    throw new KeyListenerConstructionException(new FetchException(12, "Unable to reconstruct Bloom filters: " + e1, e1));
                }
            }
            return this.tempListener;
        }
    }

    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    public SplitFileFetcherSegment getSegment(int i) {
        return this.segments[i];
    }

    public void removeMyPendingKeys(SplitFileFetcherSegment segment, ObjectContainer container, ClientContext context) {
        this.keyCount = this.tempListener.killSegment(segment, container, context);
    }

    void setKeyCount(int keyCount2, ObjectContainer container) {
        this.keyCount = keyCount2;
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public void onFailed(KeyListenerConstructionException e, ObjectContainer container, ClientContext context) {
        this.otherFailure = e.getFetchException();
        this.cancel(container, context);
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this, (Throwable)new Exception("debug"));
        }
        if (!container.ext().isStored((Object)this)) {
            Logger.error(this, "Already removed??? on " + this, new Exception("error"));
            return;
        }
        container.activate((Object)this.blockFetchContext, 1);
        this.blockFetchContext.removeFrom(container);
        if (this.deleteFetchContext) {
            container.activate((Object)this.fetchContext, 1);
            this.fetchContext.removeFrom(container);
        }
        container.activate((Object)this.clientMetadata, 1);
        this.clientMetadata.removeFrom(container);
        container.activate((Object)this.decompressors, 1);
        container.delete((Object)this.decompressors);
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileFetcherSegment segment = this.segments[i];
            this.segments[i] = null;
            container.activate((Object)segment, 1);
            segment.fetcherFinished(container, context);
        }
        container.activate((Object)this.mainBloomFile, 5);
        container.activate((Object)this.altBloomFile, 5);
        if (this.mainBloomFile != null && !this.mainBloomFile.delete() && this.mainBloomFile.exists()) {
            Logger.error(this, "Unable to delete main bloom file: " + this.mainBloomFile + " for " + this);
        } else if (this.mainBloomFile == null) {
            Logger.error(this, "mainBloomFile is null on " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Deleted main bloom file " + this.mainBloomFile);
        }
        if (this.altBloomFile != null && !this.altBloomFile.delete() && this.altBloomFile.exists()) {
            Logger.error(this, "Unable to delete alt bloom file: " + this.altBloomFile + " for " + this);
        } else if (this.altBloomFile == null) {
            Logger.error(this, "altBloomFile is null on " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Deleted alt bloom file " + this.altBloomFile);
        }
        container.delete((Object)this.mainBloomFile);
        container.delete((Object)this.altBloomFile);
        container.delete((Object)this);
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to update with hash 0 => already deleted! active=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("error"));
            return false;
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to write with hash 0 => already deleted! active=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("error"));
            return false;
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

