/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.SendableGet;

public class SingleKeyListener
implements KeyListener {
    private final Key key;
    private final BaseSingleFileFetcher fetcher;
    private final boolean dontCache;
    private boolean done;
    private short prio;
    private final boolean persistent;

    public SingleKeyListener(Key key, BaseSingleFileFetcher fetcher, boolean dontCache, short prio, boolean persistent) {
        this.key = key;
        this.fetcher = fetcher;
        this.dontCache = dontCache;
        this.prio = prio;
        this.persistent = persistent;
    }

    public long countKeys() {
        if (this.done) {
            return 0L;
        }
        return 1L;
    }

    public short definitelyWantKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return -1;
        }
        return this.prio;
    }

    public boolean dontCache() {
        return this.dontCache;
    }

    public HasKeyListener getHasKeyListener() {
        return this.fetcher;
    }

    public short getPriorityClass(ObjectContainer container) {
        return this.prio;
    }

    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return null;
        }
        return new SendableGet[]{this.fetcher};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock found, ObjectContainer container, ClientContext context) {
        if (!key.equals(this.key)) {
            return false;
        }
        if (this.persistent) {
            container.activate((Object)this.fetcher, 1);
        }
        this.fetcher.onGotKey(key, found, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.fetcher, 1);
        }
        SingleKeyListener singleKeyListener = this;
        synchronized (singleKeyListener) {
            this.done = true;
        }
        return true;
    }

    public Key[] listKeys(ObjectContainer container) {
        return new Key[]{this.key};
    }

    public boolean persistent() {
        return this.persistent;
    }

    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (this.done) {
            return false;
        }
        return key.equals(this.key);
    }

    public synchronized void onRemove() {
        this.done = true;
    }

    public boolean isEmpty() {
        return this.done;
    }

    public boolean isSSK() {
        return this.key instanceof NodeSSK;
    }
}

