/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveManager;
import freenet.client.ArchiveRestartException;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SimpleSingleFileFetcher;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.client.async.USKProxyCompletionCallback;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientCHK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFileFetcher
extends SimpleSingleFileFetcher {
    private static volatile boolean logMINOR;
    final FreenetURI uri;
    private final ArrayList<String> metaStrings;
    private int addedMetaStrings;
    final ClientMetadata clientMetadata;
    private Metadata metadata;
    private Metadata archiveMetadata;
    final ArchiveContext actx;
    private ArchiveHandler ah;
    private int recursionLevel;
    private FreenetURI thisKey;
    private final LinkedList<Compressor.COMPRESSOR_TYPE> decompressors;
    private final boolean dontTellClientGet;
    private final Bucket returnBucket;
    private final boolean isFinal;

    public SingleFileFetcher(ClientRequester parent, GetCompletionCallback cb, ClientMetadata metadata, ClientKey key, List<String> metaStrings, FreenetURI origURI, int addedMetaStrings, FetchContext ctx, boolean deleteFetchContext, ArchiveContext actx, ArchiveHandler ah, Metadata archiveMetadata, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, Bucket returnBucket, boolean isFinal, ObjectContainer container, ClientContext context) throws FetchException {
        super(key, maxRetries, ctx, parent, cb, isEssential, false, l, container, context, deleteFetchContext);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + key + " from " + origURI + " meta=" + metaStrings.toString() + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
        }
        this.isFinal = isFinal;
        this.cancelled = false;
        this.returnBucket = returnBucket;
        this.dontTellClientGet = dontTellClientGet;
        if (this.persistent && ah != null) {
            ah = ah.cloneHandler();
        }
        this.ah = ah;
        this.archiveMetadata = archiveMetadata;
        this.metaStrings = metaStrings instanceof ArrayList && !this.persistent ? (ArrayList<Object>)metaStrings : new ArrayList<String>(metaStrings);
        this.addedMetaStrings = addedMetaStrings;
        this.clientMetadata = metadata != null ? metadata.clone() : new ClientMetadata();
        this.thisKey = key.getURI();
        if (origURI == null) {
            throw new NullPointerException();
        }
        this.uri = this.persistent ? origURI.clone() : origURI;
        this.actx = actx;
        this.recursionLevel = recursionLevel + 1;
        if (recursionLevel > ctx.maxRecursionLevel) {
            throw new FetchException(9, "Too much recursion: " + recursionLevel + " > " + ctx.maxRecursionLevel);
        }
        this.decompressors = new LinkedList();
    }

    public SingleFileFetcher(SingleFileFetcher fetcher, boolean persistent, boolean deleteFetchContext, Metadata newMeta, GetCompletionCallback callback, FetchContext ctx2, ObjectContainer container, ClientContext context) throws FetchException {
        super(persistent ? fetcher.key.cloneKey() : fetcher.key, fetcher.maxRetries, ctx2, fetcher.parent, callback, false, true, fetcher.token, container, context, deleteFetchContext);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + fetcher.key + " meta=" + fetcher.metaStrings.toString(), (Throwable)new Exception("debug"));
        }
        this.returnBucket = null;
        this.isFinal = false;
        this.dontTellClientGet = fetcher.dontTellClientGet;
        this.actx = fetcher.actx;
        if (persistent && this.ah != null) {
            this.ah = this.ah.cloneHandler();
        }
        this.ah = fetcher.ah;
        this.archiveMetadata = null;
        this.clientMetadata = fetcher.clientMetadata != null ? fetcher.clientMetadata.clone() : new ClientMetadata();
        this.metadata = newMeta;
        this.metaStrings = new ArrayList();
        this.addedMetaStrings = 0;
        this.recursionLevel = fetcher.recursionLevel + 1;
        if (this.recursionLevel > this.ctx.maxRecursionLevel) {
            throw new FetchException(9);
        }
        this.thisKey = persistent ? fetcher.thisKey.clone() : fetcher.thisKey;
        this.decompressors = new LinkedList<Compressor.COMPRESSOR_TYPE>(fetcher.decompressors);
        if (fetcher.uri == null) {
            throw new NullPointerException();
        }
        this.uri = persistent ? fetcher.uri.clone() : fetcher.uri;
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object token, ObjectContainer container, ClientContext context) {
        Bucket data;
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
        }
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, container, context);
        }
        this.parent.completedBlock(fromStore, container, context);
        if (block == null) {
            Logger.error(this, "block is null! fromStore=" + fromStore + ", token=" + token, new Exception("error"));
            return;
        }
        if (this.key instanceof ClientSSK) {
            try {
                if (this.uri.isSSK() && this.uri.isSSKForUSK()) {
                    if (this.persistent) {
                        container.activate((Object)this.uri, 5);
                    }
                    FreenetURI uu = this.uri.setMetaString(null).uskForSSK();
                    USK usk = USK.create(uu);
                    context.uskManager.updateKnownGood(usk, uu.getSuggestedEdition(), context);
                }
            }
            catch (MalformedURLException e) {
                Logger.error(this, "Caught " + e, e);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
        }
        if ((data = this.extract(block, container, context)) == null) {
            if (logMINOR) {
                Logger.minor(this, "No data");
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Block " + (block.isMetadata() ? "is metadata" : "is not metadata") + " on " + this);
        }
        if (!block.isMetadata()) {
            this.onSuccess(new FetchResult(this.clientMetadata, data), container, context);
        } else {
            if (!this.ctx.followRedirects) {
                this.onFailure(new FetchException(4, "Told me not to follow redirects (splitfile block??)"), false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
            if (this.parent.isCancelled()) {
                this.onFailure(new FetchException(25), false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
            if (data.size() > (long)this.ctx.maxMetadataSize) {
                this.onFailure(new FetchException(22), false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
            try {
                this.removeMetadata(container);
                this.metadata = Metadata.construct(data);
                if (this.persistent) {
                    container.store((Object)this);
                }
                this.innerWrapHandleMetadata(false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
            }
            catch (MetadataParseException e) {
                this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
            catch (IOException e) {
                this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                data.free();
                if (this.persistent) {
                    data.removeFrom(container);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSuccess(FetchResult result, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate(this.decompressors, 1);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.rcb, 1);
        }
        this.removeMetadata(container);
        this.removeArchiveMetadata(container);
        SingleFileFetcher singleFileFetcher = this;
        synchronized (singleFileFetcher) {
            this.finished = true;
        }
        if (this.parent.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Parent is cancelled");
            }
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
            this.onFailure(new FetchException(25), false, container, context);
            return;
        }
        if (!this.decompressors.isEmpty()) {
            Bucket data = result.asBucket();
            while (!this.decompressors.isEmpty()) {
                Compressor.COMPRESSOR_TYPE c = this.decompressors.removeLast();
                try {
                    long maxLen = Math.max(this.ctx.maxTempLength, this.ctx.maxOutputLength);
                    if (logMINOR) {
                        Logger.minor(this, "Decompressing " + data + " size " + data.size() + " max length " + maxLen);
                    }
                    Bucket out = this.decompressors.isEmpty() ? this.returnBucket : null;
                    data = c.decompress(data, context.getBucketFactory(this.parent.persistent()), maxLen, maxLen * 4L, out);
                    if (!logMINOR) continue;
                    Logger.minor(this, "Decompressed to " + data + " size " + data.size());
                }
                catch (IOException e) {
                    this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                    return;
                }
                catch (CompressionOutputSizeException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Too big: limit=" + this.ctx.maxOutputLength + " temp=" + this.ctx.maxTempLength);
                    }
                    this.onFailure(new FetchException(21, e.estimatedSize, this.rcb == this.parent, result.getMimeType()), false, container, context);
                    return;
                }
            }
            result = new FetchResult(result, data);
            if (this.persistent) {
                container.store((Object)this);
                container.store(this.decompressors);
            }
        }
        if (!this.ctx.ignoreTooManyPathComponents && !this.metaStrings.isEmpty() && this.isFinal) {
            if (this.addedMetaStrings > 0) {
                this.rcb.onFailure(new FetchException(4, "Invalid metadata: too many path components in redirects", this.thisKey), this, container, context);
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Too many path components: for " + this.uri + " meta=" + this.metaStrings.toString());
                }
                FreenetURI tryURI = this.uri;
                tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                this.rcb.onFailure(new FetchException(11, result.size(), this.rcb == this.parent, result.getMimeType(), tryURI), this, container, context);
            }
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
            return;
        }
        if (result.size() > this.ctx.maxOutputLength) {
            this.rcb.onFailure(new FetchException(21, result.size(), this.rcb == this.parent, result.getMimeType()), this, container, context);
            result.asBucket().free();
            if (this.persistent) {
                result.asBucket().removeFrom(container);
            }
        } else {
            this.rcb.onSuccess(result, this, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleMetadata(ObjectContainer container, ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        block102: {
            String mimeType;
            if (this.persistent) {
                container.activate((Object)this, 2);
                container.activate((Object)this.metadata, 100);
                container.activate(this.metaStrings, Integer.MAX_VALUE);
                container.activate((Object)this.thisKey, 5);
                container.activate((Object)this.ctx, 2);
                if (this.ah != null) {
                    this.ah.activateForExecution(container);
                }
                container.activate((Object)this.parent, 1);
                container.activate((Object)this.actx, 5);
                container.activate((Object)this.clientMetadata, 5);
                container.activate((Object)this.rcb, 1);
                container.activate((Object)this.returnBucket, 5);
            }
            if (this.uri == null) {
                if (container != null) {
                    if (container.ext().isActive((Object)this)) {
                        throw new NullPointerException("SFI " + this + " is active and uri is null!");
                    }
                    throw new NullPointerException("SFI " + this + " is not active!");
                }
                throw new NullPointerException("uri = null on transient SFI?? " + this);
            }
            SingleFileFetcher singleFileFetcher = this;
            synchronized (singleFileFetcher) {
                if (this.cancelled) {
                    return;
                }
                this.finished = true;
            }
            while (true) {
                String mime;
                if (this.metadata.isSimpleManifest()) {
                    Metadata newMeta;
                    if (logMINOR) {
                        Logger.minor(this, "Is simple manifest");
                    }
                    if (this.metaStrings.isEmpty()) {
                        throw new FetchException(24, -1L, false, null, this.uri.addMetaStrings(new String[]{""}));
                    }
                    String name = this.removeMetaString();
                    if (logMINOR) {
                        Logger.minor(this, "Next meta-string: " + name + " length " + name.length() + " for " + this);
                    }
                    if (name == null) {
                        if (!this.persistent) {
                            this.metadata = this.metadata.getDefaultDocument();
                        } else {
                            newMeta = this.metadata.grabDefaultDocument();
                            this.metadata.removeFrom(container);
                            this.metadata = newMeta;
                            container.store((Object)this);
                            container.store(this.metaStrings);
                        }
                        if (this.metadata != null) continue;
                        throw new FetchException(24, -1L, false, null, this.uri.addMetaStrings(new String[]{""}));
                    }
                    if (!this.persistent) {
                        this.metadata = this.metadata.getDocument(name);
                        this.thisKey = this.thisKey.pushMetaString(name);
                    } else {
                        newMeta = this.metadata.grabDocument(name);
                        this.metadata.removeFrom(container);
                        this.metadata = newMeta;
                        FreenetURI oldThisKey = this.thisKey;
                        this.thisKey = this.thisKey.pushMetaString(name);
                        container.store((Object)this);
                        container.store(this.metaStrings);
                        container.store((Object)this.thisKey);
                        oldThisKey.removeFrom(container);
                    }
                    if (this.metadata != null) continue;
                    throw new FetchException(10, "can't find " + name);
                }
                if (this.metadata.isArchiveManifest()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is archive manifest (type=" + (Object)((Object)this.metadata.getArchiveType()) + " codec=" + this.metadata.getCompressionCodec() + ')');
                    }
                    if (this.metaStrings.isEmpty() && this.ctx.returnZIPManifests) {
                        this.metadata.setSimpleRedirect();
                        if (!this.persistent) continue;
                        container.store((Object)this.metadata);
                        continue;
                    }
                    if (this.ah == null || !this.ah.getKey().equals(this.thisKey)) {
                        this.ah = context.archiveManager.makeHandler(this.thisKey, this.metadata.getArchiveType(), this.metadata.getCompressionCodec(), this.parent instanceof ClientGetter ? ((ClientGetter)this.parent).collectingBinaryBlob() : false, this.persistent);
                    }
                    this.archiveMetadata = this.metadata;
                    this.metadata = null;
                    Bucket metadataBucket = this.ah.getMetadata(this.actx, context.archiveManager);
                    if (metadataBucket != null) {
                        try {
                            this.metadata = Metadata.construct(metadataBucket);
                            metadataBucket.free();
                        }
                        catch (IOException e) {
                            throw new FetchException(12, (Throwable)e);
                        }
                        if (this.persistent) {
                            container.store((Object)this);
                        }
                    } else {
                        final boolean persistent = this.persistent;
                        this.fetchArchive(false, this.archiveMetadata, ".metadata", new ArchiveExtractCallback(){

                            public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "gotBucket on " + SingleFileFetcher.this + " persistent=" + persistent);
                                }
                                try {
                                    SingleFileFetcher.this.metadata = Metadata.construct(data);
                                    data.free();
                                    if (persistent) {
                                        data.removeFrom(container);
                                    }
                                    SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
                                }
                                catch (MetadataParseException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
                                    return;
                                }
                                catch (IOException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                                    return;
                                }
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            public void notInArchive(ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(17, "No metadata in container! Cannot happen as ArchiveManager should synthesise some!"), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                                if (persistent) {
                                    container.deactivate((Object)SingleFileFetcher.this, 1);
                                }
                            }

                            public void removeFrom(ObjectContainer container) {
                                container.delete((Object)this);
                            }
                        }, container, context);
                        if (persistent) {
                            container.store((Object)this);
                        }
                        return;
                    }
                    metadataBucket.free();
                    continue;
                }
                if (this.metadata.isArchiveMetadataRedirect()) {
                    Bucket dataBucket;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-metadata");
                    }
                    if (this.ah == null) {
                        throw new FetchException(3, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager)) != null) {
                        Metadata newMetadata;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            newMetadata = Metadata.construct(dataBucket);
                            dataBucket.free();
                        }
                        catch (IOException e) {
                            throw new FetchException(12);
                        }
                        this.removeMetadata(container);
                        SingleFileFetcher e = this;
                        synchronized (e) {
                            this.metadata = newMetadata;
                        }
                        if (!this.persistent) continue;
                        container.store((Object)newMetadata);
                        container.store((Object)this);
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    final boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                            block12: {
                                if (persistent) {
                                    container.activate((Object)SingleFileFetcher.this, 1);
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Returning data");
                                }
                                try {
                                    try {
                                        Metadata newMetadata = Metadata.construct(data);
                                        SingleFileFetcher.this.removeMetadata(container);
                                        SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                                        synchronized (singleFileFetcher) {
                                            SingleFileFetcher.this.metadata = newMetadata;
                                        }
                                        if (persistent) {
                                            container.store((Object)newMetadata);
                                            container.store((Object)SingleFileFetcher.this);
                                        }
                                        SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
                                    }
                                    catch (IOException e) {
                                        SingleFileFetcher.this.onFailure(new FetchException(12), false, container, context);
                                        Object var8_10 = null;
                                        data.free();
                                        break block12;
                                    }
                                    catch (MetadataParseException e) {
                                        SingleFileFetcher.this.onFailure(new FetchException(4), false, container, context);
                                        Object var8_11 = null;
                                        data.free();
                                    }
                                    Object var8_9 = null;
                                    data.free();
                                }
                                catch (Throwable throwable) {
                                    Object var8_12 = null;
                                    data.free();
                                    throw throwable;
                                }
                            }
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void notInArchive(ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(10), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void removeFrom(ObjectContainer container) {
                            container.delete((Object)this);
                        }
                    }, container, context);
                    this.removeMetadata(container);
                    return;
                }
                if (this.metadata.isArchiveInternalRedirect()) {
                    Bucket dataBucket;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-internal redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    if (this.persistent) {
                        container.store((Object)this.clientMetadata);
                    }
                    if ((mime = this.clientMetadata.getMIMEType()) != null) {
                        this.rcb.onExpectedMIME(mime, container, context);
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && this.clientMetadata.getMIMETypeNoParams() != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(this.clientMetadata.getMIMETypeNoParams())) {
                        throw new FetchException(29, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    if (this.ah == null) {
                        throw new FetchException(3, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager)) != null) {
                        Bucket out;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            if (this.returnBucket != null || this.persistent) {
                                out = this.returnBucket == null ? context.persistentBucketFactory.makeBucket(dataBucket.size()) : this.returnBucket;
                                BucketTools.copy(dataBucket, out);
                                dataBucket.free();
                            } else {
                                out = dataBucket;
                            }
                        }
                        catch (IOException e) {
                            throw new FetchException(12);
                        }
                        this.onSuccess(new FetchResult(this.clientMetadata, out), container, context);
                        return;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    final boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){

                        public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
                            Bucket out;
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Returning data");
                            }
                            try {
                                if (SingleFileFetcher.this.returnBucket != null) {
                                    if (persistent) {
                                        container.activate((Object)SingleFileFetcher.this.returnBucket, 5);
                                    }
                                    out = SingleFileFetcher.this.returnBucket;
                                    BucketTools.copy(data, out);
                                    data.free();
                                    if (persistent) {
                                        data.removeFrom(container);
                                    }
                                } else {
                                    out = data;
                                }
                            }
                            catch (IOException e) {
                                SingleFileFetcher.this.onFailure(new FetchException(12), false, container, context);
                                return;
                            }
                            SingleFileFetcher.this.onSuccess(new FetchResult(SingleFileFetcher.this.clientMetadata, out), container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void notInArchive(ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(10), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
                            if (persistent) {
                                container.activate((Object)SingleFileFetcher.this, 1);
                            }
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                            if (persistent) {
                                container.deactivate((Object)SingleFileFetcher.this, 1);
                            }
                        }

                        public void removeFrom(ObjectContainer container) {
                            container.delete((Object)this);
                        }
                    }, container, context);
                    this.removeMetadata(container);
                    return;
                }
                if (this.metadata.isMultiLevelMetadata()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is multi-level metadata");
                    }
                    this.metadata.setSimpleRedirect();
                    SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, false, this.metadata, new MultiLevelMetadataCallback(), this.ctx, container, context);
                    this.metadata = null;
                    if (this.persistent) {
                        container.store((Object)this);
                    }
                    if (this.persistent) {
                        container.store((Object)f);
                    }
                    this.parent.onTransition(this, f, container);
                    f.innerWrapHandleMetadata(true, container, context);
                    if (this.persistent) {
                        container.deactivate((Object)f, 1);
                    }
                    return;
                }
                if (this.metadata.isSingleFileRedirect()) {
                    ClientKey redirectedKey;
                    if (logMINOR) {
                        Logger.minor(this, "Is single-file redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    if (this.persistent) {
                        container.store((Object)this.clientMetadata);
                    }
                    if ((mime = this.clientMetadata.getMIMEType()) != null) {
                        this.rcb.onExpectedMIME(mime, container, context);
                    }
                    if ((mimeType = this.clientMetadata.getMIMETypeNoParams()) != null && ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) && this.metaStrings.size() > 0) {
                        this.metadata.setArchiveManifest();
                        if (this.persistent) {
                            container.store((Object)this.metadata);
                        }
                        this.clientMetadata.clear();
                        if (this.persistent) {
                            container.store((Object)this.clientMetadata);
                        }
                        if (!logMINOR) continue;
                        Logger.minor(this, "Handling implicit container... (redirect)");
                        continue;
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                        throw new FetchException(29, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    FreenetURI newURI = this.metadata.getSingleTarget();
                    if (logMINOR) {
                        Logger.minor(this, "Redirecting to " + newURI);
                    }
                    try {
                        BaseClientKey k = BaseClientKey.getBaseKey(newURI);
                        if (!(k instanceof ClientKey)) {
                            throw new FetchException(3, "Redirect to a USK");
                        }
                        redirectedKey = (ClientKey)k;
                    }
                    catch (MalformedURLException e) {
                        throw new FetchException(20, (Throwable)e);
                    }
                    ArrayList<String> newMetaStrings = newURI.listMetaStrings();
                    while (!newMetaStrings.isEmpty()) {
                        String o = newMetaStrings.remove(newMetaStrings.size() - 1);
                        this.metaStrings.add(0, o);
                        ++this.addedMetaStrings;
                    }
                    SingleFileFetcher f = new SingleFileFetcher(this.parent, this.rcb, this.clientMetadata, redirectedKey, this.metaStrings, this.uri, this.addedMetaStrings, this.ctx, this.deleteFetchContext, this.actx, this.ah, this.archiveMetadata, this.maxRetries, this.recursionLevel, false, this.token, true, this.returnBucket, this.isFinal, container, context);
                    this.deleteFetchContext = false;
                    if (redirectedKey instanceof ClientCHK && !((ClientCHK)redirectedKey).isMetadata()) {
                        this.rcb.onBlockSetFinished(this, container, context);
                    }
                    if (this.metadata.isCompressed()) {
                        Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                        f.addDecompressor(codec);
                    }
                    this.parent.onTransition(this, f, container);
                    if (this.persistent) {
                        container.store(this.metaStrings);
                        container.store((Object)f);
                        container.store((Object)this);
                    }
                    f.schedule(container, context);
                    this.archiveMetadata = null;
                    if (this.persistent) {
                        this.removeFrom(container, context);
                    }
                    return;
                }
                if (!this.metadata.isSplitfile()) break block102;
                if (logMINOR) {
                    Logger.minor(this, "Fetching splitfile");
                }
                this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                if (this.persistent) {
                    container.store((Object)this.clientMetadata);
                }
                if ((mime = this.clientMetadata.getMIMEType()) != null) {
                    this.rcb.onExpectedMIME(mime, container, context);
                }
                if ((mimeType = this.clientMetadata.getMIMETypeNoParams()) == null || !ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) || this.metaStrings.size() <= 0) break;
                this.metadata.setArchiveManifest();
                this.clientMetadata.clear();
                if (this.persistent) {
                    container.store((Object)this.metadata);
                    container.store((Object)this.clientMetadata);
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Handling implicit container... (splitfile)");
            }
            if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                long len = this.metadata.uncompressedDataLength();
                if (this.persistent) {
                    this.removeFrom(container, context);
                }
                throw new FetchException(29, len, false, this.clientMetadata.getMIMEType());
            }
            if (this.metadata.isCompressed()) {
                Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                this.addDecompressor(codec);
                if (this.persistent) {
                    container.store(this.decompressors);
                }
            }
            if (this.isFinal && !this.ctx.ignoreTooManyPathComponents) {
                if (!this.metaStrings.isEmpty()) {
                    if (this.addedMetaStrings > 0) {
                        this.rcb.onFailure(new FetchException(4, "Invalid metadata: too many path components in redirects", this.thisKey), this, container, context);
                    } else {
                        FreenetURI tryURI = this.uri;
                        tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                        this.rcb.onFailure(new FetchException(11, this.metadata.uncompressedDataLength(), this.rcb == this.parent, this.clientMetadata.getMIMEType(), tryURI), this, container, context);
                    }
                    if (this.persistent) {
                        this.removeFrom(container, context);
                    }
                    return;
                }
            } else if (logMINOR) {
                Logger.minor(this, "Not finished: rcb=" + this.rcb + " for " + this);
            }
            long len = this.metadata.dataLength();
            if (this.metadata.uncompressedDataLength() > len) {
                len = this.metadata.uncompressedDataLength();
            }
            if (len > this.ctx.maxOutputLength || len > this.ctx.maxTempLength) {
                boolean compressed = this.metadata.isCompressed();
                if (this.persistent) {
                    this.removeFrom(container, context);
                }
                throw new FetchException(21, len, this.isFinal && this.decompressors.size() <= (compressed ? 1 : 0), this.clientMetadata.getMIMEType());
            }
            SplitFileFetcher sf = new SplitFileFetcher(this.metadata, this.rcb, this.parent, this.ctx, this.deleteFetchContext, this.decompressors, this.clientMetadata, this.actx, this.recursionLevel, this.returnBucket, this.token, container, context);
            this.deleteFetchContext = false;
            if (this.persistent) {
                container.store((Object)sf);
                if (!container.ext().isActive((Object)this.parent)) {
                    container.activate((Object)this.parent, 1);
                    Logger.error(this, "Not active: " + this.parent);
                }
            }
            this.parent.onTransition(this, sf, container);
            try {
                sf.schedule(container, context);
            }
            catch (KeyListenerConstructionException e) {
                this.onFailure(e.getFetchException(), false, container, context);
                if (this.persistent) {
                    container.deactivate((Object)sf, 1);
                }
                return;
            }
            if (this.persistent) {
                container.deactivate((Object)sf, 1);
            }
            this.rcb.onBlockSetFinished(this, container, context);
            if (this.persistent) {
                this.removeFrom(container, context);
            }
            return;
        }
        Logger.error(this, "Don't know what to do with metadata: " + this.metadata);
        this.removeMetadata(container);
        throw new FetchException(3);
    }

    private String removeMetaString() {
        String name = this.metaStrings.remove(0);
        if (this.addedMetaStrings > 0) {
            --this.addedMetaStrings;
        }
        return name;
    }

    private void addDecompressor(Compressor.COMPRESSOR_TYPE codec) {
        if (logMINOR) {
            Logger.minor(this, "Adding decompressor: " + codec + " on " + this, (Throwable)new Exception("debug"));
        }
        this.decompressors.add(codec);
    }

    private void fetchArchive(boolean forData, Metadata meta, String element, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        if (logMINOR) {
            Logger.minor(this, "fetchArchive()");
        }
        Metadata newMeta = (Metadata)meta.clone();
        newMeta.setSimpleRedirect();
        SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, true, newMeta, new ArchiveFetcherCallback(forData, element, callback), new FetchContext(this.ctx, 4, true, null), container, context);
        if (this.persistent) {
            container.store((Object)f);
        }
        if (logMINOR) {
            Logger.minor(this, "fetchArchive(): " + f);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        this.parent.onTransition(this, f, container);
        f.innerWrapHandleMetadata(true, container, context);
        if (this.persistent) {
            container.deactivate((Object)f, 1);
        }
    }

    protected void innerWrapHandleMetadata(boolean notFinalizedSize, ObjectContainer container, ClientContext context) {
        try {
            this.handleMetadata(container, context);
        }
        catch (MetadataParseException e) {
            this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
        }
        catch (FetchException e) {
            if (notFinalizedSize) {
                e.setNotFinalizedSize();
            }
            this.onFailure(e, false, container, context);
        }
        catch (ArchiveFailureException e) {
            this.onFailure(new FetchException(e), false, container, context);
        }
        catch (ArchiveRestartException e) {
            this.onFailure(new FetchException(e), false, container, context);
        }
    }

    @Override
    public boolean ignoreStore() {
        return this.ctx.ignoreStore;
    }

    public static ClientGetState create(ClientRequester requester, GetCompletionCallback cb, FreenetURI uri, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, Bucket returnBucket, boolean isFinal, ObjectContainer container, ClientContext context) throws MalformedURLException, FetchException {
        BaseClientKey key = BaseClientKey.getBaseKey(uri);
        if (!uri.hasMetaStrings() && !ctx.allowSplitfiles && !ctx.followRedirects && returnBucket == null && key instanceof ClientKey) {
            return new SimpleSingleFileFetcher((ClientKey)key, maxRetries, ctx, requester, cb, isEssential, false, l, container, context, false);
        }
        if (key instanceof ClientKey) {
            return new SingleFileFetcher(requester, cb, null, (ClientKey)key, new ArrayList<String>(uri.listMetaStrings()), uri, 0, ctx, false, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, returnBucket, isFinal, container, context);
        }
        return SingleFileFetcher.uskCreate(requester, cb, (USK)key, new ArrayList<String>(uri.listMetaStrings()), ctx, actx, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, returnBucket, isFinal, container, context);
    }

    private static ClientGetState uskCreate(ClientRequester requester, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, Bucket returnBucket, boolean isFinal, ObjectContainer container, ClientContext context) throws FetchException {
        if (usk.suggestedEdition >= 0L) {
            long edition = context.uskManager.lookupKnownGood(usk);
            if (edition <= usk.suggestedEdition) {
                context.uskManager.startTemporaryBackgroundFetcher(usk, context, ctx, true);
                edition = context.uskManager.lookupKnownGood(usk);
                if (edition > usk.suggestedEdition) {
                    if (logMINOR) {
                        Logger.minor(SingleFileFetcher.class, "Redirecting to edition " + edition);
                    }
                    cb.onFailure(new FetchException(27, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, container, context);
                    return null;
                }
                USKProxyCompletionCallback myCB = new USKProxyCompletionCallback(usk, cb, requester.persistent());
                SingleFileFetcher sf = new SingleFileFetcher(requester, myCB, null, usk.getSSK(), metaStrings, usk.getURI().addMetaStrings(metaStrings), 0, ctx, false, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, returnBucket, isFinal, container, context);
                return sf;
            }
            cb.onFailure(new FetchException(27, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, container, context);
            return null;
        }
        USKFetcherTag tag = context.uskManager.getFetcher(usk.copy(-usk.suggestedEdition), ctx, false, requester.persistent(), new MyUSKFetcherCallback(requester, cb, usk, metaStrings, ctx, actx, maxRetries, recursionLevel, dontTellClientGet, l, returnBucket, requester.persistent()), false, container, context);
        if (isEssential) {
            requester.addMustSucceedBlocks(1, container);
        }
        return tag;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this);
        }
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        if (this.thisKey != null) {
            container.activate((Object)this.thisKey, 5);
            this.thisKey.removeFrom(container);
        }
        if (this.ah != null) {
            this.ah.activateForExecution(container);
            this.ah.removeFrom(container);
        }
        container.activate(this.metaStrings, 1);
        this.metaStrings.clear();
        container.delete(this.metaStrings);
        container.activate((Object)this.clientMetadata, 1);
        this.clientMetadata.removeFrom(container);
        container.activate(this.decompressors, 1);
        this.decompressors.clear();
        this.removeMetadata(container);
        this.removeArchiveMetadata(container);
        container.delete(this.decompressors);
        super.removeFrom(container, context);
    }

    private void removeMetadata(ObjectContainer container) {
        if (!this.persistent) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "removeMetadata() on " + this);
        }
        if (this.metadata == null) {
            return;
        }
        container.activate((Object)this.metadata, 1);
        this.metadata.removeFrom(container);
        this.metadata = null;
    }

    private void removeArchiveMetadata(ObjectContainer container) {
        if (!this.persistent) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "removeArchiveMetadata() on " + this);
        }
        if (this.archiveMetadata == null) {
            return;
        }
        container.activate((Object)this.archiveMetadata, 1);
        this.archiveMetadata.removeFrom(container);
        this.archiveMetadata = null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyUSKFetcherCallback
    implements USKFetcherCallback {
        final ClientRequester parent;
        final GetCompletionCallback cb;
        final USK usk;
        final ArrayList<String> metaStrings;
        final FetchContext ctx;
        final ArchiveContext actx;
        final int maxRetries;
        final int recursionLevel;
        final boolean dontTellClientGet;
        final long token;
        final Bucket returnBucket;
        final boolean persistent;

        public MyUSKFetcherCallback(ClientRequester requester, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, Bucket returnBucket, boolean persistent) {
            this.parent = requester;
            this.cb = cb;
            this.usk = usk;
            this.metaStrings = metaStrings;
            this.ctx = ctx;
            this.actx = actx;
            this.maxRetries = maxRetries;
            this.recursionLevel = recursionLevel;
            this.dontTellClientGet = dontTellClientGet;
            this.token = l;
            this.returnBucket = returnBucket;
            this.persistent = persistent;
        }

        @Override
        public void onFoundEdition(long l, USK newUSK, ObjectContainer container, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
            block7: {
                if (this.persistent) {
                    container.activate((Object)this, 2);
                }
                ClientSSK key = this.usk.getSSK(l);
                try {
                    if (l == this.usk.suggestedEdition) {
                        SingleFileFetcher sf = new SingleFileFetcher(this.parent, this.cb, null, key, this.metaStrings, key.getURI().addMetaStrings(this.metaStrings), 0, this.ctx, false, this.actx, null, null, this.maxRetries, this.recursionLevel + 1, this.dontTellClientGet, this.token, false, this.returnBucket, true, container, context);
                        sf.schedule(container, context);
                        if (this.persistent) {
                            this.removeFrom(container);
                        }
                    } else {
                        this.cb.onFailure(new FetchException(27, newUSK.getURI().addMetaStrings(this.metaStrings)), null, container, context);
                        if (this.persistent) {
                            this.removeFrom(container);
                        }
                    }
                }
                catch (FetchException e) {
                    this.cb.onFailure(e, null, container, context);
                    if (!this.persistent) break block7;
                    this.removeFrom(container);
                }
            }
        }

        private void removeFrom(ObjectContainer container) {
            container.delete(this.metaStrings);
            container.delete((Object)this);
            container.activate((Object)this.usk, 5);
            this.usk.removeFrom(container);
        }

        @Override
        public void onFailure(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)this, 2);
            }
            this.cb.onFailure(new FetchException(13, "No USK found"), null, container, context);
            if (this.persistent) {
                this.removeFrom(container);
            }
        }

        @Override
        public void onCancelled(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)this, 2);
            }
            this.cb.onFailure(new FetchException(25, (String)null), null, container, context);
            if (this.persistent) {
                this.removeFrom(container);
            }
        }

        @Override
        public short getPollingPriorityNormal() {
            return this.parent.getPriorityClass();
        }

        @Override
        public short getPollingPriorityProgress() {
            return this.parent.getPriorityClass();
        }
    }

    class MultiLevelMetadataCallback
    implements GetCompletionCallback {
        private final boolean persistent;

        MultiLevelMetadataCallback() {
            this.persistent = SingleFileFetcher.this.persistent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(FetchResult result, ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive;
            block17: {
                wasActive = true;
                if (this.persistent) {
                    wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                    container.activate((Object)SingleFileFetcher.this, 1);
                    container.activate((Object)SingleFileFetcher.this.parent, 1);
                }
                try {
                    try {
                        SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
                        Metadata meta = Metadata.construct(result.asBucket());
                        SingleFileFetcher.this.removeMetadata(container);
                        SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                        synchronized (singleFileFetcher) {
                            SingleFileFetcher.this.metadata = meta;
                        }
                        if (this.persistent) {
                            container.store((Object)meta);
                            container.store((Object)SingleFileFetcher.this);
                        }
                        SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
                    }
                    catch (MetadataParseException e) {
                        SingleFileFetcher.this.onFailure(new FetchException(4, (Throwable)e), false, container, context);
                        Object var10_12 = null;
                        result.asBucket().free();
                        if (this.persistent) {
                            result.asBucket().removeFrom(container);
                        }
                        break block17;
                    }
                    catch (IOException e) {
                        SingleFileFetcher.this.onFailure(new FetchException(12, (Throwable)e), false, container, context);
                        Object var10_13 = null;
                        result.asBucket().free();
                        if (this.persistent) {
                            result.asBucket().removeFrom(container);
                        }
                    }
                    Object var10_11 = null;
                    result.asBucket().free();
                    if (this.persistent) {
                        result.asBucket().removeFrom(container);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    result.asBucket().free();
                    if (this.persistent) {
                        result.asBucket().removeFrom(container);
                    }
                    throw throwable;
                }
            }
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
            }
        }

        public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            SingleFileFetcher.this.onFailure(e, true, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
            }
        }

        public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        }

        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        public void onExpectedMIME(String mime, ObjectContainer container, ClientContext context) {
        }

        public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            boolean cbWasActive = true;
            if (this.persistent) {
                wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                container.activate((Object)SingleFileFetcher.this, 1);
                cbWasActive = container.ext().isActive((Object)SingleFileFetcher.this.rcb);
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onExpectedSize(size, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (!cbWasActive) {
                container.deactivate((Object)SingleFileFetcher.this.rcb, 1);
            }
        }

        public void onFinalizedMetadata(ObjectContainer container) {
        }
    }

    class ArchiveFetcherCallback
    implements GetCompletionCallback {
        private final boolean wasFetchingFinalData;
        private final String element;
        private final ArchiveExtractCallback callback;
        private final boolean persistent;

        ArchiveFetcherCallback(boolean wasFetchingFinalData, String element, ArchiveExtractCallback cb) {
            this.wasFetchingFinalData = wasFetchingFinalData;
            this.element = element;
            this.callback = cb;
            this.persistent = SingleFileFetcher.this.persistent;
        }

        public void onSuccess(FetchResult result, ClientGetState state, ObjectContainer container, ClientContext context) {
            if (!this.persistent) {
                this.innerSuccess(result, container, context);
            } else {
                boolean wasActive = container.ext().isActive((Object)SingleFileFetcher.this);
                if (!wasActive) {
                    container.activate((Object)SingleFileFetcher.this, 1);
                }
                container.activate((Object)SingleFileFetcher.this.parent, 1);
                SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, container);
                if (this.persistent) {
                    container.activate((Object)SingleFileFetcher.this.actx, 1);
                }
                SingleFileFetcher.this.ah.activateForExecution(container);
                SingleFileFetcher.this.ah.extractPersistentOffThread(result.asBucket(), true, SingleFileFetcher.this.actx, this.element, this.callback, container, context);
                if (!wasActive) {
                    container.deactivate((Object)SingleFileFetcher.this, 1);
                }
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerSuccess(FetchResult result, ObjectContainer container, ClientContext context) {
            try {
                try {
                    SingleFileFetcher.this.ah.extractToCache(result.asBucket(), SingleFileFetcher.this.actx, this.element, this.callback, context.archiveManager, container, context);
                }
                catch (ArchiveFailureException e) {
                    SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                    Object var6_5 = null;
                    result.asBucket().free();
                    if (this.persistent) {
                        result.asBucket().removeFrom(container);
                    }
                    return;
                }
                catch (ArchiveRestartException e) {
                    SingleFileFetcher.this.onFailure(new FetchException(e), false, container, context);
                    Object var6_6 = null;
                    result.asBucket().free();
                    if (this.persistent) {
                        result.asBucket().removeFrom(container);
                    }
                    return;
                }
                Object var6_4 = null;
                result.asBucket().free();
                if (this.persistent) {
                    result.asBucket().removeFrom(container);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                result.asBucket().free();
                if (this.persistent) {
                    result.asBucket().removeFrom(container);
                }
                throw throwable;
            }
            if (this.callback != null) {
                return;
            }
            SingleFileFetcher.this.innerWrapHandleMetadata(true, container, context);
        }

        public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            SingleFileFetcher.this.onFailure(e, true, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                if (state != null) {
                    state.removeFrom(container, context);
                }
                container.delete((Object)this);
                this.callback.removeFrom(container);
            }
        }

        public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            if (this.wasFetchingFinalData) {
                SingleFileFetcher.this.rcb.onBlockSetFinished(SingleFileFetcher.this, container, context);
            }
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
        }

        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        public void onExpectedMIME(String mime, ObjectContainer container, ClientContext context) {
        }

        public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
            boolean wasActive = true;
            if (this.persistent && !(wasActive = container.ext().isActive((Object)SingleFileFetcher.this))) {
                container.activate((Object)SingleFileFetcher.this, 1);
            }
            if (this.persistent) {
                container.activate((Object)SingleFileFetcher.this.rcb, 1);
            }
            SingleFileFetcher.this.rcb.onExpectedSize(size, container, context);
            if (!wasActive) {
                container.deactivate((Object)SingleFileFetcher.this, 1);
            }
        }

        public void onFinalizedMetadata(ObjectContainer container) {
        }
    }
}

