/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.Encodeable;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.PutCompletionCallback;
import freenet.crypt.RandomSource;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.KeyDecodeException;
import freenet.keys.KeyEncodeException;
import freenet.keys.KeyVerifyException;
import freenet.keys.SSKEncodeException;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleBlockInserter
extends SendableInsert
implements ClientPutState,
Encodeable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    Bucket sourceData;
    final short compressionCodec;
    final FreenetURI uri;
    FreenetURI resultingURI;
    final PutCompletionCallback cb;
    final BaseClientPutter parent;
    final InsertContext ctx;
    private int retries;
    private final FailureCodeTracker errors;
    private boolean finished;
    private final boolean dontSendEncoded;
    final int token;
    private final Object tokenObject;
    final boolean isMetadata;
    final boolean getCHKOnly;
    final int sourceLength;
    private int consecutiveRNFs;
    private boolean isSSK;
    private boolean freeData;

    public SingleBlockInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean getCHKOnly, boolean addToParent, boolean dontSendEncoded, Object tokenObject, ObjectContainer container, ClientContext context, boolean persistent, boolean freeData) {
        super(persistent);
        assert (persistent == parent.persistent());
        this.consecutiveRNFs = 0;
        this.tokenObject = tokenObject;
        this.token = token;
        this.parent = parent;
        this.dontSendEncoded = dontSendEncoded;
        this.retries = 0;
        this.finished = false;
        this.ctx = ctx;
        this.freeData = freeData;
        this.errors = new FailureCodeTracker(true);
        this.cb = cb;
        this.uri = uri;
        this.compressionCodec = compressionCodec;
        this.sourceData = data;
        if (this.sourceData == null) {
            throw new NullPointerException();
        }
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.getCHKOnly = getCHKOnly;
        this.isSSK = uri.getKeyType().toUpperCase().equals("SSK");
        if (addToParent) {
            parent.addBlock(container);
            parent.addMustSucceedBlocks(1, container);
            parent.notifyClients(container, context);
        }
    }

    protected ClientKeyBlock innerEncode(RandomSource random, ObjectContainer container) throws InsertException {
        if (this.persistent) {
            container.activate((Object)this.uri, 1);
            container.activate((Object)this.sourceData, 1);
        }
        try {
            return SingleBlockInserter.innerEncode(random, this.uri, this.sourceData, this.isMetadata, this.compressionCodec, this.sourceLength);
        }
        catch (KeyEncodeException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e, e);
            throw new InsertException(3, e, null);
        }
        catch (MalformedURLException e) {
            throw new InsertException(1, e, null);
        }
        catch (IOException e) {
            Logger.error(SingleBlockInserter.class, "Caught " + e + " encoding data " + this.sourceData, e);
            throw new InsertException(2, e, null);
        }
    }

    protected static ClientKeyBlock innerEncode(RandomSource random, FreenetURI uri, Bucket sourceData, boolean isMetadata, short compressionCodec, int sourceLength) throws InsertException, CHKEncodeException, IOException, SSKEncodeException, MalformedURLException {
        String uriType = uri.getKeyType();
        if (uriType.equals("CHK")) {
            return ClientCHKBlock.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, (long)sourceLength);
        }
        if (uriType.equals("SSK") || uriType.equals("KSK")) {
            InsertableClientSSK ik = InsertableClientSSK.create(uri);
            return ik.encode(sourceData, isMetadata, compressionCodec == -1, compressionCodec, sourceLength, random);
        }
        throw new InsertException(1, "Unknown keytype " + uriType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEncode(ClientKey key, ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            if (this.resultingURI != null) {
                return;
            }
            this.resultingURI = key.getURI();
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onEncode(key, this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientKeyBlock encode(ObjectContainer container, ClientContext context, boolean calledByCB) throws InsertException {
        boolean shouldSend;
        ClientKeyBlock block;
        if (this.persistent) {
            container.activate((Object)this.sourceData, 1);
            container.activate((Object)this.cb, 1);
        }
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return null;
            }
            if (this.sourceData == null) {
                Logger.error(this, "Source data is null on " + this + " but not finished!");
                return null;
            }
            block = this.innerEncode(context.random, container);
            shouldSend = this.resultingURI == null;
            this.resultingURI = block.getClientKey().getURI();
        }
        if (logMINOR) {
            Logger.minor(this, "Encoded " + this.resultingURI + " for " + this + " shouldSend=" + shouldSend + " dontSendEncoded=" + this.dontSendEncoded);
        }
        if (shouldSend && !this.dontSendEncoded) {
            this.cb.onEncode(block.getClientKey(), this, container, context);
        }
        if (shouldSend && this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent && !calledByCB) {
            container.deactivate((Object)this.cb, 1);
        }
        return block;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getPriorityClass();
    }

    @Override
    public int getRetryCount() {
        return this.retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(LowLevelPutException e, Object keyNum, ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.errors, 1);
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(10), container, context);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure() on " + e + " for " + this);
        }
        switch (e.code) {
            case 5: {
                this.fail(new InsertException(9), container, context);
                return;
            }
            case 1: {
                this.fail(new InsertException(3), container, context);
                return;
            }
            case 3: {
                this.errors.inc(4);
                break;
            }
            case 2: {
                this.errors.inc(5);
                break;
            }
            case 4: {
                this.errors.inc(8);
                break;
            }
            default: {
                Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                this.errors.inc(3);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        if (e.code == 2 || e.code == 4) {
            ++this.consecutiveRNFs;
            if (logMINOR) {
                Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " / " + this.ctx.consecutiveRNFsCountAsSuccess);
            }
            if (this.consecutiveRNFs == this.ctx.consecutiveRNFsCountAsSuccess) {
                if (logMINOR) {
                    Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " - counting as success");
                }
                this.onSuccess(keyNum, container, context);
                return;
            }
        } else {
            this.consecutiveRNFs = 0;
        }
        if (logMINOR) {
            Logger.minor(this, "Failed: " + e);
        }
        ++this.retries;
        if (this.retries > this.ctx.maxInsertRetries && this.ctx.maxInsertRetries != -1) {
            this.fail(InsertException.construct(this.persistent ? this.errors.clone() : this.errors), container, context);
            if (this.persistent) {
                container.deactivate((Object)this.ctx, 1);
            }
            return;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.deactivate((Object)this.ctx, 1);
        }
        this.getScheduler(context).registerInsert(this, this.persistent, false, container);
    }

    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        this.fail(e, false, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, boolean forceFatal, ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (e.isFatal() || forceFatal) {
            this.parent.fatallyFailedBlock(container, context);
        } else {
            this.parent.failedBlock(container, context);
        }
        this.unregister(container, context);
        if (this.freeData) {
            if (this.persistent) {
                container.activate((Object)this.sourceData, 1);
            }
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientKeyBlock getBlock(ObjectContainer container, ClientContext context, boolean calledByCB) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            if (this.persistent) {
                container.store((Object)this);
            }
            return this.encode(container, context, calledByCB);
        }
        catch (InsertException e) {
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFailure(e, this, container, context);
            if (this.persistent && !calledByCB) {
                container.deactivate((Object)this.cb, 1);
            }
            return null;
        }
        catch (Throwable t) {
            if (this.persistent) {
                container.activate((Object)this.cb, 1);
            }
            Logger.error(this, "Caught " + t, t);
            this.cb.onFailure(new InsertException(3, t, null), this, container, context);
            if (this.persistent && !calledByCB) {
                container.deactivate((Object)this.cb, 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already: " + this);
                }
                return;
            }
        }
        if (this.getCHKOnly) {
            boolean deactivateCB = false;
            if (this.persistent) {
                boolean bl = deactivateCB = !container.ext().isActive((Object)this.cb);
                if (deactivateCB) {
                    container.activate((Object)this.cb, 1);
                }
                container.activate((Object)this.parent, 1);
            }
            ClientKeyBlock block = this.encode(container, context, true);
            this.cb.onEncode(block.getClientKey(), this, container, context);
            this.parent.completedBlock(false, container, context);
            this.cb.onSuccess(this, container, context);
            this.finished = true;
            if (this.persistent) {
                container.store((Object)this);
                if (deactivateCB) {
                    container.deactivate((Object)this.cb, 1);
                }
            }
        } else {
            this.getScheduler(context).registerInsert(this, this.persistent, true, container);
        }
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreenetURI getURI(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingURI != null) {
                if (this.persistent) {
                    container.activate((Object)this.resultingURI, 5);
                }
                return this.persistent ? this.resultingURI.clone() : this.resultingURI;
            }
        }
        this.getBlock(container, context, true);
        singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.persistent) {
                container.activate((Object)this.resultingURI, 5);
            }
            return this.persistent ? this.resultingURI.clone() : this.resultingURI;
        }
    }

    public synchronized FreenetURI getURINoEncode() {
        return this.resultingURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object keyNum, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Succeeded (" + this + "): " + this.token);
        }
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        if (this.parent.isCancelled()) {
            this.fail(new InsertException(10), container, context);
            return;
        }
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                Logger.normal(this, "Block already completed: " + this);
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.sourceData, 1);
        }
        if (this.freeData) {
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        this.parent.completedBlock(false, container, context);
        this.unregister(container, context);
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Calling onSuccess for " + this.cb);
        }
        this.cb.onSuccess(this, container, context);
        if (this.persistent) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        boolean wasActive = true;
        if (this.persistent) {
            container.store((Object)this);
            wasActive = container.ext().isActive((Object)this.cb);
            if (!wasActive) {
                container.activate((Object)this.cb, 1);
            }
            container.activate((Object)this.sourceData, 1);
        }
        if (this.freeData) {
            this.sourceData.free();
            if (this.persistent) {
                this.sourceData.removeFrom(container);
            }
            this.sourceData = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }
        super.unregister(container, context);
        this.cb.onFailure(new InsertException(10), this, container, context);
        if (!wasActive) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.finished;
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        return new SendableRequestSender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean send(NodeClientCore core, RequestScheduler sched, final ClientContext context, ChosenBlock req) {
                block25: {
                    ClientKey key = null;
                    if (logMINOR) {
                        Logger.minor(this, "Starting request: " + SingleBlockInserter.this);
                    }
                    BlockItem block = (BlockItem)req.token;
                    try {
                        try {
                            ClientKeyBlock b;
                            try {
                                b = SingleBlockInserter.innerEncode(context.random, block.uri, block.copyBucket, block.isMetadata, block.compressionCodec, block.sourceLength);
                            }
                            catch (CHKEncodeException e) {
                                throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                            }
                            catch (SSKEncodeException e) {
                                throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                            }
                            catch (MalformedURLException e) {
                                throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                            }
                            catch (InsertException e) {
                                throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                            }
                            catch (IOException e) {
                                throw new LowLevelPutException(1, e.toString() + ":" + e.getMessage(), e);
                            }
                            if (b == null) {
                                Logger.error(this, "Asked to send empty block on " + SingleBlockInserter.this, new Exception("error"));
                                boolean e = false;
                                Object var14_17 = null;
                                block.copyBucket.free();
                                return e;
                            }
                            final ClientKey k = key = b.getClientKey();
                            if (block.persistent) {
                                context.jobRunner.queue(new DBJob(){

                                    public boolean run(ObjectContainer container, ClientContext context) {
                                        if (!container.ext().isStored((Object)SingleBlockInserter.this)) {
                                            return false;
                                        }
                                        container.activate((Object)SingleBlockInserter.this, 1);
                                        SingleBlockInserter.this.onEncode(k, container, context);
                                        container.deactivate((Object)SingleBlockInserter.this, 1);
                                        return false;
                                    }
                                }, 6, false);
                            } else {
                                context.mainExecutor.execute(new Runnable(){

                                    public void run() {
                                        SingleBlockInserter.this.onEncode(k, null, context);
                                    }
                                }, "Got URI");
                            }
                            core.realPut(b, req.cacheLocalRequests);
                        }
                        catch (LowLevelPutException e) {
                            block24: {
                                if (e.code == 5) {
                                    boolean bl;
                                    try {
                                        ClientSSKBlock collided = (ClientSSKBlock)core.node.fetch((ClientSSK)key, true);
                                        byte[] data = collided.memoryDecode(true);
                                        byte[] inserting = BucketTools.toByteArray(block.copyBucket);
                                        if (collided.isMetadata() != block.isMetadata || collided.getCompressionCodec() != block.compressionCodec || !Arrays.equals(data, inserting)) break block24;
                                        if (logMINOR) {
                                            Logger.minor(this, "Collided with identical data: " + SingleBlockInserter.this);
                                        }
                                        req.onInsertSuccess(context);
                                        bl = true;
                                    }
                                    catch (KeyVerifyException e1) {
                                        Logger.error(this, "Caught " + e1 + " when checking collision!", e1);
                                        break block24;
                                    }
                                    catch (KeyDecodeException e1) {
                                        Logger.error(this, "Caught " + e1 + " when checking collision!", e1);
                                        break block24;
                                    }
                                    catch (IOException e1) {
                                        Logger.error(this, "Caught " + e1 + " when checking collision!", e1);
                                        break block24;
                                    }
                                    Object var14_19 = null;
                                    block.copyBucket.free();
                                    return bl;
                                }
                            }
                            req.onFailure(e, context);
                            if (logMINOR) {
                                Logger.minor(this, "Request failed: " + SingleBlockInserter.this + " for " + e);
                            }
                            boolean bl = true;
                            Object var14_20 = null;
                            block.copyBucket.free();
                            return bl;
                        }
                        catch (DatabaseDisabledException e) {
                            Logger.error(this, "Running persistent insert but database is disabled!");
                            Object var14_21 = null;
                            block.copyBucket.free();
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        block.copyBucket.free();
                        throw throwable;
                    }
                    Object var14_18 = null;
                    block.copyBucket.free();
                }
                if (logMINOR) {
                    Logger.minor(this, "Request succeeded: " + SingleBlockInserter.this);
                }
                req.onInsertSuccess(context);
                return true;
            }
        };
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.tokenObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryEncode(ObjectContainer container, ClientContext context) {
        SingleBlockInserter singleBlockInserter = this;
        synchronized (singleBlockInserter) {
            if (this.resultingURI != null) {
                return;
            }
            if (this.finished) {
                return;
            }
        }
        try {
            this.encode(container, context, false);
        }
        catch (InsertException e) {
            this.fail(e, container, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
    }

    @Override
    public synchronized long countSendableKeys(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized long countAllKeys(ObjectContainer container, ClientContext context) {
        return this.countSendableKeys(container, context);
    }

    @Override
    public synchronized SendableRequestItem chooseKey(KeysFetchingLocally ignored, ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return null;
        }
        if (!this.persistent && ignored.hasTransientInsert(this, new FakeBlockItem())) {
            return null;
        }
        return this.getBlockItem(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockItem getBlockItem(ObjectContainer container, ClientContext context) {
        try {
            SingleBlockInserter singleBlockInserter = this;
            synchronized (singleBlockInserter) {
                if (this.finished) {
                    return null;
                }
            }
            if (this.persistent && this.sourceData == null) {
                Logger.error(this, "getBlockItem(): sourceData = null but active = " + container.ext().isActive((Object)this));
                return null;
            }
            boolean deactivateBucket = false;
            if (this.persistent) {
                container.activate((Object)this.uri, 1);
                boolean bl = deactivateBucket = !container.ext().isActive((Object)this.sourceData);
                if (deactivateBucket) {
                    container.activate((Object)this.sourceData, 1);
                }
            }
            Bucket data = this.sourceData.createShadow();
            FreenetURI u = this.uri;
            u = u.getKeyType().equals("CHK") && !this.persistent ? FreenetURI.EMPTY_CHK_URI : u.clone();
            if (data == null) {
                data = context.tempBucketFactory.makeBucket(this.sourceData.size());
                BucketTools.copy(this.sourceData, data);
            }
            if (this.persistent) {
                if (deactivateBucket) {
                    container.deactivate((Object)this.sourceData, 1);
                }
                container.deactivate((Object)this.uri, 1);
            }
            return new BlockItem(this, data, this.isMetadata, this.compressionCodec, this.sourceLength, u, this.hashCode(), this.persistent);
        }
        catch (IOException e) {
            this.fail(new InsertException(2, e, null), container, context);
            return null;
        }
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
        BlockItem item = this.getBlockItem(container, context);
        if (item == null) {
            return null;
        }
        PersistentChosenBlock block = new PersistentChosenBlock(true, request, item, null, null, sched);
        return Collections.singletonList(block);
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "removeFrom() on " + this);
        }
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        if (this.resultingURI != null) {
            container.activate((Object)this.resultingURI, 5);
            this.resultingURI.removeFrom(container);
        }
        container.activate((Object)this.errors, 5);
        this.errors.removeFrom(container);
        if (this.freeData && this.sourceData != null && container.ext().isStored((Object)this.sourceData)) {
            Logger.error(this, "Data not removed!");
            container.activate((Object)this.sourceData, 1);
            this.sourceData.removeFrom(container);
        }
        container.delete((Object)this);
    }

    @Override
    public boolean cacheInserts(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.ctx);
            if (deactivate) {
                container.activate((Object)this.ctx, 1);
            }
        }
        boolean retval = this.ctx.cacheLocalRequests;
        if (deactivate) {
            container.deactivate((Object)this.ctx, 1);
        }
        return retval;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "objectCanNew when already finished on " + this);
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "objectCanNew() on " + this, new Exception("debug"));
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    private class FakeBlockItem
    implements SendableRequestItem {
        private FakeBlockItem() {
        }

        public void dump() {
        }

        public SingleBlockInserter getParent() {
            return SingleBlockInserter.this;
        }

        public int hashCode() {
            return SingleBlockInserter.this.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof BlockItem ? ((BlockItem)o).parent == SingleBlockInserter.this : o instanceof FakeBlockItem && ((FakeBlockItem)o).getParent() == SingleBlockInserter.this;
        }
    }

    private static class BlockItem
    implements SendableRequestItem {
        private final boolean persistent;
        private final Bucket copyBucket;
        private final boolean isMetadata;
        private final short compressionCodec;
        private final int sourceLength;
        private final FreenetURI uri;
        private final int hashCode;
        private final SingleBlockInserter parent;

        BlockItem(SingleBlockInserter parent, Bucket bucket, boolean meta, short codec, int srclen, FreenetURI u, int hashCode, boolean persistent) throws IOException {
            this.parent = parent;
            this.copyBucket = bucket;
            this.isMetadata = meta;
            this.compressionCodec = codec;
            this.sourceLength = srclen;
            this.uri = u;
            this.hashCode = hashCode;
            this.persistent = persistent;
        }

        public void dump() {
            this.copyBucket.free();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof BlockItem ? ((BlockItem)o).parent == this.parent : o instanceof FakeBlockItem && ((FakeBlockItem)o).getParent() == this.parent;
        }
    }
}

