/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutState;
import freenet.client.async.HealingQueue;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.util.HashMap;

public class SimpleHealingQueue
extends BaseClientPutter
implements HealingQueue,
PutCompletionCallback {
    final int maxRunning;
    int counter;
    InsertContext ctx;
    final HashMap runningInserters;

    public SimpleHealingQueue(InsertContext context, short prio, int maxRunning) {
        super(prio, new RequestClient(){

            public boolean persistent() {
                return false;
            }

            public void removeFrom(ObjectContainer container) {
                throw new UnsupportedOperationException();
            }
        });
        this.ctx = context;
        this.runningInserters = new HashMap();
        this.maxRunning = maxRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean innerQueue(Bucket data, ClientContext context) {
        SingleBlockInserter sbi;
        int ctr;
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            ctr = this.counter++;
            if (this.runningInserters.size() > this.maxRunning) {
                return false;
            }
            try {
                sbi = new SingleBlockInserter(this, data, -1, FreenetURI.EMPTY_CHK_URI, this.ctx, this, false, 32768, ctr, false, false, false, data, null, context, false, true);
            }
            catch (Throwable e) {
                Logger.error(this, "Caught trying to insert healing block: " + e, e);
                return false;
            }
            this.runningInserters.put(data, sbi);
        }
        try {
            sbi.schedule(null, context);
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Started healing insert " + ctr + " for " + data);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.error(this, "Caught trying to insert healing block: " + e, e);
            return false;
        }
    }

    public void queue(Bucket data, ClientContext context) {
        if (!this.innerQueue(data, context)) {
            data.free();
        }
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    public FreenetURI getURI() {
        return FreenetURI.EMPTY_CHK_URI;
    }

    public boolean isFinished() {
        return false;
    }

    public void notifyClients(ObjectContainer container, ClientContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        SingleBlockInserter sbi = (SingleBlockInserter)state;
        Bucket data = (Bucket)sbi.getToken();
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            this.runningInserters.remove(data);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Successfully inserted healing block: " + sbi.getURINoEncode() + " for " + data + " (" + sbi.token + ')');
        }
        data.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        SingleBlockInserter sbi = (SingleBlockInserter)state;
        Bucket data = (Bucket)sbi.getToken();
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            this.runningInserters.remove(data);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Failed to insert healing block: " + sbi.getURINoEncode() + " : " + e + " for " + data + " (" + sbi.token + ')', (Throwable)e);
        }
        data.free();
    }

    public void onEncode(BaseClientKey usk, ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Logger.error(this, "impossible: onTransition on SimpleHealingQueue from " + oldState + " to " + newState, new Exception("debug"));
    }

    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got metadata on SimpleHealingQueue from " + state + ": " + m, new Exception("debug"));
    }

    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    public void onFetchable(ClientPutState state, ObjectContainer container) {
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    public void cancel(ObjectContainer container, ClientContext context) {
        super.cancel();
    }
}

