/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.BlockSet;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.Set;

public class SimpleBlockSet
implements BlockSet {
    private final HashMap<Key, KeyBlock> blocksByKey = new HashMap();

    public synchronized void add(KeyBlock block) {
        this.blocksByKey.put(block.getKey(), block);
    }

    public synchronized KeyBlock get(Key key) {
        return this.blocksByKey.get(key);
    }

    public synchronized Set keys() {
        return this.blocksByKey.keySet();
    }

    public ClientKeyBlock get(ClientKey key) {
        KeyBlock block = this.get(key.getNodeKey());
        if (block == null) {
            return null;
        }
        try {
            return Key.createKeyBlock(key, block);
        }
        catch (KeyVerifyException e) {
            Logger.error(this, "Caught decoding block with " + key + " : " + e, e);
            return null;
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        throw new UnsupportedOperationException("Block set storage in database not supported");
    }
}

