/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ManifestElement;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainManifestPutter
extends BaseManifestPutter {
    private static volatile boolean logDEBUG;

    public PlainManifestPutter(ClientPutCallback clientCallback, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, RequestClient clientContext, boolean earlyEncode) {
        super(clientCallback, manifestElements, prioClass, target, defaultName, ctx, getCHKOnly, clientContext, earlyEncode);
    }

    @Override
    protected void makePutHandlers(HashMap<String, Object> manifestElements, HashMap<String, Object> putHandlersByName) {
        this.makePutHandlers(manifestElements, putHandlersByName, "/");
    }

    private void makePutHandlers(HashMap<String, Object> manifestElements, HashMap<String, Object> putHandlersByName, String prefix) {
        for (String name : manifestElements.keySet()) {
            Object o = manifestElements.get(name);
            if (o instanceof HashMap) {
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                putHandlersByName.put(name, subMap);
                this.makePutHandlers((HashMap)o, subMap, prefix + name + '/');
                if (!logDEBUG) continue;
                Logger.debug(this, "Sub map for " + name + " : " + subMap.size() + " elements from " + ((HashMap)o).size());
                continue;
            }
            ManifestElement element = (ManifestElement)o;
            this.addRedirect(name, element, putHandlersByName);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

