/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.query.Query;
import freenet.client.async.CooldownQueue;
import freenet.client.async.PersistentCooldownQueueItem;
import freenet.keys.Key;
import freenet.node.SendableGet;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.util.ArrayList;

public class PersistentCooldownQueue
implements CooldownQueue {
    private long cooldownTime;

    void setCooldownTime(long time) {
        this.cooldownTime = time;
    }

    public long add(Key key, SendableGet client, ObjectContainer container) {
        assert (this.cooldownTime != 0L);
        long removeTime = System.currentTimeMillis() + this.cooldownTime;
        container.activate((Object)key, 5);
        PersistentCooldownQueueItem persistentCooldownQueueItem = new PersistentCooldownQueueItem(client, key.cloneKey(), removeTime, this);
        container.store((Object)persistentCooldownQueueItem);
        return removeTime;
    }

    public boolean removeKey(final Key key, final SendableGet client, long time, ObjectContainer container) {
        boolean found = false;
        String keyAsBytes = HexUtil.bytesToHex(key.getFullKey());
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("keyAsBytes").constrain((Object)keyAsBytes);
        Evaluation eval = new Evaluation(){

            public void evaluate(Candidate candidate) {
                PersistentCooldownQueueItem item = (PersistentCooldownQueueItem)candidate.getObject();
                if (item.client != client) {
                    candidate.include(false);
                    return;
                }
                if (item.parent != PersistentCooldownQueue.this) {
                    candidate.include(false);
                    return;
                }
                Key k = item.key;
                candidate.objectContainer().activate((Object)k, 5);
                if (k.equals(key)) {
                    candidate.include(true);
                } else {
                    candidate.include(false);
                    candidate.objectContainer().deactivate((Object)k, 5);
                }
            }
        };
        query.constrain((Object)eval);
        ObjectSet results = query.execute();
        while (results.hasNext()) {
            found = true;
            PersistentCooldownQueueItem i = (PersistentCooldownQueueItem)results.next();
            i.delete(container);
        }
        return found;
    }

    public Object removeKeyBefore(long now, long dontCareAfterMillis, ObjectContainer container, int maxCount) {
        long tStart = System.currentTimeMillis();
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("time").constrain((Object)now).smaller().and(query.descend("parent").constrain((Object)this).identity());
        ObjectSet results = query.execute();
        if (results.hasNext()) {
            long tEnd = System.currentTimeMillis();
            if (tEnd - tStart > 1000L) {
                Logger.error(this, "Query took " + (tEnd - tStart));
            } else if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Query took " + (tEnd - tStart));
            }
            ArrayList<Key> v = new ArrayList<Key>(Math.min(maxCount, results.size()));
            while (results.hasNext() && v.size() < maxCount) {
                PersistentCooldownQueueItem i = (PersistentCooldownQueueItem)results.next();
                if (i.time >= now) {
                    Logger.error(this, "removeKeyBefore(): time >= now: diff=" + (now - i.time));
                    continue;
                }
                if (i.parent != this) {
                    Logger.error(this, "parent=" + i.parent + " but should be " + this);
                    continue;
                }
                container.activate((Object)i.key, 5);
                if (i.client == null || !container.ext().isStored((Object)i.client)) {
                    Logger.normal(this, "Client has been removed but not the persistent cooldown queue item: time " + i.time + " for key " + i.key);
                } else {
                    v.add(i.key.cloneKey());
                }
                i.key.removeFrom(container);
                i.delete(container);
            }
            if (!v.isEmpty()) {
                return v.toArray(new Key[v.size()]);
            }
            query = container.query();
            query.descend("time").orderAscending().constrain((Object)(now + dontCareAfterMillis)).smaller().and(query.descend("parent").constrain((Object)this).identity());
            results = query.execute();
            if (results.hasNext()) {
                return ((PersistentCooldownQueueItem)results.next()).time;
            }
            return null;
        }
        long tEnd = System.currentTimeMillis();
        if (tEnd - tStart > 1000L) {
            Logger.error(this, "Query took " + (tEnd - tStart));
        } else if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Query took " + (tEnd - tStart));
        }
        return null;
    }

    public long size(ObjectContainer container) {
        Query query = container.query();
        query.constrain(PersistentCooldownQueueItem.class);
        query.descend("parent").constrain((Object)this).identity();
        ObjectSet results = query.execute();
        return results.size();
    }
}

