/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerCore;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.NoValidBlocksException;
import freenet.client.async.PersistentChosenBlock;
import freenet.keys.Key;
import freenet.node.BulkCallFailureItem;
import freenet.node.LowLevelGetException;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestSender;
import freenet.node.SupportsBulkCallFailure;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class PersistentChosenRequest {
    public final transient SendableRequest request;
    public final transient short prio;
    public final transient int retryCount;
    public final transient boolean localRequestOnly;
    public final transient boolean cacheLocalRequests;
    public final transient boolean ignoreStore;
    public final transient ArrayList<PersistentChosenBlock> blocksNotStarted;
    public final transient ArrayList<PersistentChosenBlock> blocksStarted;
    public final transient ArrayList<PersistentChosenBlock> blocksFinished;
    public final RequestScheduler scheduler;
    public final SendableRequestSender sender;
    private boolean logMINOR;
    private boolean finished;

    PersistentChosenRequest(SendableRequest req, short prio, int retryCount, ObjectContainer container, RequestScheduler sched, ClientContext context) throws NoValidBlocksException {
        List<PersistentChosenBlock> candidates;
        SendableRequest sg;
        this.request = req;
        this.prio = prio;
        this.retryCount = retryCount;
        if (req instanceof SendableGet) {
            sg = (SendableGet)req;
            FetchContext ctx = ((SendableGet)sg).getContext();
            if (container != null) {
                container.activate((Object)ctx, 1);
            }
            this.localRequestOnly = ctx.localRequestOnly;
            this.cacheLocalRequests = ctx.cacheLocalRequests;
            this.ignoreStore = ctx.ignoreStore;
        } else {
            sg = (SendableInsert)req;
            this.localRequestOnly = false;
            this.cacheLocalRequests = ((SendableInsert)sg).cacheInserts(container);
            this.ignoreStore = false;
        }
        this.blocksNotStarted = new ArrayList();
        this.blocksStarted = new ArrayList();
        this.blocksFinished = new ArrayList();
        this.scheduler = sched;
        boolean reqActive = container.ext().isActive((Object)req);
        if (!reqActive) {
            container.activate((Object)req, 1);
        }
        if ((candidates = req.makeBlocks(this, sched, container, context)) == null) {
            if (!reqActive) {
                container.deactivate((Object)req, 1);
            }
            throw new NoValidBlocksException();
        }
        for (PersistentChosenBlock block : candidates) {
            Key key = block.key;
            if (key != null && sched.hasFetchingKey(key)) {
                block.onDumped();
                continue;
            }
            this.blocksNotStarted.add(block);
        }
        this.sender = req.getSender(container, context);
        if (!reqActive) {
            container.deactivate((Object)req, 1);
        }
        this.logMINOR = Logger.shouldLog(4, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFinished(PersistentChosenBlock block, ClientContext context) {
        this.logMINOR = Logger.shouldLog(4, this);
        if (this.logMINOR) {
            Logger.minor(this, "onFinished() on " + this + " for " + block, (Throwable)new Exception("debug"));
        }
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            int i;
            for (i = 0; i < this.blocksNotStarted.size(); ++i) {
                if (this.blocksNotStarted.get(i) != block) continue;
                this.blocksNotStarted.remove(i);
                Logger.error(this, "Block finished but was in blocksNotStarted: " + block + " for " + this, new Exception("error"));
                --i;
            }
            for (i = 0; i < this.blocksStarted.size(); ++i) {
                if (this.blocksStarted.get(i) != block) continue;
                this.blocksStarted.remove(i);
                --i;
            }
            for (PersistentChosenBlock cmp : this.blocksFinished) {
                if (cmp != block) continue;
                Logger.error(this, "Block already in blocksFinished: " + block + " for " + this);
                return;
            }
            this.blocksFinished.add(block);
            if (!this.blocksNotStarted.isEmpty() || !this.blocksStarted.isEmpty()) {
                if (this.logMINOR) {
                    Logger.minor(this, "Not finishing yet: blocks not started: " + this.blocksNotStarted.size() + " started: " + this.blocksStarted.size() + " finished: " + this.blocksFinished.size());
                }
                return;
            }
        }
        try {
            context.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    PersistentChosenRequest.this.finish(container, context, false, false);
                    return true;
                }
            }, 6, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(ObjectContainer container, ClientContext context, boolean dumping, boolean alreadyActive) {
        PersistentChosenBlock[] finishedBlocks;
        if (!container.ext().isStored((Object)this.request)) {
            if (this.logMINOR) {
                Logger.minor(this, "Request apparently already deleted: " + this.request + " on " + this);
            }
            this.scheduler.removeRunningRequest(this.request);
            return;
        }
        if (!alreadyActive && container.ext().isActive((Object)this.request)) {
            Logger.error(this, "ALREADY ACTIVATED: " + this.request, new Exception("debug"));
        }
        if (!alreadyActive) {
            container.activate((Object)this.request, 1);
        }
        Logger.normal(this, "Finishing " + this + " for " + this.request);
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            int startedSize;
            if (this.finished) {
                if (this.blocksFinished.isEmpty()) {
                    if (!alreadyActive) {
                        container.deactivate((Object)this.request, 1);
                    }
                    return;
                }
                Logger.error(this, "Finished but blocksFinished not empty on " + this, new Exception("debug"));
            }
            if ((startedSize = this.blocksStarted.size()) > 0) {
                Logger.error(this, "Still waiting for callbacks on " + this + " for " + startedSize + " blocks");
                return;
            }
            this.finished = true;
            finishedBlocks = this.blocksFinished.toArray(new PersistentChosenBlock[this.blocksFinished.size()]);
        }
        if (finishedBlocks.length == 0) {
            if (!dumping) {
                Logger.error(this, "No finished blocks in finish() on " + this);
            } else if (this.logMINOR) {
                Logger.minor(this, "No finished blocks in finish() on " + this);
            }
            this.scheduler.removeRunningRequest(this.request);
            if (!alreadyActive) {
                container.deactivate((Object)this.request, 1);
            }
            return;
        }
        if (this.request instanceof SendableGet) {
            boolean supportsBulk = this.request instanceof SupportsBulkCallFailure;
            Vector<BulkCallFailureItem> bulkFailItems = null;
            for (PersistentChosenBlock block : finishedBlocks) {
                if (block.fetchSucceeded()) continue;
                LowLevelGetException e = block.failedGet();
                if (supportsBulk) {
                    if (bulkFailItems == null) {
                        bulkFailItems = new Vector<BulkCallFailureItem>();
                    }
                    bulkFailItems.add(new BulkCallFailureItem(e, block.token));
                    continue;
                }
                ((SendableGet)this.request).onFailure(e, block.token, container, context);
                container.commit();
            }
            if (bulkFailItems != null) {
                ((SupportsBulkCallFailure)((Object)this.request)).onFailure(bulkFailItems.toArray(new BulkCallFailureItem[bulkFailItems.size()]), container, context);
                container.commit();
            }
        } else {
            container.activate((Object)this.request, 1);
            for (PersistentChosenBlock block : finishedBlocks) {
                container.activate((Object)block, 1);
                if (block.insertSucceeded()) {
                    ((SendableInsert)this.request).onSuccess(block.token, container, context);
                    container.commit();
                    continue;
                }
                ((SendableInsert)this.request).onFailure(block.failedPut(), block.token, container, context);
                container.commit();
            }
        }
        this.scheduler.removeRunningRequest(this.request);
        if (this.request instanceof SendableInsert) {
            if (!container.ext().isActive((Object)this.request)) {
                container.activate((Object)this.request, 1);
            }
            if (!this.request.isEmpty(container) && !this.request.isCancelled(container)) {
                this.request.getScheduler(context).maybeAddToStarterQueue(this.request, container, null);
                this.request.getScheduler(context).wakeStarter();
            }
        }
        if (!alreadyActive) {
            container.deactivate((Object)this.request, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ChosenBlock grabNotStarted(Random random, RequestScheduler sched) {
        PersistentChosenBlock ret;
        ArrayList<PersistentChosenBlock> dumped = null;
        try {
            PersistentChosenRequest persistentChosenRequest = this;
            // MONITORENTER : persistentChosenRequest
        }
        catch (Throwable throwable) {
            if (dumped == null) throw throwable;
            Iterator i$ = dumped.iterator();
            while (i$.hasNext()) {
                PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
                block.onDumped();
            }
            throw throwable;
        }
        while (true) {
            int size;
            if ((size = this.blocksNotStarted.size()) == 0) {
                ChosenBlock chosenBlock = null;
                // MONITOREXIT : persistentChosenRequest
                if (dumped == null) return chosenBlock;
                Iterator i$ = dumped.iterator();
                while (i$.hasNext()) {
                    PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
                    block.onDumped();
                }
                return chosenBlock;
            }
            ret = size == 1 ? this.blocksNotStarted.remove(0) : this.blocksNotStarted.remove(random.nextInt(size));
            Key key = ret.key;
            if (key == null || !sched.hasFetchingKey(key)) break;
            if (dumped == null) {
                dumped = new ArrayList<PersistentChosenBlock>();
            }
            dumped.add(ret);
        }
        this.blocksStarted.add(ret);
        PersistentChosenBlock persistentChosenBlock = ret;
        // MONITOREXIT : persistentChosenRequest
        if (dumped == null) return persistentChosenBlock;
        Iterator i$ = dumped.iterator();
        while (i$.hasNext()) {
            PersistentChosenBlock block = (PersistentChosenBlock)i$.next();
            block.onDumped();
        }
        return persistentChosenBlock;
    }

    public synchronized int sizeNotStarted() {
        return this.blocksNotStarted.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDumped(ClientRequestSchedulerCore core, ObjectContainer container, boolean reqAlreadyActive) {
        boolean wasStarted;
        PersistentChosenBlock[] blocks;
        if (this.logMINOR) {
            Logger.minor(this, "Dumping " + this);
        }
        this.scheduler.removeRunningRequest(this.request);
        PersistentChosenRequest persistentChosenRequest = this;
        synchronized (persistentChosenRequest) {
            blocks = this.blocksNotStarted.toArray(new PersistentChosenBlock[this.blocksNotStarted.size()]);
            this.blocksNotStarted.clear();
            wasStarted = !this.blocksStarted.isEmpty();
        }
        for (PersistentChosenBlock block : blocks) {
            block.onDumped();
        }
        if (!wasStarted) {
            if (this.logMINOR) {
                Logger.minor(this, "Finishing immediately in onDumped() as nothing pending: " + this);
            }
            this.finish(container, core.sched.clientContext, true, reqAlreadyActive);
        }
    }

    public synchronized void pruneDuplicates(ClientRequestScheduler sched) {
        for (int i = 0; i < this.blocksNotStarted.size(); ++i) {
            PersistentChosenBlock block = this.blocksNotStarted.get(i);
            Key key = block.key;
            if (key == null || !sched.hasFetchingKey(key)) continue;
            this.blocksNotStarted.remove(i);
            if (this.logMINOR) {
                Logger.minor(this, "Pruned duplicate " + block + " from " + this);
            }
            --i;
        }
    }
}

